/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.DeleteCriteriaBuilder;
import com.blazebit.persistence.InsertCriteriaBuilder;
import com.blazebit.persistence.LeafOngoingFinalSetOperationCriteriaBuilder;
import com.blazebit.persistence.StartOngoingSetOperationCriteriaBuilder;
import com.blazebit.persistence.UpdateCriteriaBuilder;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.AssociationToIdParameterTransformer;
import com.blazebit.persistence.impl.CachingJpaProvider;
import com.blazebit.persistence.impl.CallerChecker;
import com.blazebit.persistence.impl.CriteriaBuilderConfigurationImpl;
import com.blazebit.persistence.impl.CriteriaBuilderImpl;
import com.blazebit.persistence.impl.DeleteCollectionCriteriaBuilderImpl;
import com.blazebit.persistence.impl.DeleteCriteriaBuilderImpl;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.FinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.ImmutableQueryConfiguration;
import com.blazebit.persistence.impl.InsertCollectionCriteriaBuilderImpl;
import com.blazebit.persistence.impl.InsertCriteriaBuilderImpl;
import com.blazebit.persistence.impl.JpqlMacroAdapter;
import com.blazebit.persistence.impl.JpqlMacroAwareExpressionFactory;
import com.blazebit.persistence.impl.JpqlMacroStorage;
import com.blazebit.persistence.impl.LeafOngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.OngoingFinalSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.QueryConfiguration;
import com.blazebit.persistence.impl.StartOngoingSetOperationCriteriaBuilderImpl;
import com.blazebit.persistence.impl.TransientEntityAssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.UpdateCollectionCriteriaBuilderImpl;
import com.blazebit.persistence.impl.UpdateCriteriaBuilderImpl;
import com.blazebit.persistence.parser.expression.ExpressionCache;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.ExpressionFactoryImpl;
import com.blazebit.persistence.parser.expression.MacroConfiguration;
import com.blazebit.persistence.parser.expression.SimpleCachingExpressionFactory;
import com.blazebit.persistence.parser.expression.SubqueryExpressionFactory;
import com.blazebit.persistence.spi.ConfigurationSource;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.EntityManagerFactoryIntegrator;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpaProviderFactory;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.JpqlFunctionGroup;
import com.blazebit.persistence.spi.PackageOpener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Metamodel;

public class CriteriaBuilderFactoryImpl
implements CriteriaBuilderFactory {
    private final PackageOpener packageOpener;
    private final EntityManagerFactory entityManagerFactory;
    private final EntityMetamodelImpl metamodel;
    private final AssociationParameterTransformerFactory transientEntityParameterTransformerFactory;
    private final ExtendedQuerySupport extendedQuerySupport;
    private final Map<String, Boolean> functions;
    private final Map<Class<?>, String> namedTypes;
    private final ExpressionCache expressionCache;
    private final ExpressionFactory expressionFactory;
    private final ExpressionFactory subqueryExpressionFactory;
    private final QueryConfiguration queryConfiguration;
    private final MacroConfiguration macroConfiguration;
    private final String configuredDbms;
    private final DbmsDialect configuredDbmsDialect;
    private final Map<String, JpqlFunction> configuredRegisteredFunctions;
    private final JpaProviderFactory configuredJpaProviderFactory;
    private final JpaProvider jpaProvider;

    public CriteriaBuilderFactoryImpl(CriteriaBuilderConfigurationImpl config, EntityManagerFactory entityManagerFactory) {
        List<EntityManagerFactoryIntegrator> integrators = config.getEntityManagerIntegrators();
        if (integrators.size() < 1) {
            throw new IllegalArgumentException("No EntityManagerFactoryIntegrator was found on the classpath! Please check if an integration for your JPA provider is visible on the classpath!");
        }
        if (integrators.size() > 1) {
            throw new IllegalArgumentException("Multiple EntityManagerFactoryIntegrator were found on the classpath! Please remove the wrong integrations from the classpath!");
        }
        EntityManagerFactoryIntegrator integrator = integrators.get(0);
        EntityManagerFactory emf = integrator.registerFunctions(entityManagerFactory, config.getFunctions());
        HashMap<String, JpqlFunction> registeredFunctions = new HashMap<String, JpqlFunction>(integrator.getRegisteredFunctions(emf));
        String dbms = integrator.getDbms(emf);
        Map<String, DbmsDialect> dbmsDialects = config.getDbmsDialects();
        DbmsDialect dialect = dbmsDialects.get(dbms);
        if (dialect == null) {
            dialect = dbmsDialects.get(null);
        }
        this.packageOpener = config.getPackageOpener();
        this.configuredDbms = dbms;
        this.configuredDbmsDialect = dialect;
        this.configuredRegisteredFunctions = registeredFunctions;
        this.configuredJpaProviderFactory = integrator.getJpaProviderFactory(emf);
        this.queryConfiguration = new ImmutableQueryConfiguration(config.getProperties());
        boolean compatibleMode = this.queryConfiguration.isCompatibleModeEnabled();
        boolean optimize = this.queryConfiguration.isExpressionOptimizationEnabled();
        this.entityManagerFactory = entityManagerFactory;
        this.metamodel = new EntityMetamodelImpl(entityManagerFactory, this.configuredJpaProviderFactory);
        this.jpaProvider = new CachingJpaProvider(this.metamodel);
        this.transientEntityParameterTransformerFactory = new TransientEntityAssociationParameterTransformerFactory(this.metamodel, new AssociationToIdParameterTransformer(this.jpaProvider));
        this.extendedQuerySupport = config.getExtendedQuerySupport();
        this.functions = CriteriaBuilderFactoryImpl.resolveFunctions(config.getFunctions(), this.configuredRegisteredFunctions);
        this.namedTypes = CriteriaBuilderFactoryImpl.resolveNamedTypes(config.getNamedTypes());
        ExpressionFactoryImpl originalExpressionFactory = new ExpressionFactoryImpl(this.functions, this.metamodel.getEntityTypes(), this.metamodel.getEnumTypes(), !compatibleMode, optimize);
        this.expressionCache = this.createCache(this.queryConfiguration.getExpressionCacheClass());
        SimpleCachingExpressionFactory cachingExpressionFactory = new SimpleCachingExpressionFactory((ExpressionFactory)originalExpressionFactory, this.expressionCache);
        SimpleCachingExpressionFactory cachingSubqueryExpressionFactory = new SimpleCachingExpressionFactory((ExpressionFactory)new SubqueryExpressionFactory(this.functions, this.metamodel.getEntityTypes(), this.metamodel.getEnumTypes(), !compatibleMode, optimize, (ExpressionFactory)originalExpressionFactory));
        this.macroConfiguration = MacroConfiguration.of(JpqlMacroAdapter.createMacros(config.getMacros(), (ExpressionFactory)cachingExpressionFactory));
        JpqlMacroStorage macroStorage = new JpqlMacroStorage(null, this.macroConfiguration);
        this.expressionFactory = new JpqlMacroAwareExpressionFactory((ExpressionFactory)cachingExpressionFactory, macroStorage);
        this.subqueryExpressionFactory = new JpqlMacroAwareExpressionFactory((ExpressionFactory)cachingSubqueryExpressionFactory, macroStorage);
    }

    private ExpressionCache createCache(String className) {
        try {
            return (ExpressionCache)Class.forName(className).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not instantiate expression cache: " + className, ex);
        }
    }

    private static Map<String, Boolean> resolveFunctions(Map<String, JpqlFunctionGroup> functions, Map<String, JpqlFunction> configuredFunctions) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (Map.Entry<String, JpqlFunctionGroup> entry : functions.entrySet()) {
            map.put(entry.getKey().toLowerCase(), entry.getValue().isAggregate());
        }
        map.put("sum", true);
        map.put("min", true);
        map.put("max", true);
        map.put("avg", true);
        map.put("count", true);
        for (Map.Entry<String, JpqlFunctionGroup> entry : configuredFunctions.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), false);
        }
        return map;
    }

    private static Map<Class<?>, String> resolveNamedTypes(Map<String, Class<?>> namedTypes) {
        HashMap types = new HashMap(namedTypes.size());
        for (Map.Entry<String, Class<?>> entry : namedTypes.entrySet()) {
            types.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(types);
    }

    public JpaProvider getJpaProvider() {
        return this.jpaProvider;
    }

    public QueryConfiguration getQueryConfiguration() {
        return this.queryConfiguration;
    }

    public EntityMetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public AssociationParameterTransformerFactory getTransientEntityParameterTransformerFactory() {
        return this.transientEntityParameterTransformerFactory;
    }

    public MacroConfiguration getMacroConfiguration() {
        return this.macroConfiguration;
    }

    public ExtendedQuerySupport getExtendedQuerySupport() {
        return this.extendedQuerySupport;
    }

    public Map<String, Boolean> getFunctions() {
        return this.functions;
    }

    public Map<Class<?>, String> getNamedTypes() {
        return this.namedTypes;
    }

    public ExpressionCache getExpressionCache() {
        return this.expressionCache;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.expressionFactory;
    }

    public ExpressionFactory getSubqueryExpressionFactory() {
        return this.subqueryExpressionFactory;
    }

    public Map<String, JpqlFunction> getRegisteredFunctions() {
        return Collections.unmodifiableMap(this.configuredRegisteredFunctions);
    }

    public Map<String, String> getProperties() {
        return this.queryConfiguration.getProperties();
    }

    public String getProperty(String propertyName) {
        return this.queryConfiguration.getProperty(propertyName);
    }

    public MainQuery createMainQuery(EntityManager entityManager) {
        return MainQuery.create(this, entityManager, this.configuredDbms, this.configuredDbmsDialect, this.configuredRegisteredFunctions);
    }

    public <T> StartOngoingSetOperationCriteriaBuilder<T, LeafOngoingFinalSetOperationCriteriaBuilder<T>> startSet(EntityManager entityManager, Class<T> resultClass) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        FinalSetOperationCriteriaBuilderImpl<T> parentFinalSetOperationBuilder = new FinalSetOperationCriteriaBuilderImpl<T>(mainQuery, null, true, resultClass, null, false, null);
        OngoingFinalSetOperationCriteriaBuilderImpl<LeafOngoingSetOperationCriteriaBuilderImpl<T>> subFinalSetOperationBuilder = new OngoingFinalSetOperationCriteriaBuilderImpl<LeafOngoingSetOperationCriteriaBuilderImpl<T>>(mainQuery, null, false, resultClass, null, true, parentFinalSetOperationBuilder.getSubListener());
        LeafOngoingSetOperationCriteriaBuilderImpl<T> leafCb = new LeafOngoingSetOperationCriteriaBuilderImpl<T>(mainQuery, null, false, resultClass, parentFinalSetOperationBuilder.getSubListener(), parentFinalSetOperationBuilder);
        StartOngoingSetOperationCriteriaBuilderImpl<T, LeafOngoingSetOperationCriteriaBuilderImpl<T>> cb = new StartOngoingSetOperationCriteriaBuilderImpl<T, LeafOngoingSetOperationCriteriaBuilderImpl<T>>(mainQuery, null, false, resultClass, subFinalSetOperationBuilder.getSubListener(), subFinalSetOperationBuilder, leafCb);
        subFinalSetOperationBuilder.setEndSetResult(leafCb);
        subFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(cb);
        parentFinalSetOperationBuilder.setOperationManager.setStartQueryBuilder(subFinalSetOperationBuilder);
        subFinalSetOperationBuilder.getSubListener().onBuilderStarted(cb);
        parentFinalSetOperationBuilder.getSubListener().onBuilderStarted(leafCb);
        return cb;
    }

    public <T> CriteriaBuilder<T> create(EntityManager entityManager, Class<T> resultClass) {
        return this.create(entityManager, resultClass, null);
    }

    public <T> CriteriaBuilder<T> create(EntityManager entityManager, Class<T> resultClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        CriteriaBuilderImpl<T> cb = new CriteriaBuilderImpl<T>(mainQuery, true, resultClass, alias);
        return cb;
    }

    public <T> DeleteCriteriaBuilder<T> delete(EntityManager entityManager, Class<T> deleteClass) {
        return this.delete(entityManager, deleteClass, null);
    }

    public <T> DeleteCriteriaBuilder<T> delete(EntityManager entityManager, Class<T> deleteClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        DeleteCriteriaBuilderImpl<T> cb = new DeleteCriteriaBuilderImpl<T>(mainQuery, deleteClass, alias);
        return cb;
    }

    public <T> DeleteCriteriaBuilder<T> deleteCollection(EntityManager entityManager, Class<T> deleteOwnerClass, String collectionName) {
        return this.deleteCollection(entityManager, deleteOwnerClass, null, collectionName);
    }

    public <T> DeleteCriteriaBuilder<T> deleteCollection(EntityManager entityManager, Class<T> deleteOwnerClass, String alias, String collectionName) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        DeleteCollectionCriteriaBuilderImpl<T> cb = new DeleteCollectionCriteriaBuilderImpl<T>(mainQuery, deleteOwnerClass, alias, collectionName);
        return cb;
    }

    public <T> UpdateCriteriaBuilder<T> update(EntityManager entityManager, Class<T> updateClass) {
        return this.update(entityManager, updateClass, null);
    }

    public <T> UpdateCriteriaBuilder<T> update(EntityManager entityManager, Class<T> updateClass, String alias) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        UpdateCriteriaBuilderImpl<T> cb = new UpdateCriteriaBuilderImpl<T>(mainQuery, updateClass, alias);
        return cb;
    }

    public <T> UpdateCriteriaBuilder<T> updateCollection(EntityManager entityManager, Class<T> updateOwnerClass, String collectionName) {
        return this.updateCollection(entityManager, updateOwnerClass, null, collectionName);
    }

    public <T> UpdateCriteriaBuilder<T> updateCollection(EntityManager entityManager, Class<T> updateOwnerClass, String alias, String collectionName) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        UpdateCollectionCriteriaBuilderImpl<T> cb = new UpdateCollectionCriteriaBuilderImpl<T>(mainQuery, updateOwnerClass, alias, collectionName);
        return cb;
    }

    public <T> InsertCriteriaBuilder<T> insert(EntityManager entityManager, Class<T> insertClass) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        InsertCriteriaBuilderImpl<T> cb = new InsertCriteriaBuilderImpl<T>(mainQuery, insertClass);
        return cb;
    }

    public <T> InsertCriteriaBuilder<T> insertCollection(EntityManager entityManager, Class<T> insertOwnerClass, String collectionName) {
        MainQuery mainQuery = this.createMainQuery(entityManager);
        InsertCollectionCriteriaBuilderImpl<T> cb = new InsertCollectionCriteriaBuilderImpl<T>(mainQuery, insertOwnerClass, collectionName);
        return cb;
    }

    public <T> T getService(Class<T> serviceClass) {
        if (SubqueryExpressionFactory.class.equals(serviceClass)) {
            return (T)this.subqueryExpressionFactory;
        }
        if (ConfigurationSource.class.equals(serviceClass)) {
            return (T)this;
        }
        if (ExpressionFactory.class.isAssignableFrom(serviceClass)) {
            return (T)this.expressionFactory;
        }
        if (DbmsDialect.class.equals(serviceClass)) {
            return (T)this.configuredDbmsDialect;
        }
        if (ExtendedQuerySupport.class.equals(serviceClass)) {
            return (T)this.extendedQuerySupport;
        }
        if (JpaProviderFactory.class.equals(serviceClass)) {
            return (T)this.configuredJpaProviderFactory;
        }
        if (JpaProvider.class.equals(serviceClass)) {
            return (T)this.jpaProvider;
        }
        if (ExpressionCache.class.equals(serviceClass)) {
            return (T)this.expressionCache;
        }
        if (Metamodel.class.isAssignableFrom(serviceClass)) {
            return (T)this.metamodel;
        }
        if (EntityManagerFactory.class.equals(serviceClass)) {
            return (T)this.entityManagerFactory;
        }
        if (PackageOpener.class.equals(serviceClass) && CallerChecker.isCallerTrusted()) {
            return (T)this.packageOpener;
        }
        return null;
    }
}

