/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SplittingVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.AbortableVisitorAdapter;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;

class EmbeddableSplittingVisitor
extends AbortableVisitorAdapter {
    protected final EntityMetamodel metamodel;
    protected final JpaProvider jpaProvider;
    protected final AliasManager aliasManager;
    protected final SplittingVisitor splittingVisitor;
    protected final List<Expression> splittedOffExpressions;
    protected Expression expressionToSplit;

    public EmbeddableSplittingVisitor(EntityMetamodel metamodel, JpaProvider jpaProvider, AliasManager aliasManager, SplittingVisitor splittingVisitor) {
        this.metamodel = metamodel;
        this.jpaProvider = jpaProvider;
        this.aliasManager = aliasManager;
        this.splittingVisitor = splittingVisitor;
        this.splittedOffExpressions = new ArrayList<Expression>();
    }

    protected void clear() {
        this.splittedOffExpressions.clear();
    }

    public List<Expression> getSplittedOffExpressions() {
        return this.splittedOffExpressions;
    }

    public List<Expression> splitOff(Expression expression) {
        this.expressionToSplit = null;
        expression.accept((Expression.ResultVisitor)this);
        if (this.collectSplittedOffExpressions(expression)) {
            return null;
        }
        return this.splittedOffExpressions;
    }

    protected boolean collectSplittedOffExpressions(Expression expression) {
        this.splittedOffExpressions.clear();
        if (this.expressionToSplit != null) {
            String field;
            JoinNode baseNode;
            if (this.expressionToSplit instanceof PathExpression) {
                PathReference pathReference = ((PathExpression)this.expressionToSplit).getPathReference();
                baseNode = (JoinNode)pathReference.getBaseNode();
                field = pathReference.getField();
            } else if (this.expressionToSplit instanceof MapKeyExpression) {
                baseNode = ((JoinNode)((MapKeyExpression)this.expressionToSplit).getPath().getBaseNode()).getKeyJoinNode();
                field = null;
            } else {
                return false;
            }
            String fieldPrefix = field == null ? "" : field + ".";
            ExtendedManagedType managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
            TreeMap<String, Boolean> orderedAttributes = new TreeMap<String, Boolean>();
            if (baseNode.getParentTreeNode() == null && field == null) {
                EntityType<?> ownerType = baseNode.getEntityType();
                for (SingularAttribute idAttribute : managedType.getIdAttributes()) {
                    this.addAttributes(ownerType, null, fieldPrefix, "", idAttribute, orderedAttributes);
                }
            } else {
                Map ownedAttributes;
                String prefix = field;
                if (baseNode.getParentTreeNode() != null && this.jpaProvider.getJpaMetamodelAccessor().isElementCollection(baseNode.getParentTreeNode().getAttribute())) {
                    String elementCollectionPath = baseNode.getParentTreeNode().getRelationName();
                    ExtendedManagedType entityManagedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getParent().getEntityType());
                    ownedAttributes = entityManagedType.getAttributes();
                    prefix = prefix == null ? elementCollectionPath : elementCollectionPath + "." + prefix;
                } else {
                    ownedAttributes = managedType.getOwnedSingularAttributes();
                }
                for (String embeddedPropertyPath : JpaUtils.getEmbeddedPropertyPaths(ownedAttributes, prefix, false, false)) {
                    orderedAttributes.put(embeddedPropertyPath, Boolean.FALSE);
                }
            }
            if (orderedAttributes.isEmpty()) {
                return true;
            }
            for (String orderedAttribute : orderedAttributes.keySet()) {
                this.splittedOffExpressions.add(this.splittingVisitor.splitOff(expression, this.expressionToSplit, orderedAttribute));
            }
        }
        return false;
    }

    public Boolean visit(PathExpression expr) {
        PathReference pathReference = expr.getPathReference();
        if (pathReference == null) {
            return (Boolean)((SelectInfo)this.aliasManager.getAliasInfo(expr.toString())).getExpression().accept((Expression.ResultVisitor)this);
        }
        JoinNode baseNode = (JoinNode)pathReference.getBaseNode();
        if (pathReference.getField() == null) {
            Attribute<?, ?> attr;
            if (baseNode.getParentTreeNode() != null && (attr = baseNode.getParentTreeNode().getAttribute()) instanceof PluralAttribute && ((PluralAttribute)attr).getElementType() instanceof EmbeddableType) {
                this.expressionToSplit = expr;
            }
        } else {
            ExtendedManagedType managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
            Attribute attr = managedType.getAttribute(pathReference.getField()).getAttribute();
            if (attr instanceof PluralAttribute) {
                return true;
            }
            SingularAttribute singularAttr = (SingularAttribute)attr;
            int dotIndex = expr.getField().lastIndexOf(46);
            if (dotIndex == -1 && singularAttr.getType() instanceof EmbeddableType) {
                this.expressionToSplit = expr;
            }
        }
        return true;
    }

    protected void addAttributes(EntityType<?> ownerType, String elementCollectionPath, String fieldPrefix, String prefix, SingularAttribute<?, ?> singularAttribute, Map<String, Boolean> orderedAttributes) {
        String attributeName = prefix.isEmpty() ? singularAttribute.getName() : prefix + singularAttribute.getName();
        if (singularAttribute.getType() instanceof EmbeddableType) {
            String newPrefix = attributeName + ".";
            TreeSet subAttributes = new TreeSet(JpaMetamodelUtils.ATTRIBUTE_NAME_COMPARATOR);
            subAttributes.addAll(((EmbeddableType)singularAttribute.getType()).getSingularAttributes());
            for (SingularAttribute attribute : subAttributes) {
                this.addAttributes(ownerType, elementCollectionPath, fieldPrefix, newPrefix, attribute, orderedAttributes);
            }
        } else if (singularAttribute.getType() instanceof ManagedType) {
            String newPrefix = attributeName + ".";
            Set attributeNames = elementCollectionPath == null ? this.jpaProvider.getJoinMappingPropertyNames(ownerType, elementCollectionPath, fieldPrefix + attributeName).keySet() : this.jpaProvider.getJoinMappingPropertyNames(ownerType, elementCollectionPath, elementCollectionPath + "." + fieldPrefix + attributeName).keySet();
            ExtendedAttribute extendedAttribute = (ExtendedAttribute)((ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, ownerType)).getAttributes().get(fieldPrefix + attributeName);
            if (extendedAttribute != null && StringUtils.isEmpty((CharSequence)extendedAttribute.getMappedBy())) {
                ExtendedManagedType managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType)singularAttribute.getType());
                for (String attrName : attributeNames) {
                    this.addAttributes(ownerType, elementCollectionPath, fieldPrefix, newPrefix, (SingularAttribute)((ExtendedAttribute)managedType.getAttributes().get(attrName)).getAttribute(), orderedAttributes);
                }
            }
        } else {
            orderedAttributes.put(attributeName, Boolean.FALSE);
        }
    }

    public Boolean visit(ListIndexExpression expression) {
        return false;
    }

    public Boolean visit(MapKeyExpression expression) {
        Attribute<?, ?> attr;
        PathExpression path = expression.getPath();
        PathReference pathReference = path.getPathReference();
        while (pathReference == null) {
            Expression aliasedExpression = ((SelectInfo)this.aliasManager.getAliasInfo(path.toString())).getExpression();
            if (aliasedExpression instanceof PathExpression) {
                path = (PathExpression)aliasedExpression;
                pathReference = path.getPathReference();
                continue;
            }
            return false;
        }
        JoinNode baseNode = (JoinNode)pathReference.getBaseNode();
        if (baseNode.getParentTreeNode() != null && (attr = baseNode.getParentTreeNode().getAttribute()) instanceof MapAttribute && ((MapAttribute)attr).getKeyType() instanceof EmbeddableType) {
            this.expressionToSplit = expression;
        }
        return false;
    }

    public Boolean visit(NullExpression expression) {
        return true;
    }

    public Boolean visit(FunctionExpression expression) {
        switch (expression.getFunctionName().toUpperCase()) {
            case "MIN": 
            case "MAX": 
            case "WINDOW_MIN": 
            case "WINDOW_MAX": {
                Expression expr = (Expression)expression.getExpressions().get(0);
                return expr instanceof PathExpression && this.visit((PathExpression)expr) != false;
            }
        }
        return false;
    }

    public Boolean visit(ArrayExpression expression) {
        return false;
    }

    public Boolean visit(GeneralCaseExpression expression) {
        return false;
    }

    public Boolean visit(SimpleCaseExpression expression) {
        return false;
    }

    public Boolean visit(WhenClauseExpression expression) {
        return false;
    }

    public Boolean visit(ParameterExpression expression) {
        return false;
    }

    public Boolean visit(MapEntryExpression expression) {
        return false;
    }

    public Boolean visit(SubqueryExpression expression) {
        return false;
    }

    public Boolean visit(TypeFunctionExpression expression) {
        return false;
    }

    public Boolean visit(TrimExpression expression) {
        return false;
    }

    public Boolean visit(ArithmeticExpression expression) {
        return false;
    }

    public Boolean visit(NumericLiteral expression) {
        return false;
    }

    public Boolean visit(BooleanLiteral expression) {
        return false;
    }

    public Boolean visit(StringLiteral expression) {
        return false;
    }

    public Boolean visit(DateLiteral expression) {
        return false;
    }

    public Boolean visit(TimeLiteral expression) {
        return false;
    }

    public Boolean visit(TimestampLiteral expression) {
        return false;
    }

    public Boolean visit(EnumLiteral expression) {
        return false;
    }

    public Boolean visit(EntityLiteral expression) {
        return false;
    }
}

