/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ConstantifiedJoinNodeAttributeCollector;
import com.blazebit.persistence.impl.EmbeddableSplittingVisitor;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SplittingVisitor;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.EntityLiteral;
import com.blazebit.persistence.parser.expression.EnumLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.TypeFunctionExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

class FunctionalDependencyAnalyzerVisitor
extends EmbeddableSplittingVisitor {
    private final ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector;
    private final Map<Object, Map<String, Boolean>> uniquenessMissingJoinNodeAttributes;
    private final Map<Object, List<ResolvedExpression>> uniquenessFormingJoinNodeExpressions;
    private final Map<Object, List<ResolvedExpression>> functionalDependencyRootExpressions;
    private Object lastJoinNode;
    private ResolvedExpression currentResolvedExpression;
    private boolean resultUnique;
    private boolean inKey;

    public FunctionalDependencyAnalyzerVisitor(EntityMetamodel metamodel, SplittingVisitor splittingVisitor, JpaProvider jpaProvider, AliasManager aliasManager) {
        super(metamodel, jpaProvider, aliasManager, splittingVisitor);
        this.constantifiedJoinNodeAttributeCollector = new ConstantifiedJoinNodeAttributeCollector(metamodel, aliasManager);
        this.uniquenessMissingJoinNodeAttributes = new HashMap<Object, Map<String, Boolean>>();
        this.uniquenessFormingJoinNodeExpressions = new HashMap<Object, List<ResolvedExpression>>();
        this.functionalDependencyRootExpressions = new LinkedHashMap<Object, List<ResolvedExpression>>();
    }

    public void reset() {
        this.constantifiedJoinNodeAttributeCollector.reset();
    }

    public void clear(CompoundPredicate rootPredicate, JoinNode firstRootNode, boolean innerJoin) {
        super.clear();
        this.uniquenessMissingJoinNodeAttributes.clear();
        this.uniquenessFormingJoinNodeExpressions.clear();
        this.functionalDependencyRootExpressions.clear();
        this.resultUnique = false;
        this.lastJoinNode = null;
        this.constantifiedJoinNodeAttributeCollector.collectConstantifiedJoinNodeAttributes(rootPredicate, firstRootNode, innerJoin);
    }

    public ConstantifiedJoinNodeAttributeCollector getConstantifiedJoinNodeAttributeCollector() {
        return this.constantifiedJoinNodeAttributeCollector;
    }

    public boolean analyzeFormsUniqueTuple(Expression expression) {
        JoinNode p;
        this.lastJoinNode = null;
        this.expressionToSplit = null;
        boolean unique = (Boolean)expression.accept((Expression.ResultVisitor)this);
        if (unique && (p = this.lastJoinNode instanceof Map.Entry ? (JoinNode)((Map.Entry)this.lastJoinNode).getKey() : (JoinNode)this.lastJoinNode) != null) {
            while (p.getParent() != null) {
                if ((p.getParentTreeNode() == null || p.getParentTreeNode().isCollection()) && !this.constantifiedJoinNodeAttributeCollector.isConstantified(p)) {
                    unique = false;
                    break;
                }
                p = p.getParent();
            }
        }
        this.resultUnique = this.resultUnique || unique;
        this.collectSplittedOffExpressions(expression);
        return unique;
    }

    public ResolvedExpression[] getFunctionalDependencyRootExpressions(CompoundPredicate rootPredicate, ResolvedExpression[] expressions, JoinNode firstRootNode) {
        List<Object> resolvedExpressions;
        this.clear(rootPredicate, firstRootNode, true);
        for (int i = 0; i < expressions.length; ++i) {
            List<ResolvedExpression> resolvedExpressions2;
            this.currentResolvedExpression = expressions[i];
            if (!this.analyzeFormsUniqueTuple(expressions[i].getExpression()) || (resolvedExpressions2 = this.uniquenessFormingJoinNodeExpressions.get(this.lastJoinNode)) == null) continue;
            this.functionalDependencyRootExpressions.put(this.lastJoinNode, resolvedExpressions2);
            this.lastJoinNode = null;
        }
        this.currentResolvedExpression = null;
        this.lastJoinNode = null;
        if (this.functionalDependencyRootExpressions.isEmpty()) {
            return null;
        }
        if (this.functionalDependencyRootExpressions.size() == 1) {
            resolvedExpressions = this.functionalDependencyRootExpressions.values().iterator().next();
        } else {
            resolvedExpressions = new ArrayList();
            block1: for (Map.Entry<Object, List<ResolvedExpression>> entry : this.functionalDependencyRootExpressions.entrySet()) {
                JoinNode node = entry.getKey() instanceof Map.Entry ? (JoinNode)((Map.Entry)entry.getKey()).getKey() : (JoinNode)entry.getKey();
                if (node.getParentTreeNode() == null || node.getParentTreeNode().isCollection()) {
                    if (entry.getKey() instanceof Map.Entry && this.functionalDependencyRootExpressions.containsKey(node)) continue;
                    resolvedExpressions.addAll((Collection<Object>)entry.getValue());
                    continue;
                }
                while (node.getParent() != null) {
                    if (this.functionalDependencyRootExpressions.containsKey(node.getParent())) continue block1;
                    node = node.getParent();
                }
                resolvedExpressions.addAll((Collection<Object>)entry.getValue());
            }
        }
        return resolvedExpressions.toArray(new ResolvedExpression[resolvedExpressions.size()]);
    }

    public boolean isResultUnique() {
        return this.resultUnique;
    }

    @Override
    public Boolean visit(PathExpression expr) {
        String prefix;
        Object baseNodeKey;
        ExtendedManagedType managedType;
        Attribute<?, ?> attr;
        PathReference pathReference = expr.getPathReference();
        if (pathReference == null) {
            Expression aliasedExpression = ((SelectInfo)this.aliasManager.getAliasInfo(expr.toString())).getExpression();
            return (Boolean)aliasedExpression.accept((Expression.ResultVisitor)this);
        }
        JoinNode baseNode = (JoinNode)pathReference.getBaseNode();
        String field = pathReference.getField();
        if (field == null) {
            this.lastJoinNode = baseNode;
            this.functionalDependencyRootExpressions.put(baseNode, Collections.singletonList(this.currentResolvedExpression));
            if (baseNode.getType().getPersistenceType() == Type.PersistenceType.BASIC) {
                return true;
            }
            if (this.inKey) {
                return true;
            }
            field = baseNode.getParentTreeNode().getRelationName();
            baseNode = baseNode.getParent();
        }
        if ((attr = (managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType())).getAttribute(field).getAttribute()) instanceof PluralAttribute) {
            this.lastJoinNode = baseNode;
            if (this.inKey) {
                this.registerFunctionalDependencyRootExpression(baseNode);
                return true;
            }
            throw new IllegalArgumentException("Ordering by plural attribute '" + expr + "' does not make sense! Please order by it's id instead!");
        }
        boolean isEmbeddedIdPart = false;
        SingularAttribute singularAttr = (SingularAttribute)attr;
        if (!singularAttr.isId() && !(isEmbeddedIdPart = this.isEmbeddedIdPart(baseNode, field, singularAttr))) {
            this.registerFunctionalDependencyRootExpression(baseNode);
            return false;
        }
        int dotIndex = expr.getField().lastIndexOf(46);
        if (dotIndex == -1) {
            baseNodeKey = baseNode;
            if (singularAttr.getType() instanceof EmbeddableType) {
                this.expressionToSplit = expr;
            }
        } else if (isEmbeddedIdPart) {
            baseNodeKey = baseNode;
        } else {
            String associationName = expr.getField().substring(0, dotIndex);
            ExtendedManagedType extendedManagedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
            ExtendedAttribute extendedAttribute = extendedManagedType.getAttribute(associationName);
            Attribute attribute = extendedAttribute.getAttribute();
            baseNodeKey = new AbstractMap.SimpleEntry<JoinNode, String>(baseNode, associationName);
            if (attribute.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE) {
                boolean nonConstantParent = true;
                Map<String, Boolean> constantifiedAttributes = this.constantifiedJoinNodeAttributeCollector.getConstantifiedJoinNodeAttributes().get(baseNode);
                if (constantifiedAttributes != null) {
                    HashMap<String, Boolean> orderedAttributes = new HashMap<String, Boolean>();
                    this.addAttributes(baseNode.getEntityType(), null, "", "", (SingularAttribute)attribute, orderedAttributes);
                    FunctionalDependencyAnalyzerVisitor.initConstantifiedAttributes(orderedAttributes, constantifiedAttributes.keySet());
                    orderedAttributes.remove(expr.getField());
                    String singleNonConstantifiedAttribute = this.getSingleNonConstantifiedAttribute(orderedAttributes);
                    if (singleNonConstantifiedAttribute != null && (singleNonConstantifiedAttribute.isEmpty() || this.equalsAny(singleNonConstantifiedAttribute, extendedManagedType.getAttribute(expr.getField()).getColumnEquivalentAttributes()))) {
                        nonConstantParent = false;
                        orderedAttributes.clear();
                        managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, JpaMetamodelUtils.resolveFieldClass(baseNode.getJavaType(), (Attribute)attribute));
                    }
                } else if (attribute instanceof SingularAttribute && ((SingularAttribute)attribute).isId()) {
                    baseNodeKey = baseNode;
                    nonConstantParent = false;
                    isEmbeddedIdPart = true;
                }
                if (nonConstantParent) {
                    this.registerFunctionalDependencyRootExpression(baseNodeKey);
                    return false;
                }
            } else {
                managedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, JpaMetamodelUtils.resolveFieldClass(baseNode.getJavaType(), (Attribute)attribute));
            }
        }
        this.registerFunctionalDependencyRootExpression(baseNodeKey);
        Map<String, Boolean> orderedAttributes = this.getUniquenessMissingAttributes(baseNodeKey, managedType);
        if (dotIndex == -1 && baseNode.getParentTreeNode() != null && !baseNode.getParentTreeNode().isCollection()) {
            prefix = baseNode.getParentTreeNode().getRelationName() + ".";
            JoinNode node = baseNode.getParent();
            while (node.getParentTreeNode() != null) {
                prefix = node.getParentTreeNode().getRelationName() + "." + prefix;
                node = node.getParent();
            }
        } else {
            String string = prefix = isEmbeddedIdPart ? field.substring(0, dotIndex + 1) : "";
        }
        if (this.removeAttribute(prefix, singularAttr, orderedAttributes) && this.currentResolvedExpression != null) {
            List<ResolvedExpression> resolvedExpressions = this.uniquenessFormingJoinNodeExpressions.get(baseNodeKey);
            if (resolvedExpressions == null) {
                resolvedExpressions = new ArrayList<ResolvedExpression>(orderedAttributes.size() + 1);
                this.uniquenessFormingJoinNodeExpressions.put(baseNodeKey, resolvedExpressions);
            }
            resolvedExpressions.add(this.currentResolvedExpression);
        }
        this.lastJoinNode = baseNodeKey;
        if (FunctionalDependencyAnalyzerVisitor.hasNonConstantifiedAttribute(orderedAttributes)) {
            return false;
        }
        String subPath = field;
        while (baseNode.getParent() != null) {
            if (baseNode.getParentTreeNode() == null) {
                return this.constantifiedJoinNodeAttributeCollector.isConstantified(baseNode);
            }
            subPath = baseNode.getParentTreeNode().getRelationName() + "." + subPath;
            attr = baseNode.getParentTreeNode().getAttribute();
            baseNode = baseNode.getParent();
            if (attr.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE) continue;
            Map<String, Boolean> constantifiedAttributes = this.constantifiedJoinNodeAttributeCollector.getConstantifiedJoinNodeAttributes().get(baseNode);
            if (constantifiedAttributes != null) {
                ExtendedManagedType extendedManagedType = (ExtendedManagedType)this.metamodel.getManagedType(ExtendedManagedType.class, baseNode.getManagedType());
                orderedAttributes = new HashMap<String, Boolean>();
                this.addAttributes(baseNode.getEntityType(), null, "", "", (SingularAttribute)attr, orderedAttributes);
                FunctionalDependencyAnalyzerVisitor.initConstantifiedAttributes(orderedAttributes, constantifiedAttributes.keySet());
                orderedAttributes.remove(subPath);
                String singleNonConstantifiedAttribute = this.getSingleNonConstantifiedAttribute(orderedAttributes);
                if (singleNonConstantifiedAttribute != null && (singleNonConstantifiedAttribute.isEmpty() || extendedManagedType.getAttributes().containsKey(subPath) && this.equalsAny(singleNonConstantifiedAttribute, extendedManagedType.getAttribute(subPath).getColumnEquivalentAttributes()))) continue;
            }
            return false;
        }
        return true;
    }

    private static boolean hasNonConstantifiedAttribute(Map<String, Boolean> orderedAttributes) {
        for (Map.Entry<String, Boolean> entry : orderedAttributes.entrySet()) {
            if (entry.getValue() != Boolean.FALSE) continue;
            return true;
        }
        return false;
    }

    private static void initConstantifiedAttributes(Map<String, Boolean> orderedAttributes, Set<String> constantifiedAttributes) {
        for (String constantifiedAttribute : constantifiedAttributes) {
            if (!orderedAttributes.containsKey(constantifiedAttribute)) continue;
            orderedAttributes.put(constantifiedAttribute, Boolean.TRUE);
        }
    }

    private String getSingleNonConstantifiedAttribute(Map<String, Boolean> orderedAttributes) {
        if (orderedAttributes.isEmpty()) {
            return "";
        }
        String attribute = null;
        for (Map.Entry<String, Boolean> entry : orderedAttributes.entrySet()) {
            if (entry.getValue() != Boolean.FALSE) continue;
            if (attribute == null) {
                attribute = entry.getKey();
                continue;
            }
            return null;
        }
        return attribute;
    }

    private boolean equalsAny(String attribute, Set<? extends ExtendedAttribute<?, ?>> columnEquivalentAttributes) {
        StringBuilder sb = null;
        for (ExtendedAttribute<?, ?> columnEquivalentAttribute : columnEquivalentAttributes) {
            String attributeName;
            List attributePath = columnEquivalentAttribute.getAttributePath();
            if (attributePath.size() == 1) {
                attributeName = ((Attribute)attributePath.get(0)).getName();
            } else {
                if (sb == null) {
                    sb = new StringBuilder();
                } else {
                    sb.setLength(0);
                }
                sb.append(((Attribute)attributePath.get(0)).getName());
                for (int i = 1; i < attributePath.size(); ++i) {
                    sb.append('.');
                    sb.append(((Attribute)attributePath.get(i)).getName());
                }
                attributeName = sb.toString();
            }
            if (!attribute.equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    private Map<String, Boolean> getUniquenessMissingAttributes(Object baseNodeKey, ExtendedManagedType<?> managedType) {
        Map<String, Boolean> orderedAttributes = this.uniquenessMissingJoinNodeAttributes.get(baseNodeKey);
        if (orderedAttributes == null) {
            String prefix;
            EntityType<?> entityType;
            JoinNode baseNode;
            orderedAttributes = new HashMap<String, Boolean>();
            if (baseNodeKey instanceof Map.Entry) {
                baseNode = (JoinNode)((Map.Entry)baseNodeKey).getKey();
                String associationName = (String)((Map.Entry)baseNodeKey).getValue();
                entityType = baseNode.getEntityType();
                prefix = (String)associationName + ".";
            } else {
                baseNode = (JoinNode)baseNodeKey;
                entityType = baseNode.getEntityType();
                prefix = "";
            }
            if (baseNode.getParentTreeNode() == null || baseNode.getParentTreeNode().getAttribute().isCollection()) {
                for (SingularAttribute idAttribute : managedType.getIdAttributes()) {
                    this.addAttributes(entityType, null, "", "", idAttribute, orderedAttributes);
                }
            } else {
                String fieldPrefix = baseNode.getParentTreeNode().getRelationName();
                fieldPrefix = fieldPrefix.substring(0, fieldPrefix.length() - baseNode.getParentTreeNode().getAttribute().getName().length());
                this.addAttributes(baseNode.getParent().getEntityType(), null, fieldPrefix, prefix, (SingularAttribute)baseNode.getParentTreeNode().getAttribute(), orderedAttributes);
            }
            Map<String, Boolean> constantifiedAttributes = this.constantifiedJoinNodeAttributeCollector.getConstantifiedJoinNodeAttributes().get(baseNodeKey);
            if (constantifiedAttributes != null) {
                FunctionalDependencyAnalyzerVisitor.initConstantifiedAttributes(orderedAttributes, constantifiedAttributes.keySet());
            }
            this.uniquenessMissingJoinNodeAttributes.put(baseNodeKey, orderedAttributes);
        }
        return orderedAttributes;
    }

    private boolean removeAttribute(String prefix, SingularAttribute<?, ?> singularAttribute, Map<String, Boolean> orderedAttributes) {
        String attributeName = prefix.isEmpty() ? singularAttribute.getName() : prefix + singularAttribute.getName();
        if (singularAttribute.getType() instanceof EmbeddableType) {
            String newPrefix = attributeName + ".";
            boolean removed = false;
            for (SingularAttribute attribute : ((EmbeddableType)singularAttribute.getType()).getSingularAttributes()) {
                if (!this.removeAttribute(newPrefix, attribute, orderedAttributes)) continue;
                removed = true;
            }
            return removed;
        }
        return orderedAttributes.remove(attributeName) != null;
    }

    private boolean isEmbeddedIdPart(JoinNode baseNode, String field, SingularAttribute<?, ?> attr) {
        ManagedType<?> managedType;
        if (attr.getDeclaringType() instanceof EmbeddableType && (managedType = baseNode.getManagedType()) instanceof EntityType) {
            int dotIndex = field.indexOf(46);
            EntityType entityType = (EntityType)managedType;
            SingularAttribute potentialIdAttribute = entityType.getSingularAttribute(field.substring(0, dotIndex));
            return potentialIdAttribute.isId();
        }
        return false;
    }

    private void registerFunctionalDependencyRootExpression(Object baseNode) {
        if (this.currentResolvedExpression != null && !this.uniquenessFormingJoinNodeExpressions.containsKey(baseNode)) {
            List<ResolvedExpression> resolvedExpressions = this.functionalDependencyRootExpressions.get(baseNode);
            if (resolvedExpressions == null) {
                resolvedExpressions = new ArrayList<ResolvedExpression>();
                this.functionalDependencyRootExpressions.put(baseNode, resolvedExpressions);
            }
            resolvedExpressions.add(this.currentResolvedExpression);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visit(ListIndexExpression expression) {
        boolean oldInKey = this.inKey;
        this.inKey = true;
        try {
            Boolean bl = (Boolean)expression.getPath().accept((Expression.ResultVisitor)this);
            return bl;
        }
        finally {
            this.inKey = oldInKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean visit(MapKeyExpression expression) {
        boolean oldInKey = this.inKey;
        this.inKey = true;
        try {
            Boolean bl = (Boolean)expression.getPath().accept((Expression.ResultVisitor)this);
            return bl;
        }
        finally {
            this.inKey = oldInKey;
        }
    }

    @Override
    public Boolean visit(NullExpression expression) {
        return true;
    }

    @Override
    public Boolean visit(FunctionExpression expression) {
        switch (expression.getFunctionName().toUpperCase()) {
            case "COALESCE": {
                return (Boolean)((Expression)expression.getExpressions().get(0)).accept((Expression.ResultVisitor)this);
            }
            case "NULLIF": {
                return (Boolean)((Expression)expression.getExpressions().get(0)).accept((Expression.ResultVisitor)this);
            }
            case "ROW_NUMBER": {
                return expression.getWindowDefinition() == null || expression.getWindowDefinition().getFilterPredicate() == null && expression.getWindowDefinition().getPartitionExpressions().isEmpty() && expression.getWindowDefinition().getWindowName() == null;
            }
            case "MIN": 
            case "MAX": {
                Expression expr = (Expression)expression.getExpressions().get(0);
                return expr instanceof PathExpression && this.visit((PathExpression)expr) != false;
            }
        }
        return false;
    }

    @Override
    public Boolean visit(ArrayExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(GeneralCaseExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(SimpleCaseExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(WhenClauseExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(ParameterExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(MapEntryExpression expression) {
        return false;
    }

    public Boolean visit(MapValueExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(SubqueryExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(TypeFunctionExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(TrimExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(ArithmeticExpression expression) {
        return false;
    }

    @Override
    public Boolean visit(NumericLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(BooleanLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(StringLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(DateLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(TimeLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(TimestampLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(EnumLiteral expression) {
        return false;
    }

    @Override
    public Boolean visit(EntityLiteral expression) {
        return false;
    }
}

