/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.EmbeddableSplittingVisitor;
import com.blazebit.persistence.impl.GroupByExpressionGatheringVisitor;
import com.blazebit.persistence.impl.ImplicitGroupByClauseDependencyRegistrationVisitor;
import com.blazebit.persistence.impl.JoinVisitor;
import com.blazebit.persistence.impl.NodeInfo;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvedExpression;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupByManager
extends AbstractManager<ExpressionModifier> {
    private final JpaProvider jpaProvider;
    private final ImplicitGroupByClauseDependencyRegistrationVisitor implicitGroupByClauseDependencyRegistrationVisitor;
    private final EmbeddableSplittingVisitor embeddableSplittingVisitor;
    private final GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor;
    private final List<NodeInfo> groupByInfos;
    private final Map<ResolvedExpression, Set<ClauseType>> groupByClauses;

    GroupByManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, JpaProvider jpaProvider, AliasManager aliasManager, EmbeddableSplittingVisitor embeddableSplittingVisitor, GroupByExpressionGatheringVisitor groupByExpressionGatheringVisitor) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.jpaProvider = jpaProvider;
        this.implicitGroupByClauseDependencyRegistrationVisitor = new ImplicitGroupByClauseDependencyRegistrationVisitor(aliasManager);
        this.embeddableSplittingVisitor = embeddableSplittingVisitor;
        this.groupByExpressionGatheringVisitor = groupByExpressionGatheringVisitor;
        this.groupByInfos = new ArrayList<NodeInfo>();
        this.groupByClauses = new LinkedHashMap<ResolvedExpression, Set<ClauseType>>();
    }

    void applyFrom(GroupByManager groupByManager, Set<ClauseType> excludedClauses, ExpressionCopyContext copyContext) {
        if (excludedClauses.isEmpty() || this.groupByClauses.isEmpty()) {
            for (NodeInfo info : groupByManager.groupByInfos) {
                this.groupBy(this.subqueryInitFactory.reattachSubqueries(info.getExpression().copy(copyContext), ClauseType.GROUP_BY));
            }
        } else {
            for (Map.Entry<ResolvedExpression, Set<ClauseType>> entry : this.groupByClauses.entrySet()) {
                if (excludedClauses.containsAll((Collection)entry.getValue())) continue;
                this.groupBy(this.subqueryInitFactory.reattachSubqueries(entry.getKey().getExpression().copy(copyContext), ClauseType.GROUP_BY));
            }
        }
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.GROUP_BY;
    }

    public void groupBy(Expression expr) {
        this.groupByInfos.add(new NodeInfo(expr));
        this.registerParameterExpressions(expr);
    }

    void collectGroupByClauses(JoinVisitor joinVisitor) {
        if (this.groupByInfos.isEmpty()) {
            return;
        }
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.CASE_WHEN);
        StringBuilder sb = new StringBuilder();
        this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
        this.queryGenerator.setQueryBuffer(sb);
        for (NodeInfo info : this.groupByInfos) {
            Expression expr = info.getExpression();
            Set<Expression> collectedExpressions = this.groupByExpressionGatheringVisitor.extractGroupByExpressions(expr);
            if (collectedExpressions.size() > 1 || collectedExpressions.iterator().next() != expr) {
                throw new RuntimeException("The complex group by expression [" + expr + "] is not supported by the underlying database. The valid sub-expressions are: " + collectedExpressions);
            }
            sb.setLength(0);
            this.queryGenerator.generate(expr);
            this.collect(new ResolvedExpression(sb.toString(), expr), ClauseType.GROUP_BY, true, joinVisitor);
        }
        this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.queryGenerator.setClauseType(null);
    }

    void buildGroupBy(StringBuilder sb) {
        this.buildGroupBy(sb, EnumSet.noneOf(ClauseType.class));
    }

    void buildGroupBy(StringBuilder sb, Set<ClauseType> excludedClauses) {
        if (!this.groupByClauses.isEmpty()) {
            this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
            this.queryGenerator.setQueryBuffer(sb);
            int initialIndex = sb.length();
            sb.append(" GROUP BY ");
            int emptyIndex = sb.length();
            for (Map.Entry<ResolvedExpression, Set<ClauseType>> entry : this.groupByClauses.entrySet()) {
                if (excludedClauses.containsAll((Collection)entry.getValue())) continue;
                entry.getKey().getExpression().accept((Expression.Visitor)this.queryGenerator);
                sb.append(", ");
            }
            if (sb.length() == emptyIndex) {
                sb.setLength(initialIndex);
            } else {
                sb.setLength(sb.length() - 2);
            }
        }
    }

    void buildGroupBy(StringBuilder sb, Set<ClauseType> excludedClauses, ResolvedExpression[] additionalGroupBys) {
        this.queryGenerator.setClauseType(ClauseType.GROUP_BY);
        this.queryGenerator.setQueryBuffer(sb);
        if (this.groupByClauses.isEmpty()) {
            if (additionalGroupBys.length != 0) {
                sb.append(" GROUP BY ");
                for (ResolvedExpression additionalGroupBy : additionalGroupBys) {
                    additionalGroupBy.getExpression().accept((Expression.Visitor)this.queryGenerator);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
        } else {
            int initialIndex = sb.length();
            sb.append(" GROUP BY ");
            int emptyIndex = sb.length();
            for (Map.Entry<ResolvedExpression, Set<ClauseType>> entry : this.groupByClauses.entrySet()) {
                if (excludedClauses.containsAll((Collection)entry.getValue())) continue;
                entry.getKey().getExpression().accept((Expression.Visitor)this.queryGenerator);
                sb.append(", ");
            }
            if (additionalGroupBys.length == 0) {
                if (sb.length() == emptyIndex) {
                    sb.setLength(initialIndex);
                } else {
                    sb.setLength(sb.length() - 2);
                }
            } else {
                for (ResolvedExpression additionalGroupBy : additionalGroupBys) {
                    Set<ClauseType> clauseTypes = this.groupByClauses.get(additionalGroupBy);
                    if (clauseTypes != null && !excludedClauses.containsAll(clauseTypes)) continue;
                    additionalGroupBy.getExpression().accept((Expression.Visitor)this.queryGenerator);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
        }
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<NodeInfo> infos = this.groupByInfos;
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            NodeInfo groupBy = infos.get(i);
            visitor.visit(groupBy, ClauseType.GROUP_BY);
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        for (NodeInfo groupBy : this.groupByInfos) {
            groupBy.getExpression().accept(v);
        }
    }

    public boolean hasGroupBys() {
        return this.groupByInfos.size() > 0;
    }

    boolean isEmpty() {
        return this.groupByInfos.isEmpty();
    }

    public void resetCollected() {
        this.groupByClauses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(ResolvedExpression expression, ClauseType clauseType, boolean hasGroupBy, JoinVisitor joinVisitor) {
        block10: {
            List<Expression> expressions = this.embeddableSplittingVisitor.splitOff(expression.getExpression());
            if (expressions == null) break block10;
            if (expressions.isEmpty()) {
                this.collect0(expression, clauseType, hasGroupBy);
            } else if (this.jpaProvider.supportsSingleValuedAssociationIdExpressions() || joinVisitor == null) {
                for (Expression splitOffExpression : expressions) {
                    ResolvedExpression subExpression = new ResolvedExpression(splitOffExpression.toString(), splitOffExpression);
                    this.collect0(subExpression, clauseType, hasGroupBy);
                }
            } else {
                ClauseType fromClause = joinVisitor.getFromClause();
                try {
                    joinVisitor.setFromClause(clauseType);
                    for (Expression splitOffExpression : expressions) {
                        if (hasGroupBy) {
                            splitOffExpression.accept((Expression.Visitor)joinVisitor);
                        }
                        ResolvedExpression subExpression = new ResolvedExpression(splitOffExpression.toString(), splitOffExpression);
                        this.collect0(subExpression, clauseType, hasGroupBy);
                    }
                }
                finally {
                    joinVisitor.setFromClause(fromClause);
                }
            }
        }
    }

    private void collect0(ResolvedExpression expression, ClauseType clauseType, boolean hasGroupBy) {
        Set<ClauseType> clauseTypes = this.groupByClauses.get(expression);
        if (clauseTypes == null) {
            clauseTypes = EnumSet.of(clauseType);
            if (hasGroupBy) {
                expression.getExpression().accept((Expression.Visitor)this.implicitGroupByClauseDependencyRegistrationVisitor);
            }
            this.groupByClauses.put(expression, clauseTypes);
        } else {
            clauseTypes.add(clauseType);
        }
    }

    public void collect(ResolvedExpression expression, Set<ClauseType> newClauseTypes) {
        Set<ClauseType> clauseTypes = this.groupByClauses.get(expression);
        if (clauseTypes == null) {
            clauseTypes = EnumSet.copyOf(newClauseTypes);
            expression.getExpression().accept((Expression.Visitor)this.implicitGroupByClauseDependencyRegistrationVisitor);
            this.groupByClauses.put(expression, clauseTypes);
        } else {
            clauseTypes.addAll(newClauseTypes);
        }
    }

    public Map<ResolvedExpression, Set<ClauseType>> getCollectedGroupByClauses() {
        return this.groupByClauses;
    }

    public boolean hasCollectedGroupByClauses() {
        return this.groupByClauses.size() != 0;
    }

    public boolean hasCollectedGroupByClauses(Set<ClauseType> excludedClauses) {
        for (Map.Entry<ResolvedExpression, Set<ClauseType>> entry : this.groupByClauses.entrySet()) {
            if (excludedClauses.containsAll((Collection)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.groupByInfos != null ? this.groupByInfos.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupByManager other = (GroupByManager)obj;
        return this.groupByInfos == other.groupByInfos || this.groupByInfos != null && this.groupByInfos.equals(other.groupByInfos);
    }
}

