/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;

public class IllegalSubqueryDetector
extends VisitorAdapter {
    private final AliasManager aliasManager;
    private boolean inSubquery = false;

    public IllegalSubqueryDetector(AliasManager aliasManager) {
        this.aliasManager = aliasManager;
    }

    public void visit(PathExpression expression) {
        JoinNode joinNode;
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(expression.toString());
        if (aliasInfo != null && aliasInfo instanceof SelectInfo) {
            ((SelectInfo)aliasInfo).getExpression().accept((Expression.Visitor)this);
        } else if (this.inSubquery && (joinNode = (JoinNode)expression.getBaseNode()) != null && joinNode.getAliasInfo().getAliasOwner() == this.aliasManager) {
            while (joinNode != null && joinNode.getParentTreeNode() != null) {
                if (joinNode.getParentTreeNode().isCollection()) {
                    throw new IllegalStateException("Unsupported external collection access [" + joinNode.getAliasInfo().getAbsolutePath() + "]");
                }
                joinNode = joinNode.getParent();
            }
        }
    }

    public void visit(SubqueryExpression expression) {
        boolean inSubqueryCpy = this.inSubquery;
        this.inSubquery = true;
        AbstractCommonQueryBuilder builder = (AbstractCommonQueryBuilder)expression.getSubquery();
        builder.applyVisitor(this);
        if (!inSubqueryCpy) {
            this.inSubquery = false;
        }
    }
}

