/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.From;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.JoinType;
import com.blazebit.persistence.Path;
import com.blazebit.persistence.impl.AbortableOnClauseJoinNodeVisitor;
import com.blazebit.persistence.impl.AbortableResultJoinNodeVisitor;
import com.blazebit.persistence.impl.AbstractCTECriteriaBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AttributeHolder;
import com.blazebit.persistence.impl.CTEInfo;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ConstantifiedJoinNodeAttributeCollector;
import com.blazebit.persistence.impl.EntityMetamodelImpl;
import com.blazebit.persistence.impl.ExternalAliasDereferencingException;
import com.blazebit.persistence.impl.ImplicitJoinNotAllowedException;
import com.blazebit.persistence.impl.JoinAliasInfo;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.JoinNodeVisitor;
import com.blazebit.persistence.impl.JoinTreeNode;
import com.blazebit.persistence.impl.JpaUtils;
import com.blazebit.persistence.impl.MainQuery;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.TreatedJoinAliasInfo;
import com.blazebit.persistence.impl.builder.predicate.JoinOnBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListenerImpl;
import com.blazebit.persistence.impl.function.entity.ValuesEntity;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.impl.util.CompositeAttributeAccessor;
import com.blazebit.persistence.impl.util.Keywords;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapEntryAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.QualifiedAttribute;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.QualifiedExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.VisitorAdapter;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.AttributeAccessor;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.JpaMetamodelAccessor;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.BasicType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public class JoinManager
extends AbstractManager<ExpressionModifier> {
    private static final Logger LOG = Logger.getLogger(JoinManager.class.getName());
    private final List<JoinNode> rootNodes = new ArrayList<JoinNode>(1);
    private final List<JoinNode> entityFunctionNodes = new ArrayList<JoinNode>();
    private final List<JoinNode> lateInlineNodes = new ArrayList<JoinNode>();
    private final List<JoinNode> explicitJoinNodes = new ArrayList<JoinNode>();
    private final String joinRestrictionKeyword;
    private final MainQuery mainQuery;
    private final AliasManager aliasManager;
    private final EntityMetamodelImpl metamodel;
    private final JoinManager parent;
    private final JoinOnBuilderEndedListener joinOnBuilderListener;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder;
    private final Set<JoinNode> collectionJoinNodes = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<JoinNode> renderedJoins = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<JoinNode> markedJoinNodes = Collections.newSetFromMap(new IdentityHashMap());
    private final StringBuilder tempSb = new StringBuilder();
    private boolean emulateJoins;
    private boolean hasFullJoin;

    JoinManager(MainQuery mainQuery, AbstractCommonQueryBuilder<?, ?, ?, ?, ?> queryBuilder, ResolvingQueryGenerator queryGenerator, AliasManager aliasManager, JoinManager parent, ExpressionFactory expressionFactory) {
        super(queryGenerator, mainQuery.parameterManager, null);
        this.mainQuery = mainQuery;
        this.aliasManager = aliasManager;
        this.metamodel = mainQuery.metamodel;
        this.parent = parent;
        this.joinRestrictionKeyword = " " + mainQuery.jpaProvider.getOnClause() + " ";
        this.joinOnBuilderListener = new JoinOnBuilderEndedListener();
        this.subqueryInitFactory = new SubqueryInitiatorFactory(mainQuery, queryBuilder, aliasManager, this);
        this.expressionFactory = expressionFactory;
        this.queryBuilder = queryBuilder;
    }

    Map<JoinNode, JoinNode> applyFrom(JoinManager joinManager, Set<ClauseType> clauseExclusions, Set<JoinNode> alwaysIncludedNodes, ExpressionCopyContext copyContext) {
        IdentityHashMap<JoinNode, JoinNode> nodeMapping = new IdentityHashMap<JoinNode, JoinNode>();
        for (JoinNode node : joinManager.rootNodes) {
            JoinNode rootNode = this.applyFrom(nodeMapping, node, clauseExclusions, alwaysIncludedNodes, copyContext);
            if (node.getValueCount() <= 0) continue;
            this.entityFunctionNodes.add(rootNode);
        }
        for (JoinNode explicitJoinNode : joinManager.explicitJoinNodes) {
            JoinNode joinNode = (JoinNode)nodeMapping.get(explicitJoinNode);
            if (joinNode == null) continue;
            this.explicitJoinNodes.add(joinNode);
        }
        return nodeMapping;
    }

    private JoinNode applyFrom(Map<JoinNode, JoinNode> nodeMapping, JoinNode node, Set<ClauseType> clauseExclusions, Set<JoinNode> alwaysIncludedNodes, ExpressionCopyContext copyContext) {
        String rootAlias = node.getAlias();
        boolean implicit = node.getAliasInfo().isImplicit();
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, implicit, true, this.aliasManager);
        JoinNode rootNode = node.cloneRootNode(rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        nodeMapping.put(node, rootNode);
        for (JoinTreeNode joinTreeNode : node.getNodes().values()) {
            this.applyFrom(nodeMapping, rootNode, joinTreeNode, clauseExclusions, alwaysIncludedNodes, copyContext);
        }
        for (JoinNode joinNode : node.getEntityJoinNodes()) {
            JoinNode joinNode2 = this.applyFrom(nodeMapping, rootNode, null, joinNode.getAlias(), joinNode, clauseExclusions, alwaysIncludedNodes, copyContext);
            if (joinNode2 == null) continue;
            rootNode.addEntityJoin(joinNode2);
        }
        for (Map.Entry entry : node.getTreatedJoinNodes().entrySet()) {
            JoinNode treatedNode = (JoinNode)entry.getValue();
            JoinNode joinNode = this.applyFrom(nodeMapping, rootNode, null, treatedNode.getAlias(), treatedNode, clauseExclusions, alwaysIncludedNodes, copyContext);
            if (joinNode == null) continue;
            rootNode.getTreatedJoinNodes().put(treatedNode.getTreatType().getName(), joinNode);
        }
        return rootNode;
    }

    private void applyFrom(Map<JoinNode, JoinNode> nodeMapping, JoinNode parent, JoinTreeNode treeNode, Set<ClauseType> clauseExclusions, Set<JoinNode> alwaysIncludedNodes, ExpressionCopyContext copyContext) {
        JoinTreeNode newTreeNode = parent.getOrCreateTreeNode(treeNode.getRelationName(), treeNode.getAttribute());
        for (Map.Entry nodeEntry : treeNode.getJoinNodes().entrySet()) {
            JoinNode newNode = this.applyFrom(nodeMapping, parent, newTreeNode, (String)nodeEntry.getKey(), (JoinNode)nodeEntry.getValue(), clauseExclusions, alwaysIncludedNodes, copyContext);
            if (newNode == null) continue;
            newTreeNode.addJoinNode(newNode, nodeEntry.getValue() == treeNode.getDefaultNode());
        }
    }

    private JoinNode applyFrom(Map<JoinNode, JoinNode> nodeMapping, JoinNode parent, JoinTreeNode treeNode, String alias, JoinNode oldNode, Set<ClauseType> clauseExclusions, Set<JoinNode> alwaysIncludedNodes, ExpressionCopyContext copyContext) {
        JoinAliasInfo newAliasInfo;
        if (!clauseExclusions.isEmpty() && clauseExclusions.containsAll(oldNode.getClauseDependencies()) && !alwaysIncludedNodes.contains(oldNode)) {
            return null;
        }
        if (oldNode.getTreatType() == null) {
            newAliasInfo = new JoinAliasInfo(alias, oldNode.getAliasInfo().getAbsolutePath(), oldNode.getAliasInfo().isImplicit(), oldNode.getAliasInfo().isRootNode(), this.aliasManager);
            this.aliasManager.registerAliasInfo(newAliasInfo);
        } else {
            newAliasInfo = new TreatedJoinAliasInfo(nodeMapping.get(((TreatedJoinAliasInfo)oldNode.getAliasInfo()).getTreatedJoinNode()), oldNode.getTreatType());
        }
        JoinNode node = oldNode.cloneJoinNode(parent, treeNode, newAliasInfo);
        newAliasInfo.setJoinNode(node);
        nodeMapping.put(oldNode, node);
        if (oldNode.getOnPredicate() != null) {
            node.setOnPredicate(this.subqueryInitFactory.reattachSubqueries(oldNode.getOnPredicate().copy(copyContext), ClauseType.JOIN));
        }
        for (JoinTreeNode joinTreeNode : oldNode.getNodes().values()) {
            this.applyFrom(nodeMapping, node, joinTreeNode, clauseExclusions, alwaysIncludedNodes, copyContext);
        }
        for (JoinNode joinNode : oldNode.getEntityJoinNodes()) {
            JoinNode joinNode2 = this.applyFrom(nodeMapping, node, null, joinNode.getAlias(), joinNode, clauseExclusions, alwaysIncludedNodes, copyContext);
            if (joinNode2 == null) continue;
            node.addEntityJoin(joinNode2);
        }
        for (Map.Entry entry : oldNode.getTreatedJoinNodes().entrySet()) {
            JoinNode treatedNode = (JoinNode)entry.getValue();
            JoinTreeNode subTreeNode = treatedNode.getParentTreeNode() == null ? null : node.getOrCreateTreeNode(treatedNode.getParentTreeNode().getRelationName(), treatedNode.getParentTreeNode().getAttribute());
            JoinNode joinNode = this.applyFrom(nodeMapping, node, subTreeNode, treatedNode.getAlias(), treatedNode, clauseExclusions, alwaysIncludedNodes, copyContext);
            if (joinNode == null) continue;
            node.getTreatedJoinNodes().put((String)entry.getKey(), joinNode);
        }
        return node;
    }

    @Override
    public ClauseType getClauseType() {
        return ClauseType.JOIN;
    }

    Set<JoinNode> getKeyRestrictedLeftJoins() {
        if (!this.mainQuery.jpaProvider.needsJoinSubqueryRewrite()) {
            return Collections.emptySet();
        }
        HashSet<JoinNode> keyRestrictedLeftJoins = new HashSet<JoinNode>();
        this.acceptVisitor(new KeyRestrictedLeftJoinCollectingVisitor(this.mainQuery.jpaProvider, keyRestrictedLeftJoins));
        return keyRestrictedLeftJoins;
    }

    void removeSelectOnlyNodes(Set<JoinNode> candidateNodes) {
        int size = this.rootNodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode rootNode = this.rootNodes.get(i);
            JoinManager.removeSelectOnlyNodes(candidateNodes, rootNode);
        }
    }

    private static void removeSelectOnlyNodes(Set<JoinNode> candidateNodes, JoinNode node) {
        Iterator iterator = node.getNodes().values().iterator();
        while (iterator.hasNext()) {
            JoinTreeNode joinTreeNode = (JoinTreeNode)iterator.next();
            JoinManager.removeSelectOnlyNodes(candidateNodes, joinTreeNode.getJoinNodes().values().iterator());
            if (!joinTreeNode.getJoinNodes().isEmpty()) continue;
            iterator.remove();
        }
        JoinManager.removeSelectOnlyNodes(candidateNodes, node.getEntityJoinNodes().iterator());
    }

    private static void removeSelectOnlyNodes(Set<JoinNode> candidateNodes, Iterator<JoinNode> joinNodeIterator) {
        while (joinNodeIterator.hasNext()) {
            JoinNode subNode = joinNodeIterator.next();
            if (candidateNodes.contains(subNode) && subNode.getClauseDependencies().size() == 1 && subNode.getClauseDependencies().contains((Object)ClauseType.SELECT)) {
                joinNodeIterator.remove();
                continue;
            }
            JoinManager.removeSelectOnlyNodes(candidateNodes, subNode);
        }
    }

    public void collectCorrelatedRootExpressions(AliasManager aliasManager, Collection<Expression> expressions) {
        int size = this.rootNodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode rootNode = this.rootNodes.get(i);
            if (rootNode.getCorrelationParent() == null || rootNode.getCorrelationParent().getAliasInfo().getAliasOwner() != aliasManager) continue;
            ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, rootNode.getCorrelationParent().getManagedType());
            for (SingularAttribute idAttribute : extendedManagedType.getIdAttributes()) {
                ArrayList<PropertyExpression> pathElementExpressions = new ArrayList<PropertyExpression>(2);
                pathElementExpressions.add(new PropertyExpression(rootNode.getCorrelationParent().getAlias()));
                pathElementExpressions.add(new PropertyExpression(idAttribute.getName()));
                expressions.add((Expression)new PathExpression(pathElementExpressions, (PathReference)new SimplePathReference(rootNode.getCorrelationParent(), idAttribute.getName(), idAttribute.getType()), false, false));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String addRootValues(Class<?> valueHolderEntityClass, Class<?> valueClass, String rootAlias, int valueCount, String typeName, String castedParameter, boolean identifiableReference, boolean valueClazzAttributeSingular, String valuesClassAttributeName, ExtendedAttribute<?, ?> valuesLikeAttribute, String valueLikeClause, String qualificationExpression) {
        void var23_27;
        Object attributes;
        LinkedHashSet<String> idAttributeNames;
        boolean simpleValue;
        this.mainQuery.assertSupportsAdvancedSql("Illegal use of VALUES clause!");
        if (rootAlias == null) {
            throw new IllegalArgumentException("Illegal empty alias for the VALUES clause: " + valueHolderEntityClass.getName());
        }
        EntityType<?> entityType = this.mainQuery.metamodel.getEntity(valueHolderEntityClass);
        Type<?> type = this.mainQuery.metamodel.type(valueClass);
        ArrayList<String> attributePaths = new ArrayList<String>();
        String simpleValueAttributePrefix = "";
        ExtendedManagedType extendedManagedType = this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)entityType);
        if (identifiableReference) {
            simpleValue = false;
            idAttributeNames = new LinkedHashSet<String>();
            TreeMap attributes2 = new TreeMap(extendedManagedType.getAttributes());
            Set<SingularAttribute> idAttributes = valuesClassAttributeName == null ? JpaMetamodelUtils.getIdAttributes(entityType) : Collections.singleton((SingularAttribute)JpaMetamodelUtils.getAttribute(entityType, (String)valuesClassAttributeName));
            for (SingularAttribute singularAttribute : idAttributes) {
                idAttributeNames.add(singularAttribute.getName());
                Collection<String> embeddedPropertyPaths = JpaUtils.getEmbeddedPropertyPaths(attributes2, singularAttribute.getName(), this.mainQuery.jpaProvider.needsElementCollectionIdCutoff(), true);
                if (embeddedPropertyPaths.isEmpty()) {
                    attributePaths.add(singularAttribute.getName());
                    continue;
                }
                for (String embeddedPropertyPath : embeddedPropertyPaths) {
                    attributePaths.add(singularAttribute.getName() + "." + embeddedPropertyPath);
                }
            }
        } else {
            Collection<String> embeddedPropertyPaths;
            simpleValueAttributePrefix = valuesClassAttributeName == null ? "" : valuesClassAttributeName + ".";
            idAttributeNames = null;
            if (valuesLikeAttribute == null) {
                ManagedType<?> managedType = this.mainQuery.metamodel.getManagedType(valueClass);
                if (managedType == null) {
                    simpleValue = true;
                    attributes = new TreeMap(extendedManagedType.getAttributes());
                } else {
                    simpleValue = false;
                    attributes = new TreeMap(this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, managedType).getAttributes());
                }
                embeddedPropertyPaths = JpaUtils.getEmbeddedPropertyPaths(attributes, valuesClassAttributeName, this.mainQuery.jpaProvider.needsElementCollectionIdCutoff(), true);
                attributePaths.addAll(embeddedPropertyPaths);
            } else {
                String prefix = valuesClassAttributeName.substring(0, valuesClassAttributeName.length() - valuesLikeAttribute.getAttribute().getName().length());
                if (qualificationExpression == null) {
                    attributes = new TreeMap(extendedManagedType.getAttributes());
                    embeddedPropertyPaths = JpaUtils.getEmbeddedPropertyPaths(attributes, valuesClassAttributeName, this.mainQuery.jpaProvider.needsElementCollectionIdCutoff(), true);
                    if (embeddedPropertyPaths.isEmpty()) {
                        attributePaths.add(valuesClassAttributeName);
                    } else {
                        for (String embeddedPropertyPath : embeddedPropertyPaths) {
                            attributePaths.add(simpleValueAttributePrefix + embeddedPropertyPath);
                        }
                    }
                } else {
                    attributePaths.add(prefix + valuesLikeAttribute.getAttribute().getName());
                }
                simpleValue = type instanceof BasicType;
            }
        }
        String[][] parameterNames = new String[valueCount][attributePaths.size()];
        attributes = new String[attributePaths.size()];
        AttributeAccessor[] pathExpressions = new AttributeAccessor[attributePaths.size()];
        boolean bl = false;
        while (var23_27 < attributePaths.size()) {
            int j;
            String attributeName = (String)attributePaths.get((int)var23_27);
            String parameterPart = attributeName.replace('.', '_');
            attributes[var23_27] = attributeName;
            if (simpleValueAttributePrefix.isEmpty()) {
                pathExpressions[var23_27] = CompositeAttributeAccessor.of(this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, valueClass), attributeName);
                for (j = 0; j < valueCount; ++j) {
                    parameterNames[j][var23_27] = rootAlias + '_' + parameterPart + '_' + j;
                }
            } else if (attributeName.startsWith(simpleValueAttributePrefix)) {
                pathExpressions[var23_27] = CompositeAttributeAccessor.of(this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, valueClass), attributeName.substring(simpleValueAttributePrefix.length()));
                for (j = 0; j < valueCount; ++j) {
                    parameterNames[j][var23_27] = rootAlias + '_' + parameterPart + '_' + j;
                }
            } else if (simpleValue || attributeName.equals(valuesClassAttributeName)) {
                pathExpressions[var23_27] = null;
                if (qualificationExpression != null) {
                    parameterPart = parameterPart + '_' + qualificationExpression.toLowerCase();
                }
                for (j = 0; j < valueCount; ++j) {
                    parameterNames[j][var23_27] = rootAlias + '_' + parameterPart + '_' + j;
                }
            } else {
                pathExpressions[var23_27] = CompositeAttributeAccessor.of(this.mainQuery.metamodel.getManagedType(ExtendedManagedType.class, valueClass), attributeName);
                for (j = 0; j < valueCount; ++j) {
                    parameterNames[j][var23_27] = rootAlias + '_' + parameterPart + '_' + j;
                }
            }
            ++var23_27;
        }
        this.parameterManager.registerValuesParameter(rootAlias, valueClass, parameterNames, pathExpressions, this.queryBuilder);
        JoinAliasInfo joinAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, true, this.aliasManager);
        JoinNode rootNode = JoinNode.createValuesRootNode(type, entityType, typeName, valueCount, idAttributeNames, valueLikeClause, qualificationExpression, valueClazzAttributeSingular, simpleValue, valuesClassAttributeName, castedParameter, attributes, joinAliasInfo);
        joinAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.explicitJoinNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(joinAliasInfo);
        this.entityFunctionNodes.add(rootNode);
        return rootAlias;
    }

    String addRoot(EntityType<?> entityType, String rootAlias) {
        if (rootAlias == null) {
            String entityTypeName = entityType.getName();
            int dotIdx = entityTypeName.lastIndexOf(46);
            if (dotIdx != -1) {
                entityTypeName = entityTypeName.substring(dotIdx + 1);
            }
            StringBuilder sb = new StringBuilder(entityTypeName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String alias = sb.toString();
            rootAlias = this.metamodel.getEntity(alias) == null && this.aliasManager.isAliasAvailable(alias) && !Keywords.JPQL.contains(alias.toUpperCase()) ? alias : this.aliasManager.generateRootAlias(alias);
        }
        JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, true, true, this.aliasManager);
        JoinNode rootNode = JoinNode.createRootNode(entityType, rootAliasInfo);
        rootAliasInfo.setJoinNode(rootNode);
        this.rootNodes.add(rootNode);
        this.explicitJoinNodes.add(rootNode);
        this.aliasManager.registerAliasInfo(rootAliasInfo);
        return rootAlias;
    }

    String addRoot(String correlationPath, String rootAlias, boolean lateral) {
        Expression expr = this.expressionFactory.createJoinPathExpression(correlationPath);
        return this.addRoot(correlationPath, expr, rootAlias, lateral);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String addRoot(String correlationPath, Expression expr, String rootAlias, boolean lateral) {
        JoinNode rootNode;
        PathExpression pathExpression;
        String treatEntityType = null;
        if (expr instanceof PathExpression) {
            pathExpression = (PathExpression)expr;
        } else if (expr instanceof TreatExpression) {
            TreatExpression treatExpression = (TreatExpression)expr;
            Expression expression = treatExpression.getExpression();
            if (!(expression instanceof PathExpression)) throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
            pathExpression = (PathExpression)expression;
            treatEntityType = treatExpression.getType();
        } else {
            if (!(expr instanceof FunctionExpression) || !ExpressionUtils.isOuterFunction((FunctionExpression)((FunctionExpression)expr))) throw new IllegalArgumentException("Correlation join path [" + correlationPath + "] is not a valid join path");
            FunctionExpression outerFunctionExpr = (FunctionExpression)expr;
            pathExpression = (PathExpression)outerFunctionExpr.getExpressions().get(0);
        }
        if (this.isJoinableSelectAlias(pathExpression, false, false)) {
            throw new IllegalArgumentException("No select alias allowed in join path");
        }
        ArrayList<JoinNode> treatedCorrelationNodes = new ArrayList<JoinNode>();
        ArrayList<PathExpression> pathExpressionStack = new ArrayList<PathExpression>();
        pathExpressionStack.add(pathExpression);
        JoinNode correlationParent = null;
        int start = 0;
        for (int i = 0; i < pathExpressionStack.size(); ++i) {
            AliasInfo aliasInfo;
            PathExpression currentPathExpression = (PathExpression)pathExpressionStack.get(i);
            List pathElements = currentPathExpression.getExpressions();
            if (pathElements.get(0) instanceof PropertyExpression) {
                aliasInfo = this.aliasManager.getAliasInfo(((PathElementExpression)pathElements.get(0)).toString());
                if (aliasInfo != null) {
                    correlationParent = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    start = 1;
                    continue;
                }
                correlationParent = this.parent.getRootNodeOrFail("Could not join correlation path [", correlationPath, "] because it did not use an absolute path but multiple root nodes are available!");
                continue;
            }
            if (!(pathElements.get(0) instanceof TreatExpression)) throw new IllegalArgumentException("The correlation path '" + correlationPath + "' couldn't be properly analyzed because of an unsupported expression structure!");
            TreatExpression treatExpression = (TreatExpression)pathElements.get(0);
            PathExpression treatExpressionPathExpression = (PathExpression)treatExpression.getExpression();
            if (treatExpressionPathExpression.getExpressions().size() == 1) {
                aliasInfo = this.aliasManager.getAliasInfo(((PathElementExpression)treatExpressionPathExpression.getExpressions().get(0)).toString());
                if (aliasInfo != null) {
                    correlationParent = ((JoinAliasInfo)aliasInfo).getJoinNode().getTreatedJoinNode(this.metamodel.entity(treatExpression.getType()));
                    treatedCorrelationNodes.add(correlationParent);
                    start = 1;
                    continue;
                }
                correlationParent = this.parent.getRootNodeOrFail("Could not join correlation path [", correlationPath, "] because it did not use an absolute path but multiple root nodes are available!");
                pathExpressionStack.add(treatExpressionPathExpression);
                break;
            }
            pathExpressionStack.add(treatExpressionPathExpression);
        }
        PathExpression currentPathExpression = (PathExpression)pathExpressionStack.remove(pathExpressionStack.size() - 1);
        List pathElements = currentPathExpression.getExpressions();
        ArrayList<PathElementExpression> fields = new ArrayList<PathElementExpression>();
        String correlatedAttribute = this.findCorrelatedAttribute(correlationParent, pathElements, start, pathElements.size(), fields);
        Expression correlatedAttributeExpr = this.expressionFactory.createSimpleExpression(correlatedAttribute, false);
        AttributeHolder joinResult = JpaUtils.getAttributeForJoining(this.metamodel, correlationParent.getNodeType(), correlatedAttributeExpr, null);
        Type<?> type = joinResult.getAttributeType();
        if (rootAlias == null) {
            String typeName = JpaMetamodelUtils.getSimpleTypeName(type);
            StringBuilder sb = new StringBuilder(typeName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            String alias = sb.toString();
            rootAlias = this.metamodel.getEntity(alias) == null && this.aliasManager.isAliasAvailable(alias) ? alias : this.aliasManager.generateRootAlias(alias);
        }
        if (pathExpressionStack.isEmpty() && (start += fields.size()) + 1 == pathElements.size()) {
            JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAlias, rootAlias, false, true, this.aliasManager);
            rootNode = JoinNode.createCorrelationRootNode(correlationParent, correlatedAttribute, joinResult.getAttribute(), type, this.metamodel.getEntity(treatEntityType), rootAliasInfo, lateral);
            rootAliasInfo.setJoinNode(rootNode);
            this.rootNodes.add(rootNode);
            this.explicitJoinNodes.add(rootNode);
            this.aliasManager.registerAliasInfo(rootAliasInfo);
        } else {
            JoinNode treatedNode;
            EntityType<?> treatType;
            TreatExpression treatExpression;
            JoinResult result;
            String rootAliasBase = rootAlias + "_base";
            if (this.metamodel.getEntity(rootAliasBase) != null || !this.aliasManager.isAliasAvailable(rootAliasBase)) {
                rootAliasBase = this.aliasManager.generateRootAlias(rootAliasBase);
            }
            JoinAliasInfo rootAliasInfo = new JoinAliasInfo(rootAliasBase, rootAliasBase, true, true, this.aliasManager);
            rootNode = JoinNode.createCorrelationRootNode(correlationParent, correlatedAttribute, joinResult.getAttribute(), type, null, rootAliasInfo, lateral);
            rootAliasInfo.setJoinNode(rootNode);
            this.rootNodes.add(rootNode);
            this.explicitJoinNodes.add(rootNode);
            this.aliasManager.registerAliasInfo(rootAliasInfo);
            if (pathExpressionStack.size() > 1) {
                result = this.implicitJoin(rootNode, currentPathExpression, null, JoinType.INNER, null, new HashSet<String>(), start + 1, pathElements.size(), true, true, false);
                start = 0;
                while (pathExpressionStack.size() > 1) {
                    currentPathExpression = (PathExpression)pathExpressionStack.remove(pathExpressionStack.size() - 1);
                    pathElements = currentPathExpression.getExpressions();
                    treatExpression = (TreatExpression)pathElements.get(0);
                    treatType = this.metamodel.entity(treatExpression.getType());
                    treatedNode = result.baseNode.getTreatedJoinNode(treatType);
                    treatedCorrelationNodes.add(treatedNode);
                    result = this.implicitJoin(treatedNode, currentPathExpression, null, JoinType.INNER, null, new HashSet<String>(), 1, pathElements.size(), true, true, false);
                }
            } else {
                result = new JoinResult(rootNode, null, rootNode.getNodeType(), -1, -1);
            }
            if (pathExpressionStack.size() > 0) {
                currentPathExpression = (PathExpression)pathExpressionStack.remove(0);
                pathElements = currentPathExpression.getExpressions();
                treatExpression = (TreatExpression)pathElements.get(0);
                treatType = this.metamodel.entity(treatExpression.getType());
                treatedNode = result.baseNode.getTreatedJoinNode(treatType);
                treatedCorrelationNodes.add(treatedNode);
                result = new JoinResult(treatedNode, null, (Type<?>)treatType, -1, -1);
            }
            pathElements = currentPathExpression.getExpressions();
            Expression elementExpr = (Expression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(result.baseNode, pathExpression, null, JoinType.INNER, null, new HashSet<String>(), start + 1, pathElements.size() - 1, true, true, false);
            JoinResult finalNode = this.createOrUpdateNode(result.baseNode, result.addToList(Collections.singletonList(elementExpr.toString())), treatEntityType, rootAlias, JoinType.INNER, null, false, true, true);
            if (treatEntityType != null) {
                treatedCorrelationNodes.add(finalNode.baseNode);
            }
        }
        if (treatedCorrelationNodes.isEmpty()) return rootAlias;
        rootNode.setJoinNodesNeedingTreatConjunct(treatedCorrelationNodes);
        return rootAlias;
    }

    private String findCorrelatedAttribute(JoinNode correlationParent, List<PathElementExpression> pathElements, int start, int end, List<PathElementExpression> fields) {
        PathTargetResolvingExpressionVisitor pathResolvingVisitor = new PathTargetResolvingExpressionVisitor((EntityMetamodel)this.metamodel, correlationParent.getNodeType(), correlationParent.getAlias());
        for (int i = start; i < end; ++i) {
            PathElementExpression expression = pathElements.get(i);
            expression.accept((Expression.Visitor)pathResolvingVisitor);
            Attribute attribute = (Attribute)pathResolvingVisitor.getPossibleTargets().entrySet().iterator().next().getKey();
            if (attribute == null) continue;
            if (this.mainQuery.jpaProvider.getJpaMetamodelAccessor().isJoinable(attribute)) {
                StringBuilder sb = new StringBuilder();
                for (PathElementExpression field : fields) {
                    sb.append(field.toString());
                    sb.append('.');
                }
                sb.append(attribute.getName());
                return sb.toString();
            }
            fields.add(expression);
        }
        return null;
    }

    void removeRoot() {
        JoinNode rootNode = this.rootNodes.remove(0);
        this.explicitJoinNodes.remove(0);
        this.aliasManager.unregisterAliasInfoForBottomLevel(rootNode.getAliasInfo());
    }

    JoinNode getRootNodeOrFail(String string) {
        return this.getRootNodeOrFail(string, "", "");
    }

    JoinNode getRootNodeOrFail(String prefix, Object middle, String suffix) {
        if (this.rootNodes.size() > 1) {
            throw new IllegalArgumentException(prefix + middle + suffix);
        }
        return this.rootNodes.get(0);
    }

    JoinNode getRootNode(Expression expression) {
        if (!(expression instanceof PropertyExpression)) {
            return null;
        }
        String alias = expression.toString();
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode node = nodes.get(i);
            if (!alias.equals(node.getAliasInfo().getAlias())) continue;
            return node;
        }
        return null;
    }

    public List<JoinNode> getRoots() {
        return this.rootNodes;
    }

    boolean hasCollections() {
        final ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector = this.queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector();
        final JoinNode firstRootNode = this.rootNodes.get(0);
        return this.acceptVisitor(new AbortableResultJoinNodeVisitor<Boolean>(){

            @Override
            public Boolean getStopValue() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visit(JoinNode node) {
                return node != firstRootNode && node.isCollection(constantifiedJoinNodeAttributeCollector);
            }
        });
    }

    boolean hasNonEmulatableJoins() {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            JoinNode n = nodes.get(i);
            if (!n.getNodes().isEmpty()) {
                return true;
            }
            for (JoinNode joinNode : n.getEntityJoinNodes()) {
                if (joinNode.getJoinType() == JoinType.INNER) continue;
                return true;
            }
            if (n.getTreatedJoinNodes().isEmpty()) continue;
            for (JoinNode treatedNode : n.getTreatedJoinNodes().values()) {
                if (treatedNode.getNodes().isEmpty() && treatedNode.getEntityJoinNodes().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasEntityFunctions() {
        return this.entityFunctionNodes.size() > 0 || this.lateInlineNodes.size() > 0;
    }

    List<JoinNode> getEntityFunctions(Set<ClauseType> clauseExclusions, boolean ignoreCardinality, Set<JoinNode> alwaysIncludedNodes) {
        ArrayList<JoinNode> entityFunctions = new ArrayList<JoinNode>(this.entityFunctionNodes.size() + this.lateInlineNodes.size());
        for (JoinNode node : this.entityFunctionNodes) {
            if (!node.isRootJoinNode() && !clauseExclusions.isEmpty() && clauseExclusions.containsAll(node.getClauseDependencies()) && (ignoreCardinality || !node.isCardinalityMandatory()) && !alwaysIncludedNodes.contains(node)) continue;
            entityFunctions.add(node);
        }
        for (JoinNode node : this.lateInlineNodes) {
            if (!node.isRootJoinNode() && !clauseExclusions.isEmpty() && clauseExclusions.containsAll(node.getClauseDependencies()) && (ignoreCardinality || !node.isCardinalityMandatory()) && !alwaysIncludedNodes.contains(node)) continue;
            entityFunctions.add(node);
        }
        return entityFunctions;
    }

    boolean hasLateInlineNodes() {
        return this.acceptVisitor(new AbortableResultJoinNodeVisitor<Boolean>(){

            @Override
            public Boolean getStopValue() {
                return Boolean.TRUE;
            }

            @Override
            public Boolean visit(JoinNode node) {
                Class<?> cteType = node.getJavaType();
                if (cteType != null) {
                    CTEInfo cte = ((JoinManager)JoinManager.this).mainQuery.cteManager.getCte(cteType, node.getAlias(), JoinManager.this);
                    if (cte == null) {
                        cte = ((JoinManager)JoinManager.this).mainQuery.cteManager.getCte(cteType);
                    }
                    return cte != null && cte.inline;
                }
                return false;
            }
        });
    }

    public Set<JoinNode> getCollectionJoins() {
        if (this.rootNodes.isEmpty()) {
            return Collections.emptySet();
        }
        final HashSet<JoinNode> collectionJoins = new HashSet<JoinNode>();
        final ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector = this.queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector();
        final JoinNode firstRootNode = this.rootNodes.get(0);
        this.acceptVisitor(new JoinNodeVisitor(){

            @Override
            public void visit(JoinNode node) {
                if (node != firstRootNode && node.isCollection(constantifiedJoinNodeAttributeCollector)) {
                    collectionJoins.add(node);
                }
            }
        });
        return collectionJoins;
    }

    List<JoinNode> getEntityFunctionNodes() {
        return this.entityFunctionNodes;
    }

    List<JoinNode> getLateInlineNodes() {
        return this.lateInlineNodes;
    }

    public JoinManager getParent() {
        return this.parent;
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public SubqueryInitiatorFactory getSubqueryInitFactory() {
        return this.subqueryInitFactory;
    }

    void reorderSimpleValuesClauses() {
        ArrayList<JoinNode> newRootNodes = new ArrayList<JoinNode>();
        ArrayList<JoinNode> noJoinValuesNodes = new ArrayList<JoinNode>();
        for (JoinNode rootNode : this.rootNodes) {
            if (JoinManager.isNoJoinValuesNode(rootNode)) {
                noJoinValuesNodes.add(rootNode);
                continue;
            }
            newRootNodes.add(rootNode);
        }
        newRootNodes.addAll(noJoinValuesNodes);
        this.rootNodes.clear();
        this.rootNodes.addAll(newRootNodes);
    }

    private static boolean isNoJoinValuesNode(JoinNode rootNode) {
        return rootNode.getValueCount() > 0 && rootNode.getNodes().isEmpty() && rootNode.getTreatedJoinNodes().isEmpty() && rootNode.getEntityJoinNodes().isEmpty();
    }

    Set<JoinNode> buildClause(StringBuilder sb, Set<ClauseType> clauseExclusions, String aliasPrefix, boolean collectCollectionJoinNodes, boolean externalRepresentation, boolean ignoreCardinality, boolean lateralExample, List<String> optionalWhereConjuncts, List<String> whereConjuncts, Map<Class<?>, Map<String, DbmsModificationState>> explicitVersionEntities, Set<JoinNode> nodesToFetch, Set<JoinNode> alwaysIncludedNodes) {
        boolean renderFetches = !clauseExclusions.contains((Object)ClauseType.SELECT);
        this.collectionJoinNodes.clear();
        this.renderedJoins.clear();
        sb.append(" FROM ");
        StringBuilder noJoinValuesNodesSb = new StringBuilder();
        ArrayList<JoinNode> stack = new ArrayList<JoinNode>(this.explicitJoinNodes);
        Collections.reverse(stack);
        ArrayList<JoinNode> placeholderRequiringNodes = new ArrayList<JoinNode>();
        boolean firstRootNode = true;
        while (!stack.isEmpty()) {
            JoinNode node = (JoinNode)stack.remove(stack.size() - 1);
            if (node.isRootJoinNode()) {
                if (firstRootNode) {
                    firstRootNode = false;
                } else {
                    sb.append(", ");
                }
                JoinNode correlationParent = node.getCorrelationParent();
                boolean renderAlias = true;
                if (externalRepresentation && node.getValueCount() > 0) {
                    EntityType<?> valueType = node.getValueType();
                    Type<?> nodeType = node.getNodeType();
                    if (valueType.getJavaType() == ValuesEntity.class) {
                        sb.append(node.getValuesTypeName());
                    } else if (nodeType instanceof EntityType) {
                        sb.append(((EntityType)nodeType).getName());
                    } else {
                        sb.append(node.getNodeType().getJavaType().getSimpleName());
                    }
                    sb.append("(");
                    sb.append(node.getValueCount());
                    if (node.getValuesIdNames() != null) {
                        sb.append(" ID");
                    }
                    sb.append(" VALUES");
                    if (node.getValuesLikeClause() != null) {
                        sb.append(" LIKE ");
                        sb.append(node.getValuesLikeClause());
                    }
                    sb.append(")");
                } else if (externalRepresentation && explicitVersionEntities.get(node.getJavaType()) != null) {
                    DbmsModificationState state = explicitVersionEntities.get(node.getJavaType()).get(node.getAlias());
                    EntityType<?> type = node.getEntityType();
                    if (state == DbmsModificationState.NEW) {
                        sb.append("NEW(");
                    } else {
                        sb.append("OLD(");
                    }
                    sb.append(type.getName());
                    sb.append(')');
                } else {
                    if (correlationParent != null && !node.isLateral()) {
                        renderAlias = this.renderCorrelationJoinPath(sb, correlationParent.getAliasInfo(), node, whereConjuncts, optionalWhereConjuncts, externalRepresentation);
                    } else {
                        EntityType<?> type = node.getInternalEntityType();
                        sb.append(type.getName());
                    }
                    if (externalRepresentation && node.isInlineCte()) {
                        sb.append('(');
                        node.getInlineCte().nonRecursiveCriteriaBuilder.buildExternalQueryString(sb);
                        sb.append(')');
                    }
                }
                if (renderAlias) {
                    sb.append(' ');
                    if (aliasPrefix != null) {
                        sb.append(aliasPrefix);
                    }
                    sb.append(node.getAliasInfo().getAlias());
                    if (externalRepresentation && node.isInlineCte()) {
                        this.renderInlineCteAttributes(sb, node);
                    }
                }
                this.renderedJoins.add(node);
                node.registerDependencies();
                if (node.getValueCount() > 0) {
                    if (!externalRepresentation && !node.isValueClazzAttributeSingular()) {
                        sb.append(" LEFT JOIN ");
                        sb.append(node.getAlias());
                        sb.append('.');
                        sb.append(node.getValuesLikeAttribute());
                        sb.append(' ');
                        sb.append(node.getAlias());
                        sb.append('_');
                        sb.append(node.getValuesLikeAttribute().replace('.', '_'));
                        if (node.getQualificationExpression() != null) {
                            sb.append('_').append(node.getQualificationExpression().toLowerCase());
                        }
                    }
                    placeholderRequiringNodes.add(node);
                } else if (!externalRepresentation && node.isInlineCte()) {
                    placeholderRequiringNodes.add(node);
                }
                if (!node.getNodes().isEmpty()) {
                    this.addDefaultJoins(stack, node.getNodes().descendingMap());
                }
                for (JoinNode treatedNode : node.getTreatedJoinNodes().values()) {
                    if (treatedNode.getNodes().isEmpty()) continue;
                    this.addDefaultJoins(stack, treatedNode.getNodes().descendingMap());
                }
                continue;
            }
            boolean isCollection = false;
            if (node.getParentTreeNode() != null && node.getParentTreeNode().isCollection() || node.isEntityJoinNode()) {
                ConstantifiedJoinNodeAttributeCollector constantifiedJoinNodeAttributeCollector = this.queryBuilder.functionalDependencyAnalyzerVisitor.getConstantifiedJoinNodeAttributeCollector();
                isCollection = !constantifiedJoinNodeAttributeCollector.isConstantified(node);
            }
            this.addDefaultJoinsAndRenderJoinNode(sb, node.getParent().getAliasInfo(), stack, node, isCollection, clauseExclusions, aliasPrefix, collectCollectionJoinNodes, renderFetches, ignoreCardinality, nodesToFetch, whereConjuncts, placeholderRequiringNodes, alwaysIncludedNodes, externalRepresentation, lateralExample);
        }
        if (!placeholderRequiringNodes.isEmpty() && !externalRepresentation) {
            if (noJoinValuesNodesSb.length() != 0) {
                noJoinValuesNodesSb.append(" AND ");
            }
            this.renderPlaceholderRequiringPredicate(noJoinValuesNodesSb, placeholderRequiringNodes, externalRepresentation);
        }
        if (noJoinValuesNodesSb.length() != 0) {
            whereConjuncts.add(0, noJoinValuesNodesSb.toString());
        }
        return this.collectionJoinNodes;
    }

    void renderPlaceholderRequiringPredicate(StringBuilder sb, List<JoinNode> placeholderRequiringNodes, boolean externalRepresentation) {
        JoinNode placeholderRequiringNode = placeholderRequiringNodes.get(0);
        this.renderPlaceholderRequiringPredicate(sb, placeholderRequiringNode, placeholderRequiringNode.getAlias(), externalRepresentation, true);
        for (int i = 1; i < placeholderRequiringNodes.size(); ++i) {
            placeholderRequiringNode = placeholderRequiringNodes.get(i);
            sb.append(" AND ");
            this.renderPlaceholderRequiringPredicate(sb, placeholderRequiringNode, placeholderRequiringNode.getAlias(), externalRepresentation, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renderPlaceholderRequiringPredicate(StringBuilder sb, JoinNode rootNode, String alias, boolean externalRepresentation, boolean renderMarkerPredicate) {
        int valueCount = rootNode.getValueCount();
        if (!externalRepresentation) {
            if (valueCount > 0) {
                String typeName = rootNode.getValuesTypeName() == null ? null : rootNode.getValuesTypeName().toUpperCase();
                String[] attributes = rootNode.getValuesAttributes();
                String valueClazzAttributeName = rootNode.getValuesLikeAttribute();
                String prefix = rootNode.getAlias();
                for (int i = 0; i < valueCount; ++i) {
                    for (int j = 0; j < attributes.length; ++j) {
                        if (typeName != null) {
                            sb.append("TREAT_");
                            sb.append(typeName);
                            sb.append('(');
                            sb.append(alias);
                            sb.append('.');
                            sb.append(attributes[j]);
                            sb.append(')');
                        } else {
                            if (rootNode.getQualificationExpression() != null) {
                                sb.append(rootNode.getQualificationExpression()).append('(');
                            }
                            sb.append(alias);
                            if (rootNode.isValueClazzAttributeSingular()) {
                                sb.append('.');
                                if (rootNode.isValueClazzSimpleValue()) {
                                    sb.append(valueClazzAttributeName);
                                } else {
                                    sb.append(attributes[j]);
                                }
                            } else {
                                sb.append('_');
                                sb.append(valueClazzAttributeName.replace('.', '_'));
                                if (!rootNode.isValueClazzSimpleValue()) {
                                    sb.append(attributes[j], valueClazzAttributeName.length(), attributes[j].length());
                                }
                            }
                            if (rootNode.getQualificationExpression() != null) {
                                sb.append('_');
                                sb.append(rootNode.getQualificationExpression().toLowerCase());
                                sb.append(')');
                            }
                        }
                        sb.append(" = ");
                        sb.append(':');
                        sb.append(prefix);
                        sb.append('_');
                        if (rootNode.isValueClazzSimpleValue()) {
                            sb.append(valueClazzAttributeName.replace('.', '_'));
                        } else {
                            sb.append(attributes[j].replace('.', '_'));
                        }
                        if (rootNode.getQualificationExpression() != null) {
                            sb.append('_');
                            sb.append(rootNode.getQualificationExpression().toLowerCase());
                        }
                        sb.append('_').append(i);
                        sb.append(" OR ");
                    }
                }
                sb.setLength(sb.length() - " OR ".length());
                if (renderMarkerPredicate) {
                    sb.append(" AND ").append("999=999").append(" AND ").append(rootNode.getAlias()).append(".");
                    if (rootNode.getValuesTypeName() != null) {
                        sb.append(valueClazzAttributeName);
                    } else {
                        sb.append(this.getBasicExampleAttribute(rootNode.getInternalEntityType()));
                    }
                    sb.append(" IS NULL");
                }
            } else if (rootNode.isInlineCte()) {
                sb.append(this.mainQuery.jpaProvider.getCustomFunctionInvocation("nullfn", 1));
                sb.append('(');
                StringBuilder oldBuffer = this.queryGenerator.getQueryBuffer();
                this.queryGenerator.setClauseType(ClauseType.SET);
                this.queryGenerator.setQueryBuffer(sb);
                try {
                    rootNode.getInlineCte().nonRecursiveCriteriaBuilder.prepareAndCheck();
                    rootNode.getInlineCte().nonRecursiveCriteriaBuilder.asExpression(false).accept((Expression.Visitor)this.queryGenerator);
                }
                finally {
                    this.queryGenerator.setClauseType(null);
                    this.queryGenerator.setQueryBuffer(oldBuffer);
                }
                sb.append(')').append(')').append(" IS NULL");
                sb.append(" AND ").append("999=999");
                String exampleAttributeName = this.getBasicExampleAttribute(rootNode.getEntityType());
                sb.append(" AND ").append(rootNode.getAlias()).append(".").append(exampleAttributeName).append(" IS NULL");
            }
        }
    }

    private String getBasicExampleAttribute(EntityType<?> entityType) {
        SingularAttribute attribute = (SingularAttribute)JpaMetamodelUtils.getIdAttributes(entityType).iterator().next();
        if (attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED) {
            ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, (ManagedType<?>)entityType);
            String prefix = attribute.getName() + ".";
            for (Map.Entry entry : extendedManagedType.getOwnedSingularAttributes().entrySet()) {
                if (!((String)entry.getKey()).startsWith(prefix) || ((ExtendedAttribute)entry.getValue()).getAttribute().getPersistentAttributeType() != Attribute.PersistentAttributeType.BASIC) continue;
                return (String)entry.getKey();
            }
        }
        return attribute.getName();
    }

    void verifyBuilderEnded() {
        this.joinOnBuilderListener.verifyBuilderEnded();
    }

    void acceptVisitor(JoinNodeVisitor v) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(v);
        }
    }

    public boolean acceptVisitor(AbortableResultJoinNodeVisitor<Boolean> visitor) {
        Boolean stop = visitor.getStopValue();
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!stop.equals(nodes.get(i).accept(visitor))) continue;
            return true;
        }
        return false;
    }

    void setEmulateJoins(boolean emulateJoins) {
        this.emulateJoins = emulateJoins;
    }

    public boolean acceptVisitor(Expression.ResultVisitor<Boolean> aggregateDetector, boolean stopValue) {
        Boolean stop = stopValue;
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            if (!stop.equals(nodes.get(i).accept(new AbortableOnClauseJoinNodeVisitor(aggregateDetector, stopValue)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        List<JoinNode> nodes = this.rootNodes;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            nodes.get(i).accept(visitor);
        }
    }

    private void renderJoinNode(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, String aliasPrefix, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts, List<JoinNode> placeholderRequiringNodes, boolean externalRepresentation, boolean lateralExample) {
        if (!this.renderedJoins.contains(node)) {
            boolean fetch;
            boolean bl = fetch = nodesToFetch.contains(node) && renderFetches;
            if (node.isQualifiedJoin() && !fetch) {
                this.renderedJoins.add(node);
                return;
            }
            if (node.isTreatedJoinNode()) {
                this.renderedJoins.add(node);
                return;
            }
            if (node.isInlineCte()) {
                placeholderRequiringNodes.add(node);
            }
            if (!externalRepresentation && node.isEntityJoinNode() && (this.emulateJoins || !this.mainQuery.jpaProvider.supportsEntityJoin())) {
                if (node.getJoinType() != JoinType.INNER) {
                    throw new IllegalArgumentException("Can't emulate outer join for entity join node: " + node);
                }
                sb.append(", ");
                EntityType<?> type = node.getEntityType();
                sb.append(type.getName());
                sb.append(' ');
                if (aliasPrefix != null) {
                    sb.append(aliasPrefix);
                }
                sb.append(node.getAliasInfo().getAlias());
                node.registerDependencies();
                if (node.getOnPredicate() != null && !node.getOnPredicate().getChildren().isEmpty()) {
                    this.tempSb.setLength(0);
                    this.queryGenerator.setClauseType(ClauseType.JOIN);
                    this.queryGenerator.setQueryBuffer(this.tempSb);
                    SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
                    this.queryGenerator.generate((Expression)node.getOnPredicate());
                    this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
                    this.queryGenerator.setClauseType(null);
                    whereConjuncts.add(this.tempSb.toString());
                    this.tempSb.setLength(0);
                }
                this.renderedJoins.add(node);
            } else {
                boolean onClause;
                switch (node.getJoinType()) {
                    case INNER: {
                        sb.append(" JOIN ");
                        break;
                    }
                    case LEFT: {
                        sb.append(" LEFT JOIN ");
                        break;
                    }
                    case RIGHT: {
                        sb.append(" RIGHT JOIN ");
                        break;
                    }
                    case FULL: {
                        sb.append(" FULL JOIN ");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown join type: " + node.getJoinType());
                    }
                }
                if (externalRepresentation && node.isLateral()) {
                    sb.append("LATERAL ");
                }
                if (fetch) {
                    sb.append("FETCH ");
                }
                if (aliasPrefix != null) {
                    sb.append(aliasPrefix);
                }
                String onCondition = this.renderJoinPath(sb, joinBase, node, whereConjuncts, externalRepresentation);
                sb.append(' ');
                if (aliasPrefix != null) {
                    sb.append(aliasPrefix);
                }
                sb.append(node.getAliasInfo().getAlias());
                if (externalRepresentation && node.isInlineCte()) {
                    this.renderInlineCteAttributes(sb, node);
                }
                this.renderedJoins.add(node);
                boolean realOnClause = node.getOnPredicate() != null && !node.getOnPredicate().getChildren().isEmpty() || onCondition != null;
                boolean bl2 = onClause = !fetch && !placeholderRequiringNodes.isEmpty() && !externalRepresentation || realOnClause;
                if (onClause) {
                    sb.append(this.joinRestrictionKeyword);
                    sb.append('(');
                }
                if (onClause && !placeholderRequiringNodes.isEmpty() && !lateralExample) {
                    if (!externalRepresentation) {
                        this.renderPlaceholderRequiringPredicate(sb, placeholderRequiringNodes, externalRepresentation);
                        if (realOnClause) {
                            sb.append(" AND ");
                        }
                    }
                    placeholderRequiringNodes.clear();
                }
                if (node.getOnPredicate() != null && !node.getOnPredicate().getChildren().isEmpty() && !lateralExample) {
                    if (onCondition != null) {
                        sb.append(onCondition).append(" AND ");
                    }
                    this.queryGenerator.setClauseType(ClauseType.JOIN);
                    this.queryGenerator.setQueryBuffer(sb);
                    SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
                    this.queryGenerator.setRenderedJoinNodes(this.renderedJoins);
                    this.queryGenerator.generate((Expression)node.getOnPredicate());
                    this.queryGenerator.setRenderedJoinNodes(null);
                    this.queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
                    this.queryGenerator.setClauseType(null);
                } else if (onCondition != null && !lateralExample) {
                    sb.append(onCondition);
                }
                if (onClause) {
                    if (lateralExample) {
                        sb.append("1=1");
                    }
                    sb.append(')');
                }
            }
        }
    }

    private void renderInlineCteAttributes(StringBuilder sb, JoinNode node) {
        sb.append('(');
        List<String> attributes = node.getInlineCte().attributes;
        sb.append(attributes.get(0));
        for (int i = 1; i < attributes.size(); ++i) {
            sb.append(", ").append(attributes.get(i));
        }
        sb.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean renderCorrelationJoinPath(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, List<String> whereConjuncts, List<String> optionalWhereConjuncts, boolean externalRepresentation) {
        boolean renderTreat;
        StringBuilder whereSb = null;
        if (node.getJoinNodesNeedingTreatConjunct() != null) {
            whereSb = new StringBuilder();
            for (JoinNode joinNode : node.getJoinNodesNeedingTreatConjunct()) {
                whereSb.setLength(0);
                whereSb.append("TYPE(");
                joinNode.appendAlias(whereSb, false, externalRepresentation);
                whereSb.append(") = ");
                whereSb.append(joinNode.getTreatType().getName());
                whereConjuncts.add(whereSb.toString());
            }
        }
        boolean bl = renderTreat = this.mainQuery.jpaProvider.supportsTreatJoin() && (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving() || node.getJoinType() == JoinType.INNER);
        if (this.mainQuery.jpaProvider.needsCorrelationPredicateWhenCorrelatingWithWhereClause() || node.getTreatType() != null && !renderTreat && !this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) {
            ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, node.getCorrelationParent().getManagedType());
            ExtendedAttribute attribute = extendedManagedType.getAttribute(node.getCorrelationPath());
            if (StringUtils.isEmpty((CharSequence)attribute.getMappedBy())) {
                if (attribute.getAttribute() instanceof ListAttribute && !attribute.isBag()) {
                    boolean singleValuedAssociationId;
                    sb.append(node.getCorrelationParent().getEntityType().getName());
                    sb.append(" _synthetic_");
                    sb.append(node.getAlias());
                    sb.append(" JOIN _synthetic_");
                    sb.append(node.getAlias());
                    sb.append('.').append(node.getCorrelationPath());
                    if (whereSb == null) {
                        whereSb = new StringBuilder();
                    } else {
                        whereSb.setLength(0);
                    }
                    whereSb.append("_synthetic_").append(node.getAlias());
                    boolean bl2 = singleValuedAssociationId = this.mainQuery.jpaProvider.supportsSingleValuedAssociationIdExpressions() && extendedManagedType.getIdAttributes().size() == 1;
                    if (singleValuedAssociationId) {
                        whereSb.append('.').append(extendedManagedType.getIdAttribute().getName());
                    }
                    whereSb.append(" = ");
                    node.getCorrelationParent().appendAlias(whereSb, false, externalRepresentation);
                    if (singleValuedAssociationId) {
                        whereSb.append('.').append(extendedManagedType.getIdAttribute().getName());
                    }
                    whereConjuncts.add(whereSb.toString());
                    return true;
                }
            } else {
                boolean singleValuedAssociationId;
                boolean renderAlias = true;
                sb.append(node.getEntityType().getName());
                if (whereSb == null) {
                    whereSb = new StringBuilder();
                } else {
                    whereSb.setLength(0);
                }
                ExtendedManagedType elementManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, node.getManagedType());
                if (elementManagedType.getAttribute(attribute.getMappedBy()).getAttribute().isCollection()) {
                    renderAlias = false;
                    sb.append(' ');
                    sb.append(node.getAlias());
                    sb.append(" JOIN ");
                    sb.append(node.getAlias());
                    sb.append('.').append(attribute.getMappedBy());
                    sb.append(" _synthetic_");
                    sb.append(node.getAlias());
                    whereSb.append(" _synthetic_").append(node.getAlias());
                } else {
                    whereSb.append(node.getAlias());
                    whereSb.append('.').append(attribute.getMappedBy());
                }
                boolean bl3 = singleValuedAssociationId = this.mainQuery.jpaProvider.supportsSingleValuedAssociationIdExpressions() && extendedManagedType.getIdAttributes().size() == 1;
                if (singleValuedAssociationId) {
                    whereSb.append('.').append(extendedManagedType.getIdAttribute().getName());
                }
                whereSb.append(" = ");
                node.getCorrelationParent().appendAlias(whereSb, false, externalRepresentation);
                if (singleValuedAssociationId) {
                    whereSb.append('.').append(extendedManagedType.getIdAttribute().getName());
                }
                whereConjuncts.add(whereSb.toString());
                return renderAlias;
            }
        }
        if (node.getTreatType() != null) {
            if (renderTreat) {
                sb.append("TREAT(");
                this.renderAlias(sb, joinBase.getJoinNode(), this.mainQuery.jpaProvider.supportsRootTreat(), externalRepresentation);
                sb.append('.');
                sb.append(node.getCorrelationPath());
                sb.append(" AS ");
                sb.append(node.getTreatType().getName());
                sb.append(')');
                return true;
            } else {
                if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                sb.append(joinBase.getAlias()).append('.').append(node.getCorrelationPath());
            }
            return true;
        } else {
            JoinNode baseNode = joinBase.getJoinNode();
            if (baseNode.getTreatType() != null) {
                if (this.mainQuery.jpaProvider.supportsRootTreatJoin()) {
                    baseNode.appendAlias(sb, true, externalRepresentation);
                } else {
                    if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                    baseNode.appendAlias(sb, false, externalRepresentation);
                }
            } else {
                baseNode.appendAlias(sb, false, externalRepresentation);
            }
            sb.append('.').append(node.getCorrelationPath());
        }
        return true;
    }

    private String renderJoinPath(StringBuilder sb, JoinAliasInfo joinBase, JoinNode node, List<String> whereConjuncts, boolean externalRepresentation) {
        if (node.getTreatType() != null && node.getBaseType() != node.getTreatType()) {
            String onCondition;
            boolean renderTreat = this.mainQuery.jpaProvider.supportsTreatJoin() && (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving() || node.getJoinType() == JoinType.INNER);
            JoinNode baseNode = joinBase.getJoinNode();
            String treatType = node.getTreatType().getName();
            String relationName = node.getParentTreeNode().getRelationName();
            JpaProvider.ConstraintType constraintType = this.mainQuery.jpaProvider.requiresTreatFilter(baseNode.getEntityType(), relationName, node.getJoinType());
            if (constraintType != JpaProvider.ConstraintType.NONE) {
                String constraint = "TYPE(" + node.getAlias() + ") = " + treatType;
                if (constraintType == JpaProvider.ConstraintType.WHERE) {
                    whereConjuncts.add(constraint);
                    onCondition = null;
                } else {
                    onCondition = constraint;
                }
            } else {
                onCondition = null;
            }
            if (renderTreat) {
                sb.append("TREAT(");
                this.renderAlias(sb, baseNode, this.mainQuery.jpaProvider.supportsRootTreatTreatJoin(), externalRepresentation);
                sb.append('.');
                sb.append(relationName);
                sb.append(" AS ");
                sb.append(treatType);
                sb.append(')');
            } else if (this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) {
                sb.append(joinBase.getAlias()).append('.').append(node.getParentTreeNode().getRelationName());
            } else {
                throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
            }
            return onCondition;
        }
        if (node.getCorrelationPath() == null && node.getAliasInfo().isRootNode() || node.getCorrelationPath() != null && node.isLateral()) {
            sb.append(node.getEntityType().getName());
            if (externalRepresentation && node.isInlineCte()) {
                sb.append('(');
                node.getInlineCte().nonRecursiveCriteriaBuilder.buildExternalQueryString(sb);
                sb.append(')');
            }
        } else if (node.isQualifiedJoin()) {
            sb.append(node.getQualificationExpression());
            sb.append('(');
            sb.append(joinBase.getJoinNode().getAlias());
            sb.append(')');
        } else {
            this.renderAlias(sb, joinBase.getJoinNode(), this.mainQuery.jpaProvider.supportsRootTreatJoin(), externalRepresentation);
            sb.append('.').append(node.getParentTreeNode().getRelationName());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderAlias(StringBuilder sb, JoinNode baseNode, boolean supportsTreat, boolean externalRepresentation) {
        if (baseNode.getTreatType() != null) {
            if (supportsTreat) {
                baseNode.appendAlias(sb, true, externalRepresentation);
                return;
            } else {
                if (!this.mainQuery.jpaProvider.supportsSubtypeRelationResolving()) throw new IllegalArgumentException("Treat should not be used as the JPA provider does not support subtype property access!");
                baseNode.appendAlias(sb, false, externalRepresentation);
            }
            return;
        } else {
            baseNode.appendAlias(sb, false, externalRepresentation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderReverseDependency(StringBuilder sb, JoinNode dependency, String aliasPrefix, boolean renderFetches, Set<JoinNode> nodesToFetch, List<String> whereConjuncts, List<JoinNode> placeholderRequiringNodes, boolean externalRepresentation, boolean lateralExample) {
        if (dependency.getParent() != null) {
            if (!placeholderRequiringNodes.contains(dependency.getParent())) {
                this.renderReverseDependency(sb, dependency.getParent(), aliasPrefix, renderFetches, nodesToFetch, whereConjuncts, placeholderRequiringNodes, externalRepresentation, lateralExample);
            }
            if (!dependency.getDependencies().isEmpty()) {
                this.markedJoinNodes.add(dependency);
                try {
                    for (JoinNode dep : dependency.getDependencies()) {
                        if (this.markedJoinNodes.contains(dep)) {
                            StringBuilder errorSb = new StringBuilder();
                            errorSb.append("Cyclic join dependency between nodes: [");
                            for (JoinNode seenNode : this.markedJoinNodes) {
                                errorSb.append(seenNode.getAliasInfo().getAlias());
                                if (seenNode.getAliasInfo().isImplicit()) {
                                    errorSb.append('(').append(seenNode.getAliasInfo().getAbsolutePath()).append(')');
                                }
                                errorSb.append(", ");
                            }
                            errorSb.setLength(errorSb.length() - 2);
                            errorSb.append(']');
                            throw new IllegalStateException(errorSb.toString());
                        }
                        this.renderReverseDependency(sb, dep, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts, placeholderRequiringNodes, externalRepresentation, lateralExample);
                    }
                }
                finally {
                    this.markedJoinNodes.remove(dependency);
                }
            }
            this.renderJoinNode(sb, dependency.getParent().getAliasInfo(), dependency, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts, placeholderRequiringNodes, externalRepresentation, lateralExample);
        }
    }

    private void addDefaultJoins(List<JoinNode> stack, Map<String, JoinTreeNode> nodes) {
        for (Map.Entry<String, JoinTreeNode> nodeEntry : nodes.entrySet()) {
            JoinTreeNode treeNode = nodeEntry.getValue();
            for (JoinNode value : treeNode.getJoinNodes().descendingMap().values()) {
                if (!value.isDefaultJoinNode()) continue;
                stack.add(value);
            }
        }
    }

    private void addDefaultJoinsAndRenderJoinNode(StringBuilder sb, JoinAliasInfo joinBase, List<JoinNode> stack, JoinNode node, boolean isCollection, Set<ClauseType> clauseExclusions, String aliasPrefix, boolean collectCollectionJoinNodes, boolean renderFetches, boolean ignoreCardinality, Set<JoinNode> nodesToFetch, List<String> whereConjuncts, List<JoinNode> placeholderRequiringNodes, Set<JoinNode> alwaysIncludedNodes, boolean externalRepresentation, boolean lateralExample) {
        if (!(clauseExclusions.isEmpty() || !clauseExclusions.containsAll(node.getClauseDependencies()) || !ignoreCardinality && node.isCardinalityMandatory() || alwaysIncludedNodes.contains(node))) {
            return;
        }
        stack.addAll(node.getTreatedJoinNodes().values());
        if (!node.getDependencies().isEmpty() || !node.isDefaultJoinNode()) {
            this.renderReverseDependency(sb, node, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts, placeholderRequiringNodes, externalRepresentation, lateralExample);
        }
        if (collectCollectionJoinNodes && isCollection) {
            this.collectionJoinNodes.add(node);
        }
        this.renderJoinNode(sb, joinBase, node, aliasPrefix, renderFetches, nodesToFetch, whereConjuncts, placeholderRequiringNodes, externalRepresentation, lateralExample);
        if (!node.getNodes().isEmpty()) {
            this.addDefaultJoins(stack, node.getNodes().descendingMap());
        }
    }

    private boolean isExternal(PathExpression path) {
        PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
        return this.isExternal(path, firstElem);
    }

    private boolean isExternal(TreatExpression treatExpression) {
        Expression expression = treatExpression.getExpression();
        if (expression instanceof PathExpression) {
            PathExpression path = (PathExpression)expression;
            PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
            return this.isExternal(path, firstElem);
        }
        if (expression instanceof FunctionExpression) {
            PathExpression path = (PathExpression)((FunctionExpression)expression).getExpressions().get(0);
            PathElementExpression firstElem = (PathElementExpression)path.getExpressions().get(0);
            return this.isExternal(path, firstElem);
        }
        throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
    }

    private boolean isExternal(PathExpression path, PathElementExpression firstElem) {
        String startAlias;
        if (firstElem instanceof ArrayExpression) {
            startAlias = ((ArrayExpression)firstElem).getBase().toString();
        } else if (firstElem instanceof TreatExpression) {
            Expression treatedExpression = ((TreatExpression)firstElem).getExpression();
            if (treatedExpression instanceof PathExpression) {
                treatedExpression = (Expression)((PathExpression)treatedExpression).getExpressions().get(0);
            }
            startAlias = treatedExpression instanceof ArrayExpression ? ((ArrayExpression)treatedExpression).getBase().toString() : (treatedExpression instanceof TreatExpression ? ((TreatExpression)treatedExpression).getExpression().toString() : treatedExpression.toString());
        } else {
            startAlias = firstElem.toString();
        }
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return false;
        }
        if (this.parent != null && aliasInfo.getAliasOwner() != this.aliasManager) {
            if (path.getExpressions().size() > 1 && aliasInfo instanceof SelectInfo) {
                throw new ExternalAliasDereferencingException("Start alias [" + startAlias + "] of path [" + path.toString() + "] is external and must not be dereferenced");
            }
            return true;
        }
        if (aliasInfo.getAliasOwner() == this.aliasManager) {
            return false;
        }
        throw new IllegalStateException("Alias [" + aliasInfo.getAlias() + "] originates from an unknown query");
    }

    public boolean isJoinableSelectAlias(PathExpression pathExpr, boolean fromSelect, boolean fromSubquery) {
        return this.getJoinableSelectAlias(pathExpr, fromSelect, fromSubquery) != null;
    }

    public Expression getJoinableSelectAlias(PathExpression pathExpr, boolean fromSelect, boolean fromSubquery) {
        if (!(pathExpr.getExpressions().get(0) instanceof PropertyExpression)) {
            return null;
        }
        boolean singlePathElement = pathExpr.getExpressions().size() == 1;
        String startAlias = ((PathElementExpression)pathExpr.getExpressions().get(0)).toString();
        AliasInfo aliasInfo = this.aliasManager.getAliasInfo(startAlias);
        if (aliasInfo == null) {
            return null;
        }
        if (aliasInfo instanceof SelectInfo) {
            if (!singlePathElement) {
                throw new IllegalStateException("Path starting with select alias not allowed");
            }
            Expression expression = ((SelectInfo)aliasInfo).getExpression();
            if (expression == pathExpr) {
                return null;
            }
            return expression;
        }
        return null;
    }

    <X> JoinOnBuilder<X> joinOn(X result, String base, Class<?> clazz, String alias, JoinType type, boolean lateral) {
        return this.joinOn(result, base, this.metamodel.entity(clazz), alias, type, lateral);
    }

    private JoinNode implicitJoinTreatExpression(TreatExpression treatExpression, boolean joinAllowed, ClauseType fromClause, JoinType joinType, JoinNode currentJoinNode, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean idRemovable, boolean fetch, boolean reuseExisting) {
        JoinNode resultJoinNode;
        if (treatExpression.getExpression() instanceof PathExpression) {
            PathExpression treatedPathExpression = (PathExpression)treatExpression.getExpression();
            this.implicitJoin((Expression)treatedPathExpression, joinAllowed, true, treatExpression.getType(), fromClause, joinType, currentJoinNode, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, idRemovable, fetch, reuseExisting);
            JoinNode treatedJoinNode = (JoinNode)treatedPathExpression.getBaseNode();
            if (treatedJoinNode.getTreatType() == null) {
                EntityType<?> treatType = this.metamodel.entity(treatExpression.getType());
                resultJoinNode = treatedJoinNode.getTreatedJoinNode(treatType);
            } else {
                resultJoinNode = treatedJoinNode;
            }
        } else {
            throw new UnsupportedOperationException("Unsupported treated expression type: " + treatExpression.getExpression().getClass());
        }
        return resultJoinNode;
    }

    <X> JoinOnBuilder<X> joinOn(X result, String base, EntityType<?> entityType, String alias, JoinType type, boolean lateral) {
        JoinNode baseNode;
        PathExpression basePath = this.expressionFactory.createPathExpression(base);
        if (type == JoinType.FULL) {
            this.hasFullJoin = true;
        }
        if (alias == null || alias.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty alias!");
        }
        if (type != JoinType.INNER && !this.mainQuery.jpaProvider.supportsEntityJoin()) {
            throw new IllegalArgumentException("The JPA provider does not support entity joins and an emulation for non-inner entity joins is not implemented!");
        }
        List pathElementExpressions = basePath.getExpressions();
        if (pathElementExpressions.size() > 1 || pathElementExpressions.size() == 1 && !(pathElementExpressions.get(0) instanceof PropertyExpression)) {
            if (pathElementExpressions.get(0) instanceof TreatExpression) {
                HashSet<String> currentlyResolvingAliases = new HashSet<String>();
                currentlyResolvingAliases.add(alias);
                baseNode = this.implicitJoinTreatExpression((TreatExpression)pathElementExpressions.get(0), true, null, null, null, currentlyResolvingAliases, false, false, true, false, false, false);
                basePath.setPathReference((PathReference)new SimplePathReference(baseNode, null, baseNode.getType()));
            } else {
                AliasInfo aliasInfo = this.aliasManager.getAliasInfo(((PathElementExpression)pathElementExpressions.get(0)).toString());
                if (!(aliasInfo instanceof JoinAliasInfo)) {
                    throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
                }
                baseNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
                HashSet<String> currentlyResolvingAliases = new HashSet<String>();
                currentlyResolvingAliases.add(alias);
                this.implicitJoin((Expression)basePath, true, true, null, null, null, null, currentlyResolvingAliases, false, false, true, false, false, false);
            }
            for (int i = 1; i < pathElementExpressions.size(); ++i) {
                String relationName = ((PathElementExpression)pathElementExpressions.get(i)).toString();
                JoinTreeNode treeNode = (JoinTreeNode)baseNode.getNodes().get(relationName);
                if (treeNode == null || (baseNode = treeNode.getDefaultNode()) == null) break;
            }
            if (baseNode == null) {
                throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
            }
        } else {
            AliasInfo aliasInfo = this.aliasManager.getAliasInfo(base);
            if (!(aliasInfo instanceof JoinAliasInfo)) {
                throw new IllegalArgumentException("The base '" + base + "' is not a valid join alias!");
            }
            baseNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
        }
        JoinAliasInfo joinAliasInfo = new JoinAliasInfo(alias, null, false, true, this.aliasManager);
        JoinNode entityJoinNode = JoinNode.createEntityJoinNode(baseNode, type, entityType, joinAliasInfo, lateral);
        joinAliasInfo.setJoinNode(entityJoinNode);
        baseNode.addEntityJoin(entityJoinNode);
        this.explicitJoinNodes.add(entityJoinNode);
        this.aliasManager.registerAliasInfo(joinAliasInfo);
        this.joinOnBuilderListener.joinNode = entityJoinNode;
        return this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    <X> FullSelectCTECriteriaBuilder<X> join(X result, String correlationPath, String alias, String subqueryAlias, JoinType type) {
        String realAlias = this.addRoot(correlationPath, alias, true);
        JoinAliasInfo aliasInfo = (JoinAliasInfo)this.aliasManager.getAliasInfo(realAlias);
        JoinNode joinNode = aliasInfo.getJoinNode();
        joinNode.setJoinType(type);
        this.joinOnBuilderListener.joinNode = joinNode;
        this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory)).onExpression("1=1").end();
        FullSelectCTECriteriaBuilder<X> cteCriteriaBuilder = this.mainQuery.cteManager.with(joinNode.getJavaType(), alias, result, true, this, this.aliasManager, this);
        ((AbstractCTECriteriaBuilder)cteCriteriaBuilder).joinManager.addRoot(correlationPath, subqueryAlias, false);
        return cteCriteriaBuilder;
    }

    <X> FullSelectCTECriteriaBuilder<JoinOnBuilder<X>> joinOn(X result, String correlationPath, String alias, String subqueryAlias, JoinType type) {
        String realAlias = this.addRoot(correlationPath, alias, true);
        JoinAliasInfo aliasInfo = (JoinAliasInfo)this.aliasManager.getAliasInfo(realAlias);
        JoinNode joinNode = aliasInfo.getJoinNode();
        joinNode.setJoinType(type);
        this.joinOnBuilderListener.joinNode = joinNode;
        JoinOnBuilder joinBuilder = this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
        FullSelectCTECriteriaBuilder<JoinOnBuilder> cteCriteriaBuilder = this.mainQuery.cteManager.with(joinNode.getJavaType(), alias, joinBuilder, true, this, this.aliasManager, this);
        ((AbstractCTECriteriaBuilder)cteCriteriaBuilder).joinManager.addRoot(correlationPath, subqueryAlias, false);
        return cteCriteriaBuilder;
    }

    <X> JoinOnBuilder<X> joinOn(X result, String path, String alias, JoinType type, boolean defaultJoin) {
        this.joinOnBuilderListener.joinNode = this.join(path, alias, type, false, defaultJoin);
        this.explicitJoinNodes.add(this.joinOnBuilderListener.joinNode);
        return this.joinOnBuilderListener.startBuilder(new JoinOnBuilderImpl<X>(result, this.joinOnBuilderListener, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JoinNode join(String path, String alias, JoinType type, boolean fetch, boolean defaultJoin) {
        JoinNode current;
        JoinResult result;
        PathElementExpression elementExpr;
        Expression expr = this.expressionFactory.createJoinPathExpression(path);
        String treatType = null;
        if (type == JoinType.FULL) {
            this.hasFullJoin = true;
        }
        if (expr instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expr;
            if (this.isExternal(pathExpression) || this.isJoinableSelectAlias(pathExpression, false, false)) {
                throw new IllegalArgumentException("No external path or select alias allowed in join path");
            }
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(null, pathExpression, null, null, null, new HashSet<String>(), 0, pathElements.size() - 1, false, true, false);
            current = result.baseNode;
        } else if (expr instanceof QualifiedExpression) {
            elementExpr = (PathElementExpression)expr;
            result = null;
            current = null;
        } else {
            if (!(expr instanceof TreatExpression)) throw new IllegalArgumentException("Join path [" + path + "] is not a path");
            TreatExpression treatExpression = (TreatExpression)expr;
            if (this.isExternal(treatExpression)) {
                throw new IllegalArgumentException("No external path or select alias allowed in join path");
            }
            Expression expression = treatExpression.getExpression();
            if (!(expression instanceof PathExpression)) throw new IllegalArgumentException("Unexpected expression type[" + expression.getClass().getSimpleName() + "] in treat expression: " + treatExpression);
            PathExpression pathExpression = (PathExpression)expression;
            List pathElements = pathExpression.getExpressions();
            elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            result = this.implicitJoin(null, pathExpression, null, null, null, new HashSet<String>(), 0, pathElements.size() - 1, false, true, false);
            current = result.baseNode;
            treatType = treatExpression.getType();
        }
        if (elementExpr instanceof ArrayExpression) {
            throw new IllegalArgumentException("Array expressions are not allowed!");
        }
        if (elementExpr instanceof MapKeyExpression) {
            MapKeyExpression mapKeyExpression = (MapKeyExpression)elementExpr;
            boolean fromSubquery = false;
            boolean fromSelectAlias = false;
            boolean joinRequired = true;
            current = this.joinMapKey(mapKeyExpression, alias, null, new HashSet<String>(), fromSubquery, fromSelectAlias, joinRequired, fetch, false, defaultJoin);
            result = new JoinResult(current, null, current.getNodeType(), -1, -1);
        } else {
            List joinRelationAttributes = result.addToList(new ArrayList());
            joinRelationAttributes.add(elementExpr.toString());
            current = current == null ? this.getRootNodeOrFail("Could not join path [", path, "] because it did not use an absolute path but multiple root nodes are available!") : current;
            result = this.createOrUpdateNode(current, joinRelationAttributes, treatType, alias, type, null, false, defaultJoin, true);
        }
        if (!fetch) return result.baseNode;
        this.fetchPath(result.baseNode);
        return result.baseNode;
    }

    public void implicitJoin(Expression expression, boolean joinAllowed, boolean objectLeafAllowed, String targetType, ClauseType fromClause, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean idRemovable) {
        this.implicitJoin(expression, joinAllowed, objectLeafAllowed, targetType, fromClause, null, null, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, idRemovable, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implicitJoin(Expression expression, boolean joinAllowed, boolean objectLeafAllowed, String targetTypeName, ClauseType fromClause, JoinType joinType, JoinNode currentJoinNode, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean idRemovable, boolean fetch, boolean reuseExisting) {
        if (expression instanceof PathExpression) {
            JoinResult result;
            AliasInfo aliasInfo;
            JoinResult currentResult;
            JoinNode possibleRoot;
            Expression aliasedExpression;
            String alias;
            PathExpression pathExpression = (PathExpression)expression;
            if (pathExpression.getExpressions().size() == 1 && currentlyResolvingAliases != null && !currentlyResolvingAliases.contains(alias = pathExpression.toString()) && (aliasedExpression = this.getJoinableSelectAlias(pathExpression, fromClause == ClauseType.SELECT, fromSubquery)) != null) {
                if (!fromSelectAlias) {
                    try {
                        currentlyResolvingAliases.add(alias);
                        this.implicitJoin(aliasedExpression, joinAllowed, true, null, fromClause, currentlyResolvingAliases, fromSubquery, true, joinRequired, false);
                    }
                    finally {
                        currentlyResolvingAliases.remove(alias);
                    }
                }
                return;
            }
            if (this.isExternal(pathExpression)) {
                this.parent.implicitJoin((Expression)pathExpression, true, true, targetTypeName, fromClause, currentlyResolvingAliases, true, fromSelectAlias, joinRequired, false);
                return;
            }
            List pathElements = pathExpression.getExpressions();
            int pathElementSize = pathElements.size();
            for (int i = 0; i < pathElementSize; ++i) {
                PathElementExpression pathElem = (PathElementExpression)pathElements.get(i);
                if (!(pathElem instanceof ArrayExpression)) continue;
                this.implicitJoin(((ArrayExpression)pathElem).getIndex(), joinAllowed, false, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false);
            }
            PathElementExpression elementExpr = (PathElementExpression)pathElements.get(pathElements.size() - 1);
            int singleValuedAssociationNameStartIndex = -1;
            int singleValuedAssociationNameEndIndex = -1;
            JoinNode current = null;
            ArrayList<String> resultFields = new ArrayList();
            int startIndex = 0;
            if (pathElements.size() > 1 && (possibleRoot = this.getRootNode((Expression)pathElements.get(0))) != null) {
                startIndex = 1;
                current = possibleRoot;
            }
            if (pathElements.size() > startIndex + 1) {
                currentResult = this.implicitJoin(current, pathExpression, fromClause, joinType, currentJoinNode, currentlyResolvingAliases, startIndex, pathElements.size() - 1, false, joinAllowed, idRemovable);
                current = currentResult.baseNode;
                resultFields = currentResult.addToList(resultFields);
                singleValuedAssociationNameStartIndex = currentResult.singleValuedAssociationNameIndex;
                singleValuedAssociationNameEndIndex = currentResult.singleValuedAssociationNameEndIndex;
                if (singleValuedAssociationNameStartIndex != -1 && !this.mainQuery.jpaProvider.supportsSingleValuedAssociationIdExpressions()) {
                    if (idRemovable) {
                        elementExpr = null;
                        if (current == null) {
                            AliasInfo a = this.aliasManager.getAliasInfo(((PathElementExpression)pathElements.get(currentResult.singleValuedAssociationNameIndex)).toString());
                            current = ((JoinAliasInfo)a).getJoinNode();
                            resultFields = Collections.emptyList();
                        }
                    } else {
                        elementExpr = null;
                        resultFields.clear();
                        currentResult = this.implicitJoin(current, resultFields, pathExpression, fromClause, joinType, currentJoinNode, currentlyResolvingAliases, currentResult.singleValuedAssociationNameIndex, pathElements.size(), false, joinAllowed, idRemovable);
                        current = currentResult.baseNode;
                        resultFields = currentResult.addToList(resultFields);
                        singleValuedAssociationNameStartIndex = -1;
                    }
                }
            } else {
                currentResult = this.implicitJoin(current, pathExpression, fromClause, joinType, currentJoinNode, currentlyResolvingAliases, startIndex, pathElements.size() - 1, false, joinAllowed, idRemovable);
                current = currentResult.baseNode;
                resultFields = currentResult.addToList(resultFields);
                if (idRemovable) {
                    if (current != null) {
                        if (this.isId(current.getNodeType(), (Expression)elementExpr)) {
                            elementExpr = null;
                            singleValuedAssociationNameStartIndex = singleValuedAssociationNameEndIndex = startIndex - 1;
                        }
                    } else {
                        String elementExpressionString = elementExpr instanceof ArrayExpression ? ((ArrayExpression)elementExpr).getBase().toString() : elementExpr.toString();
                        AliasInfo a = this.aliasManager.getAliasInfo(elementExpressionString);
                        if (a == null && this.isId((current = this.getRootNodeOrFail("Could not join path [", expression, "] because it did not use an absolute path but multiple root nodes are available!")).getNodeType(), (Expression)elementExpr)) {
                            elementExpr = new PropertyExpression(current.getAlias());
                        }
                    }
                }
            }
            if (pathElements.size() == 1 && !fromSelectAlias && currentlyResolvingAliases != null && !currentlyResolvingAliases.contains(alias = elementExpr.toString()) && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(alias)) != null) {
                if (aliasInfo instanceof SelectInfo) {
                    if (targetTypeName != null) {
                        throw new IllegalArgumentException("The select alias '" + aliasInfo.getAlias() + "' can not be used for a treat expression!.");
                    }
                    Expression selectExpr = ((SelectInfo)aliasInfo).getExpression();
                    if (!(selectExpr instanceof PathExpression)) {
                        throw new RuntimeException("The select expression '" + selectExpr.toString() + "' is not a simple path expression! No idea how to implicit join that.");
                    }
                    if (((PathExpression)selectExpr).getBaseNode() == null) {
                        this.implicitJoin(selectExpr, joinAllowed, objectLeafAllowed, null, fromClause, currentlyResolvingAliases, fromSubquery, true, joinRequired, false);
                    }
                    PathExpression selectPathExpr = (PathExpression)selectExpr;
                    PathReference reference = selectPathExpr.getPathReference();
                    result = new JoinResult((JoinNode)selectPathExpr.getBaseNode(), Arrays.asList(selectPathExpr.getField()), reference.getType(), -1, -1);
                } else {
                    JoinNode pathJoinNode = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    if (targetTypeName != null) {
                        ManagedType<?> targetType = this.metamodel.managedType(targetTypeName);
                        result = new JoinResult(pathJoinNode, null, (Type<?>)targetType, -1, -1);
                    } else {
                        result = new JoinResult(pathJoinNode, null, pathJoinNode.getNodeType(), -1, -1);
                    }
                }
            } else if (pathElements.size() == 1 && elementExpr instanceof QualifiedExpression) {
                JoinNode baseNode;
                QualifiedExpression qualifiedExpression = (QualifiedExpression)elementExpr;
                if (elementExpr instanceof MapKeyExpression) {
                    baseNode = this.joinMapKey((MapKeyExpression)elementExpr, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof ListIndexExpression) {
                    baseNode = this.joinListIndex((ListIndexExpression)elementExpr, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof MapEntryExpression) {
                    baseNode = this.joinMapEntry((MapEntryExpression)elementExpr, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, true, fetch, true, true);
                } else if (elementExpr instanceof MapValueExpression) {
                    this.implicitJoin((Expression)qualifiedExpression.getPath(), true, objectLeafAllowed, targetTypeName, fromClause, joinType, null, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false, fetch, false);
                    baseNode = (JoinNode)qualifiedExpression.getPath().getBaseNode();
                } else {
                    throw new IllegalArgumentException("Unknown qualified expression type: " + elementExpr);
                }
                result = new JoinResult(baseNode, null, baseNode.getNodeType(), -1, -1);
            } else {
                String attributeName;
                if (current == null) {
                    current = this.getRootNodeOrFail("Could not join path [", expression, "] because it did not use an absolute path but multiple root nodes are available!");
                }
                if (singleValuedAssociationNameStartIndex != -1) {
                    String associationName = new PathExpression(pathElements.subList(singleValuedAssociationNameStartIndex, singleValuedAssociationNameEndIndex + 1)).toString();
                    AliasInfo singleValuedAssociationRootAliasInfo = null;
                    if (pathElements.size() == 2) {
                        singleValuedAssociationRootAliasInfo = this.aliasManager.getAliasInfoForBottomLevel(associationName);
                    }
                    if (singleValuedAssociationRootAliasInfo != null) {
                        JoinNode singleValuedAssociationRoot = ((JoinAliasInfo)singleValuedAssociationRootAliasInfo).getJoinNode();
                        if (elementExpr != null) {
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, singleValuedAssociationRoot.getNodeType(), (Expression)elementExpr, singleValuedAssociationRoot.getAlias());
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(singleValuedAssociationRoot, Arrays.asList(elementExpr.toString()), type, -1, -1);
                        } else {
                            result = new JoinResult(singleValuedAssociationRoot, null, singleValuedAssociationRoot.getNodeType(), -1, -1);
                        }
                    } else {
                        JoinTreeNode treeNode = (JoinTreeNode)current.getNodes().get(associationName);
                        if (reuseExisting && treeNode != null && treeNode.getDefaultNode() != null) {
                            if (elementExpr != null) {
                                PathExpression restExpression = new PathExpression(pathElements.subList(singleValuedAssociationNameEndIndex + 1, pathElementSize));
                                String elementString = restExpression.toString();
                                AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, treeNode.getDefaultNode().getNodeType(), (Expression)restExpression, treeNode.getDefaultNode().getAlias());
                                Type<?> type = attributeHolder.getAttributeType();
                                result = new JoinResult(treeNode.getDefaultNode(), Arrays.asList(elementString), type, -1, -1);
                            } else {
                                result = new JoinResult(treeNode.getDefaultNode(), null, treeNode.getDefaultNode().getNodeType(), -1, -1);
                            }
                        } else if (elementExpr != null) {
                            PathExpression restExpression = new PathExpression(pathElements.subList(singleValuedAssociationNameStartIndex, pathElementSize));
                            String elementString = restExpression.toString();
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, currentResult.baseNode.getNodeType(), (Expression)restExpression, null);
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(currentResult.baseNode, Arrays.asList(elementString), type, -1, -1);
                        } else {
                            Expression resultExpr = this.expressionFactory.createSimpleExpression(associationName, false);
                            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, current.getNodeType(), resultExpr, current.getAlias());
                            Type<?> type = attributeHolder.getAttributeType();
                            result = new JoinResult(current, Arrays.asList(associationName), type, -1, -1);
                        }
                    }
                } else if (elementExpr instanceof ArrayExpression) {
                    ArrayExpression arrayExpr = (ArrayExpression)elementExpr;
                    String joinRelationName = arrayExpr.getBase().toString();
                    if (pathElements.size() == 1 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                        if (aliasInfo instanceof SelectInfo) {
                            throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                        }
                        current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                        this.generateAndApplyOnPredicate(current, arrayExpr);
                    } else {
                        JoinNode matchingNode = this.findNode(current, joinRelationName, arrayExpr);
                        if (matchingNode != null) {
                            current = matchingNode;
                        } else {
                            String joinAlias = this.getJoinAlias(arrayExpr);
                            resultFields.add(joinRelationName);
                            currentResult = this.createOrUpdateNode(current, resultFields, targetTypeName, joinAlias, joinType, currentJoinNode, true, false, joinAllowed);
                            current = currentResult.baseNode;
                            if (currentResult.hasField()) {
                                throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + currentResult.joinFields() + "]");
                            }
                            this.generateAndApplyOnPredicate(current, arrayExpr);
                        }
                    }
                    result = new JoinResult(current, null, current.getNodeType(), -1, -1);
                } else if (!pathExpression.isUsedInCollectionFunction()) {
                    if (resultFields.isEmpty()) {
                        result = this.implicitJoinSingle(current, elementExpr.toString(), targetTypeName, joinType, currentJoinNode, objectLeafAllowed, joinRequired, joinAllowed);
                    } else {
                        resultFields.add(elementExpr.toString());
                        attributeName = StringUtils.join((CharSequence)".", resultFields);
                        this.getPathType(current.getNodeType(), attributeName, pathExpression);
                        result = this.implicitJoinSingle(current, attributeName, targetTypeName, joinType, currentJoinNode, objectLeafAllowed, joinRequired, joinAllowed);
                    }
                } else if (resultFields.isEmpty()) {
                    attributeName = elementExpr.toString();
                    Type<?> type = this.getPathType(current.getNodeType(), attributeName, pathExpression);
                    result = new JoinResult(current, Arrays.asList(attributeName), type, -1, -1);
                } else {
                    resultFields.add(elementExpr.toString());
                    attributeName = StringUtils.join((CharSequence)".", resultFields);
                    Type<?> type = this.getPathType(current.getNodeType(), attributeName, pathExpression);
                    result = new JoinResult(current, resultFields, type, -1, -1);
                }
            }
            if (fetch) {
                this.fetchPath(result.baseNode);
            }
            if (fromClause != null) {
                try {
                    result.baseNode.updateClauseDependencies(fromClause, new LinkedHashSet<JoinNode>());
                }
                catch (IllegalStateException ex) {
                    throw new IllegalArgumentException("Implicit join in expression '" + expression + "' introduces cyclic join dependency!", ex);
                }
            }
            if (result.isLazy()) {
                pathExpression.setPathReference((PathReference)new LazyPathReference(result.baseNode, result.joinFields(), result.type, joinAllowed));
            } else {
                pathExpression.setPathReference((PathReference)new SimplePathReference(result.baseNode, result.joinFields(), result.type));
            }
        } else if (expression instanceof FunctionExpression) {
            List expressions = ((FunctionExpression)expression).getExpressions();
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                this.implicitJoin((Expression)expressions.get(i), joinAllowed, objectLeafAllowed, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false);
            }
        } else if (expression instanceof MapKeyExpression) {
            MapKeyExpression mapKeyExpression = (MapKeyExpression)expression;
            this.joinMapKey(mapKeyExpression, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, fetch, true, true);
        } else if (expression instanceof QualifiedExpression) {
            this.implicitJoin((Expression)((QualifiedExpression)expression).getPath(), joinAllowed, objectLeafAllowed, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false);
        } else if (expression instanceof ArrayExpression || expression instanceof GeneralCaseExpression || expression instanceof TreatExpression) {
            throw new IllegalArgumentException("Unsupported expression for implicit joining found: " + expression);
        }
    }

    private Type<?> getPathType(Type<?> baseType, String expression, PathExpression pathExpression) {
        try {
            return JpaUtils.getAttributeForJoining(this.metamodel, baseType, (Expression)this.expressionFactory.createPathExpression(expression), null).getAttributeType();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The join path [" + pathExpression + "] has a non joinable part [" + expression + "]", ex);
        }
    }

    private static boolean contains(Set<? extends Attribute<?, ?>> attributes, PathElementExpression expression) {
        String attributeName = expression.toString();
        for (Attribute<?, ?> attribute : attributes) {
            if (!attributeName.equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(ExtendedManagedType<?> type, PathExpression expression) {
        Set attributes = type.getIdAttributes();
        if (expression.getExpressions().size() > 1) {
            String attributeName = ((PathElementExpression)expression.getExpressions().get(0)).toString();
            for (Attribute attribute : attributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return type.getOwnedSingularAttributes().containsKey(expression.toString());
            }
        } else {
            String attributeName = expression.toString();
            for (Attribute attribute : attributes) {
                if (!attributeName.equals(attribute.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isId(Type<?> type, Expression idExpression) {
        AttributeHolder maybeSingularAssociationIdJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, type, idExpression, null);
        Attribute<?, ?> maybeSingularAssociationId = maybeSingularAssociationIdJoinResult.getAttribute();
        if (!(maybeSingularAssociationId instanceof SingularAttribute)) {
            return false;
        }
        return ((SingularAttribute)maybeSingularAssociationId).isId();
    }

    private String getSimpleName(PathElementExpression element) {
        if (element == null || element instanceof TreatExpression) {
            return null;
        }
        if (element instanceof ArrayExpression) {
            return ((ArrayExpression)element).getBase().getProperty();
        }
        return element.toString();
    }

    private String getJoinAlias(ArrayExpression expr) {
        StringBuilder sb = new StringBuilder(expr.getBase().toString());
        Expression indexExpr = expr.getIndex();
        if (indexExpr instanceof ParameterExpression) {
            ParameterExpression indexParamExpr = (ParameterExpression)indexExpr;
            sb.append('_');
            sb.append(indexParamExpr.getName());
        } else if (indexExpr instanceof PathExpression) {
            PathExpression indexPathExpr = (PathExpression)indexExpr;
            sb.append('_');
            sb.append(((JoinNode)indexPathExpr.getBaseNode()).getAliasInfo().getAlias());
            if (indexPathExpr.getField() != null) {
                sb.append('_');
                sb.append(indexPathExpr.getField().replaceAll("\\.", "_"));
            }
        } else if (indexExpr instanceof NumericLiteral) {
            sb.append('_');
            sb.append(((NumericLiteral)indexExpr).getValue());
        } else if (indexExpr instanceof StringLiteral) {
            sb.append('_');
            sb.append(((StringLiteral)indexExpr).getValue());
        } else {
            throw new IllegalStateException("Invalid array index expression " + indexExpr.toString());
        }
        return sb.toString();
    }

    private EqPredicate getArrayExpressionPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        PathExpression keyPath = new PathExpression(new ArrayList(), true);
        keyPath.getExpressions().add(new PropertyExpression(joinNode.getAliasInfo().getAlias()));
        keyPath.setPathReference((PathReference)new SimplePathReference(joinNode, null, joinNode.getNodeType()));
        Attribute<?, ?> arrayBaseAttribute = joinNode.getParentTreeNode().getAttribute();
        Object keyExpression = arrayBaseAttribute instanceof ListAttribute ? new ListIndexExpression(keyPath) : new MapKeyExpression(keyPath);
        return new EqPredicate((Expression)keyExpression, arrayExpr.getIndex());
    }

    private void generateAndApplyOnPredicate(JoinNode joinNode, ArrayExpression arrayExpr) {
        EqPredicate valueKeyFilterPredicate = this.getArrayExpressionPredicate(joinNode, arrayExpr);
        if (joinNode.getOnPredicate() != null) {
            CompoundPredicate currentPred = joinNode.getOnPredicate();
            if (!this.findPredicate(currentPred, (Predicate)valueKeyFilterPredicate)) {
                currentPred.getChildren().add(valueKeyFilterPredicate);
                joinNode.registerDependencies();
                joinNode.updateClauseDependencies(ClauseType.JOIN, new LinkedHashSet<JoinNode>());
            }
        } else {
            CompoundPredicate onAndPredicate = new CompoundPredicate(CompoundPredicate.BooleanOperator.AND);
            onAndPredicate.getChildren().add(valueKeyFilterPredicate);
            joinNode.setOnPredicate(onAndPredicate);
            joinNode.registerDependencies();
            joinNode.updateClauseDependencies(ClauseType.JOIN, new LinkedHashSet<JoinNode>());
        }
    }

    private JoinResult implicitJoin(JoinNode current, PathExpression pathExpression, ClauseType fromClause, JoinType joinType, JoinNode currentJoinNode, Set<String> currentlyResolvingAliases, int start, int end, boolean allowParentAliases, boolean joinAllowed, boolean idRemovable) {
        return this.implicitJoin(current, new ArrayList<String>(), pathExpression, fromClause, joinType, currentJoinNode, currentlyResolvingAliases, start, end, allowParentAliases, joinAllowed, idRemovable);
    }

    private JoinResult implicitJoin(JoinNode current, List<String> resultFields, PathExpression pathExpression, ClauseType fromClause, JoinType joinType, JoinNode currentJoinNode, Set<String> currentlyResolvingAliases, int start, int end, boolean allowParentAliases, boolean joinAllowed, boolean idRemovable) {
        List pathElements = pathExpression.getExpressions();
        int singleValuedAssociationNameStartIndex = -1;
        int singleValuedAssociationNameEndIndex = -1;
        for (int i = start; i < end; ++i) {
            AliasInfo aliasInfo;
            PathElementExpression elementExpr = (PathElementExpression)pathElements.get(i);
            if (elementExpr instanceof ArrayExpression) {
                String joinRelationName;
                List joinRelationAttributes;
                ArrayExpression arrayExpr = (ArrayExpression)elementExpr;
                if (!resultFields.isEmpty()) {
                    resultFields.add((String)arrayExpr.getBase().toString());
                    joinRelationAttributes = resultFields;
                    resultFields = new ArrayList<String>();
                    joinRelationName = StringUtils.join((CharSequence)".", joinRelationAttributes);
                } else {
                    joinRelationName = arrayExpr.getBase().toString();
                    joinRelationAttributes = Arrays.asList(joinRelationName);
                }
                current = current == null ? this.getRootNodeOrFail("Ambiguous join path [", joinRelationName, "] because of multiple root nodes!") : current;
                JoinNode matchingNode = this.findNode(current, joinRelationName, arrayExpr);
                if (matchingNode != null) {
                    current = matchingNode;
                    continue;
                }
                if (i == 0 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(joinRelationName)) != null) {
                    if (aliasInfo instanceof SelectInfo) {
                        throw new IllegalArgumentException("Illegal reference to the select alias '" + joinRelationName + "'");
                    }
                    current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    this.generateAndApplyOnPredicate(current, arrayExpr);
                    continue;
                }
                String joinAlias = this.getJoinAlias(arrayExpr);
                JoinResult result = this.createOrUpdateNode(current, joinRelationAttributes, null, joinAlias, joinType, currentJoinNode, true, false, joinAllowed);
                current = result.baseNode;
                resultFields = result.addToList(resultFields);
                this.generateAndApplyOnPredicate(current, arrayExpr);
                continue;
            }
            if (elementExpr instanceof TreatExpression) {
                if (i != 0 || current != null) {
                    throw new IllegalArgumentException("A treat expression should be the first element in a path!");
                }
                TreatExpression treatExpression = (TreatExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = false;
                boolean fetch = false;
                current = this.implicitJoinTreatExpression((TreatExpression)elementExpr, joinAllowed, fromClause, joinType, currentJoinNode, currentlyResolvingAliases, fromSubquery, fromSelectAlias, true, false, fetch, false);
                continue;
            }
            if (elementExpr instanceof MapKeyExpression) {
                MapKeyExpression mapKeyExpression = (MapKeyExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = true;
                boolean fetch = false;
                current = this.joinMapKey(mapKeyExpression, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, fetch, true, true);
                continue;
            }
            if (elementExpr instanceof MapValueExpression) {
                MapValueExpression mapValueExpression = (MapValueExpression)elementExpr;
                boolean fromSubquery = false;
                boolean fromSelectAlias = false;
                boolean joinRequired = true;
                boolean fetch = false;
                this.implicitJoin((Expression)mapValueExpression.getPath(), joinAllowed, true, null, fromClause, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, fetch);
                current = (JoinNode)mapValueExpression.getPath().getBaseNode();
                continue;
            }
            if (pathElements.size() == 1 && (aliasInfo = this.aliasManager.getAliasInfoForBottomLevel(elementExpr.toString())) != null) {
                if (aliasInfo instanceof SelectInfo) {
                    throw new IllegalArgumentException("Can't dereference a select alias");
                }
                current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                continue;
            }
            String elementExpressionString = elementExpr.toString();
            if (current == null) {
                AliasInfo aliasInfo2 = aliasInfo = allowParentAliases ? this.aliasManager.getAliasInfo(elementExpressionString) : this.aliasManager.getAliasInfoForBottomLevel(elementExpressionString);
                if (aliasInfo instanceof JoinAliasInfo) {
                    ExtendedManagedType managedType;
                    current = ((JoinAliasInfo)aliasInfo).getJoinNode();
                    if (!idRemovable || !(current.getNodeType() instanceof ManagedType) || pathElements.size() != i + 2 || !JoinManager.contains((managedType = this.metamodel.getManagedType(ExtendedManagedType.class, current.getManagedType())).getIdAttributes(), (PathElementExpression)pathElements.get(i + 1))) continue;
                    singleValuedAssociationNameStartIndex = 0;
                    singleValuedAssociationNameEndIndex = 0;
                    break;
                }
                current = this.getRootNodeOrFail("Ambiguous join path [", elementExpressionString, "] because of multiple root nodes!");
            }
            int pathElementsSize = pathElements.size();
            if (joinType != JoinType.INNER && (idRemovable || this.mainQuery.jpaProvider.supportsSingleValuedAssociationIdExpressions()) && (current.getManagedType().getPersistenceType() != Type.PersistenceType.EMBEDDABLE || current.getValuesLikeAttribute() != null) && i + 1 < pathElementsSize) {
                PathElementExpression pathElementExpression;
                ArrayList<PathElementExpression> pathElementExpressions = new ArrayList<PathElementExpression>(pathElementsSize - i);
                for (int j = i; j < pathElementsSize && (pathElementExpression = (PathElementExpression)pathElements.get(j)) instanceof PropertyExpression; ++j) {
                    pathElementExpressions.add(pathElementExpression);
                }
                ExtendedManagedType extendedManagedType = this.metamodel.getManagedType(ExtendedManagedType.class, current.getManagedType());
                if (pathElementExpressions.size() == pathElementsSize - i) {
                    PathExpression pathRestExpression = new PathExpression(pathElementExpressions);
                    String pathRestString = pathRestExpression.toString();
                    int idx = 0;
                    ExtendedAttribute extendedAttribute = current.getValuesLikeAttribute() == null ? (ExtendedAttribute)extendedManagedType.getOwnedSingularAttributes().get(pathRestString) : (ExtendedAttribute)extendedManagedType.getAttributes().get(pathRestString);
                    if (extendedAttribute != null && !JpaMetamodelUtils.isAssociation((Attribute)extendedAttribute.getAttribute())) {
                        ExtendedAttribute associationAttribute = null;
                        singleValuedAssociationNameStartIndex = i;
                        ArrayList<String> newResultFields = new ArrayList<String>();
                        for (int j = i; j < end; ++j) {
                            ExtendedAttribute attr;
                            if ((idx = pathRestString.indexOf(46, idx + 1)) != -1 && JpaMetamodelUtils.isAssociation((Attribute)(attr = extendedManagedType.getAttribute(pathRestString.substring(0, idx))).getAttribute())) {
                                associationAttribute = attr;
                                singleValuedAssociationNameEndIndex = j;
                            }
                            newResultFields.add(((PathElementExpression)pathElements.get(j)).toString());
                        }
                        if (singleValuedAssociationNameEndIndex == -1) {
                            singleValuedAssociationNameStartIndex = -1;
                        } else if (current.getValueType() == null && this.mainQuery.jpaProvider.isForeignJoinColumn((EntityType)current.getManagedType(), new PathExpression(pathElements.subList(singleValuedAssociationNameStartIndex, singleValuedAssociationNameEndIndex + 1)).toString()) || current.getValueType() != null && this.mainQuery.jpaProvider.isForeignJoinColumn(current.getValueType(), current.getValuesLikeAttribute() + "." + new PathExpression(pathElements.subList(singleValuedAssociationNameStartIndex, singleValuedAssociationNameEndIndex + 1)).toString())) {
                            singleValuedAssociationNameStartIndex = -1;
                        } else if (!this.mainQuery.jpaProvider.supportsSingleValuedAssociationNaturalIdExpressions() && !JoinManager.contains(this.metamodel.getManagedType(ExtendedManagedType.class, associationAttribute.getElementClass()), new PathExpression(pathElements.subList(singleValuedAssociationNameEndIndex + 1, pathElementsSize)))) {
                            singleValuedAssociationNameStartIndex = -1;
                        } else {
                            resultFields.addAll(newResultFields);
                            break;
                        }
                    }
                }
            }
            if (resultFields.isEmpty()) {
                JoinResult result = this.implicitJoinSingle(current, elementExpressionString, null, joinType, currentJoinNode, allowParentAliases, joinAllowed);
                if (current != result.baseNode) {
                    current = result.baseNode;
                }
                resultFields = result.addToList(resultFields);
                continue;
            }
            resultFields.add((String)elementExpressionString);
            JoinResult currentResult = this.createOrUpdateNode(current, resultFields, null, null, joinType, currentJoinNode, true, true, joinAllowed);
            current = currentResult.baseNode;
            if (currentResult.hasField()) continue;
            resultFields.clear();
        }
        if (resultFields.isEmpty()) {
            return new JoinResult(current, null, current == null ? null : current.getNodeType(), singleValuedAssociationNameStartIndex, singleValuedAssociationNameEndIndex);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(resultFields.get(0));
        for (int i = 1; i < resultFields.size(); ++i) {
            sb.append('.');
            sb.append(resultFields.get(i));
        }
        Expression expression = this.expressionFactory.createSimpleExpression(sb.toString(), false);
        Type<?> type = JpaUtils.getAttributeForJoining(this.metamodel, current.getNodeType(), expression, current.getAlias()).getAttributeType();
        return new JoinResult(current, resultFields, type, singleValuedAssociationNameStartIndex, singleValuedAssociationNameEndIndex);
    }

    private JoinNode joinMapKey(MapKeyExpression mapKeyExpression, String alias, ClauseType fromClause, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)mapKeyExpression.getPath(), true, true, null, fromClause, null, null, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false, fetch, false);
        JoinNode current = (JoinNode)mapKeyExpression.getPath().getBaseNode();
        String joinRelationName = "KEY(" + current.getParentTreeNode().getRelationName() + ")";
        MapAttribute mapAttribute = (MapAttribute)current.getParentTreeNode().getAttribute();
        MapKeyAttribute keyAttribute = new MapKeyAttribute(mapAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_key" : alias;
        Type joinRelationType = this.metamodel.type(mapAttribute.getKeyJavaType());
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, defaultJoin, (Attribute<?, ?>)keyAttribute);
        return current;
    }

    private JoinNode joinMapEntry(MapEntryExpression mapEntryExpression, String alias, ClauseType fromClause, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)mapEntryExpression.getPath(), true, true, null, fromClause, null, null, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false, fetch, false);
        JoinNode current = (JoinNode)mapEntryExpression.getPath().getBaseNode();
        String joinRelationName = "ENTRY(" + current.getParentTreeNode().getRelationName() + ")";
        MapAttribute mapAttribute = (MapAttribute)current.getParentTreeNode().getAttribute();
        MapEntryAttribute entryAttribute = new MapEntryAttribute(mapAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_entry" : alias;
        Type<Map.Entry> joinRelationType = this.metamodel.type(Map.Entry.class);
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, defaultJoin, (Attribute<?, ?>)entryAttribute);
        return current;
    }

    private JoinNode joinListIndex(ListIndexExpression listIndexExpression, String alias, ClauseType fromClause, Set<String> currentlyResolvingAliases, boolean fromSubquery, boolean fromSelectAlias, boolean joinRequired, boolean fetch, boolean implicit, boolean defaultJoin) {
        this.implicitJoin((Expression)listIndexExpression.getPath(), true, true, null, fromClause, null, null, currentlyResolvingAliases, fromSubquery, fromSelectAlias, joinRequired, false, fetch, false);
        JoinNode current = (JoinNode)listIndexExpression.getPath().getBaseNode();
        String joinRelationName = "INDEX(" + current.getParentTreeNode().getRelationName() + ")";
        ListAttribute listAttribute = (ListAttribute)current.getParentTreeNode().getAttribute();
        ListIndexAttribute indexAttribute = new ListIndexAttribute(listAttribute);
        String aliasToUse = alias == null ? current.getParentTreeNode().getRelationName().replaceAll("\\.", "_") + "_index" : alias;
        Type<Integer> joinRelationType = this.metamodel.type(Integer.class);
        current = this.getOrCreate(current, joinRelationName, joinRelationType, null, aliasToUse, JoinType.LEFT, "Ambiguous implicit join", implicit, defaultJoin, (Attribute<?, ?>)indexAttribute);
        return current;
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName, String treatTypeName, JoinType joinType, JoinNode currentJoinNode, boolean allowParentAliases, boolean joinAllowed) {
        if (baseNode == null) {
            AliasInfo aliasInfo;
            AliasInfo aliasInfo2 = aliasInfo = allowParentAliases ? this.aliasManager.getAliasInfo(attributeName) : this.aliasManager.getAliasInfoForBottomLevel(attributeName);
            if (aliasInfo != null && aliasInfo instanceof JoinAliasInfo) {
                JoinNode node = ((JoinAliasInfo)aliasInfo).getJoinNode();
                return new JoinResult(node, null, node.getNodeType(), -1, -1);
            }
        }
        if (baseNode == null) {
            baseNode = this.getRootNodeOrFail("Ambiguous join path [", attributeName, "] because of multiple root nodes!");
        }
        return this.createOrUpdateNode(baseNode, Arrays.asList(attributeName), treatTypeName, null, joinType, currentJoinNode, true, true, joinAllowed);
    }

    private JoinResult implicitJoinSingle(JoinNode baseNode, String attributeName, String treatTypeName, JoinType joinType, JoinNode currentJoinNode, boolean objectLeafAllowed, boolean joinRequired, boolean joinAllowed) {
        Type<?> type;
        String field;
        JoinNode newBaseNode;
        boolean lazy = false;
        Type<?> baseNodeType = baseNode.getNodeType();
        if (objectLeafAllowed) {
            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(attributeName), baseNode.getAlias());
            Attribute<?, ?> attr = attributeHolder.getAttribute();
            if (attr == null) {
                throw new IllegalArgumentException("Field with name '" + attributeName + "' was not found within managed type " + JpaMetamodelUtils.getTypeName(baseNodeType));
            }
            if (joinRequired || attr.isCollection()) {
                JoinResult newBaseNodeResult = this.implicitJoinSingle(baseNode, attributeName, treatTypeName, joinType, currentJoinNode, false, joinAllowed);
                newBaseNode = newBaseNodeResult.baseNode;
                if (newBaseNode != baseNode) {
                    field = null;
                    type = newBaseNode.getNodeType();
                } else {
                    field = attributeName;
                    type = attributeHolder.getAttributeType();
                }
            } else {
                newBaseNode = baseNode;
                field = attributeName;
                type = attributeHolder.getAttributeType();
                lazy = true;
            }
        } else {
            JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
            AttributeHolder attributeHolder = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(attributeName), baseNode.getAlias());
            Attribute<?, ?> attr = attributeHolder.getAttribute();
            if (attr == null) {
                throw new IllegalArgumentException("Field with name " + attributeName + " was not found within class " + JpaMetamodelUtils.getTypeName(baseNodeType));
            }
            if (jpaMetamodelAccessor.isJoinable(attr)) {
                if (jpaMetamodelAccessor.isCompositeNode(attr)) {
                    throw new IllegalArgumentException("No object leaf allowed but " + attributeName + " is an object leaf");
                }
                JoinResult newBaseNodeResult = this.implicitJoinSingle(baseNode, attributeName, treatTypeName, joinType, currentJoinNode, false, joinAllowed);
                newBaseNode = newBaseNodeResult.baseNode;
                field = null;
                type = newBaseNode.getNodeType();
            } else {
                newBaseNode = baseNode;
                field = attributeName;
                type = attributeHolder.getAttributeType();
            }
        }
        return new JoinResult(newBaseNode, field == null ? null : Arrays.asList(field), type, -1, -1, lazy);
    }

    private JoinType getModelAwareType(JoinNode baseNode, Attribute<?, ?> attr) {
        if (baseNode.getJoinType() == JoinType.LEFT || baseNode.getJoinType() == JoinType.FULL) {
            return JoinType.LEFT;
        }
        if (!(attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.MANY_TO_ONE && attr.getPersistentAttributeType() != Attribute.PersistentAttributeType.ONE_TO_ONE || ((SingularAttribute)attr).isOptional())) {
            return JoinType.INNER;
        }
        return JoinType.LEFT;
    }

    private JoinResult createOrUpdateNode(JoinNode baseNode, List<String> joinRelationAttributes, String treatType, String alias, JoinType joinType, JoinNode currentJoinNode, boolean implicit, boolean defaultJoin, boolean joinAllowed) {
        Type<?> baseNodeType = baseNode.getNodeType();
        String joinRelationName = StringUtils.join((CharSequence)".", joinRelationAttributes);
        JpaMetamodelAccessor jpaMetamodelAccessor = this.mainQuery.jpaProvider.getJpaMetamodelAccessor();
        AttributeHolder attrJoinResult = JpaUtils.getAttributeForJoining(this.metamodel, baseNodeType, this.expressionFactory.createJoinPathExpression(joinRelationName), baseNode.getAlias());
        Attribute<?, ?> attr = attrJoinResult.getAttribute();
        if (attr == null) {
            throw new IllegalArgumentException("Field with name " + joinRelationName + " was not found within class " + JpaMetamodelUtils.getTypeName(baseNodeType));
        }
        if (!jpaMetamodelAccessor.isJoinable(attr)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Field with name " + joinRelationName + " of class " + JpaMetamodelUtils.getTypeName(baseNodeType) + " is parseable and therefore it has not to be fetched explicitly.");
            }
            return new JoinResult(baseNode, joinRelationAttributes, attrJoinResult.getAttributeType(), -1, -1);
        }
        if (!(joinAllowed || currentJoinNode != null && currentJoinNode.containsNode(baseNode, joinRelationName))) {
            throw new ImplicitJoinNotAllowedException(baseNode, joinRelationAttributes, treatType);
        }
        if (implicit) {
            String aliasToUse = alias == null ? attr.getName() : alias;
            alias = baseNode.getAliasInfo().getAliasOwner().generateJoinAlias(aliasToUse);
        }
        if (joinType == null) {
            joinType = this.getModelAwareType(baseNode, attr);
        }
        Type<?> joinRelationType = attrJoinResult.getAttributeType();
        JoinNode newNode = this.getOrCreate(baseNode, joinRelationName, joinRelationType, treatType, alias, joinType, "Ambiguous implicit join", implicit, defaultJoin, attr);
        return new JoinResult(newNode, null, newNode.getNodeType(), -1, -1);
    }

    private void checkAliasIsAvailable(AliasManager aliasManager, String alias, String currentJoinPath, String errorMessage) {
        AliasInfo oldAliasInfo = aliasManager.getAliasInfoForBottomLevel(alias);
        if (oldAliasInfo instanceof SelectInfo) {
            throw new IllegalStateException("Alias [" + oldAliasInfo.getAlias() + "] already used as select alias");
        }
        JoinAliasInfo oldJoinAliasInfo = (JoinAliasInfo)oldAliasInfo;
        if (oldJoinAliasInfo != null) {
            if (!oldJoinAliasInfo.getAbsolutePath().equals(currentJoinPath)) {
                throw new IllegalArgumentException(errorMessage);
            }
            throw new RuntimeException("Probably a programming error if this happens. An alias[" + alias + "] for the same join path[" + currentJoinPath + "] is available but the join node is not!");
        }
    }

    private JoinNode getOrCreate(JoinNode baseNode, String joinRelationName, Type<?> joinRelationType, String treatType, String alias, JoinType type, String errorMessage, boolean implicit, boolean defaultJoin, Attribute<?, ?> attribute) {
        String currentJoinPath;
        EntityType<?> treatJoinType;
        String qualifiedJoinPath;
        JoinTreeNode treeNode = baseNode.getOrCreateTreeNode(joinRelationName, attribute);
        JoinNode node = treeNode.getJoinNode(alias, defaultJoin);
        String qualificationExpression = null;
        if (attribute instanceof QualifiedAttribute) {
            QualifiedAttribute qualifiedAttribute = (QualifiedAttribute)attribute;
            qualificationExpression = qualifiedAttribute.getQualificationExpression();
            qualifiedJoinPath = joinRelationName.substring(0, qualificationExpression.length() + 1) + baseNode.getAliasInfo().getAbsolutePath() + "." + joinRelationName.substring(qualificationExpression.length() + 1);
        } else {
            qualifiedJoinPath = baseNode.getAliasInfo().getAbsolutePath() + "." + joinRelationName;
        }
        if (!defaultJoin && treatType != null) {
            treatJoinType = this.metamodel.getEntity(treatType);
            currentJoinPath = "TREAT(" + qualifiedJoinPath + " AS " + treatJoinType.getName() + ")";
        } else {
            treatJoinType = null;
            currentJoinPath = qualifiedJoinPath;
        }
        if (node == null) {
            AliasManager aliasManager = baseNode.getAliasInfo().getAliasOwner();
            this.checkAliasIsAvailable(aliasManager, alias, currentJoinPath, errorMessage);
            if (implicit && !aliasManager.isAliasAvailable(alias)) {
                alias = aliasManager.generateJoinAlias(alias);
            }
            JoinAliasInfo newAliasInfo = new JoinAliasInfo(alias, currentJoinPath, implicit, false, aliasManager);
            aliasManager.registerAliasInfo(newAliasInfo);
            node = JoinNode.createAssociationJoinNode(baseNode, treeNode, type, joinRelationType, treatJoinType, qualificationExpression, newAliasInfo);
            newAliasInfo.setJoinNode(node);
            treeNode.addJoinNode(node, defaultJoin);
            if (!implicit) {
                this.explicitJoinNodes.add(node);
            }
        } else {
            JoinAliasInfo nodeAliasInfo = node.getAliasInfo();
            if (!alias.equals(nodeAliasInfo.getAlias())) {
                if (nodeAliasInfo.isImplicit() && !implicit) {
                    this.aliasManager.unregisterAliasInfoForBottomLevel(nodeAliasInfo);
                    nodeAliasInfo.setAlias(alias);
                    nodeAliasInfo.setImplicit(false);
                    node.setJoinType(type);
                    this.aliasManager.registerAliasInfo(nodeAliasInfo);
                    this.explicitJoinNodes.add(node);
                } else if (!nodeAliasInfo.isImplicit() && !implicit) {
                    throw new IllegalArgumentException("Alias conflict [" + nodeAliasInfo.getAlias() + "=" + nodeAliasInfo.getAbsolutePath() + ", " + alias + "=" + currentJoinPath + "]");
                }
            }
            if (treatJoinType != null) {
                if (node.getTreatType() == null) {
                    node = node.getTreatedJoinNode(treatJoinType);
                } else if (!treatJoinType.equals(node.getTreatType())) {
                    throw new IllegalArgumentException("A join node [" + nodeAliasInfo.getAlias() + "=" + nodeAliasInfo.getAbsolutePath() + "] for treat type [" + treatType + "] conflicts with the existing treat type [" + node.getTreatType() + "]");
                }
            }
        }
        return node;
    }

    private JoinNode findNode(JoinNode baseNode, String joinRelationName, ArrayExpression arrayExpression) {
        JoinTreeNode treeNode = (JoinTreeNode)baseNode.getNodes().get(joinRelationName);
        if (treeNode == null) {
            return null;
        }
        for (JoinNode node : treeNode.getJoinNodes().values()) {
            EqPredicate pred = this.getArrayExpressionPredicate(node, arrayExpression);
            CompoundPredicate compoundPredicate = node.getOnPredicate();
            if (!this.findPredicate(compoundPredicate, (Predicate)pred)) continue;
            return node;
        }
        return null;
    }

    private boolean findPredicate(CompoundPredicate compoundPredicate, Predicate pred) {
        if (compoundPredicate != null) {
            List children = compoundPredicate.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                if (!pred.equals(children.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void fetchPath(JoinNode node) {
        node.setFetch(true);
        node.getClauseDependencies().add(ClauseType.SELECT);
    }

    public boolean hasFullJoin() {
        return this.hasFullJoin;
    }

    private class JoinOnBuilderEndedListener
    extends PredicateBuilderEndedListenerImpl {
        private JoinNode joinNode;

        private JoinOnBuilderEndedListener() {
        }

        @Override
        public void onBuilderEnded(PredicateBuilder builder) {
            super.onBuilderEnded(builder);
            Predicate predicate = builder.getPredicate();
            predicate.accept((Expression.Visitor)new VisitorAdapter(){
                private boolean isKeyFunction;

                public void visit(ListIndexExpression expression) {
                    boolean old = this.isKeyFunction;
                    this.isKeyFunction = true;
                    super.visit(expression);
                    this.isKeyFunction = old;
                }

                public void visit(MapKeyExpression expression) {
                    boolean old = this.isKeyFunction;
                    this.isKeyFunction = true;
                    super.visit(expression);
                    this.isKeyFunction = old;
                }

                public void visit(PathExpression expression) {
                    expression.setCollectionQualifiedPath(this.isKeyFunction);
                    super.visit(expression);
                }
            });
            this.joinNode.setOnPredicate((CompoundPredicate)predicate);
            this.joinNode.updateClauseDependencies(ClauseType.JOIN, new LinkedHashSet<JoinNode>());
        }
    }

    private static class JoinResult {
        final JoinNode baseNode;
        final List<String> fields;
        final Type<?> type;
        final boolean lazy;
        final int singleValuedAssociationNameIndex;
        final int singleValuedAssociationNameEndIndex;

        public JoinResult(JoinNode baseNode, List<String> fields, Type<?> type, int singleValuedAssociationNameIndex, int singleValuedAssociationNameEndIndex) {
            this.baseNode = baseNode;
            this.fields = fields;
            this.type = type;
            this.singleValuedAssociationNameIndex = singleValuedAssociationNameIndex;
            this.singleValuedAssociationNameEndIndex = singleValuedAssociationNameEndIndex;
            this.lazy = false;
        }

        public JoinResult(JoinNode baseNode, List<String> fields, Type<?> type, int singleValuedAssociationNameIndex, int singleValuedAssociationNameEndIndex, boolean lazy) {
            this.baseNode = baseNode;
            this.fields = fields;
            this.type = type;
            this.singleValuedAssociationNameIndex = singleValuedAssociationNameIndex;
            this.singleValuedAssociationNameEndIndex = singleValuedAssociationNameEndIndex;
            this.lazy = lazy;
        }

        private boolean hasField() {
            return this.fields != null && !this.fields.isEmpty();
        }

        private String joinFields(String field) {
            if (this.fields == null || this.fields.isEmpty()) {
                return field;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.fields.get(0));
            for (int i = 1; i < this.fields.size(); ++i) {
                sb.append('.');
                sb.append(this.fields.get(i));
            }
            if (field != null) {
                sb.append('.');
                sb.append(field);
            }
            return sb.toString();
        }

        private String joinFields() {
            return this.joinFields(null);
        }

        private List<String> addToList(List<String> resultFields) {
            if (this.hasField() && resultFields != this.fields) {
                resultFields.addAll(this.fields);
            }
            return resultFields;
        }

        private boolean isLazy() {
            return this.lazy;
        }
    }

    private static class LazyPathReference
    implements PathReference,
    Path {
        private final JoinNode baseNode;
        private final String field;
        private final Type<?> type;
        private final boolean joinAllowed;

        public LazyPathReference(JoinNode baseNode, String field, Type<?> type, boolean joinAllowed) {
            this.baseNode = baseNode;
            this.field = field;
            this.type = type;
            this.joinAllowed = joinAllowed;
        }

        public JoinNode getBaseNode() {
            JoinTreeNode subNode;
            if (this.joinAllowed && (subNode = (JoinTreeNode)this.baseNode.getNodes().get(this.field)) != null && subNode.getDefaultNode() != null) {
                return subNode.getDefaultNode();
            }
            return this.baseNode;
        }

        public String getField() {
            JoinTreeNode subNode;
            if (this.joinAllowed && (subNode = (JoinTreeNode)this.baseNode.getNodes().get(this.field)) != null && subNode.getDefaultNode() != null) {
                return null;
            }
            return this.field;
        }

        public Type<?> getType() {
            return this.type;
        }

        public From getFrom() {
            return this.getBaseNode();
        }

        public String getPath() {
            StringBuilder sb = new StringBuilder();
            this.getBaseNode().appendDeReference(sb, this.getField(), true, false, false);
            return sb.toString();
        }

        public Class<?> getJavaType() {
            return this.type.getJavaType();
        }

        public String toString() {
            return this.getPath();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseNode == null ? 0 : this.baseNode.hashCode());
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PathReference)) {
                return false;
            }
            PathReference other = (PathReference)obj;
            if (this.baseNode == null ? other.getBaseNode() != null : !this.baseNode.equals(other.getBaseNode())) {
                return false;
            }
            return !(this.field == null ? other.getField() != null : !this.field.equals(other.getField()));
        }
    }

    static class KeyRestrictedLeftJoinCollectingVisitor
    extends VisitorAdapter
    implements JoinNodeVisitor {
        final JpaProvider jpaProvider;
        final Set<JoinNode> keyRestrictedLeftJoins;

        public KeyRestrictedLeftJoinCollectingVisitor(JpaProvider jpaProvider, Set<JoinNode> keyRestrictedLeftJoins) {
            this.jpaProvider = jpaProvider;
            this.keyRestrictedLeftJoins = keyRestrictedLeftJoins;
        }

        @Override
        public void visit(JoinNode node) {
            if (node.getJoinType() == JoinType.LEFT && node.getOnPredicate() != null) {
                node.getOnPredicate().accept((Expression.Visitor)this);
            }
        }

        public void visit(MapKeyExpression expression) {
            super.visit(expression);
            this.visitKeyOrIndexExpression(expression.getPath());
        }

        public void visit(ListIndexExpression expression) {
            super.visit(expression);
            this.visitKeyOrIndexExpression(expression.getPath());
        }

        private void visitKeyOrIndexExpression(PathExpression pathExpression) {
            JoinNode node = (JoinNode)pathExpression.getBaseNode();
            Attribute<?, ?> attribute = node.getParentTreeNode().getAttribute();
            if (!this.jpaProvider.getJpaMetamodelAccessor().isElementCollection(attribute) && this.jpaProvider.getJoinTable(node.getParent().getEntityType(), attribute.getName()) != null) {
                this.keyRestrictedLeftJoins.add(node);
            }
        }
    }
}

