/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AbstractQueryConfiguration;
import com.blazebit.persistence.impl.QueryConfiguration;
import java.util.Map;

public class MutableQueryConfiguration
extends AbstractQueryConfiguration {
    private final boolean compatibleModeEnabled;
    private final boolean expressionOptimizationEnabled;
    private final String expressionCacheClass;
    private boolean returningClauseCaseSensitive;
    private boolean sizeToCountTransformationEnabled;
    private boolean implicitGroupByFromSelectEnabled;
    private boolean implicitGroupByFromHavingEnabled;
    private boolean implicitGroupByFromOrderByEnabled;
    private boolean valuesClauseFilterNullsEnabled;
    private boolean parameterAsLiteralRenderingEnabled;
    private boolean optimizedKeysetPredicateRenderingEnabled;
    private boolean cacheable;
    private Boolean inlineIdQuery;
    private Boolean inlineCountQuery;
    private Boolean inlineCtes;

    public MutableQueryConfiguration(QueryConfiguration queryConfiguration) {
        this.compatibleModeEnabled = queryConfiguration.isCompatibleModeEnabled();
        this.expressionOptimizationEnabled = queryConfiguration.isExpressionOptimizationEnabled();
        this.expressionCacheClass = queryConfiguration.getExpressionCacheClass();
        this.returningClauseCaseSensitive = queryConfiguration.isReturningClauseCaseSensitive();
        this.sizeToCountTransformationEnabled = queryConfiguration.isCountTransformationEnabled();
        this.implicitGroupByFromSelectEnabled = queryConfiguration.isImplicitGroupByFromSelectEnabled();
        this.implicitGroupByFromHavingEnabled = queryConfiguration.isImplicitGroupByFromHavingEnabled();
        this.implicitGroupByFromOrderByEnabled = queryConfiguration.isImplicitGroupByFromOrderByEnabled();
        this.valuesClauseFilterNullsEnabled = queryConfiguration.isValuesClauseFilterNullsEnabled();
        this.parameterAsLiteralRenderingEnabled = queryConfiguration.isParameterAsLiteralRenderingEnabled();
        this.optimizedKeysetPredicateRenderingEnabled = queryConfiguration.isOptimizedKeysetPredicateRenderingEnabled();
        this.cacheable = queryConfiguration.isCacheable();
        this.inlineIdQuery = queryConfiguration.getInlineIdQueryEnabled();
        this.inlineCountQuery = queryConfiguration.getInlineCountQueryEnabled();
        this.inlineCtes = queryConfiguration.getInlineCtesEnabled();
    }

    @Override
    public boolean isCompatibleModeEnabled() {
        return this.compatibleModeEnabled;
    }

    @Override
    public boolean isReturningClauseCaseSensitive() {
        return this.returningClauseCaseSensitive;
    }

    @Override
    public boolean isExpressionOptimizationEnabled() {
        return this.expressionOptimizationEnabled;
    }

    @Override
    public String getExpressionCacheClass() {
        return this.expressionCacheClass;
    }

    @Override
    public boolean isCountTransformationEnabled() {
        return this.sizeToCountTransformationEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromSelectEnabled() {
        return this.implicitGroupByFromSelectEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromHavingEnabled() {
        return this.implicitGroupByFromHavingEnabled;
    }

    @Override
    public boolean isImplicitGroupByFromOrderByEnabled() {
        return this.implicitGroupByFromOrderByEnabled;
    }

    @Override
    public boolean isValuesClauseFilterNullsEnabled() {
        return this.valuesClauseFilterNullsEnabled;
    }

    @Override
    public boolean isParameterAsLiteralRenderingEnabled() {
        return this.parameterAsLiteralRenderingEnabled;
    }

    @Override
    public boolean isOptimizedKeysetPredicateRenderingEnabled() {
        return this.optimizedKeysetPredicateRenderingEnabled;
    }

    @Override
    public Boolean getInlineIdQueryEnabled() {
        return this.inlineIdQuery;
    }

    @Override
    public Boolean getInlineCountQueryEnabled() {
        return this.inlineCountQuery;
    }

    @Override
    public Boolean getInlineCtesEnabled() {
        return this.inlineCtes;
    }

    @Override
    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setProperty(String propertyName, String propertyValue) {
        switch (propertyName) {
            case "com.blazebit.persistence.compatible_mode": {
                throw this.propertySetNotAllowed(propertyName);
            }
            case "com.blazebit.persistence.returning_clause_case_sensitive": {
                this.returningClauseCaseSensitive = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.size_to_count_transformation": {
                this.sizeToCountTransformationEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.implicit_group_by_from_select": {
                this.implicitGroupByFromSelectEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.implicit_group_by_from_having": {
                this.implicitGroupByFromHavingEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.implicit_group_by_from_order_by": {
                this.implicitGroupByFromOrderByEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.expression_optimization": {
                throw this.propertySetNotAllowed(propertyName);
            }
            case "com.blazebit.persistence.expression.cache_class": {
                throw this.propertySetNotAllowed(propertyName);
            }
            case "com.blazebit.persistence.values.filter_nulls": {
                this.valuesClauseFilterNullsEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.parameter_literal_rendering": {
                this.parameterAsLiteralRenderingEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.optimized_keyset_predicate_rendering": {
                this.optimizedKeysetPredicateRenderingEnabled = this.booleanOrFail(propertyName, propertyValue);
                break;
            }
            case "com.blazebit.persistence.inline_id_query": {
                this.inlineIdQuery = "auto".equalsIgnoreCase(propertyValue) ? null : Boolean.valueOf(this.booleanOrFail(propertyName, propertyValue));
                break;
            }
            case "com.blazebit.persistence.inline_count_query": {
                this.inlineCountQuery = "auto".equalsIgnoreCase(propertyValue) ? null : Boolean.valueOf(this.booleanOrFail(propertyName, propertyValue));
                break;
            }
            case "com.blazebit.persistence.inline_ctes": {
                this.inlineCtes = "auto".equalsIgnoreCase(propertyValue) ? null : Boolean.valueOf(this.booleanOrFail(propertyName, propertyValue));
                break;
            }
        }
    }

    private RuntimeException propertySetNotAllowed(String propertyName) {
        return new IllegalArgumentException("Not allowed to set property: " + propertyName);
    }

    private boolean booleanOrFail(String propertyName, String propertyValue) {
        if ("true".equalsIgnoreCase(propertyValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(propertyValue)) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value '" + propertyValue + "' for boolean property '" + propertyName + "'");
    }
}

