/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.BaseFinalSetOperationBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AliasInfo;
import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.AssociationParameterTransformerFactory;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.ExpressionUtils;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.AggregateExpression;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.OrderByItem;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.WindowDefinition;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.EqPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.GePredicate;
import com.blazebit.persistence.parser.predicate.GtPredicate;
import com.blazebit.persistence.parser.predicate.InPredicate;
import com.blazebit.persistence.parser.predicate.IsEmptyPredicate;
import com.blazebit.persistence.parser.predicate.IsNullPredicate;
import com.blazebit.persistence.parser.predicate.LePredicate;
import com.blazebit.persistence.parser.predicate.LikePredicate;
import com.blazebit.persistence.parser.predicate.LtPredicate;
import com.blazebit.persistence.parser.predicate.MemberOfPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import com.blazebit.persistence.spi.JpaProvider;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Type;

public class ResolvingQueryGenerator
extends SimpleQueryGenerator {
    private static final Set<String> BUILT_IN_FUNCTIONS;
    protected String aliasPrefix;
    private boolean resolveSelectAliases = true;
    private boolean externalRepresentation;
    private Set<JoinNode> renderedJoinNodes;
    private ClauseType clauseType;
    private Map<JoinNode, Boolean> treatedJoinNodesForConstraints;
    private final EntityMetamodel entityMetamodel;
    private final Set<String> currentlyResolvingAliases;
    private final AliasManager aliasManager;
    private final ParameterManager parameterManager;
    private final AssociationParameterTransformerFactory parameterTransformerFactory;
    private final JpaProvider jpaProvider;
    private final Map<String, JpqlFunction> registeredFunctions;
    private final Map<String, String> registeredFunctionsNames;

    public ResolvingQueryGenerator(EntityMetamodel entityMetamodel, AliasManager aliasManager, ParameterManager parameterManager, AssociationParameterTransformerFactory parameterTransformerFactory, JpaProvider jpaProvider, Map<String, JpqlFunction> registeredFunctions) {
        this.entityMetamodel = entityMetamodel;
        this.aliasManager = aliasManager;
        this.parameterManager = parameterManager;
        this.parameterTransformerFactory = parameterTransformerFactory;
        this.jpaProvider = jpaProvider;
        this.registeredFunctions = registeredFunctions;
        this.currentlyResolvingAliases = new HashSet<String>();
        this.registeredFunctionsNames = new HashMap<String, String>(registeredFunctions.size());
        for (Map.Entry<String, JpqlFunction> registeredFunctionEntry : registeredFunctions.entrySet()) {
            this.registeredFunctionsNames.put(registeredFunctionEntry.getKey().toLowerCase(), registeredFunctionEntry.getKey());
        }
    }

    public void generate(Expression expression) {
        if (expression instanceof NullExpression && this.clauseType != ClauseType.SET) {
            if (this.externalRepresentation) {
                this.sb.append("NULL");
            } else {
                this.sb.append(this.jpaProvider.getNullExpression());
            }
            return;
        }
        expression.accept((Expression.Visitor)this);
    }

    public void visit(MapValueExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
    }

    public void visit(FunctionExpression expression) {
        if (this.externalRepresentation && expression.getRealArgument() != null) {
            expression.getRealArgument().accept((Expression.Visitor)this);
            return;
        }
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        if (expression instanceof AggregateExpression) {
            this.treatedJoinNodesForConstraints = null;
        }
        if (com.blazebit.persistence.parser.util.ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            ((Expression)expression.getExpressions().get(0)).accept((Expression.Visitor)this);
        } else if (ExpressionUtils.isFunctionFunctionExpression(expression)) {
            List arguments = expression.getExpressions();
            String literalFunctionName = ExpressionUtils.unwrapStringLiteral(((Expression)arguments.get(0)).toString());
            String resolvedFunctionName = this.resolveRenderedFunctionName(literalFunctionName);
            List<Object> argumentsWithoutFunctionName = arguments.size() > 1 ? arguments.subList(1, arguments.size()) : Collections.emptyList();
            this.renderFunctionFunction(resolvedFunctionName, argumentsWithoutFunctionName, expression.getResolvedWindowDefinition());
        } else if (this.isCountStarFunction(expression)) {
            this.renderCountStar(expression.getResolvedWindowDefinition());
        } else if (BUILT_IN_FUNCTIONS.contains(expression.getFunctionName().toLowerCase()) && expression.getResolvedWindowDefinition() == null) {
            super.visit(expression);
        } else {
            this.renderFunctionFunction(this.resolveRenderedFunctionName(expression.getFunctionName()), expression.getExpressions(), expression.getResolvedWindowDefinition());
        }
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
    }

    private String resolveRenderedFunctionName(String literalFunctionName) {
        String registeredFunctionName = this.registeredFunctionsNames.get(literalFunctionName.toLowerCase());
        return registeredFunctionName == null ? literalFunctionName : registeredFunctionName;
    }

    protected void renderCountStar(WindowDefinition windowDefinition) {
        if (this.jpaProvider.supportsCustomFunctions()) {
            if (this.jpaProvider.supportsCountStar() && windowDefinition == null) {
                this.sb.append("COUNT(*)");
            } else if (windowDefinition != null) {
                this.renderFunctionFunction(this.resolveRenderedFunctionName("WINDOW_COUNT"), Collections.emptyList(), windowDefinition);
            } else {
                this.renderFunctionFunction(this.resolveRenderedFunctionName("COUNT_STAR"), Collections.emptyList(), null);
            }
        } else {
            if (windowDefinition != null) {
                throw new IllegalArgumentException("JPA provider does not support custom function invocation!");
            }
            this.sb.append("COUNT(1)");
        }
    }

    public void visit(SubqueryExpression expression) {
        if (!this.externalRepresentation && expression.getSubquery() instanceof SubqueryInternalBuilder) {
            boolean isSimple;
            AbstractCommonQueryBuilder subquery = (AbstractCommonQueryBuilder)expression.getSubquery();
            subquery.prepareAndCheck();
            boolean hasFirstResult = subquery.getFirstResult() != 0;
            boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
            boolean hasLimit = hasFirstResult || hasMaxResults;
            boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
            boolean hasEntityFunctions = subquery.joinManager.hasEntityFunctions();
            boolean bl = isSimple = !hasLimit && !hasSetOperations && !hasEntityFunctions;
            if (isSimple) {
                this.sb.append('(');
                subquery.buildBaseQueryString(this.sb, this.externalRepresentation, null);
                this.sb.append(')');
            } else {
                if (!this.externalRepresentation) {
                    this.sb.append('(');
                }
                Expression subqueryExpression = subquery.asExpression(this.externalRepresentation);
                if (!this.externalRepresentation && subqueryExpression instanceof SubqueryExpression) {
                    this.sb.append(((SubqueryExpression)subqueryExpression).getSubquery().getQueryString());
                } else {
                    subqueryExpression.accept((Expression.Visitor)this);
                }
                if (!this.externalRepresentation) {
                    this.sb.append(')');
                }
            }
        } else {
            this.sb.append('(');
            this.sb.append(expression.getSubquery().getQueryString());
            this.sb.append(')');
        }
    }

    protected boolean isSimpleSubquery(SubqueryExpression expression) {
        if (!this.externalRepresentation && expression.getSubquery() instanceof SubqueryInternalBuilder) {
            AbstractCommonQueryBuilder subquery = (AbstractCommonQueryBuilder)expression.getSubquery();
            boolean hasFirstResult = subquery.getFirstResult() != 0;
            boolean hasMaxResults = subquery.getMaxResults() != Integer.MAX_VALUE;
            boolean hasLimit = hasFirstResult || hasMaxResults;
            boolean hasSetOperations = subquery instanceof BaseFinalSetOperationBuilder;
            boolean hasEntityFunctions = subquery.joinManager.hasEntityFunctions();
            return !hasLimit && !hasSetOperations && !hasEntityFunctions && !subquery.joinManager.hasLateInlineNodes();
        }
        return super.isSimpleSubquery(expression);
    }

    protected void renderFunctionFunction(String functionName, List<Expression> arguments, WindowDefinition windowDefinition) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        int size = arguments.size();
        if (this.registeredFunctions.containsKey(functionName)) {
            this.sb.append(this.jpaProvider.getCustomFunctionInvocation(functionName, windowDefinition == null ? size : size + 1));
            if (size == 0) {
                this.visitWindowDefinition(windowDefinition);
            } else {
                arguments.get(0).accept((Expression.Visitor)this);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    arguments.get(i).accept((Expression.Visitor)this);
                }
                if (windowDefinition != null) {
                    this.sb.append(",");
                    this.visitWindowDefinition(windowDefinition);
                }
            }
            this.sb.append(')');
        } else if (this.jpaProvider.supportsJpa21()) {
            this.sb.append("FUNCTION('");
            this.sb.append(functionName);
            this.sb.append('\'');
            for (int i = 0; i < size; ++i) {
                this.sb.append(',');
                arguments.get(i).accept((Expression.Visitor)this);
            }
            if (windowDefinition != null) {
                this.sb.append(",");
                this.visitWindowDefinition(windowDefinition);
            }
            this.sb.append(')');
        } else {
            throw new IllegalArgumentException("Unknown function [" + functionName + "] is used!");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    protected void visitWindowDefinition(WindowDefinition windowDefinition) {
        if (windowDefinition != null) {
            List orderByExpressions;
            List partitionExpressions;
            int size;
            Predicate filterPredicate = windowDefinition.getFilterPredicate();
            if (filterPredicate != null) {
                this.sb.append("'FILTER',");
                filterPredicate.accept((Expression.Visitor)this);
            }
            if ((size = (partitionExpressions = windowDefinition.getPartitionExpressions()).size()) != 0) {
                if (filterPredicate != null) {
                    this.sb.append(",");
                }
                this.sb.append("'PARTITION BY',");
                ((Expression)partitionExpressions.get(0)).accept((Expression.Visitor)this);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    ((Expression)partitionExpressions.get(i)).accept((Expression.Visitor)this);
                }
            }
            if ((size = (orderByExpressions = windowDefinition.getOrderByExpressions()).size()) != 0) {
                if (filterPredicate != null || partitionExpressions.size() != 0) {
                    this.sb.append(",");
                }
                this.sb.append("'ORDER BY',");
                this.visit((OrderByItem)orderByExpressions.get(0));
                for (int i = 1; i < size; ++i) {
                    this.sb.append(",");
                    this.visit((OrderByItem)orderByExpressions.get(i));
                }
            }
            if (windowDefinition.getFrameMode() != null) {
                if (filterPredicate != null || partitionExpressions.size() != 0 || orderByExpressions.size() != 0) {
                    this.sb.append(",");
                }
                this.sb.append('\'');
                this.sb.append(windowDefinition.getFrameMode().name());
                this.sb.append("'");
                if (windowDefinition.getFrameEndType() != null) {
                    this.sb.append(",'BETWEEN'");
                }
                if (windowDefinition.getFrameStartExpression() != null) {
                    this.sb.append(",");
                    windowDefinition.getFrameStartExpression().accept((Expression.Visitor)this);
                }
                this.sb.append(",'");
                this.sb.append(this.getFrameType(windowDefinition.getFrameStartType()));
                this.sb.append("'");
                if (windowDefinition.getFrameEndType() != null) {
                    this.sb.append(",'AND'");
                    if (windowDefinition.getFrameEndExpression() != null) {
                        this.sb.append(",");
                        windowDefinition.getFrameEndExpression().accept((Expression.Visitor)this);
                    }
                    this.sb.append(",'");
                    this.sb.append(this.getFrameType(windowDefinition.getFrameEndType()));
                    this.sb.append("'");
                }
                if (windowDefinition.getFrameExclusionType() != null) {
                    this.sb.append(",'");
                    this.sb.append(this.getFrameExclusionType(windowDefinition.getFrameExclusionType()));
                    this.sb.append("'");
                }
            }
        }
    }

    private void visit(OrderByItem orderByItem) {
        orderByItem.getExpression().accept((Expression.Visitor)this);
        this.sb.append(",'");
        this.sb.append(orderByItem.isAscending() ? "ASC" : "DESC");
        this.sb.append(orderByItem.isNullFirst() ? " NULLS FIRST" : " NULLS LAST");
        this.sb.append("'");
    }

    private boolean isCountStarFunction(FunctionExpression expression) {
        return expression instanceof AggregateExpression && expression.getExpressions().isEmpty() && "COUNT".equalsIgnoreCase(expression.getFunctionName());
    }

    public void visit(TreatExpression expression) {
        if (this.jpaProvider.supportsRootTreat()) {
            super.visit(expression);
        } else if (this.jpaProvider.supportsSubtypePropertyResolving()) {
            expression.getExpression().accept((Expression.Visitor)this);
        } else {
            throw new IllegalArgumentException("Can not render treat expression[" + expression.toString() + "] as the JPA provider does not support it!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(PathExpression expression) {
        JoinNode baseNode;
        if (this.resolveSelectAliases && expression.getExpressions().size() == 1) {
            String potentialAlias = ((PathElementExpression)expression.getExpressions().get(0)).toString();
            try {
                AliasInfo aliasInfo;
                if (this.currentlyResolvingAliases.add(potentialAlias) && (aliasInfo = this.aliasManager.getAliasInfo(potentialAlias)) != null && aliasInfo instanceof SelectInfo) {
                    SelectInfo selectAliasInfo = (SelectInfo)aliasInfo;
                    if (selectAliasInfo.getExpression() instanceof PathExpression) {
                        PathExpression aliasedExpression = (PathExpression)selectAliasInfo.getExpression();
                        boolean collectionKeyPath = aliasedExpression.isCollectionQualifiedPath();
                        boolean usedInCollectionFunction = aliasedExpression.isUsedInCollectionFunction();
                        aliasedExpression.setCollectionQualifiedPath(expression.isCollectionQualifiedPath());
                        aliasedExpression.setUsedInCollectionFunction(expression.isUsedInCollectionFunction());
                        try {
                            selectAliasInfo.getExpression().accept((Expression.Visitor)this);
                        }
                        finally {
                            aliasedExpression.setCollectionQualifiedPath(collectionKeyPath);
                            aliasedExpression.setUsedInCollectionFunction(usedInCollectionFunction);
                        }
                    } else {
                        selectAliasInfo.getExpression().accept((Expression.Visitor)this);
                    }
                    return;
                }
            }
            finally {
                this.currentlyResolvingAliases.remove(potentialAlias);
            }
        }
        if ((baseNode = (JoinNode)expression.getBaseNode()) == null) {
            super.visit(expression);
        } else {
            String collectionValueFunction = this.jpaProvider.getCollectionValueFunction();
            String field = expression.getField();
            if (field == null) {
                if (expression.isUsedInCollectionFunction() || this.renderAbsolutePath(expression)) {
                    super.visit(expression);
                } else {
                    boolean valueFunction;
                    boolean bl = valueFunction = collectionValueFunction != null && this.needsValueFunction(expression, baseNode, field);
                    if (valueFunction) {
                        this.sb.append(collectionValueFunction);
                        this.sb.append('(');
                    }
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb, this.externalRepresentation);
                    if (valueFunction) {
                        this.sb.append(')');
                    }
                }
            } else {
                boolean addTypeCaseWhen;
                List<JoinNode> treatedJoinNodes = baseNode.getJoinNodesForTreatConstraint();
                if (this.treatedJoinNodesForConstraints != null) {
                    for (JoinNode node : treatedJoinNodes) {
                        this.treatedJoinNodesForConstraints.put(node, Boolean.FALSE);
                    }
                }
                ManagedType<?> baseNodeType = baseNode.getManagedType();
                boolean bl = addTypeCaseWhen = !treatedJoinNodes.isEmpty() && baseNodeType instanceof EntityType && this.jpaProvider.needsTypeConstraintForColumnSharing() && this.jpaProvider.isColumnShared((EntityType)baseNodeType, field);
                if (addTypeCaseWhen) {
                    this.sb.append("CASE WHEN ");
                    boolean first = true;
                    for (int i = 0; i < treatedJoinNodes.size(); ++i) {
                        JoinNode treatedJoinNode = treatedJoinNodes.get(i);
                        if (this.jpaProvider.supportsTreatJoin() && treatedJoinNode.isTreatJoinNode()) continue;
                        if (first) {
                            first = false;
                        } else {
                            this.sb.append(" AND ");
                        }
                        this.sb.append("TYPE(");
                        this.sb.append(treatedJoinNode.getAlias());
                        this.sb.append(") IN (");
                        for (EntityType entitySubtype : this.entityMetamodel.getEntitySubtypes(treatedJoinNode.getTreatType())) {
                            this.sb.append(entitySubtype.getName());
                            this.sb.append(", ");
                        }
                        this.sb.setLength(this.sb.length() - 2);
                        this.sb.append(')');
                    }
                    this.sb.append(" THEN ");
                }
                boolean valueFunction = collectionValueFunction != null && this.needsValueFunction(expression, baseNode, field);
                boolean renderTreat = this.jpaProvider.supportsRootTreat();
                if (valueFunction) {
                    this.sb.append(collectionValueFunction);
                    this.sb.append('(');
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendAlias(this.sb, renderTreat, this.externalRepresentation);
                    this.sb.append(')');
                    this.sb.append(".").append(field);
                } else {
                    if (this.aliasPrefix != null) {
                        this.sb.append(this.aliasPrefix);
                    }
                    baseNode.appendDeReference(this.sb, field, renderTreat, this.externalRepresentation, this.jpaProvider.needsElementCollectionIdCutoff());
                }
                if (addTypeCaseWhen) {
                    this.sb.append(" END");
                }
            }
        }
    }

    private boolean needsValueFunction(PathExpression expression, JoinNode baseNode, String field) {
        return !expression.isCollectionQualifiedPath() && baseNode.getParentTreeNode() != null && baseNode.getParentTreeNode().isMap() && (field == null || this.jpaProvider.supportsCollectionValueDereference());
    }

    private boolean renderAbsolutePath(PathExpression expression) {
        JoinNode baseNode = (JoinNode)expression.getBaseNode();
        return this.renderedJoinNodes != null && !this.renderedJoinNodes.contains(baseNode);
    }

    protected boolean needsParenthesisForCaseResult(Expression expression) {
        return expression instanceof ArithmeticExpression;
    }

    protected String getBooleanConditionalExpression(boolean value) {
        return this.jpaProvider.getBooleanConditionalExpression(value);
    }

    protected String getBooleanExpression(boolean value) {
        return this.jpaProvider.getBooleanExpression(value);
    }

    protected String escapeCharacter(char character) {
        return this.jpaProvider.escapeCharacter(character);
    }

    public void visit(ParameterExpression expression) {
        boolean needsBrackets;
        boolean bl = needsBrackets = this.jpaProvider.needsBracketsForListParameter() && expression.isCollectionValued();
        if (needsBrackets) {
            this.sb.append('(');
        }
        super.visit(expression);
        if (needsBrackets) {
            this.sb.append(')');
        }
    }

    protected String getLiteralParameterValue(ParameterExpression expression) {
        TypeConverter converter;
        Object value = expression.getValue();
        if (value == null) {
            value = this.parameterManager.getParameterValue(expression.getName());
        }
        if (!(value == null || (converter = TypeUtils.getConverter(value.getClass())) == null || value instanceof Enum && this.getBooleanLiteralRenderingContext() != SimpleQueryGenerator.BooleanLiteralRenderingContext.PLAIN)) {
            return converter.toString(value);
        }
        return null;
    }

    public void setResolveSelectAliases(boolean replaceSelectAliases) {
        this.resolveSelectAliases = replaceSelectAliases;
    }

    public boolean isResolveSelectAliases() {
        return this.resolveSelectAliases;
    }

    public void setAliasPrefix(String aliasPrefix) {
        this.aliasPrefix = aliasPrefix;
    }

    public void addAlias(String alias) {
        this.currentlyResolvingAliases.add(alias);
    }

    public void removeAlias(String alias) {
        this.currentlyResolvingAliases.remove(alias);
    }

    public void setRenderedJoinNodes(Set<JoinNode> renderedJoinNodes) {
        this.renderedJoinNodes = renderedJoinNodes;
    }

    public void setClauseType(ClauseType clauseType) {
        this.clauseType = clauseType;
    }

    public boolean isExternalRepresentation() {
        return this.externalRepresentation;
    }

    public void setExternalRepresentation(boolean externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public void visit(ArrayExpression expression) {
    }

    public void visit(InPredicate predicate) {
        if (predicate.getRight().size() == 1 && this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            Expression right = (Expression)predicate.getRight().get(0);
            if (right instanceof ParameterExpression) {
                ParameterExpression parameterExpression = (ParameterExpression)right;
                Type<?> associationType = this.getAssociationType(predicate.getLeft(), right);
                if (associationType instanceof EntityType) {
                    this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
                } else {
                    super.visit(predicate);
                }
            } else if (right instanceof PathExpression) {
                this.renderEquality(predicate.getLeft(), right, predicate.isNegated(), PredicateQuantifier.ONE);
            } else {
                super.visit(predicate);
            }
        } else {
            super.visit(predicate);
        }
    }

    private Type<?> getAssociationType(Expression expression1, Expression expression2) {
        if (expression1 instanceof PathExpression) {
            return ((PathExpression)expression1).getPathReference().getType();
        }
        return ((PathExpression)expression2).getPathReference().getType();
    }

    public void visit(EqPredicate predicate) {
        this.renderEquality(predicate.getLeft(), predicate.getRight(), predicate.isNegated(), predicate.getQuantifier());
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    private void renderEquality(Expression left, Expression right, boolean negated, PredicateQuantifier quantifier) {
        String operator = negated ? " <> " : " = ";
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PLAIN);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        if (this.jpaProvider.needsAssociationToIdRewriteInOnClause() && this.clauseType == ClauseType.JOIN) {
            boolean rewritten = this.renderAssociationIdIfPossible(left);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            if (rewritten |= this.renderAssociationIdIfPossible(right)) {
                this.rewriteToIdParam(left);
                this.rewriteToIdParam(right);
            }
        } else {
            left.accept((Expression.Visitor)this);
            this.sb.append(operator);
            if (quantifier != PredicateQuantifier.ONE) {
                this.sb.append(quantifier.toString());
            }
            right.accept((Expression.Visitor)this);
        }
        this.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private boolean renderAssociationIdIfPossible(Expression expression) {
        expression.accept((Expression.Visitor)this);
        if (expression instanceof PathExpression) {
            Type pathType;
            PathExpression pathExpression = (PathExpression)expression;
            if ((!this.jpaProvider.needsBrokenAssociationToIdRewriteInOnClause() || pathExpression.getBaseNode() != null && pathExpression.getField() != null) && (pathType = pathExpression.getPathReference().getType()) instanceof ManagedType && JpaMetamodelUtils.isIdentifiable((ManagedType)((ManagedType)pathType))) {
                String idName = JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)((IdentifiableType)pathType)).getName();
                this.sb.append('.');
                this.sb.append(idName);
                return true;
            }
        }
        return false;
    }

    private void rewriteToIdParam(Expression expression) {
        if (!(expression instanceof ParameterExpression)) {
            return;
        }
        ParameterExpression parameterExpression = (ParameterExpression)expression;
        ParameterManager.ParameterImpl<?> param = this.parameterManager.getParameter(parameterExpression.getName());
        param.setTranformer(this.parameterTransformerFactory.getToIdTransformer());
    }

    public void visit(IsNullPredicate predicate) {
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        predicate.getExpression().accept((Expression.Visitor)this);
        if (predicate.isNegated()) {
            this.sb.append(" IS NOT NULL");
            this.flipTreatedJoinNodeConstraints();
        } else {
            this.sb.append(" IS NULL");
        }
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    public void visit(IsEmptyPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(MemberOfPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LikePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(BetweenPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(ExistsPredicate predicate) {
        SubqueryExpression subqueryExpression;
        if (predicate.getExpression() instanceof SubqueryExpression && !this.isSimpleSubquery(subqueryExpression = (SubqueryExpression)predicate.getExpression())) {
            if (this.externalRepresentation) {
                if (predicate.isNegated()) {
                    this.sb.append("NOT EXISTS ");
                } else {
                    this.sb.append("EXISTS ");
                }
                this.sb.append('(');
                predicate.getExpression().accept((Expression.Visitor)this);
                this.sb.append(')');
            } else {
                this.sb.append("1 = ");
                this.sb.append(this.jpaProvider.getCustomFunctionInvocation("exist", 1));
                subqueryExpression.accept((Expression.Visitor)this);
                if (predicate.isNegated()) {
                    this.sb.append(",1");
                }
                this.sb.append(")");
            }
        } else {
            super.visit(predicate);
        }
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(GtPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(GePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LtPredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    public void visit(LePredicate predicate) {
        super.visit(predicate);
        if (predicate.isNegated()) {
            this.flipTreatedJoinNodeConstraints();
        }
    }

    protected void visitWhenClauseCondition(Expression condition) {
        if (!(condition instanceof Predicate) || condition instanceof CompoundPredicate) {
            condition.accept((Expression.Visitor)this);
            return;
        }
        Predicate p = (Predicate)condition;
        int startPosition = this.sb.length();
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
        p.accept((Expression.Visitor)this);
        this.insertTreatJoinConstraint(startPosition, this.sb.length());
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
    }

    public void visit(CompoundPredicate predicate) {
        boolean parenthesisRequired;
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldConditionalContext = this.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        SimpleQueryGenerator.ParameterRenderingMode oldParameterRenderingMode = this.setParameterRenderingMode(SimpleQueryGenerator.ParameterRenderingMode.PLACEHOLDER);
        boolean bl = parenthesisRequired = predicate.getChildren().size() > 1;
        if (predicate.isNegated()) {
            this.sb.append("NOT ");
            if (parenthesisRequired) {
                this.sb.append('(');
            }
        }
        if (predicate.getChildren().size() == 1) {
            int startPosition = this.sb.length();
            Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
            this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
            ((Predicate)predicate.getChildren().get(0)).accept((Expression.Visitor)this);
            this.insertTreatJoinConstraint(startPosition, this.sb.length());
            this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
            return;
        }
        int startLen = this.sb.length();
        String operator = " " + predicate.getOperator().toString() + " ";
        List children = predicate.getChildren();
        int size = children.size();
        Map<JoinNode, Boolean> oldTreatedJoinNodesForConstraints = this.treatedJoinNodesForConstraints;
        this.treatedJoinNodesForConstraints = new LinkedHashMap<JoinNode, Boolean>();
        for (int i = 0; i < size; ++i) {
            int endPosition;
            int startPosition = this.sb.length();
            Predicate child = (Predicate)children.get(i);
            if (child instanceof CompoundPredicate && ((CompoundPredicate)child).getOperator() != predicate.getOperator() && !child.isNegated()) {
                this.sb.append("(");
                int len = this.sb.length();
                child.accept((Expression.Visitor)this);
                if (len == this.sb.length()) {
                    this.sb.deleteCharAt(len - 1);
                    endPosition = this.sb.length();
                } else {
                    this.sb.append(")");
                    endPosition = this.sb.length();
                    this.sb.append(operator);
                }
            } else {
                child.accept((Expression.Visitor)this);
                endPosition = this.sb.length();
                this.sb.append(operator);
            }
            this.insertTreatJoinConstraint(startPosition, endPosition);
            this.treatedJoinNodesForConstraints.clear();
        }
        this.treatedJoinNodesForConstraints = oldTreatedJoinNodesForConstraints;
        if (startLen < this.sb.length()) {
            this.sb.delete(this.sb.length() - operator.length(), this.sb.length());
        }
        if (predicate.isNegated() && parenthesisRequired) {
            this.sb.append(')');
        }
        this.setBooleanLiteralRenderingContext(oldConditionalContext);
        this.setParameterRenderingMode(oldParameterRenderingMode);
    }

    private void flipTreatedJoinNodeConstraints() {
        if (this.treatedJoinNodesForConstraints != null) {
            for (Map.Entry<JoinNode, Boolean> entry : this.treatedJoinNodesForConstraints.entrySet()) {
                if (entry.getValue() == Boolean.TRUE) {
                    entry.setValue(Boolean.FALSE);
                    continue;
                }
                entry.setValue(Boolean.TRUE);
            }
        }
    }

    private boolean insertTreatJoinConstraint(int startPosition, int endPosition) {
        if (!this.treatedJoinNodesForConstraints.isEmpty()) {
            StringBuilder treatConditionBuilder = new StringBuilder(this.treatedJoinNodesForConstraints.size() * 40);
            treatConditionBuilder.append('(');
            for (Map.Entry<JoinNode, Boolean> entry : this.treatedJoinNodesForConstraints.entrySet()) {
                JoinNode node = entry.getKey();
                if (this.jpaProvider.supportsTreatJoin() && node.isTreatJoinNode()) continue;
                treatConditionBuilder.append("TYPE(");
                treatConditionBuilder.append(node.getAlias());
                if (entry.getValue() == Boolean.TRUE) {
                    treatConditionBuilder.append(") <> ");
                    treatConditionBuilder.append(node.getTreatType().getName());
                    treatConditionBuilder.append(" OR ");
                    continue;
                }
                treatConditionBuilder.append(") = ");
                treatConditionBuilder.append(node.getTreatType().getName());
                treatConditionBuilder.append(" AND ");
            }
            if (treatConditionBuilder.length() > 1) {
                this.sb.insert(endPosition, ')');
                this.sb.insert(startPosition, treatConditionBuilder);
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> functions = new HashSet<String>();
        functions.add("concat");
        functions.add("substring");
        functions.add("lower");
        functions.add("upper");
        functions.add("length");
        functions.add("locate");
        functions.add("abs");
        functions.add("sqrt");
        functions.add("mod");
        functions.add("coalesce");
        functions.add("nullif");
        functions.add("size");
        functions.add("type");
        functions.add("avg");
        functions.add("max");
        functions.add("min");
        functions.add("sum");
        functions.add("count");
        functions.add("current_date");
        functions.add("current_time");
        functions.add("current_timestamp");
        BUILT_IN_FUNCTIONS = functions;
    }
}

