/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectBuilder;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.KeysetPaginationHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KeysetExtractionObjectBuilder<T>
implements ObjectBuilder<T> {
    private final int[] keysetToSelectIndexMapping;
    private final int keysetSuffix;
    private final KeysetMode keysetMode;
    private final boolean unwrap;
    private final boolean extractCount;
    private Object[] first;
    private Object[] last;
    private ArrayList<Object[]> keysets;
    private long count = -1L;

    public KeysetExtractionObjectBuilder(int[] keysetToSelectIndexMapping, KeysetMode keysetMode, boolean unwrap, boolean extractAll, boolean extractCount) {
        this.keysetToSelectIndexMapping = keysetToSelectIndexMapping;
        this.keysetMode = keysetMode;
        this.unwrap = unwrap;
        this.extractCount = extractCount;
        if (extractAll) {
            this.keysets = new ArrayList();
        }
        int suffix = 0;
        for (int i = 0; i < keysetToSelectIndexMapping.length; ++i) {
            if (keysetToSelectIndexMapping[i] != -1) continue;
            ++suffix;
        }
        this.keysetSuffix = suffix;
    }

    public T build(Object[] tuple) {
        if (this.keysetMode == KeysetMode.PREVIOUS) {
            if (this.keysets != null) {
                if (this.keysets.isEmpty()) {
                    this.keysets.add(tuple);
                } else if (!this.equals(this.keysets.get(0), tuple)) {
                    this.keysets.add(0, tuple);
                }
            }
            if (this.first == null) {
                this.first = tuple;
                this.last = tuple;
            } else {
                this.first = tuple;
            }
        } else {
            if (this.keysets != null && (this.keysets.isEmpty() || !this.equals(this.keysets.get(this.keysets.size() - 1), tuple))) {
                this.keysets.add(tuple);
            }
            if (this.first == null) {
                this.first = tuple;
                this.last = tuple;
            } else {
                this.last = tuple;
            }
        }
        if (this.extractCount) {
            this.count = (Long)tuple[tuple.length - 1];
        }
        if (this.unwrap) {
            return (T)tuple[0];
        }
        Object[] newTuple = new Object[tuple.length - this.keysetSuffix - (this.extractCount ? 1 : 0)];
        System.arraycopy(tuple, 0, newTuple, 0, newTuple.length);
        return (T)newTuple;
    }

    private boolean equals(Object[] existing, Object[] tuple) {
        for (int index : this.keysetToSelectIndexMapping) {
            if (index != -1 && Objects.equals(existing[index], tuple[index])) continue;
            return false;
        }
        return true;
    }

    public Serializable[] getLowest() {
        if (this.first == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.first, this.keysetToSelectIndexMapping, this.keysetSuffix + (this.extractCount ? 1 : 0));
    }

    public Serializable[] getHighest() {
        if (this.last == null) {
            return null;
        }
        return KeysetPaginationHelper.extractKey(this.last, this.keysetToSelectIndexMapping, this.keysetSuffix + (this.extractCount ? 1 : 0));
    }

    public Serializable[][] getKeysets() {
        if (this.keysets == null) {
            return null;
        }
        Serializable[][] keysetArray = new Serializable[this.keysets.size()][];
        for (int i = 0; i < keysetArray.length; ++i) {
            keysetArray[i] = KeysetPaginationHelper.extractKey(this.keysets.get(i), this.keysetToSelectIndexMapping, this.keysetSuffix + (this.extractCount ? 1 : 0));
        }
        return keysetArray;
    }

    public long getCount() {
        return this.count;
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
    }
}

