/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.predicate.UnaryExpressionPredicate;

public class RightHandsideSubqueryPredicateBuilder<T>
extends SubqueryBuilderListenerImpl<T>
implements PredicateBuilder {
    private final Predicate predicate;
    private final PredicateBuilderEndedListener listener;

    public RightHandsideSubqueryPredicateBuilder(PredicateBuilderEndedListener listener, Predicate predicate) {
        this.predicate = predicate;
        this.listener = listener;
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        if (this.predicate instanceof ExistsPredicate && builder.getMaxResults() != Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Limiting a subquery in an exists predicate is currently unsupported!");
        }
        if (!(this.predicate instanceof UnaryExpressionPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate type was unexpected");
        }
        ((UnaryExpressionPredicate)this.predicate).setExpression((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }
}

