/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.DefaultDbmsDialect;
import com.blazebit.persistence.impl.dialect.MSSQL2012DbmsLimitHandler;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsLimitHandler;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.Map;

public class MSSQLDbmsDialect
extends DefaultDbmsDialect {
    public MSSQLDbmsDialect() {
    }

    public MSSQLDbmsDialect(Map<Class<?>, String> childSqlTypes) {
        super(childSqlTypes);
    }

    @Override
    public String getWithClause(boolean recursive) {
        return "with";
    }

    @Override
    protected String getWindowFunctionDummyOrderBy() {
        return " order by (select 0)";
    }

    @Override
    public boolean supportsReturningColumns() {
        return true;
    }

    @Override
    public boolean isNullSmallest() {
        return true;
    }

    @Override
    public LateralStyle getLateralStyle() {
        return LateralStyle.APPLY;
    }

    @Override
    protected String getOperator(SetOperationType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case UNION: {
                return "UNION";
            }
            case UNION_ALL: {
                return "UNION ALL";
            }
            case INTERSECT: {
                return "INTERSECT";
            }
            case INTERSECT_ALL: {
                return "INTERSECT";
            }
            case EXCEPT: {
                return "EXCEPT";
            }
            case EXCEPT_ALL: {
                return "EXCEPT";
            }
        }
        throw new IllegalArgumentException("Unknown operation type: " + type);
    }

    @Override
    protected boolean supportsPartitionInRowNumberOver() {
        return true;
    }

    @Override
    public boolean supportsRowValueConstructor() {
        return false;
    }

    @Override
    public boolean supportsFullRowValueComparison() {
        return false;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean addParenthesis;
        boolean bl = addParenthesis = isSubquery && sqlSb.length() > 0 && sqlSb.charAt(0) != '(';
        if (addParenthesis) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            sqlSb.insert(0, withClause);
        }
        if (returningColumns != null) {
            if (isSubquery) {
                throw new IllegalArgumentException("Returning columns in a subquery is not possible for this dbms!");
            }
            StringBuilder outputSb = new StringBuilder();
            outputSb.append(" output ");
            for (int i = 0; i < returningColumns.length; ++i) {
                if (i != 0) {
                    outputSb.append(',');
                }
                if (statementType == DbmsStatementType.DELETE) {
                    outputSb.append("deleted.");
                } else {
                    outputSb.append("inserted.");
                }
                outputSb.append(returningColumns[i]);
            }
            if (statementType == DbmsStatementType.DELETE || statementType == DbmsStatementType.UPDATE) {
                int whereIndex = SqlUtils.indexOfWhere(sqlSb);
                if (whereIndex == -1) {
                    sqlSb.append((CharSequence)outputSb);
                } else {
                    sqlSb.insert(whereIndex, outputSb);
                }
            } else if (statementType == DbmsStatementType.INSERT) {
                int selectIndex = SqlUtils.indexOfSelect(sqlSb);
                sqlSb.insert(selectIndex - 1, outputSb);
            }
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (addParenthesis) {
            sqlSb.append(')');
        }
        return null;
    }

    @Override
    protected boolean needsAliasForFromClause() {
        return true;
    }

    @Override
    protected boolean needsAliasInSetOrderBy() {
        return true;
    }

    @Override
    public void appendOrderByElement(StringBuilder sqlSb, OrderByElement element, String[] aliases) {
        if (!element.isNullable() || element.isAscending() && element.isNullsFirst() || !element.isAscending() && !element.isNullsFirst()) {
            if (aliases != null) {
                sqlSb.append(aliases[element.getPosition() - 1]);
            } else {
                sqlSb.append(element.getPosition());
            }
            if (element.isAscending()) {
                sqlSb.append(" asc");
            } else {
                sqlSb.append(" desc");
            }
        } else {
            this.appendEmulatedOrderByElementWithNulls(sqlSb, element, aliases);
        }
    }

    @Override
    public DbmsLimitHandler createLimitHandler() {
        return new MSSQL2012DbmsLimitHandler();
    }
}

