/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.dialect;

import com.blazebit.persistence.impl.dialect.MySQLDbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.LateralStyle;
import java.util.Map;

public class MySQL8DbmsDialect
extends MySQLDbmsDialect {
    public MySQL8DbmsDialect() {
    }

    public MySQL8DbmsDialect(Map<Class<?>, String> childSqlTypes) {
        super(childSqlTypes);
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsWithClause() {
        return true;
    }

    @Override
    public boolean supportsNonRecursiveWithClause() {
        return true;
    }

    @Override
    public LateralStyle getLateralStyle() {
        return LateralStyle.LATERAL;
    }

    @Override
    public String getWithClause(boolean recursive) {
        if (recursive) {
            return "with recursive";
        }
        return "with";
    }

    @Override
    public Map<String, String> appendExtendedSql(StringBuilder sqlSb, DbmsStatementType statementType, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String limit, String offset, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        boolean addParenthesis;
        boolean bl = addParenthesis = isSubquery && sqlSb.length() > 0 && sqlSb.charAt(0) != '(';
        if (addParenthesis) {
            sqlSb.insert(0, '(');
        }
        if (withClause != null) {
            if (statementType == DbmsStatementType.INSERT) {
                sqlSb.insert(MySQL8DbmsDialect.indexOfIgnoreCase(sqlSb, "select"), withClause);
            } else {
                sqlSb.insert(0, withClause);
            }
        }
        if (limit != null) {
            this.appendLimit(sqlSb, isSubquery, limit, offset);
        }
        if (isSubquery && !this.supportsModificationQueryInWithClause() && returningColumns != null) {
            throw new IllegalArgumentException("Returning columns in a subquery is not possible for this dbms!");
        }
        if (addParenthesis) {
            sqlSb.append(')');
        }
        return null;
    }
}

