/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.rowvalue;

import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiFirstPatternFinder;
import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiLastPatternFinder;
import com.blazebit.persistence.impl.util.PatternFinder;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RowValueComparisonFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "compare_row_value";
    private static final String AND = " and ";
    private static final String THEN = " then ";
    private static final PatternFinder AND_FINDER = new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" and ");
    private static final PatternFinder THEN_FINDER = new BoyerMooreCaseInsensitiveAsciiLastPatternFinder(" then ");
    private static final Pattern NULLIF_PREFIX_SPLIT_PATTERN = Pattern.compile("\\s*nullif\\(1,\\s*1\\)\\s*=\\s*", 2);
    private static final Pattern NULLIF_SUFFIX_SPLIT_PATTERN = Pattern.compile("\\s*=\\s*nullif\\(1,\\s*1\\)\\s*", 2);
    private static final Pattern PARAM_PREFIX_SPLIT_PATTERN = Pattern.compile("\\s*\\?\\s*=\\s*", 2);
    private static final Pattern PARAM_SUFFIX_SPLIT_PATTERN = Pattern.compile("\\s*=\\s*\\?\\s*", 2);
    private static final Pattern NULLIF_PATTERN = Pattern.compile("nullif\\(1,\\s*1\\)", 2);

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return Boolean.TYPE;
    }

    public void render(FunctionRenderContext context) {
        int i;
        int lastNullIndex;
        String operator = context.getArgument(0);
        operator = operator.substring(1, operator.length() - 1);
        context.addChunk(this.getLeftmostChunk());
        ArrayList<String> elements = new ArrayList<String>(context.getArgumentsSize() - 1);
        for (int argIdx = 1; argIdx < context.getArgumentsSize(); ++argIdx) {
            Matcher matcher;
            char c;
            char c2;
            String caseWhenExpression = context.getArgument(argIdx);
            int firstIndex = AND_FINDER.indexIn(caseWhenExpression) + AND.length() - 1;
            while (Character.isWhitespace(c2 = caseWhenExpression.charAt(firstIndex))) {
                ++firstIndex;
            }
            int lastIndex = THEN_FINDER.indexIn(caseWhenExpression);
            while (Character.isWhitespace(c = caseWhenExpression.charAt(lastIndex))) {
                --lastIndex;
            }
            String predicate = caseWhenExpression.substring(firstIndex, ++lastIndex);
            if (predicate.length() > 2 && predicate.charAt(0) == '(' && predicate.charAt(predicate.length() - 1) == ')' && predicate.charAt(predicate.length() - 2) == ')') {
                predicate = predicate.substring(1, predicate.length() - 2);
            }
            if ((matcher = NULLIF_PREFIX_SPLIT_PATTERN.matcher(predicate)).find()) {
                elements.add("nullif(1, 1)");
                elements.add(predicate.substring(matcher.end()));
                continue;
            }
            matcher = NULLIF_SUFFIX_SPLIT_PATTERN.matcher(predicate);
            if (matcher.find()) {
                elements.add(predicate.substring(0, matcher.start()));
                elements.add("nullif(1, 1)");
                continue;
            }
            matcher = PARAM_PREFIX_SPLIT_PATTERN.matcher(predicate);
            if (matcher.find()) {
                elements.add("?");
                elements.add(predicate.substring(matcher.end()));
                continue;
            }
            matcher = PARAM_SUFFIX_SPLIT_PATTERN.matcher(predicate);
            if (matcher.find()) {
                elements.add(predicate.substring(0, matcher.start()));
                elements.add("?");
                continue;
            }
            elements.add(predicate);
        }
        String[] parts = elements.toArray(new String[elements.size()]);
        for (int i2 = lastNullIndex = parts.length - 1; i2 >= 0; i2 -= 2) {
            if (!"nullif(".regionMatches(true, 0, parts[i2], 0, "nullif(".length()) || !NULLIF_PATTERN.matcher(parts[i2]).matches()) continue;
            parts[i2 - 1] = parts[lastNullIndex - 1];
            parts[i2] = parts[lastNullIndex];
            lastNullIndex -= 2;
        }
        int rowValueArity = (lastNullIndex + 1) / 2;
        int end = rowValueArity * 2;
        context.addChunk(parts[0]);
        for (i = 2; i < end; i += 2) {
            context.addChunk(", ");
            context.addChunk(parts[i]);
        }
        context.addChunk(") " + operator + " (");
        context.addChunk(parts[1]);
        for (i = 3; i < end; i += 2) {
            context.addChunk(", ");
            context.addChunk(parts[i]);
        }
        context.addChunk(this.getRightmostChunk());
    }

    protected String getLeftmostChunk() {
        return "((";
    }

    protected String getRightmostChunk() {
        return "))";
    }
}

