/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.window;

import com.blazebit.persistence.impl.function.Order;
import com.blazebit.persistence.parser.expression.WindowFrameExclusionType;
import com.blazebit.persistence.parser.expression.WindowFrameMode;
import com.blazebit.persistence.parser.expression.WindowFramePositionType;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractWindowFunction
implements JpqlFunction {
    protected final String functionName;
    protected final boolean nullIsSmallest;
    protected final boolean supportsNullPrecedence;
    protected final boolean supportsFilterClause;
    protected final boolean allowsFilterClause;

    protected AbstractWindowFunction(String functionName, boolean nullIsSmallest, boolean supportsNullPrecedence, boolean supportsFilterClause, boolean allowsFilterClause) {
        this.functionName = functionName;
        this.nullIsSmallest = nullIsSmallest;
        this.supportsNullPrecedence = supportsNullPrecedence;
        this.supportsFilterClause = supportsFilterClause;
        this.allowsFilterClause = allowsFilterClause;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return firstArgumentType;
    }

    public final void render(FunctionRenderContext context) {
        WindowFunction windowFunction = this.getWindowFunction(context);
        this.render(context, windowFunction);
    }

    protected WindowFunction getWindowFunction(FunctionRenderContext context) {
        return this.getWindowFunction(context, new WindowFunction(this.functionName), 0);
    }

    protected <T extends WindowFunction> T getWindowFunction(FunctionRenderContext context, T function, int startIndex) {
        T windowFunction = function;
        Mode mode = Mode.ARGUMENTS;
        Enum<?> argumentMode = null;
        Boolean startFrame = null;
        block41: for (int parameterIndex = startIndex; parameterIndex < context.getArgumentsSize(); ++parameterIndex) {
            String argument = context.getArgument(parameterIndex);
            switch (argument.toUpperCase()) {
                case "'FILTER'": {
                    if (!this.allowsFilterClause) {
                        throw new IllegalArgumentException("FILTER clause is disallowed for function: " + this.functionName);
                    }
                    mode = Mode.FILTER;
                    continue block41;
                }
                case "'PARTITION BY'": {
                    mode = Mode.PARTITION_BY;
                    continue block41;
                }
                case "'ORDER BY'": {
                    mode = Mode.ORDER_BY;
                    continue block41;
                }
                case "'RANGE'": {
                    mode = Mode.FRAME_CLAUSE;
                    ((WindowFunction)windowFunction).frameMode = WindowFrameMode.RANGE;
                    startFrame = true;
                    continue block41;
                }
                case "'ROWS'": {
                    mode = Mode.FRAME_CLAUSE;
                    ((WindowFunction)windowFunction).frameMode = WindowFrameMode.ROWS;
                    startFrame = true;
                    continue block41;
                }
                case "'GROUPS'": {
                    mode = Mode.FRAME_CLAUSE;
                    ((WindowFunction)windowFunction).frameMode = WindowFrameMode.GROUPS;
                    startFrame = true;
                    continue block41;
                }
                default: {
                    switch (mode) {
                        case ARGUMENTS: {
                            argumentMode = this.processArgument(argumentMode, windowFunction, argument);
                            continue block41;
                        }
                        case FILTER: {
                            ((WindowFunction)windowFunction).filterExpressions.add(argument);
                            continue block41;
                        }
                        case PARTITION_BY: {
                            ((WindowFunction)windowFunction).partitionExpressions.add(argument);
                            continue block41;
                        }
                        case ORDER_BY: {
                            String sortOrder;
                            Order order = null;
                            if (context.getArgumentsSize() > parameterIndex + 1 && (order = AbstractWindowFunction.getOrder(sortOrder = context.getArgument(parameterIndex + 1), argument)) != null) {
                                ++parameterIndex;
                            }
                            if (order == null) {
                                order = new Order(argument, null, null);
                            }
                            ((WindowFunction)windowFunction).orderBys.add(order);
                            continue block41;
                        }
                        case FRAME_CLAUSE: {
                            if (startFrame == null) {
                                throw new IllegalArgumentException("Illegal frame clause, expected to see 'RANGE' first.");
                            }
                            switch (argument) {
                                case "'BETWEEN'": {
                                    startFrame = true;
                                    continue block41;
                                }
                                case "'AND'": {
                                    startFrame = false;
                                    continue block41;
                                }
                                case "'UNBOUNDED PRECEDING'": {
                                    if (startFrame.booleanValue()) {
                                        ((WindowFunction)windowFunction).frameStartType = WindowFramePositionType.UNBOUNDED_PRECEDING;
                                        continue block41;
                                    }
                                    throw new IllegalArgumentException("Illegal frame clause! The end frame type can't be UNBOUNDED_PRECEDING");
                                }
                                case "'PRECEDING'": {
                                    if (startFrame.booleanValue()) {
                                        ((WindowFunction)windowFunction).frameStartType = WindowFramePositionType.BOUNDED_PRECEDING;
                                        continue block41;
                                    }
                                    ((WindowFunction)windowFunction).frameEndType = WindowFramePositionType.BOUNDED_PRECEDING;
                                    continue block41;
                                }
                                case "'CURRENT ROW'": {
                                    if (startFrame.booleanValue()) {
                                        ((WindowFunction)windowFunction).frameStartType = WindowFramePositionType.CURRENT_ROW;
                                        continue block41;
                                    }
                                    ((WindowFunction)windowFunction).frameEndType = WindowFramePositionType.CURRENT_ROW;
                                    continue block41;
                                }
                                case "'FOLLOWING'": {
                                    if (startFrame.booleanValue()) {
                                        ((WindowFunction)windowFunction).frameStartType = WindowFramePositionType.BOUNDED_FOLLOWING;
                                        continue block41;
                                    }
                                    ((WindowFunction)windowFunction).frameEndType = WindowFramePositionType.BOUNDED_FOLLOWING;
                                    continue block41;
                                }
                                case "'UNBOUNDED FOLLOWING'": {
                                    if (startFrame.booleanValue()) {
                                        throw new IllegalArgumentException("Illegal frame clause! The start frame type can't be UNBOUNDED_FOLLOWING");
                                    }
                                    ((WindowFunction)windowFunction).frameEndType = WindowFramePositionType.UNBOUNDED_FOLLOWING;
                                    continue block41;
                                }
                            }
                            if (startFrame.booleanValue()) {
                                ((WindowFunction)windowFunction).frameStartExpression = argument;
                                continue block41;
                            }
                            ((WindowFunction)windowFunction).frameEndExpression = argument;
                            continue block41;
                        }
                    }
                    throw new IllegalArgumentException("No branch for " + (Object)((Object)mode));
                }
            }
        }
        return function;
    }

    protected Enum<?> processArgument(Enum<?> mode, WindowFunction windowFunction, String argument) {
        windowFunction.arguments.add(argument);
        return null;
    }

    private static Order getOrder(String sort, String expression) {
        String type = sort.trim().toUpperCase();
        if ("'ASC'".equals(type)) {
            return new Order(expression, true, null);
        }
        if ("'DESC'".equals(type)) {
            return new Order(expression, false, null);
        }
        if ("'ASC NULLS FIRST'".equals(type)) {
            return new Order(expression, true, true);
        }
        if ("'ASC NULLS LAST'".equals(type)) {
            return new Order(expression, true, false);
        }
        if ("'DESC NULLS FIRST'".equals(type)) {
            return new Order(expression, false, true);
        }
        if ("'DESC NULLS LAST'".equals(type)) {
            return new Order(expression, false, false);
        }
        return null;
    }

    protected void render(FunctionRenderContext context, WindowFunction windowFunction) {
        this.renderFunction(context, windowFunction);
        this.renderFilterExpressions(context, windowFunction.getFilterExpressions());
        context.addChunk(" OVER (");
        this.renderPartitions(context, windowFunction.getPartitionExpressions());
        if (!windowFunction.getOrderBys().isEmpty() && !windowFunction.getPartitionExpressions().isEmpty()) {
            context.addChunk(" ");
        }
        this.renderOrderBy(context, windowFunction.getOrderBys());
        if (!(windowFunction.getFrameMode() == null || windowFunction.getOrderBys().isEmpty() && windowFunction.getPartitionExpressions().isEmpty())) {
            context.addChunk(" ");
        }
        this.renderFrame(context, windowFunction);
        context.addChunk(")");
    }

    protected void renderFunction(FunctionRenderContext context, WindowFunction windowFunction) {
        context.addChunk(windowFunction.getFunctionName());
        context.addChunk("(");
        this.renderArguments(context, windowFunction);
        context.addChunk(")");
    }

    protected void renderArguments(FunctionRenderContext context, WindowFunction windowFunction) {
        block4: {
            List<String> arguments = windowFunction.getArguments();
            int size = arguments.size();
            if (size == 0) break block4;
            List<String> filterExpressions = windowFunction.getFilterExpressions();
            int filtersSize = filterExpressions.size();
            if (this.supportsFilterClause || filtersSize == 0) {
                this.renderArgument(context, windowFunction, null, null, arguments.get(0), 0);
                for (int i = 1; i < size; ++i) {
                    context.addChunk(", ");
                    this.renderArgument(context, windowFunction, null, null, arguments.get(i), i);
                }
            } else {
                String caseWhenPre = AbstractWindowFunction.getCaseWhenPre(filterExpressions);
                String caseWhenPost = AbstractWindowFunction.getCaseWhenPost();
                this.renderArgument(context, windowFunction, caseWhenPre, caseWhenPost, arguments.get(0), 0);
                for (int i = 1; i < size; ++i) {
                    context.addChunk(", ");
                    this.renderArgument(context, windowFunction, caseWhenPre, caseWhenPost, arguments.get(i), i);
                }
            }
        }
    }

    protected static String getCaseWhenPre(List<String> filterExpressions) {
        int size = filterExpressions.size();
        StringBuilder sb = new StringBuilder();
        sb.append("CASE WHEN ");
        sb.append(filterExpressions.get(0));
        for (int i = 1; i < size; ++i) {
            sb.append(" AND ");
            sb.append(filterExpressions.get(i));
        }
        sb.append(" THEN ");
        return sb.toString();
    }

    protected static String getCaseWhenPost() {
        return " ELSE NULL END";
    }

    protected void renderArgument(FunctionRenderContext context, WindowFunction windowFunction, String caseWhenPre, String caseWhenPost, String argument, int argumentIndex) {
        if (caseWhenPre == null || argumentIndex != 0) {
            context.addChunk(argument);
        } else {
            context.addChunk(caseWhenPre);
            context.addChunk(argument);
            context.addChunk(caseWhenPost);
        }
    }

    protected void renderFilterExpressions(FunctionRenderContext context, List<String> filterExpressions) {
        int size = filterExpressions.size();
        if (size != 0 && this.supportsFilterClause) {
            context.addChunk(" FILTER ( WHERE ");
            context.addChunk(filterExpressions.get(0));
            for (int i = 1; i < size; ++i) {
                context.addChunk(" AND ");
                context.addChunk(filterExpressions.get(i));
            }
            context.addChunk(")");
        }
    }

    protected void renderPartitions(FunctionRenderContext context, List<String> partitionExpressions) {
        int size = partitionExpressions.size();
        if (size != 0) {
            context.addChunk("PARTITION BY ");
            context.addChunk(partitionExpressions.get(0));
            for (int i = 1; i < size; ++i) {
                context.addChunk(", ");
                context.addChunk(partitionExpressions.get(i));
            }
        }
    }

    protected void renderOrderBy(FunctionRenderContext context, List<Order> orderBys) {
        int size = orderBys.size();
        if (size != 0) {
            context.addChunk("ORDER BY ");
            this.renderOrder(context, orderBys.get(0));
            for (int i = 1; i < size; ++i) {
                context.addChunk(", ");
                this.renderOrder(context, orderBys.get(i));
            }
        }
    }

    protected void renderOrder(FunctionRenderContext context, Order order) {
        if (this.supportsNullPrecedence) {
            context.addChunk(order.getExpression());
            context.addChunk(" ");
            context.addChunk(order.isAscending() ? "ASC " : "DESC ");
            context.addChunk(order.isNullsFirst() ? "NULLS FIRST" : "NULLS LAST");
        } else {
            this.appendEmulatedOrderByElementWithNulls(context, order);
        }
    }

    protected void renderFrame(FunctionRenderContext context, WindowFunction windowFunction) {
        if (windowFunction.getFrameMode() != null) {
            context.addChunk(windowFunction.getFrameMode().toString());
            context.addChunk(" ");
            if (windowFunction.getFrameEndType() == null) {
                this.renderFramePosition(context, windowFunction.getFrameStartType(), windowFunction.getFrameStartExpression());
            } else {
                context.addChunk("BETWEEN ");
                this.renderFramePosition(context, windowFunction.getFrameStartType(), windowFunction.getFrameStartExpression());
                context.addChunk("AND ");
                this.renderFramePosition(context, windowFunction.getFrameEndType(), windowFunction.getFrameEndExpression());
            }
            if (windowFunction.getFrameExclusionType() != null) {
                switch (windowFunction.getFrameExclusionType()) {
                    case EXCLUDE_CURRENT_ROW: {
                        context.addChunk("EXCLUDE CURRENT ROW");
                        break;
                    }
                    case EXCLUDE_GROUP: {
                        context.addChunk("EXCLUDE GROUP");
                        break;
                    }
                    case EXCLUDE_NO_OTHERS: {
                        context.addChunk("EXCLUDE NO OTHERS");
                        break;
                    }
                    case EXCLUDE_TIES: {
                        context.addChunk("EXCLUDE TIES");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No branch for " + windowFunction.getFrameExclusionType());
                    }
                }
            }
        }
    }

    protected void renderFramePosition(FunctionRenderContext context, WindowFramePositionType type, String frameExpression) {
        switch (type) {
            case UNBOUNDED_PRECEDING: {
                context.addChunk("UNBOUNDED PRECEDING");
                break;
            }
            case BOUNDED_PRECEDING: {
                context.addChunk(frameExpression);
                context.addChunk(" PRECEDING");
                break;
            }
            case CURRENT_ROW: {
                context.addChunk("CURRENT ROW");
                break;
            }
            case UNBOUNDED_FOLLOWING: {
                context.addChunk("UNBOUNDED FOLLOWING");
                break;
            }
            case BOUNDED_FOLLOWING: {
                context.addChunk(frameExpression);
                context.addChunk(" FOLLOWING");
                break;
            }
            default: {
                throw new IllegalArgumentException("No branch for " + type);
            }
        }
        context.addChunk(" ");
    }

    protected boolean optimizeNullPrecedence() {
        return true;
    }

    protected void appendEmulatedOrderByElementWithNulls(FunctionRenderContext context, Order element) {
        boolean optimizeNullPrecedence = this.optimizeNullPrecedence();
        if (!(optimizeNullPrecedence && this.nullIsSmallest && element.isAscending() == element.isNullsFirst() || optimizeNullPrecedence && !this.nullIsSmallest && element.isAscending() != element.isNullsFirst())) {
            if (element.isNullsFirst()) {
                context.addChunk("case when ");
                context.addChunk(element.getExpression());
                context.addChunk(" is null then 0 else 1 end, ");
            } else {
                context.addChunk("case when ");
                context.addChunk(element.getExpression());
                context.addChunk(" is null then 1 else 0 end, ");
            }
        }
        context.addChunk(element.getExpression());
        context.addChunk(element.isAscending() ? " asc" : " desc");
    }

    protected static class WindowFunction {
        private final String functionName;
        private final List<String> arguments = new ArrayList<String>();
        private final List<String> filterExpressions = new ArrayList<String>();
        private final List<String> partitionExpressions = new ArrayList<String>();
        private final List<Order> orderBys = new ArrayList<Order>();
        private WindowFrameMode frameMode;
        private WindowFramePositionType frameStartType;
        private String frameStartExpression;
        private WindowFramePositionType frameEndType;
        private String frameEndExpression;
        private WindowFrameExclusionType frameExclusionType;

        public WindowFunction(String functionName) {
            this.functionName = functionName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public List<String> getArguments() {
            return this.arguments;
        }

        public List<String> getFilterExpressions() {
            return this.filterExpressions;
        }

        public List<String> getPartitionExpressions() {
            return this.partitionExpressions;
        }

        public List<Order> getOrderBys() {
            return this.orderBys;
        }

        public WindowFrameMode getFrameMode() {
            return this.frameMode;
        }

        public void setFrameMode(WindowFrameMode frameMode) {
            this.frameMode = frameMode;
        }

        public WindowFramePositionType getFrameStartType() {
            return this.frameStartType;
        }

        public void setFrameStartType(WindowFramePositionType frameStartType) {
            this.frameStartType = frameStartType;
        }

        public String getFrameStartExpression() {
            return this.frameStartExpression;
        }

        public void setFrameStartExpression(String frameStartExpression) {
            this.frameStartExpression = frameStartExpression;
        }

        public WindowFramePositionType getFrameEndType() {
            return this.frameEndType;
        }

        public void setFrameEndType(WindowFramePositionType frameEndType) {
            this.frameEndType = frameEndType;
        }

        public String getFrameEndExpression() {
            return this.frameEndExpression;
        }

        public void setFrameEndExpression(String frameEndExpression) {
            this.frameEndExpression = frameEndExpression;
        }

        public WindowFrameExclusionType getFrameExclusionType() {
            return this.frameExclusionType;
        }

        public void setFrameExclusionType(WindowFrameExclusionType frameExclusionType) {
            this.frameExclusionType = frameExclusionType;
        }
    }

    private static enum Mode {
        ARGUMENTS,
        FILTER,
        PARTITION_BY,
        ORDER_BY,
        FRAME_CLAUSE;

    }
}

