/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.window.count;

import com.blazebit.persistence.impl.function.window.AbstractWindowFunction;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.List;

public class CountFunction
extends AbstractWindowFunction {
    public static final String FUNCTION_NAME = "WINDOW_COUNT";

    public CountFunction(DbmsDialect dbmsDialect) {
        super("COUNT", dbmsDialect.isNullSmallest(), dbmsDialect.supportsWindowNullPrecedence(), dbmsDialect.supportsFilterClause(), true);
    }

    @Override
    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return Long.class;
    }

    @Override
    protected void renderArguments(FunctionRenderContext context, AbstractWindowFunction.WindowFunction windowFunction) {
        if (windowFunction.getArguments().isEmpty()) {
            List<String> filterExpressions = windowFunction.getFilterExpressions();
            if (filterExpressions.isEmpty()) {
                context.addChunk("*");
            } else {
                String caseWhenPre = CountFunction.getCaseWhenPre(filterExpressions);
                String caseWhenPost = CountFunction.getCaseWhenPost();
                context.addChunk(caseWhenPre);
                context.addChunk("1");
                context.addChunk(caseWhenPost);
            }
        } else {
            super.renderArguments(context, windowFunction);
        }
    }
}

