/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.ModificationQuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsModificationState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class CollectionInsertModificationQuerySpecification<T>
extends ModificationQuerySpecification<T> {
    private final Query insertExampleQuery;
    private final String insertSql;
    private final int cutoffColumns;

    public CollectionInsertModificationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Query exampleQuery, Set<Parameter<?>> parameters, Set<String> parameterListNames, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes, boolean isEmbedded, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates, Map<String, String> returningAttributeBindingMap, Query insertExampleQuery, String insertSql, int cutoffColumns) {
        super(commonQueryBuilder, baseQuery, exampleQuery, parameters, parameterListNames, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes, isEmbedded, returningColumns, includedModificationStates, returningAttributeBindingMap);
        this.insertExampleQuery = insertExampleQuery;
        this.insertSql = insertSql;
        this.cutoffColumns = cutoffColumns;
    }

    @Override
    protected void initialize() {
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        for (Map.Entry entry : this.listParameters.entrySet()) {
            this.baseQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        String sql = this.extendedQuerySupport.getSql(this.em, this.baseQuery);
        StringBuilder sqlSb = this.applySqlTransformations(sql);
        if (this.cutoffColumns > 0) {
            final ArrayList tableAliasesToRemove = new ArrayList();
            String[] selectItemPositions = SqlUtils.getSelectItems(sqlSb, 0, new SqlUtils.SelectItemExtractor(){

                @Override
                public String extract(StringBuilder sb, int index, int currentPosition) {
                    int dotIndex = sb.indexOf(".");
                    if (dotIndex == -1) {
                        tableAliasesToRemove.add("");
                    } else {
                        tableAliasesToRemove.add(sb.substring(0, dotIndex).trim());
                    }
                    return Integer.toString(currentPosition);
                }
            });
            int removeStart = Integer.parseInt(selectItemPositions[selectItemPositions.length - (this.cutoffColumns + 1)]);
            int removeEnd = Integer.parseInt(selectItemPositions[selectItemPositions.length - 1]);
            sqlSb.replace(removeStart, removeEnd, "");
            int whereIndex = SqlUtils.indexOfWhere(sqlSb);
            HashSet<String> processedAliases = new HashSet<String>();
            for (int i = tableAliasesToRemove.size() - this.cutoffColumns; i < tableAliasesToRemove.size(); ++i) {
                String aliasOnPart;
                int aliasIndex;
                String tableAlias = (String)tableAliasesToRemove.get(i);
                if (!processedAliases.add(tableAlias) || (aliasIndex = sqlSb.indexOf(aliasOnPart = " " + tableAlias + " on ", removeStart)) <= -1 || aliasIndex >= whereIndex) continue;
                int onClauseStart = aliasIndex + aliasOnPart.length();
                int onClauseEnd = SqlUtils.findEndOfOnClause(sqlSb, onClauseStart, whereIndex);
                int joinStartIndex = SqlUtils.findJoinStartIndex(sqlSb, aliasIndex);
                sqlSb.replace(joinStartIndex, onClauseEnd, "");
                whereIndex -= onClauseEnd - joinStartIndex;
            }
        }
        sqlSb.insert(0, this.insertSql);
        sqlSb.insert(this.insertSql.length(), ' ');
        StringBuilder withClause = this.applyCtes(sqlSb, this.baseQuery, participatingQueries);
        Map<String, String> addedCtes = this.applyExtendedSql(sqlSb, false, this.isEmbedded, withClause, this.returningColumns, this.includedModificationStates);
        participatingQueries.add(this.baseQuery);
        boolean hasCtes = withClause != null && withClause.length() != 0 || addedCtes != null && !addedCtes.isEmpty();
        this.query = hasCtes && this.returningAttributeBindingMap.isEmpty() && !this.dbmsDialect.usesExecuteUpdateWhenWithClauseInModificationQuery() ? this.exampleQuery : this.insertExampleQuery;
        this.sql = sqlSb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }
}

