/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.function.entity.EntityFunction;
import com.blazebit.persistence.impl.plan.CustomSelectQueryPlan;
import com.blazebit.persistence.impl.plan.ModificationQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.impl.query.QuerySpecification;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.spi.DbmsDialect;
import com.blazebit.persistence.spi.DbmsModificationState;
import com.blazebit.persistence.spi.DbmsStatementType;
import com.blazebit.persistence.spi.ExtendedQuerySupport;
import com.blazebit.persistence.spi.LateralStyle;
import com.blazebit.persistence.spi.ServiceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class CustomQuerySpecification<T>
implements QuerySpecification<T> {
    protected final EntityManager em;
    protected final DbmsDialect dbmsDialect;
    protected final ServiceProvider serviceProvider;
    protected final ExtendedQuerySupport extendedQuerySupport;
    protected final DbmsStatementType statementType;
    protected final Query baseQuery;
    protected final Set<Parameter<?>> parameters;
    protected final Map<String, Collection<?>> listParameters;
    protected final String limit;
    protected final String offset;
    protected final List<String> keyRestrictedLeftJoinAliases;
    protected final List<EntityFunctionNode> entityFunctionNodes;
    protected final boolean recursive;
    protected final List<CTENode> ctes;
    protected final boolean shouldRenderCtes;
    protected boolean dirty;
    protected String sql;
    protected List<Query> participatingQueries;
    protected Map<String, String> addedCtes;

    public CustomQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query baseQuery, Set<Parameter<?>> parameters, Set<String> listParameters, String limit, String offset, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCtes) {
        this.em = commonQueryBuilder.getEntityManager();
        this.dbmsDialect = commonQueryBuilder.getService(DbmsDialect.class);
        this.serviceProvider = commonQueryBuilder;
        this.extendedQuerySupport = commonQueryBuilder.getService(ExtendedQuerySupport.class);
        this.statementType = commonQueryBuilder.getStatementType();
        this.baseQuery = baseQuery;
        this.parameters = parameters;
        this.listParameters = new HashMap();
        this.limit = limit;
        this.offset = offset;
        for (String listParameter : listParameters) {
            this.listParameters.put(listParameter, Collections.emptyList());
        }
        this.keyRestrictedLeftJoinAliases = keyRestrictedLeftJoinAliases;
        this.entityFunctionNodes = entityFunctionNodes;
        this.recursive = recursive;
        this.ctes = ctes;
        this.shouldRenderCtes = shouldRenderCtes;
        this.dirty = true;
    }

    @Override
    public ModificationQueryPlan createModificationPlan(int firstResult, int maxResults) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SelectQueryPlan<T> createSelectPlan(int firstResult, int maxResults) {
        String sql = this.getSql();
        return new CustomSelectQueryPlan(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.participatingQueries, sql, firstResult, maxResults);
    }

    @Override
    public String getSql() {
        if (this.dirty) {
            this.initialize();
        }
        return this.sql;
    }

    @Override
    public List<Query> getParticipatingQueries() {
        if (this.dirty) {
            this.initialize();
        }
        return this.participatingQueries;
    }

    @Override
    public Set<Parameter<?>> getParameters() {
        return this.parameters;
    }

    @Override
    public Map<String, String> getAddedCtes() {
        if (this.dirty) {
            this.initialize();
        }
        return this.addedCtes;
    }

    @Override
    public Query getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    public void onCollectionParameterChange(String parameterName, Collection<?> value) {
        Collection<?> listParameterValue = this.listParameters.get(parameterName);
        if (listParameterValue != null && listParameterValue.size() != value.size()) {
            this.dirty = true;
            this.listParameters.put(parameterName, value);
        }
    }

    protected void initialize() {
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        for (Map.Entry<String, Collection<?>> entry : this.listParameters.entrySet()) {
            this.baseQuery.setParameter(entry.getKey(), entry.getValue());
        }
        String sqlQuery = this.extendedQuerySupport.getSql(this.em, this.baseQuery);
        StringBuilder sqlSb = this.applySqlTransformations(sqlQuery);
        StringBuilder withClause = this.applyCtes(sqlSb, this.baseQuery, participatingQueries);
        Map<String, String> addedCtes = this.applyExtendedSql(sqlSb, false, false, withClause, null, null);
        participatingQueries.add(this.baseQuery);
        this.sql = sqlSb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }

    protected Map<String, String> applyExtendedSql(StringBuilder sqlSb, boolean isSubquery, boolean isEmbedded, StringBuilder withClause, String[] returningColumns, Map<DbmsModificationState, String> includedModificationStates) {
        return this.dbmsDialect.appendExtendedSql(sqlSb, this.statementType, isSubquery, isEmbedded, withClause, this.limit, this.offset, returningColumns, includedModificationStates);
    }

    protected StringBuilder applyCtes(StringBuilder sqlSb, Query baseQuery, List<Query> participatingQueries) {
        if (!this.shouldRenderCtes || this.ctes.isEmpty() && (this.statementType != DbmsStatementType.DELETE || !this.dbmsDialect.supportsModificationQueryInWithClause())) {
            return null;
        }
        LinkedHashMap<String, String> tableNameRemapping = new LinkedHashMap<String, String>(0);
        StringBuilder sb = new StringBuilder(this.ctes.size() * 100);
        sb.append(this.dbmsDialect.getWithClause(this.recursive));
        sb.append(" ");
        boolean firstCte = true;
        for (CTENode cTENode : this.ctes) {
            QuerySpecification nonRecursiveQuerySpecification = cTENode.getNonRecursiveQuerySpecification();
            Query nonRecursiveQuery = nonRecursiveQuerySpecification.getBaseQuery();
            participatingQueries.addAll(nonRecursiveQuerySpecification.getParticipatingQueries());
            QuerySpecification recursiveQuerySpecification = null;
            if (cTENode.isRecursive()) {
                recursiveQuerySpecification = cTENode.getRecursiveQuerySpecification();
                participatingQueries.addAll(recursiveQuerySpecification.getParticipatingQueries());
            }
            if (this.dbmsDialect.supportsModificationQueryInWithClause()) {
                firstCte = this.applyCascadingDelete(nonRecursiveQuery, participatingQueries, sb, cTENode.getName(), firstCte);
            }
            firstCte = this.applyAddedCtes(nonRecursiveQuerySpecification, cTENode.getNonRecursiveTableNameRemappings(), sb, tableNameRemapping, firstCte);
            firstCte = this.applyAddedCtes(recursiveQuerySpecification, cTENode.getRecursiveTableNameRemappings(), sb, tableNameRemapping, firstCte);
            if (firstCte) {
                firstCte = false;
            } else {
                sb.append(", ");
            }
            sb.append(cTENode.getHead());
            sb.append(" AS( ");
            final String sql = cTENode.getNonRecursiveQuerySpecification().getSql();
            if (cTENode.getAliases() != null) {
                final String[] newAliases = cTENode.getAliases();
                final StringBuilder newSqlSb = new StringBuilder(sql.length());
                String[] endPositions = SqlUtils.getSelectItems(sql, 0, new SqlUtils.SelectItemExtractor(){

                    @Override
                    public String extract(StringBuilder sb, int index, int currentPosition) {
                        if (index == 0) {
                            newSqlSb.append(sql, 0, currentPosition - sb.length());
                        } else {
                            newSqlSb.append(',');
                        }
                        String originalAlias = SqlUtils.extractAlias(sb);
                        int aliasPosition = sb.length() - originalAlias.length() - 1;
                        if (aliasPosition != -1 && sb.charAt(aliasPosition) == ' ') {
                            newSqlSb.append(sb, 0, aliasPosition + 1);
                        } else {
                            newSqlSb.append((CharSequence)sb);
                            newSqlSb.append(" as ");
                        }
                        newSqlSb.append(newAliases[index]);
                        return Integer.toString(currentPosition);
                    }
                });
                newSqlSb.append(sql, (int)Integer.valueOf(endPositions[endPositions.length - 1]), sql.length());
                sb.append((CharSequence)newSqlSb);
            } else {
                sb.append(sql);
            }
            if (cTENode.isRecursive()) {
                if (cTENode.isUnionAll()) {
                    sb.append(" UNION ALL ");
                } else {
                    sb.append(" UNION ");
                }
                sb.append(cTENode.getRecursiveQuerySpecification().getSql());
            } else if (!this.dbmsDialect.supportsNonRecursiveWithClause()) {
                sb.append(cTENode.getNonRecursiveWithClauseSuffix());
            }
            sb.append(" )");
        }
        if (this.dbmsDialect.supportsModificationQueryInWithClause()) {
            firstCte = this.applyCascadingDelete(baseQuery, participatingQueries, sb, "main_query", firstCte);
        }
        if (firstCte) {
            return null;
        }
        for (CTENode cTENode : this.ctes) {
            String cteName = cTENode.getEntityName();
            String subselect = "( select * from " + cteName + " )";
            this.replaceWithCteName(sb, subselect, cteName);
            this.replaceWithCteName(sqlSb, subselect, cteName);
        }
        sb.append(" ");
        for (Map.Entry entry : tableNameRemapping.entrySet()) {
            String sqlAlias = this.extendedQuerySupport.getSqlAlias(this.em, baseQuery, (String)entry.getKey());
            String newCteName = (String)entry.getValue();
            SqlUtils.applyTableNameRemapping(sqlSb, sqlAlias, newCteName, null, null, false);
        }
        return sb;
    }

    private void replaceWithCteName(StringBuilder sqlSb, String mainSubselect, String cteName) {
        int subselectIndex = 0;
        while ((subselectIndex = sqlSb.indexOf(mainSubselect, subselectIndex)) > -1) {
            sqlSb.replace(subselectIndex, subselectIndex + mainSubselect.length(), cteName);
        }
    }

    private boolean applyAddedCtes(QuerySpecification<?> querySpecification, Map<String, String> cteTableNameRemappings, StringBuilder sb, Map<String, String> tableNameRemapping, boolean firstCte) {
        Map<String, String> addedCtes;
        if (querySpecification != null && (addedCtes = querySpecification.getAddedCtes()) != null && addedCtes.size() > 0) {
            for (Map.Entry<String, String> simpleCteEntry : addedCtes.entrySet()) {
                for (Map.Entry<String, String> cteTableNameRemapping : cteTableNameRemappings.entrySet()) {
                    if (!cteTableNameRemapping.getValue().equals(simpleCteEntry.getKey())) continue;
                    tableNameRemapping.put(cteTableNameRemapping.getKey(), cteTableNameRemapping.getValue());
                }
                if (firstCte) {
                    firstCte = false;
                } else {
                    sb.append(", ");
                }
                sb.append(simpleCteEntry.getKey());
                sb.append(" AS ( ");
                sb.append(simpleCteEntry.getValue());
                sb.append(" )");
            }
        }
        return firstCte;
    }

    private boolean applyCascadingDelete(Query baseQuery, List<Query> participatingQueries, StringBuilder sb, String cteBaseName, boolean firstCte) {
        List cascadingDeleteSqls = this.extendedQuerySupport.getCascadingDeleteSql(this.em, baseQuery);
        StringBuilder cascadingDeleteSqlSb = new StringBuilder();
        int cteBaseNameCount = 0;
        for (String cascadingDeleteSql : cascadingDeleteSqls) {
            if (firstCte) {
                firstCte = false;
            } else {
                sb.append(", ");
            }
            participatingQueries.add(baseQuery);
            sb.append(cteBaseName);
            sb.append('_').append(cteBaseNameCount++);
            sb.append(" AS ( ");
            cascadingDeleteSqlSb.setLength(0);
            cascadingDeleteSqlSb.append(cascadingDeleteSql);
            this.dbmsDialect.appendExtendedSql(cascadingDeleteSqlSb, DbmsStatementType.DELETE, false, true, null, null, null, null, null);
            sb.append((CharSequence)cascadingDeleteSqlSb);
            sb.append(" )");
        }
        return firstCte;
    }

    protected StringBuilder applySqlTransformations(String sqlQuery) {
        if (this.entityFunctionNodes.isEmpty() && this.keyRestrictedLeftJoinAliases.isEmpty()) {
            return new StringBuilder(sqlQuery);
        }
        StringBuilder sb = new StringBuilder(sqlQuery.length() + this.entityFunctionNodes.size() * 100 + this.keyRestrictedLeftJoinAliases.size() * 20);
        EntityFunction.appendSubqueryPart(sb, sqlQuery);
        for (int i = 1; i < this.entityFunctionNodes.size(); ++i) {
            EntityFunction.removeSyntheticPredicate(sb, sqlQuery, sb.length());
        }
        for (String sqlAlias : this.keyRestrictedLeftJoinAliases) {
            this.applyLeftJoinSubqueryRewrite(sb, sqlAlias);
        }
        LateralStyle lateralStyle = this.dbmsDialect.getLateralStyle();
        String andSeparator = " and ";
        for (EntityFunctionNode node : this.entityFunctionNodes) {
            String valuesTableSqlAlias = node.getTableAlias();
            String valuesClause = node.getSubquery();
            String valuesAliases = node.getAliases();
            String syntheticPredicate = node.getSyntheticPredicate();
            boolean useApply = node.isLateral() && lateralStyle == LateralStyle.APPLY;
            String entityName = node.getEntityName();
            String subselect = "( select * from " + entityName + " )";
            String subselectTableExpr = subselect + " " + valuesTableSqlAlias;
            int subselectIndex = sb.indexOf(subselectTableExpr, 0);
            if (subselectIndex == -1) {
                if (syntheticPredicate != null) {
                    int syntheticPredicateStart = sb.indexOf(syntheticPredicate, SqlUtils.indexOfFrom(sb));
                    int end = syntheticPredicateStart + syntheticPredicate.length();
                    if (sb.indexOf(" and ", end) == end) {
                        sb.replace(syntheticPredicateStart, end + " and ".length(), "");
                    } else {
                        sb.replace(syntheticPredicateStart, end, "1=1");
                    }
                }
            } else {
                while ((subselectIndex = sb.indexOf(subselectTableExpr, subselectIndex)) > -1) {
                    int endIndex = subselectIndex + subselect.length();
                    if (syntheticPredicate != null) {
                        int syntheticPredicateStart = sb.indexOf(syntheticPredicate, endIndex);
                        int end = syntheticPredicateStart + syntheticPredicate.length();
                        if (sb.indexOf(" and ", end) == end) {
                            sb.replace(syntheticPredicateStart, end + " and ".length(), "");
                        } else {
                            sb.replace(syntheticPredicateStart, end, "1=1");
                        }
                    }
                    sb.replace(subselectIndex, endIndex, entityName);
                }
            }
            String newSqlAlias = null;
            if (node.getPluralTableJoin() != null) {
                newSqlAlias = node.getPluralTableAlias() + " ";
                valuesTableSqlAlias = valuesTableSqlAlias + " " + node.getPluralTableJoin();
                if (node.getPluralCollectionTableAlias() != null) {
                    String dereference = node.getPluralCollectionTableAlias() + ".";
                    int fromIndex = SqlUtils.indexOfFrom(sb);
                    int dereferenceIndex = 0;
                    while ((dereferenceIndex = sb.indexOf(dereference, dereferenceIndex)) != -1 && dereferenceIndex <= fromIndex) {
                        sb.replace(dereferenceIndex, dereferenceIndex + node.getPluralCollectionTableAlias().length(), newSqlAlias);
                        dereferenceIndex += newSqlAlias.length() - node.getPluralCollectionTableAlias().length();
                    }
                }
            }
            SqlUtils.applyTableNameRemapping(sb, valuesTableSqlAlias, valuesClause, valuesAliases, newSqlAlias, useApply);
        }
        return sb;
    }

    private void applyLeftJoinSubqueryRewrite(StringBuilder sb, String sqlAlias) {
        block5: {
            String searchAs = " as";
            String searchAlias = " " + sqlAlias + " ";
            int searchIndex = 0;
            if ((searchIndex = sb.indexOf(searchAlias, searchIndex)) <= -1) break block5;
            int[] indexRange = " as".equalsIgnoreCase(sb.substring(searchIndex - " as".length(), searchIndex)) ? SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex - " as".length()) : SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex);
            String leftJoinString = "left outer join ";
            int joinTableJoinIndex = -1;
            int targetTableJoinIndex = -1;
            int currentIndex = -1;
            while ((currentIndex = sb.indexOf(leftJoinString, currentIndex + 1)) < indexRange[0] && currentIndex > 0) {
                joinTableJoinIndex = targetTableJoinIndex;
                targetTableJoinIndex = currentIndex;
            }
            if (joinTableJoinIndex < 1) {
                throw new IllegalStateException("The left join for subquery rewriting could not be found!");
            }
            String onString = " on ";
            int joinTableIndex = joinTableJoinIndex + leftJoinString.length();
            int onIndex = sb.indexOf(onString, joinTableIndex);
            if (onIndex > targetTableJoinIndex) {
                throw new IllegalStateException("The left join for subquery rewriting could not be found!");
            }
            StringBuilder onCondition = new StringBuilder(sb.substring(onIndex, targetTableJoinIndex));
            int aliasIndex = sb.indexOf(" ", joinTableIndex) + 1;
            String joinTableAlias = sb.substring(aliasIndex, onIndex);
            int realOnConditionStartIndex = indexRange[1];
            String realOnConditionStart = " and (";
            int realOnConditionIndex = sb.indexOf(realOnConditionStart, realOnConditionStartIndex);
            List<String> joinTableParentExpressions = this.getColumnExpressions(sb, joinTableAlias, onIndex, targetTableJoinIndex);
            List<String> joinTableKeyExpressions = this.getColumnExpressions(sb, joinTableAlias, realOnConditionIndex, sb.length());
            if (joinTableKeyExpressions.size() != 1) {
                throw new IllegalStateException("Expected exactly one key expression but found: " + joinTableKeyExpressions.size());
            }
            String joinTableKeyExpression = joinTableKeyExpressions.get(0);
            String joinTableKeyAlias = "join_table_key";
            String joinTableParentAliasPrefix = "join_table_parent_";
            StringBuilder subqueryPrefixSb = new StringBuilder();
            subqueryPrefixSb.append("(select ");
            subqueryPrefixSb.append(joinTableKeyExpression);
            subqueryPrefixSb.append(" as ");
            subqueryPrefixSb.append(joinTableKeyAlias);
            subqueryPrefixSb.append(", ");
            subqueryPrefixSb.append(sqlAlias);
            subqueryPrefixSb.append(".*");
            for (int i = 0; i < joinTableParentExpressions.size(); ++i) {
                subqueryPrefixSb.append(", ");
                subqueryPrefixSb.append(joinTableParentExpressions.get(i));
                subqueryPrefixSb.append(" as ");
                subqueryPrefixSb.append(joinTableParentAliasPrefix);
                subqueryPrefixSb.append(i);
                String newParentExpression = sqlAlias + "." + joinTableParentAliasPrefix + i;
                int lengthDifference = newParentExpression.length() - joinTableParentExpressions.get(i).length();
                this.replaceExpressionUntil(0, onCondition.length(), lengthDifference, onCondition, joinTableParentExpressions.get(i), newParentExpression);
            }
            subqueryPrefixSb.append(" from ");
            String subqueryPrefix = subqueryPrefixSb.toString();
            String subqueryInsert = subqueryPrefix + sb.substring(joinTableIndex, onIndex);
            sb.replace(joinTableIndex, targetTableJoinIndex - 1, subqueryInsert);
            realOnConditionStartIndex += subqueryInsert.length() - (targetTableJoinIndex - joinTableIndex);
            String subqueryEnd = ") " + sqlAlias + onCondition;
            sb.insert(realOnConditionIndex += subqueryInsert.length() - (targetTableJoinIndex - joinTableIndex - 1), subqueryEnd);
            String targetTableKeyExpression = sqlAlias + "." + joinTableKeyAlias;
            int lengthDifference = targetTableKeyExpression.length() - joinTableKeyExpression.length();
            int diff = this.replaceExpressionUntil(-1, joinTableIndex, lengthDifference, sb, joinTableKeyExpression, targetTableKeyExpression);
            this.replaceExpressionUntil((realOnConditionStartIndex += subqueryEnd.length()) + diff, sb.length(), lengthDifference, sb, joinTableKeyExpression, targetTableKeyExpression);
        }
    }

    private List<String> getColumnExpressions(StringBuilder sb, String tableAlias, int startIndex, int endIndex) {
        String columnExpressionStart = tableAlias + ".";
        ArrayList<String> columnExpressions = new ArrayList<String>();
        while (startIndex < endIndex) {
            char keyChar;
            int expressionIndex = sb.indexOf(columnExpressionStart, startIndex);
            if (expressionIndex < 0) {
                if (!columnExpressions.isEmpty()) break;
                throw new IllegalStateException("The join table column expression needed for subquery rewriting could not be found!");
            }
            StringBuilder columnExpressionSb = new StringBuilder(80);
            columnExpressionSb.append(columnExpressionStart);
            expressionIndex += columnExpressionStart.length();
            while (SqlUtils.isIdentifier(keyChar = sb.charAt(expressionIndex))) {
                columnExpressionSb.append(keyChar);
                ++expressionIndex;
            }
            columnExpressions.add(columnExpressionSb.toString());
            startIndex = expressionIndex;
        }
        return columnExpressions;
    }

    private int replaceExpressionUntil(int searchIndex, int endIndex, int lengthDifference, StringBuilder sb, String oldExpression, String newExpression) {
        int diff = 0;
        while ((searchIndex = sb.indexOf(oldExpression, searchIndex + 1)) > 0 && searchIndex < endIndex) {
            if (SqlUtils.isIdentifierStart(sb.charAt(searchIndex - 1)) || SqlUtils.isIdentifier(sb.charAt(searchIndex + oldExpression.length()))) continue;
            sb.replace(searchIndex, searchIndex + oldExpression.length(), newExpression);
            searchIndex += lengthDifference;
            endIndex += lengthDifference;
            diff += lengthDifference;
        }
        return diff;
    }

    private String getSql(Query query) {
        if (query instanceof CustomSQLQuery) {
            return ((CustomSQLQuery)query).getSql();
        }
        if (query instanceof CustomSQLTypedQuery) {
            return ((CustomSQLTypedQuery)query).getSql();
        }
        return this.extendedQuerySupport.getSql(this.em, query);
    }
}

