/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.query;

import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.plan.CustomSelectQueryPlan;
import com.blazebit.persistence.impl.plan.SelectQueryPlan;
import com.blazebit.persistence.impl.query.AbstractCustomQuery;
import com.blazebit.persistence.impl.query.CTENode;
import com.blazebit.persistence.impl.query.CustomQuerySpecification;
import com.blazebit.persistence.impl.query.CustomSQLQuery;
import com.blazebit.persistence.impl.query.CustomSQLTypedQuery;
import com.blazebit.persistence.impl.query.EntityFunctionNode;
import com.blazebit.persistence.spi.OrderByElement;
import com.blazebit.persistence.spi.SetOperationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Parameter;
import javax.persistence.Query;

public class SetOperationQuerySpecification<T>
extends CustomQuerySpecification<T> {
    private final Query leftMostQuery;
    private final List<Query> setOperands;
    private final SetOperationType operator;
    private final List<? extends OrderByElement> orderByElements;
    private final boolean nested;

    public SetOperationQuerySpecification(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> commonQueryBuilder, Query leftMostQuery, Query baseQuery, List<Query> setOperands, SetOperationType operator, List<? extends OrderByElement> orderByElements, boolean nested, Set<Parameter<?>> parameters, Set<String> parameterListNames, String limit, String offset, List<String> keyRestrictedLeftJoinAliases, List<EntityFunctionNode> entityFunctionNodes, boolean recursive, List<CTENode> ctes, boolean shouldRenderCteNodes) {
        super(commonQueryBuilder, baseQuery, parameters, parameterListNames, limit, offset, keyRestrictedLeftJoinAliases, entityFunctionNodes, recursive, ctes, shouldRenderCteNodes);
        this.leftMostQuery = leftMostQuery;
        this.setOperands = setOperands;
        this.operator = operator;
        this.orderByElements = orderByElements;
        this.nested = nested;
    }

    @Override
    public Query getBaseQuery() {
        return this.baseQuery;
    }

    @Override
    protected void initialize() {
        String sqlQuery;
        List<Query> customQueryParticipants;
        AbstractCustomQuery customQuery;
        ArrayList<Query> participatingQueries = new ArrayList<Query>();
        ArrayList<Query> cteQueries = new ArrayList<Query>();
        this.bindListParameters(this.baseQuery);
        if (this.leftMostQuery instanceof CustomSQLQuery) {
            customQuery = (CustomSQLQuery)this.leftMostQuery;
            this.bindListParameters(this.leftMostQuery);
            customQueryParticipants = customQuery.getParticipatingQueries();
            participatingQueries.addAll(customQueryParticipants);
            sqlQuery = customQuery.getSql();
        } else if (this.leftMostQuery instanceof CustomSQLTypedQuery) {
            customQuery = (CustomSQLTypedQuery)this.leftMostQuery;
            this.bindListParameters(this.leftMostQuery);
            customQueryParticipants = customQuery.getParticipatingQueries();
            participatingQueries.addAll(customQueryParticipants);
            sqlQuery = customQuery.getSql();
        } else {
            participatingQueries.add(this.baseQuery);
            sqlQuery = this.extendedQuerySupport.getSql(this.em, this.baseQuery);
        }
        int size = sqlQuery.length() + 10;
        ArrayList<String> setOperands = new ArrayList<String>();
        setOperands.add(sqlQuery);
        for (Query q : this.setOperands) {
            String setOperandSql;
            List<Query> customQueryParticipants2;
            AbstractCustomQuery customQuery2;
            this.bindListParameters(q);
            if (q instanceof CustomSQLQuery) {
                customQuery2 = (CustomSQLQuery)q;
                customQueryParticipants2 = customQuery2.getParticipatingQueries();
                participatingQueries.addAll(customQueryParticipants2);
                setOperandSql = customQuery2.getSql();
            } else if (q instanceof CustomSQLTypedQuery) {
                customQuery2 = (CustomSQLTypedQuery)q;
                customQueryParticipants2 = customQuery2.getParticipatingQueries();
                participatingQueries.addAll(customQueryParticipants2);
                setOperandSql = customQuery2.getSql();
            } else {
                setOperandSql = this.extendedQuerySupport.getSql(this.em, q);
                participatingQueries.add(q);
            }
            setOperands.add(setOperandSql);
            size += setOperandSql.length() + 30;
        }
        StringBuilder sqlSb = new StringBuilder(size);
        this.dbmsDialect.appendSet(sqlSb, this.operator, this.nested, setOperands, this.orderByElements, this.limit, this.offset);
        StringBuilder withClause = this.applyCtes(sqlSb, this.baseQuery, cteQueries);
        Map addedCtes = this.dbmsDialect.appendExtendedSql(sqlSb, this.statementType, false, false, withClause, null, null, null, null);
        cteQueries.addAll(participatingQueries);
        participatingQueries = cteQueries;
        this.sql = sqlSb.toString();
        this.participatingQueries = participatingQueries;
        this.addedCtes = addedCtes;
        this.dirty = false;
    }

    @Override
    public SelectQueryPlan<T> createSelectPlan(int firstResult, int maxResults) {
        String sql = this.getSql();
        return new CustomSelectQueryPlan(this.extendedQuerySupport, this.serviceProvider, this.baseQuery, this.participatingQueries, sql, firstResult, maxResults);
    }

    private void bindListParameters(Query q) {
        for (Parameter parameter : q.getParameters()) {
            Collection value = (Collection)this.listParameters.get(parameter.getName());
            if (value == null) continue;
            q.setParameter(parameter, (Object)value);
        }
    }
}

