/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.transform;

import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.JoinManager;
import com.blazebit.persistence.impl.transform.ClauseAndJoinAwareVisitor;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import java.util.HashSet;

public class OuterFunctionVisitor
extends ClauseAndJoinAwareVisitor
implements ExpressionModifierVisitor<ExpressionModifier> {
    private final JoinManager joinManager;

    public OuterFunctionVisitor(JoinManager joinManager) {
        this.joinManager = joinManager;
    }

    @Override
    public void visit(ExpressionModifier expressionModifier, ClauseType clauseType) {
        this.visit(clauseType, expressionModifier.get());
    }

    public void visit(FunctionExpression expression) {
        if (ExpressionUtils.isOuterFunction((FunctionExpression)expression)) {
            PathExpression path = (PathExpression)expression.getExpressions().get(0);
            if (this.joinManager.getParent() != null) {
                this.joinManager.getParent().implicitJoin((Expression)path, true, true, null, this.fromClause, null, null, new HashSet<String>(), false, true, this.joinRequired, false, false, false);
            }
        }
        super.visit(expression);
    }
}

