/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.util;

import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiFirstPatternFinder;
import com.blazebit.persistence.impl.util.BoyerMooreCaseInsensitiveAsciiLastPatternFinder;
import com.blazebit.persistence.impl.util.PatternFinder;
import com.blazebit.persistence.impl.util.QuoteMode;
import com.blazebit.persistence.impl.util.QuotedIdentifierAwarePatternFinder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class SqlUtils {
    private static final String SELECT = "select ";
    private static final String SET = " set ";
    private static final String FROM = " from ";
    private static final String JOIN = " join ";
    private static final String WITH = "with ";
    private static final String WHERE = " where ";
    private static final String ORDER_BY = " order by ";
    private static final String AS = " as ";
    private static final String FROM_FINAL_TABLE = " from final table (";
    private static final String NEXT_VALUE_FOR = "next value for ";
    private static final PatternFinder SELECT_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("select "));
    private static final PatternFinder SET_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" set "));
    private static final PatternFinder FROM_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from "));
    private static final PatternFinder JOIN_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" join "));
    private static final PatternFinder WITH_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("with "));
    private static final PatternFinder WHERE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" where "));
    private static final PatternFinder ORDER_BY_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" order by "));
    private static final PatternFinder AS_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiLastPatternFinder(" as "));
    private static final PatternFinder FROM_FINAL_TABLE_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" from final table ("));
    private static final PatternFinder NEXT_VALUE_FOR_FINDER = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder("next value for "));
    private static final SelectItemExtractor ALIAS_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractAlias(sb);
        }
    };
    private static final SelectItemExtractor EXPRESSION_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractExpression(sb);
        }
    };
    private static final SelectItemExtractor COLUMN_EXTRACTOR = new SelectItemExtractor(){

        @Override
        public String extract(StringBuilder sb, int index, int currentPosition) {
            return SqlUtils.extractColumn(sb);
        }
    };

    private SqlUtils() {
    }

    public static void applyTableNameRemapping(StringBuilder sb, String sqlAlias, String newCteName, String aliasExtension, String newSqlAlias, boolean useApply) {
        String searchAs = " as";
        String searchAlias = " " + sqlAlias;
        int searchIndex = 0;
        while ((searchIndex = sb.indexOf(searchAlias, searchIndex)) > -1) {
            int idx = searchIndex + searchAlias.length();
            if ((idx >= sb.length() || sb.charAt(idx) != '.') && SqlUtils.isInMainQuery(sb, searchIndex)) {
                int[] tableNameIndexRange = " as".equalsIgnoreCase(sb.substring(searchIndex - " as".length(), searchIndex)) ? SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex - " as".length()) : SqlUtils.rtrimBackwardsToFirstWhitespace(sb, searchIndex);
                if (sb.charAt(tableNameIndexRange[0]) == ')') {
                    int parenthesis = 1;
                    QuoteMode mode = QuoteMode.NONE;
                    for (int i = tableNameIndexRange[0] - 1; i >= 0; --i) {
                        char c = sb.charAt(i);
                        if ((mode = mode.onCharBackwards(c)) != QuoteMode.NONE) continue;
                        if (c == '(') {
                            if (--parenthesis != 0) continue;
                            tableNameIndexRange[0] = i;
                            break;
                        }
                        if (c != ')') continue;
                        ++parenthesis;
                    }
                }
                if (newSqlAlias != null) {
                    sb.replace(tableNameIndexRange[1] + 1, tableNameIndexRange[1] + 1 + sqlAlias.length(), newSqlAlias);
                    searchIndex += newSqlAlias.length() - sqlAlias.length();
                    sqlAlias = newSqlAlias;
                }
                int oldTableNameLength = tableNameIndexRange[1] - tableNameIndexRange[0];
                if (useApply) {
                    int whereIndex = SqlUtils.indexOfWhere(sb, tableNameIndexRange[1]);
                    if (whereIndex == -1) {
                        whereIndex = sb.length();
                    }
                    int[] indexRange = SqlUtils.indexOfFullJoin(sb, sqlAlias, tableNameIndexRange[1] + 1, whereIndex);
                    oldTableNameLength += tableNameIndexRange[0] - indexRange[0];
                    sb.replace(indexRange[0], indexRange[1], newCteName + sb.substring(tableNameIndexRange[1], tableNameIndexRange[1] + searchAlias.length()));
                } else {
                    sb.replace(tableNameIndexRange[0], tableNameIndexRange[1], newCteName);
                }
                if (aliasExtension != null) {
                    sb.insert(searchIndex + searchAlias.length() + (newCteName.length() - oldTableNameLength), aliasExtension);
                    searchIndex += aliasExtension.length();
                }
                searchIndex += newCteName.length() - oldTableNameLength;
            }
            ++searchIndex;
        }
    }

    private static boolean isInMainQuery(StringBuilder sb, int tableNameIndex) {
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        for (int i = 0; i < tableNameIndex; ++i) {
            char c = sb.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                ++parenthesis;
                continue;
            }
            if (c != ')') continue;
            --parenthesis;
        }
        return parenthesis == 0;
    }

    public static int[] rtrimBackwardsToFirstWhitespace(CharSequence sb, int startIndex) {
        int tableNameStartIndex;
        int tableNameEndIndex = startIndex;
        boolean text = false;
        for (tableNameStartIndex = tableNameEndIndex; tableNameStartIndex >= 0; --tableNameStartIndex) {
            if (text) {
                char c = sb.charAt(tableNameStartIndex);
                if (!Character.isWhitespace(c) && c != ',') continue;
                break;
            }
            if (Character.isWhitespace(sb.charAt(tableNameStartIndex))) {
                --tableNameEndIndex;
                continue;
            }
            text = true;
            ++tableNameEndIndex;
        }
        return new int[]{++tableNameStartIndex, tableNameEndIndex};
    }

    public static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isIdentifier(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static String[] getSelectItemAliases(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, ALIAS_EXTRACTOR);
    }

    public static String[] getSelectItemExpressions(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, EXPRESSION_EXTRACTOR);
    }

    public static String[] getSelectItemColumns(CharSequence sql, int start) {
        return SqlUtils.getSelectItems(sql, start, COLUMN_EXTRACTOR);
    }

    public static String[] getSelectItems(CharSequence sql, int start, SelectItemExtractor extractor) {
        int selectIndex = SELECT_FINDER.indexIn(sql, start);
        int fromIndex = FROM_FINDER.indexIn(sql, selectIndex);
        if (fromIndex == -1) {
            fromIndex = sql.length();
        }
        List<String> selectItems = SqlUtils.getExpressionItems(sql, selectIndex + SELECT.length(), fromIndex, extractor);
        return selectItems.toArray(new String[selectItems.size()]);
    }

    public static List<String> getExpressionItems(CharSequence sql) {
        return SqlUtils.getExpressionItems(sql, 0, sql.length(), EXPRESSION_EXTRACTOR);
    }

    public static List<String> getExpressionItems(CharSequence sql, int i, int end, SelectItemExtractor extractor) {
        ArrayList<String> selectItems = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        int fromIndex = end;
        while (i < end) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) == QuoteMode.NONE) {
                if (parenthesis == 0 && c == ',') {
                    selectItems.add(extractor.extract(sb, selectItems.size(), i));
                    sb.setLength(0);
                    ++i;
                    continue;
                }
                if (c == '(') {
                    end = sql.length();
                    ++parenthesis;
                } else if (c == ')') {
                    if (i < fromIndex && parenthesis == 1) {
                        end = fromIndex;
                    } else {
                        end = fromIndex = FROM_FINDER.indexIn(sql, parenthesis == 1 ? i : i + 2);
                        if (fromIndex == -1) {
                            end = fromIndex = sql.length();
                        }
                    }
                    --parenthesis;
                }
            }
            sb.append(c);
            ++i;
        }
        String lastAlias = extractor.extract(sb, selectItems.size(), i);
        if (!lastAlias.isEmpty()) {
            selectItems.add(lastAlias);
        }
        return selectItems;
    }

    public static CharSequence getSetElementSequence(CharSequence sql) {
        int setIndex = SET_FINDER.indexIn(sql);
        if (setIndex == -1) {
            return null;
        }
        setIndex += SET.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        return sql.subSequence(setIndex, whereIndex);
    }

    public static int indexOfSelect(CharSequence sql) {
        int selectIndex = SELECT_FINDER.indexIn(sql);
        int withIndex = WITH_FINDER.indexIn(sql, 0, selectIndex);
        if (withIndex == -1) {
            return selectIndex;
        }
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = selectIndex;
        for (int i = withIndex + WITH.length(); i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < selectIndex ? selectIndex : (selectIndex = SELECT_FINDER.indexIn(sql, i));
        }
        return selectIndex;
    }

    public static int indexOfFrom(CharSequence sql) {
        return FROM_FINDER.indexIn(sql, 0);
    }

    public static int indexOfWhere(CharSequence sql) {
        return SqlUtils.indexOfWhere(sql, 0);
    }

    public static int indexOfWhere(CharSequence sql, int start) {
        int whereIndex = WHERE_FINDER.indexIn(sql, start);
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = whereIndex;
        for (int i = 0; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < whereIndex ? whereIndex : (whereIndex = WHERE_FINDER.indexIn(sql, i));
        }
        return whereIndex;
    }

    public static int indexOfOrderBy(CharSequence sql) {
        int orderByIndex = ORDER_BY_FINDER.indexIn(sql);
        int brackets = 0;
        QuoteMode mode = QuoteMode.NONE;
        int end = orderByIndex;
        for (int i = 0; i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = sql.length();
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            end = i < orderByIndex ? orderByIndex : (orderByIndex = ORDER_BY_FINDER.indexIn(sql, i));
        }
        return orderByIndex;
    }

    public static int[] indexOfFinalTableSubquery(CharSequence sql, int selectIndex) {
        int fromFinalTableIndex = FROM_FINAL_TABLE_FINDER.indexIn(sql, selectIndex);
        if (fromFinalTableIndex == -1) {
            return new int[]{0, sql.length()};
        }
        int brackets = 1;
        QuoteMode mode = QuoteMode.NONE;
        int end = sql.length();
        for (int i = fromFinalTableIndex + FROM_FINAL_TABLE.length(); i < end; ++i) {
            char c = sql.charAt(i);
            if ((mode = mode.onChar(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                ++brackets;
                continue;
            }
            if (c != ')' || --brackets != 0) continue;
            return new int[]{fromFinalTableIndex + FROM_FINAL_TABLE.length(), i};
        }
        return new int[]{0, sql.length()};
    }

    public static int indexOfTableName(CharSequence sql, String tableName) {
        QuotedIdentifierAwarePatternFinder finder;
        int index;
        int startIndex = FROM_FINDER.indexIn(sql, 0);
        if (startIndex == -1) {
            return -1;
        }
        startIndex += FROM.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        if ((index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" " + tableName + " "))).indexIn(sql, startIndex, whereIndex)) == -1) {
            return -1;
        }
        return index + 1;
    }

    public static int indexOfJoinTableAlias(CharSequence sql, String tableName) {
        QuotedIdentifierAwarePatternFinder finder;
        int index;
        int startIndex = FROM_FINDER.indexIn(sql, 0);
        if (startIndex == -1) {
            return -1;
        }
        startIndex += FROM.length();
        int whereIndex = SqlUtils.indexOfWhere(sql);
        if (whereIndex == -1) {
            whereIndex = sql.length();
        }
        if ((index = (finder = new QuotedIdentifierAwarePatternFinder(new BoyerMooreCaseInsensitiveAsciiFirstPatternFinder(" " + tableName + " on "))).indexIn(sql, startIndex, whereIndex)) == -1) {
            return -1;
        }
        return index + 1;
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias) {
        int whereIndex = SqlUtils.indexOfWhere(sql);
        return SqlUtils.indexOfFullJoin(sql, tableAlias, whereIndex);
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias, int whereIndex) {
        int aliasIndex = SqlUtils.indexOfJoinTableAlias(sql, tableAlias);
        return SqlUtils.indexOfFullJoin(sql, tableAlias, aliasIndex, whereIndex);
    }

    public static int[] indexOfFullJoin(CharSequence sql, String tableAlias, int aliasIndex, int whereIndex) {
        String aliasOnPart = " " + tableAlias + " on ";
        if (aliasIndex > -1 && aliasIndex < whereIndex) {
            int onClauseStart = --aliasIndex + aliasOnPart.length();
            int onClauseEnd = SqlUtils.findEndOfOnClause(sql, onClauseStart, whereIndex);
            int joinStartIndex = SqlUtils.findJoinStartIndex(sql, aliasIndex);
            return new int[]{joinStartIndex, onClauseEnd};
        }
        return null;
    }

    public static int findJoinStartIndex(CharSequence sqlSb, int aliasIndex) {
        int[] tokenRange = SqlUtils.rtrimBackwardsToFirstWhitespace(sqlSb, aliasIndex);
        return SqlUtils.findJoinStartIndex(sqlSb, tokenRange[0] - 1, EnumSet.of(JoinToken.JOIN));
    }

    public static int findJoinStartIndex(CharSequence sqlSb, int tokenEnd, Set<JoinToken> allowedTokens) {
        int[] tokenRange;
        do {
            tokenRange = SqlUtils.rtrimBackwardsToFirstWhitespace(sqlSb, tokenEnd);
            tokenEnd = tokenRange[0] - 1;
            JoinToken token = JoinToken.of(sqlSb.subSequence(tokenRange[0], tokenRange[1]).toString().trim().toUpperCase());
            if (!allowedTokens.contains((Object)token)) {
                return tokenRange[1];
            }
            allowedTokens = token.previous();
        } while (!allowedTokens.isEmpty());
        return tokenRange[0];
    }

    public static int findEndOfOnClause(CharSequence sqlSb, int predicateStartIndex, int whereIndex) {
        int joinIndex = JOIN_FINDER.indexIn(sqlSb, predicateStartIndex);
        int end = joinIndex == -1 || joinIndex > whereIndex ? whereIndex : SqlUtils.findJoinStartIndex(sqlSb, joinIndex, JoinToken.JOIN.previous());
        int potentialEndIndex = end;
        int parenthesis = 0;
        QuoteMode mode = QuoteMode.NONE;
        for (int i = predicateStartIndex; i < end; ++i) {
            char c = sqlSb.charAt(i);
            if ((mode = mode.onCharBackwards(c)) != QuoteMode.NONE) continue;
            if (c == '(') {
                end = whereIndex;
                ++parenthesis;
                continue;
            }
            if (c == ')') {
                --parenthesis;
                if (i < potentialEndIndex) {
                    end = potentialEndIndex;
                    continue;
                }
                joinIndex = JOIN_FINDER.indexIn(sqlSb, i);
                if (joinIndex == -1) {
                    return whereIndex;
                }
                end = potentialEndIndex = SqlUtils.findJoinStartIndex(sqlSb, joinIndex, JoinToken.JOIN.previous());
                continue;
            }
            if (c != ',' || parenthesis != 0) continue;
            return i;
        }
        return end;
    }

    public static String extractAlias(StringBuilder sb) {
        int aliasEndCharIndex = SqlUtils.findLastNonWhitespace(sb);
        QuoteMode mode = QuoteMode.NONE.onCharBackwards(sb.charAt(aliasEndCharIndex));
        int endIndex = aliasEndCharIndex;
        if (mode != QuoteMode.NONE) {
            while ((mode = mode.onCharBackwards(sb.charAt(--endIndex))) != QuoteMode.NONE || endIndex > 0 && sb.charAt(endIndex) == sb.charAt(endIndex - 1)) {
            }
        }
        int aliasBeforeIndex = SqlUtils.findLastWhitespace(sb, endIndex);
        int dotIndex = sb.lastIndexOf(".", endIndex);
        aliasBeforeIndex = Math.max(aliasBeforeIndex, dotIndex);
        if (NEXT_VALUE_FOR_FINDER.indexIn(sb) != -1) {
            return sb.toString();
        }
        return sb.substring(aliasBeforeIndex + 1, aliasEndCharIndex + 1);
    }

    public static String extractAlias(CharSequence sb, int index) {
        char c;
        int i;
        int aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, index);
        int asIndex = AS_FINDER.indexIn(sb, aliasBeginCharIndex - 1);
        if (asIndex != -1) {
            aliasBeginCharIndex = SqlUtils.skipWhitespaces(sb, asIndex + AS.length());
        }
        QuoteMode mode = QuoteMode.NONE;
        int end = sb.length();
        for (i = aliasBeginCharIndex; !(i >= end || (mode = mode.onChar(c = sb.charAt(i))) == QuoteMode.NONE && Character.isWhitespace(c)); ++i) {
        }
        return sb.subSequence(aliasBeginCharIndex, i).toString();
    }

    private static int skipWhitespaces(CharSequence charSequence, int index) {
        while (Character.isWhitespace(charSequence.charAt(index))) {
            int nextIndex = index + 1;
            if (nextIndex == charSequence.length()) {
                return nextIndex;
            }
            index = nextIndex;
        }
        return index;
    }

    private static String extractExpression(StringBuilder sb) {
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.toString();
        }
        return sb.substring(0, asIndex);
    }

    private static String extractColumn(StringBuilder sb) {
        int asIndex = AS_FINDER.indexIn(sb);
        if (asIndex == -1) {
            return sb.substring(SqlUtils.findLastDot(sb, sb.length()) + 1);
        }
        return sb.substring(SqlUtils.findLastDot(sb, asIndex) + 1, asIndex);
    }

    private static int findLastDot(StringBuilder sb, int end) {
        int i = end - 1;
        QuoteMode mode = QuoteMode.NONE;
        while (i >= 0) {
            char c = sb.charAt(i);
            if ((mode = mode.onCharBackwards(sb.charAt(i))) == QuoteMode.NONE) {
                if (c == '.') break;
                --i;
                continue;
            }
            --i;
        }
        return i;
    }

    private static int findLastNonWhitespace(StringBuilder sb) {
        return SqlUtils.findLastNonWhitespace(sb, sb.length() - 1);
    }

    private static int findLastNonWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    private static int findLastWhitespace(StringBuilder sb, int end) {
        int i;
        for (i = end; i >= 0 && !Character.isWhitespace(sb.charAt(i)); --i) {
        }
        return i;
    }

    static enum JoinToken {
        COMMA,
        LEFT,
        INNER,
        RIGHT,
        CROSS,
        OUTER{

            @Override
            Set<JoinToken> previous() {
                return EnumSet.of(LEFT, RIGHT);
            }
        }
        ,
        JOIN{

            @Override
            Set<JoinToken> previous() {
                return EnumSet.of(LEFT, INNER, RIGHT, OUTER, CROSS);
            }
        };


        Set<JoinToken> previous() {
            return EnumSet.noneOf(JoinToken.class);
        }

        static JoinToken of(String text) {
            switch (text) {
                case ",": {
                    return COMMA;
                }
            }
            return JoinToken.valueOf(text);
        }
    }

    public static interface SelectItemExtractor {
        public String extract(StringBuilder var1, int var2, int var3);
    }
}

