/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.PrefixingAndAliasReplacementQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroFunction;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.persistence.view.spi.ViewRootJpqlMacro;

public class CorrelationProviderProxyBase
implements CorrelationProvider {
    private final Class<?> correlated;
    private final String correlationKeyAlias;
    private final int approximateExpressionSize;
    private final String correlationExpression;

    private CorrelationProviderProxyBase(Class<?> correlated, String correlationKeyAlias, String correlationExpression) {
        this.correlated = correlated;
        this.correlationKeyAlias = correlationKeyAlias;
        this.approximateExpressionSize = correlationExpression.length() * 2;
        this.correlationExpression = correlationExpression;
    }

    public void applyCorrelation(CorrelationBuilder correlationBuilder, String correlationExpression) {
        String originalExpressionString;
        String alias = correlationBuilder.getCorrelationAlias();
        ExpressionFactory expressionFactory = (ExpressionFactory)correlationBuilder.getService(ExpressionFactory.class);
        String expressionString = originalExpressionString = AbstractAttribute.replaceThisFromMapping(this.correlationExpression, alias);
        MacroFunction viewRootFunction = expressionFactory.getDefaultMacroConfiguration().get("VIEW_ROOT");
        ViewRootJpqlMacro viewRootMacro = (ViewRootJpqlMacro)viewRootFunction.getState()[0];
        EmbeddingViewJpqlMacro embeddingViewJpqlMacro = (EmbeddingViewJpqlMacro)expressionFactory.getDefaultMacroConfiguration().get("EMBEDDING_VIEW").getState()[0];
        String viewRoot = viewRootMacro.getViewRoot();
        String embeddingViewPath = embeddingViewJpqlMacro.getEmbeddingViewPath();
        expressionString = CorrelationProviderHelper.temporaryReplace(expressionString, this.correlationKeyAlias.equals(viewRoot) ? null : viewRoot, "__VIEW_ROOT_MATCHING_NAME");
        expressionString = CorrelationProviderHelper.temporaryReplace(expressionString, this.correlationKeyAlias.equals(embeddingViewPath) ? null : embeddingViewPath, "__EMBEDDING_VIEW_MATCHING_NAME");
        Predicate expression = expressionFactory.createBooleanExpression(expressionString, false);
        String aliasToSkip = viewRootMacro.getViewRoot() == null ? embeddingViewJpqlMacro.getEmbeddingViewPath() : viewRootMacro.getViewRoot();
        PrefixingAndAliasReplacementQueryGenerator generator = new PrefixingAndAliasReplacementQueryGenerator(alias, correlationExpression, this.correlationKeyAlias, aliasToSkip, true);
        StringBuilder buffer = new StringBuilder(this.approximateExpressionSize);
        generator.setQueryBuffer(buffer);
        expression.accept((Expression.Visitor)generator);
        String finalExpression = buffer.toString();
        if (originalExpressionString != expressionString) {
            if (viewRoot != null) {
                finalExpression = finalExpression.replaceAll("__VIEW_ROOT_MATCHING_NAME", viewRoot);
            }
            if (embeddingViewPath != null) {
                finalExpression = finalExpression.replaceAll("__EMBEDDING_VIEW_MATCHING_NAME", embeddingViewPath);
            }
        }
        correlationBuilder.correlate(this.correlated).setOnExpression(finalExpression);
    }
}

