/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.PathElementExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.parser.expression.TreatExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PrefixingQueryGenerator
extends SimpleQueryGenerator {
    private final String prefix;
    private final String aliasToSkip;
    private final String aliasToReplaceWithSkipAlias;
    private final String secondAliasToSkip;

    public PrefixingQueryGenerator(List<String> prefixParts) {
        this(prefixParts, null, null, null);
    }

    public PrefixingQueryGenerator(List<String> prefixParts, String aliasToSkip, String aliasToReplaceWithSkipAlias, String secondAliasToSkip) {
        StringBuilder prefixSb = new StringBuilder();
        if (prefixParts != null && !prefixParts.isEmpty()) {
            prefixSb.append(prefixParts.get(0));
            for (int i = 1; i < prefixParts.size(); ++i) {
                prefixSb.append('.');
                prefixSb.append(prefixParts.get(i));
            }
        }
        this.prefix = prefixSb.toString();
        this.aliasToSkip = aliasToSkip;
        this.aliasToReplaceWithSkipAlias = Objects.equals(aliasToSkip, aliasToReplaceWithSkipAlias) ? null : aliasToReplaceWithSkipAlias;
        this.secondAliasToSkip = secondAliasToSkip;
    }

    public static String prefix(ExpressionFactory ef, String mapping, String prefix) {
        int thisIndex = mapping.indexOf("this");
        if (thisIndex == 0 && mapping.length() == "this".length()) {
            return prefix;
        }
        if (mapping.indexOf(40) == -1 && thisIndex == -1) {
            return prefix + "." + mapping;
        }
        Expression expression = ef.createSimpleExpression(mapping, false, false, true);
        PrefixingQueryGenerator generator = new PrefixingQueryGenerator(Collections.singletonList(prefix));
        StringBuilder sb = new StringBuilder(mapping.length() + prefix.length() + 1);
        generator.setQueryBuffer(sb);
        expression.accept((Expression.Visitor)generator);
        return sb.toString();
    }

    public void visit(PathExpression expression) {
        List expressions = expression.getExpressions();
        if (expressions.isEmpty()) {
            this.sb.append(this.prefix);
        } else {
            PathElementExpression firstElement = (PathElementExpression)expressions.get(0);
            int size = expressions.size();
            if (size == 1 && this.secondAliasToSkip != null && firstElement instanceof PropertyExpression && this.secondAliasToSkip.equals(((PropertyExpression)firstElement).getProperty())) {
                super.visit(expression);
                return;
            }
            if (this.aliasToReplaceWithSkipAlias != null && firstElement instanceof PropertyExpression && this.aliasToReplaceWithSkipAlias.equals(((PropertyExpression)firstElement).getProperty())) {
                this.sb.append(this.aliasToSkip);
                for (int i = 1; i < size; ++i) {
                    this.sb.append(".");
                    ((PathElementExpression)expressions.get(i)).accept((Expression.Visitor)this);
                }
                return;
            }
            if (size > 1 && this.aliasToSkip != null && firstElement instanceof PropertyExpression && this.aliasToSkip.equals(((PropertyExpression)firstElement).getProperty())) {
                super.visit(expression);
                return;
            }
            if (!(firstElement instanceof TreatExpression)) {
                String expressionString = expression.toString();
                int dotIndex = -1;
                int length = Math.min(this.prefix.length(), expressionString.length());
                block1: for (int i = 0; i < length; ++i) {
                    if (this.prefix.charAt(i) == expressionString.charAt(i)) continue;
                    while (i > 0) {
                        if (this.prefix.charAt(i) == '.' && expressionString.charAt(i) == '.') {
                            dotIndex = i;
                            break block1;
                        }
                        --i;
                    }
                    break;
                }
                if (!(dotIndex != -1 || this.prefix.isEmpty() || expressionString.length() < this.prefix.length() && this.prefix.charAt(expressionString.length()) == '.' && this.prefix.startsWith(expressionString) || expressionString.length() > this.prefix.length() && expressionString.charAt(this.prefix.length()) == '.' && expressionString.startsWith(this.prefix) || expressionString.equals(this.prefix))) {
                    this.sb.append(this.prefix);
                    this.sb.append('.');
                }
            }
            if (firstElement instanceof PropertyExpression && "this".equalsIgnoreCase(((PropertyExpression)firstElement).getProperty())) {
                if (size > 1) {
                    for (int i = 1; i < size; ++i) {
                        ((PathElementExpression)expressions.get(i)).accept((Expression.Visitor)this);
                    }
                } else {
                    this.sb.setLength(this.sb.length() - 1);
                }
            } else {
                super.visit(expression);
            }
        }
    }
}

