/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.ListIndexAttribute;
import com.blazebit.persistence.parser.MapKeyAttribute;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.ArithmeticExpression;
import com.blazebit.persistence.parser.expression.ArithmeticFactor;
import com.blazebit.persistence.parser.expression.ArrayExpression;
import com.blazebit.persistence.parser.expression.DateLiteral;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.FunctionExpression;
import com.blazebit.persistence.parser.expression.GeneralCaseExpression;
import com.blazebit.persistence.parser.expression.ListIndexExpression;
import com.blazebit.persistence.parser.expression.MapEntryExpression;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.NullExpression;
import com.blazebit.persistence.parser.expression.NumericLiteral;
import com.blazebit.persistence.parser.expression.ParameterExpression;
import com.blazebit.persistence.parser.expression.SimpleCaseExpression;
import com.blazebit.persistence.parser.expression.StringLiteral;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.expression.TimeLiteral;
import com.blazebit.persistence.parser.expression.TimestampLiteral;
import com.blazebit.persistence.parser.expression.TreatExpression;
import com.blazebit.persistence.parser.expression.TrimExpression;
import com.blazebit.persistence.parser.expression.WhenClauseExpression;
import com.blazebit.persistence.parser.predicate.BooleanLiteral;
import com.blazebit.persistence.parser.util.ExpressionUtils;
import com.blazebit.persistence.spi.JpqlFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;

public class ScalarTargetResolvingExpressionVisitor
extends PathTargetResolvingExpressionVisitor {
    private final ManagedType<?> managedType;
    private final Map<String, JpqlFunction> functions;
    private boolean parametersAllowed;

    public ScalarTargetResolvingExpressionVisitor(Class<?> managedType, EntityMetamodel metamodel, Map<String, JpqlFunction> functions) {
        this(metamodel.managedType(managedType), metamodel, functions);
    }

    public ScalarTargetResolvingExpressionVisitor(ManagedType<?> managedType, EntityMetamodel metamodel, Map<String, JpqlFunction> functions) {
        super(metamodel, managedType, null);
        this.managedType = managedType;
        this.functions = functions;
        this.parametersAllowed = false;
    }

    public void clear() {
        this.reset((Type)this.managedType);
    }

    public List<TargetType> getPossibleTargetTypes() {
        List positions = this.pathPositions;
        int size = positions.size();
        if (this.managedType != null && size == 1 && ((PathTargetResolvingExpressionVisitor.PathPosition)positions.get(0)).getAttribute() == null && this.managedType.getJavaType().equals(((PathTargetResolvingExpressionVisitor.PathPosition)positions.get(0)).getRealCurrentClass())) {
            return Collections.emptyList();
        }
        ArrayList<TargetType> possibleTargets = new ArrayList<TargetType>(size);
        for (int i = 0; i < size; ++i) {
            PathTargetResolvingExpressionVisitor.PathPosition position = (PathTargetResolvingExpressionVisitor.PathPosition)positions.get(i);
            if (position.getCurrentClass() == null) continue;
            possibleTargets.add(new TargetTypeImpl(position.hasCollectionJoin(), position.getAttribute(), position.getRealCurrentClass(), position.getKeyCurrentClass(), position.getCurrentClass()));
        }
        return possibleTargets;
    }

    public void visit(GeneralCaseExpression expression) {
        List currentPositions = this.pathPositions;
        ArrayList<PathTargetResolvingExpressionVisitor.PathPosition> newPositions = new ArrayList<PathTargetResolvingExpressionVisitor.PathPosition>();
        int positionsSize = currentPositions.size();
        for (int j = 0; j < positionsSize; ++j) {
            List expressions = expression.getWhenClauses();
            int size = expressions.size();
            block1: for (int i = 0; i < size; ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
                this.pathPositions = new ArrayList();
                this.currentPosition = position;
                this.pathPositions.add(this.currentPosition);
                ((WhenClauseExpression)expressions.get(i)).accept((Expression.Visitor)this);
                for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                    if (newPosition.getCurrentClass() == null) continue;
                    newPositions.add(newPosition);
                    break block1;
                }
            }
            if (!newPositions.isEmpty() || expression.getDefaultExpr() == null) continue;
            PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
            this.pathPositions = new ArrayList();
            this.currentPosition = position;
            this.pathPositions.add(this.currentPosition);
            expression.getDefaultExpr().accept((Expression.Visitor)this);
            for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                if (newPosition.getCurrentClass() == null) continue;
                newPositions.add(newPosition);
            }
        }
        this.currentPosition = null;
        this.pathPositions = newPositions;
    }

    public void visit(ArrayExpression expression) {
        boolean wasParamsAllowed = this.parametersAllowed;
        List currentPositions = this.pathPositions;
        PathTargetResolvingExpressionVisitor.PathPosition position = this.currentPosition;
        this.parametersAllowed = true;
        this.pathPositions = new ArrayList();
        this.currentPosition = new PathTargetResolvingExpressionVisitor.PathPosition(this.managedType, null);
        this.pathPositions.add(this.currentPosition);
        expression.getIndex().accept((Expression.Visitor)this);
        this.parametersAllowed = wasParamsAllowed;
        this.currentPosition = position;
        this.pathPositions = currentPositions;
        expression.getBase().accept((Expression.Visitor)this);
        this.currentPosition.setCurrentType(this.currentPosition.getCurrentType());
    }

    public void visit(TreatExpression expression) {
        EntityType type = this.metamodel.getEntity(expression.getType());
        if (type == null) {
            throw new RuntimeException("No entity found with name \"" + expression.getType() + "\"");
        }
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType((Type)type);
    }

    public void visit(ParameterExpression expression) {
        if (this.parametersAllowed) {
            this.currentPosition.setCurrentType(null);
        } else {
            for (PathTargetResolvingExpressionVisitor.PathPosition position : this.pathPositions) {
                if (position == this.currentPosition || position.getCurrentClass() == null) continue;
                this.currentPosition.setCurrentType(null);
                return;
            }
            this.invalid(expression, "Parameters are not allowed as results in mapping. Please use @MappingParameter for this instead!");
        }
    }

    public void visit(NullExpression expression) {
        this.currentPosition.setCurrentType(null);
    }

    public void visit(ArithmeticExpression expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        }
    }

    public void visit(ArithmeticFactor expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        }
    }

    public void visit(NumericLiteral expression) {
        if (expression.getNumericType() != null) {
            this.currentPosition.setCurrentType(this.metamodel.type(expression.getNumericType().getJavaType()));
        }
    }

    public void visit(BooleanLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Boolean.class));
    }

    public void visit(StringLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(String.class));
    }

    public void visit(DateLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(TimeLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(TimestampLiteral expression) {
        this.currentPosition.setCurrentType(this.metamodel.type(Date.class));
    }

    public void visit(SubqueryExpression expression) {
        this.invalid(expression);
    }

    public void visit(ListIndexExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof ListAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.List!");
        } else {
            this.currentPosition.setAttribute((Attribute)new ListIndexAttribute((ListAttribute)this.currentPosition.getAttribute()));
            this.currentPosition.setCurrentType(this.metamodel.type(Integer.class));
        }
    }

    public void visit(MapEntryExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(this.metamodel.type(Map.Entry.class));
        }
    }

    public void visit(MapKeyExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            MapKeyAttribute keyAttribute = new MapKeyAttribute((MapAttribute)this.currentPosition.getAttribute());
            this.currentPosition.setAttribute((Attribute)keyAttribute);
            this.currentPosition.setCurrentType(keyAttribute.getType());
        }
    }

    public void visit(MapValueExpression expression) {
        expression.getPath().accept((Expression.Visitor)this);
        if (!(this.currentPosition.getAttribute() instanceof MapAttribute)) {
            this.invalid(expression, "Does not resolve to java.util.Map!");
        } else {
            this.currentPosition.setCurrentType(this.currentPosition.getCurrentType());
        }
    }

    public void visit(FunctionExpression expression) {
        String name = expression.getFunctionName();
        if ("FUNCTION".equalsIgnoreCase(name)) {
            this.resolveFirst(expression.getExpressions().subList(1, expression.getExpressions().size()), true);
            this.resolveToFunctionReturnType(((StringLiteral)expression.getExpressions().get(0)).getValue());
        } else if (ExpressionUtils.isSizeFunction((FunctionExpression)expression)) {
            this.currentPosition.setAttribute(null);
            this.currentPosition.setCurrentType(this.metamodel.type(Long.class));
        } else {
            this.resolveFirst(expression.getExpressions(), true);
            this.resolveToFunctionReturnType(name);
        }
    }

    private void resolveFirst(List<Expression> expressions, boolean allowParams) {
        List currentPositions = this.pathPositions;
        ArrayList<PathTargetResolvingExpressionVisitor.PathPosition> newPositions = new ArrayList<PathTargetResolvingExpressionVisitor.PathPosition>();
        int positionsSize = currentPositions.size();
        block0: for (int j = 0; j < positionsSize; ++j) {
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                PathTargetResolvingExpressionVisitor.PathPosition position = ((PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(j)).copy();
                this.pathPositions = new ArrayList();
                this.currentPosition = position;
                this.pathPositions.add(this.currentPosition);
                if (allowParams) {
                    this.parametersAllowed = true;
                }
                expressions.get(i).accept((Expression.Visitor)this);
                if (allowParams) {
                    this.parametersAllowed = false;
                }
                for (PathTargetResolvingExpressionVisitor.PathPosition newPosition : this.pathPositions) {
                    if (newPosition.getCurrentClass() == null) continue;
                    newPositions.add(newPosition);
                    continue block0;
                }
            }
        }
        this.currentPosition = null;
        this.pathPositions = newPositions;
    }

    private void resolveToFunctionReturnType(String functionName) {
        JpqlFunction function = this.functions.get(functionName.toLowerCase());
        if (function == null) {
            return;
        }
        List currentPositions = this.pathPositions;
        int positionsSize = currentPositions.size();
        for (int i = 0; i < positionsSize; ++i) {
            PathTargetResolvingExpressionVisitor.PathPosition position = (PathTargetResolvingExpressionVisitor.PathPosition)currentPositions.get(i);
            Class returnType = function.getReturnType(position.getCurrentClass());
            position.setAttribute(null);
            position.setCurrentType(this.metamodel.type(returnType));
        }
    }

    public void visit(TrimExpression expression) {
        this.currentPosition.setAttribute(null);
        this.currentPosition.setCurrentType(this.metamodel.type(String.class));
    }

    public void visit(SimpleCaseExpression expression) {
        this.visit((GeneralCaseExpression)expression);
    }

    public void visit(WhenClauseExpression expression) {
        expression.getResult().accept((Expression.Visitor)this);
    }

    public static class TargetTypeImpl
    implements TargetType {
        private final boolean hasCollectionJoin;
        private final Attribute<?, ?> leafMethod;
        private final Class<?> leafBaseClass;
        private final Class<?> leafBaseKeyClass;
        private final Class<?> leafBaseValueClass;

        public TargetTypeImpl(boolean hasCollectionJoin, Attribute<?, ?> leafMethod, Class<?> leafBaseClass, Class<?> leafBaseKeyClass, Class<?> leafBaseValueClass) {
            this.hasCollectionJoin = hasCollectionJoin;
            this.leafMethod = leafMethod;
            this.leafBaseClass = leafBaseClass;
            this.leafBaseKeyClass = leafBaseKeyClass;
            this.leafBaseValueClass = leafBaseValueClass;
        }

        @Override
        public boolean hasCollectionJoin() {
            return this.hasCollectionJoin;
        }

        @Override
        public Attribute<?, ?> getLeafMethod() {
            return this.leafMethod;
        }

        @Override
        public Class<?> getLeafBaseClass() {
            return this.leafBaseClass;
        }

        @Override
        public Class<?> getLeafBaseKeyClass() {
            return this.leafBaseKeyClass;
        }

        @Override
        public Class<?> getLeafBaseValueClass() {
            return this.leafBaseValueClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetTypeImpl that = (TargetTypeImpl)o;
            if (this.leafBaseClass != null ? !this.leafBaseClass.equals(that.leafBaseClass) : that.leafBaseClass != null) {
                return false;
            }
            return this.leafBaseValueClass != null ? this.leafBaseValueClass.equals(that.leafBaseValueClass) : that.leafBaseValueClass == null;
        }

        public int hashCode() {
            int result = this.leafBaseClass != null ? this.leafBaseClass.hashCode() : 0;
            result = 31 * result + (this.leafBaseValueClass != null ? this.leafBaseValueClass.hashCode() : 0);
            return result;
        }
    }

    public static interface TargetType {
        public boolean hasCollectionJoin();

        public Attribute<?, ?> getLeafMethod();

        public Class<?> getLeafBaseClass();

        public Class<?> getLeafBaseKeyClass();

        public Class<?> getLeafBaseValueClass();
    }
}

