/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.SubqueryProviderFactory;
import com.blazebit.persistence.view.impl.ParameterizedSubqueryProviderFactory;
import com.blazebit.persistence.view.impl.SimpleSubqueryProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;

public class SubqueryProviderHelper {
    private SubqueryProviderHelper() {
    }

    public static SubqueryProviderFactory getFactory(Class<? extends SubqueryProvider> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length > 1) {
            throw new IllegalArgumentException("Invalid subquery provider with more than a single constructors: " + clazz.getName());
        }
        Constructor<?> constructor = constructors[0];
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        int size = parameterAnnotations.length;
        if (size == 0) {
            return new SimpleSubqueryProviderFactory(clazz);
        }
        String[] parameterNames = new String[size];
        for (int i = 0; i < size; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            int annotationsSize = annotations.length;
            for (int j = 0; j < annotationsSize; ++j) {
                if (annotations[j].annotationType() != MappingParameter.class) continue;
                parameterNames[i] = ((MappingParameter)annotations[j]).value();
                break;
            }
            if (parameterNames[i] != null) continue;
            throw new IllegalArgumentException("Could not find any parameter mapping annotations on constructor parameter at index " + i + " of subquery provider: " + clazz.getName());
        }
        return new ParameterizedSubqueryProviderFactory(constructor, parameterNames);
    }
}

