/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionOperations;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionAddAllAction<C extends Collection<E>, E>
implements CollectionAction<C> {
    private final Collection<E> elements;

    public CollectionAddAllAction(int size, boolean allowDuplicates) {
        this.elements = allowDuplicates ? new ArrayList(size) : Collections.newSetFromMap(new IdentityHashMap(size));
    }

    public CollectionAddAllAction(E element, boolean allowDuplicates) {
        this.elements = allowDuplicates ? new ArrayList() : Collections.newSetFromMap(new IdentityHashMap());
        this.elements.add(element);
    }

    public CollectionAddAllAction(Collection<? extends E> collection, boolean allowDuplicates) {
        if (allowDuplicates) {
            this.elements = new ArrayList<E>(collection);
        } else {
            this.elements = Collections.newSetFromMap(new IdentityHashMap(collection.size()));
            this.elements.addAll(collection);
        }
    }

    private CollectionAddAllAction(CollectionAddAllAction<C, E> action) {
        if (action.elements instanceof Set) {
            this.elements = Collections.newSetFromMap(new IdentityHashMap(action.elements.size()));
            this.elements.addAll(action.elements);
        } else {
            this.elements = new ArrayList<E>(action.elements);
        }
    }

    @Override
    public void doAction(C collection, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        if (mapper != null) {
            if (collection instanceof ArrayList) {
                ((ArrayList)collection).ensureCapacity(collection.size() + this.elements.size());
            }
            for (E e : this.elements) {
                collection.add((Object)mapper.applyToEntity(context, null, e));
            }
        } else {
            collection.addAll(this.elements);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        for (E element : this.elements) {
            if (!addedObjects.contains(element)) continue;
            collection.remove(element);
        }
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        for (E element : this.elements) {
            if (element != o) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return this.elements;
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        ArrayList<Object> objects = new ArrayList<Object>(this.elements.size());
        for (E element : this.elements) {
            if (collection.contains(element)) continue;
            objects.add(element);
        }
        return objects;
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return Collections.emptyList();
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, oldElem, elem);
        if (newElements == null) {
            return null;
        }
        return new CollectionAddAllAction<C, Object>(newElements, this.elements instanceof List);
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        if (newElements == null) {
            return new CollectionAddAllAction<C, E>(this);
        }
        return new CollectionAddAllAction<C, Object>(newElements, this.elements instanceof List);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        CollectionOperations op = new CollectionOperations(actions);
        if (op.addElements(recordingCollection, this.elements)) {
            actions.add(this);
        }
        op.removeEmpty();
    }

    public void add(Object o) {
        this.elements.add(o);
    }

    public Collection<Object> onRemoveObjects(Collection<Object> objectsToRemove) {
        return RecordingUtils.compensateObjects(this.elements, objectsToRemove);
    }

    public Collection<Object> onAddObjects(Collection<Object> objectsToAdd) {
        this.elements.addAll(objectsToAdd);
        return Collections.emptyList();
    }
}

