/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.ListAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ListAddAllAction<C extends List<E>, E>
implements ListAction<C> {
    private final int index;
    private final boolean append;
    private final List<? extends E> elements;

    public ListAddAllAction(int index, boolean append, Collection<? extends E> collection) {
        this.index = index;
        this.append = append;
        this.elements = new ArrayList<E>(collection);
    }

    private ListAddAllAction(List<? extends E> collection, int index, boolean append) {
        this.index = index;
        this.elements = collection;
        this.append = append;
    }

    @Override
    public void doAction(C list, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        if (mapper != null) {
            if (list instanceof ArrayList) {
                ((ArrayList)list).ensureCapacity(list.size() + this.elements.size());
            }
            int i = this.index;
            for (E e : this.elements) {
                list.add(i++, (Object)mapper.applyToEntity(context, null, e));
            }
        } else {
            list.addAll(this.index, this.elements);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        for (int i = this.index + this.elements.size() - 1; i >= this.index; --i) {
            collection.remove(i);
        }
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        for (E element : this.elements) {
            if (element != o) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return this.elements;
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        ArrayList<Object> objects = new ArrayList<Object>(this.elements.size());
        for (E element : this.elements) {
            if (collection.contains(element)) continue;
            objects.add(element);
        }
        return objects;
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getInsertedObjectEntries() {
        if (this.append) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<Object, Integer>> list = new ArrayList<Map.Entry<Object, Integer>>(this.elements.size());
        for (int i = 0; i < this.elements.size(); ++i) {
            list.add(new AbstractMap.SimpleEntry<E, Integer>(this.elements.get(i), this.index + i));
        }
        return list;
    }

    @Override
    public List<Map.Entry<Object, Integer>> getAppendedObjectEntries() {
        if (this.append) {
            ArrayList<Map.Entry<Object, Integer>> list = new ArrayList<Map.Entry<Object, Integer>>(this.elements.size());
            for (int i = 0; i < this.elements.size(); ++i) {
                list.add(new AbstractMap.SimpleEntry<E, Integer>(this.elements.get(i), this.index + i));
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getRemovedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getTrimmedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, oldElem, elem);
        if (newElements == null) {
            return null;
        }
        return new ListAddAllAction<C, Object>(this.index, this.append, newElements);
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        if (newElements == null) {
            return new ListAddAllAction<C, E>(this.index, this.append, this.elements);
        }
        return new ListAddAllAction<C, Object>(newElements, this.index, this.append);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        actions.add(this);
    }
}

