/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.AbstractCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ListCollectionInstantiator
extends AbstractCollectionInstantiator {
    private final Set<Class<?>> allowedSubtypes;
    private final Set<Class<?>> parentRequiringUpdateSubtypes;
    private final Set<Class<?>> parentRequiringCreateSubtypes;
    private final boolean updatable;
    private final boolean indexed;
    private final boolean optimize;
    private final boolean forceUnique;
    private final boolean strictCascadingCheck;
    private final Comparator<Object> comparator;

    public ListCollectionInstantiator(PluralObjectFactory<Collection<?>> collectionFactory, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringUpdateSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean indexed, boolean optimize, boolean forceUnique, boolean strictCascadingCheck, Comparator<?> comparator) {
        super(collectionFactory);
        this.allowedSubtypes = allowedSubtypes;
        this.parentRequiringUpdateSubtypes = parentRequiringUpdateSubtypes;
        this.parentRequiringCreateSubtypes = parentRequiringCreateSubtypes;
        this.updatable = updatable;
        this.indexed = indexed;
        this.optimize = optimize;
        this.forceUnique = forceUnique;
        this.strictCascadingCheck = strictCascadingCheck;
        this.comparator = comparator;
    }

    @Override
    public boolean allowsDuplicates() {
        return true;
    }

    @Override
    public boolean requiresPostConstruct() {
        return this.forceUnique || this.comparator != null;
    }

    @Override
    public void postConstruct(Collection<?> collection) {
        ArrayList list = collection instanceof RecordingCollection ? (ArrayList)((RecordingCollection)collection).getDelegate() : (ArrayList)collection;
        if (this.forceUnique) {
            HashSet set = new HashSet(list.size());
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (set.add(o)) continue;
                iter.remove();
            }
        }
        if (this.comparator != null) {
            Collections.sort(list, this.comparator);
        }
    }

    public List<?> createCollection(int size) {
        return new ArrayList(size);
    }

    public RecordingList<?> createRecordingCollection(int size) {
        return new RecordingList(this.createCollection(size), this.indexed, this.allowedSubtypes, this.parentRequiringUpdateSubtypes, this.parentRequiringCreateSubtypes, this.updatable, this.optimize, this.strictCascadingCheck);
    }
}

