/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.ListAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ListSetAction<C extends List<E>, E>
implements ListAction<C> {
    final int index;
    final boolean last;
    final E element;
    final E removedElementInView;

    public ListSetAction(int index, boolean last, E element, List<?> delegate) {
        this.index = index;
        this.last = last;
        this.element = element;
        this.removedElementInView = delegate == null ? null : delegate.get(index);
    }

    private ListSetAction(int index, boolean last, E element, E removedElementInView) {
        this.index = index;
        this.last = last;
        this.element = element;
        this.removedElementInView = removedElementInView;
    }

    @Override
    public void doAction(C list, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        Object removedElement = mapper == null ? list.set(this.index, this.element) : list.set(this.index, (Object)mapper.applyToEntity(context, null, this.element));
        if (removeListener != null && removedElement != null) {
            removeListener.onCollectionRemove(context, this.removedElementInView);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        collection.set(this.index, this.removedElementInView);
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        return this.element == o;
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return Collections.singleton(this.element);
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return this.removedElementInView == null ? Collections.emptySet() : Collections.singleton(this.removedElementInView);
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        return Collections.singleton(this.element);
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return Collections.singleton(collection.get(this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getInsertedObjectEntries() {
        if (this.last) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.element, this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getAppendedObjectEntries() {
        if (this.last) {
            return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.element, this.index));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getRemovedObjectEntries() {
        if (this.last) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.removedElementInView, this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getTrimmedObjectEntries() {
        if (this.last) {
            return Collections.singletonList(new AbstractMap.SimpleEntry<E, Integer>(this.removedElementInView, this.index));
        }
        return Collections.emptyList();
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        if (this.element == oldElem) {
            if (this.removedElementInView == oldElem) {
                return new ListSetAction<C, Object>(this.index, this.last, elem, elem);
            }
            return new ListSetAction<C, Object>(this.index, this.last, elem, this.removedElementInView);
        }
        if (this.removedElementInView == oldElem) {
            return new ListSetAction<C, Object>(this.index, this.last, this.element, elem);
        }
        return null;
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Object newElement = objectMapping.get(this.element);
        Object newRemovedElement = objectMapping.get(this.removedElementInView);
        if (newElement == null && newRemovedElement == null) {
            return this;
        }
        if (newElement == null) {
            newElement = this.element;
        }
        if (newRemovedElement == null) {
            newRemovedElement = this.removedElementInView;
        }
        return new ListSetAction<C, Object>(this.index, this.last, newElement, newRemovedElement);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        CollectionAction<C> lastAction;
        if (!actions.isEmpty() && (lastAction = actions.get(actions.size() - 1)) instanceof ListSetAction && this.index == ((ListSetAction)lastAction).index) {
            actions.set(actions.size() - 1, new ListSetAction<C, E>(this.index, this.last, this.element, ((ListSetAction)lastAction).removedElementInView));
            return;
        }
        actions.add(this);
    }
}

