/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.MapRemoveAllKeysAction;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapRemoveAllEntriesAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final Collection<Map.Entry<K, V>> elements;
    private final Map<K, V> removedObjectsInView;

    public MapRemoveAllEntriesAction(Map.Entry<K, V> entry, Map<K, V> delegate) {
        this((Collection<Map.Entry<K, V>>)new ArrayList<Map.Entry<K, V>>(Collections.singleton(entry)), delegate);
    }

    public MapRemoveAllEntriesAction(Collection<Map.Entry<K, V>> elements, Map<K, V> delegate) {
        this.elements = elements;
        this.removedObjectsInView = new LinkedHashMap(elements.size());
        for (Map.Entry<K, V> entry : elements) {
            V oldValue = delegate.get(entry.getKey());
            if (oldValue == null) continue;
            this.removedObjectsInView.put(entry.getKey(), oldValue);
        }
    }

    private MapRemoveAllEntriesAction(List<Map.Entry<K, V>> elements, Map<K, V> removedObjectsInView) {
        this.elements = elements;
        this.removedObjectsInView = removedObjectsInView;
    }

    public static <C extends Map<K, V>, K, V> MapRemoveAllKeysAction<C, K, V> retainAll(Collection<?> c, C delegate) {
        int size = c.size() >= delegate.size() ? delegate.size() : delegate.size() - c.size();
        LinkedHashMap<K, V> removedObjectsInView = new LinkedHashMap<K, V>(size);
        for (Map.Entry<K, V> entry : delegate.entrySet()) {
            if (c.contains(entry)) continue;
            removedObjectsInView.put(entry.getKey(), entry.getValue());
        }
        return new MapRemoveAllKeysAction(new ArrayList(removedObjectsInView.entrySet()), removedObjectsInView);
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        if (mapper != null) {
            Set entrySet = map.entrySet();
            ViewToEntityMapper keyMapper = mapper.getKeyMapper();
            ViewToEntityMapper valueMapper = mapper.getValueMapper();
            for (Map.Entry<K, V> entry : this.elements) {
                AbstractMap.SimpleEntry<K, V> e;
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (keyMapper != null) {
                    k = keyMapper.applyToEntity(context, null, k);
                }
                if (valueMapper != null) {
                    v = valueMapper.applyToEntity(context, null, v);
                }
                if (!entrySet.remove(e = new AbstractMap.SimpleEntry<K, V>(k, v))) continue;
                if (keyRemoveListener != null && k != null) {
                    keyRemoveListener.onCollectionRemove(context, entry.getKey());
                }
                if (valueRemoveListener == null || v == null) continue;
                valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(entry.getKey()));
            }
        } else if (map.size() > 0 && (keyRemoveListener != null || valueRemoveListener != null)) {
            Set entrySet = map.entrySet();
            for (Map.Entry<K, V> e : this.elements) {
                if (!entrySet.remove(e)) continue;
                K k = e.getKey();
                V v = e.getValue();
                if (keyRemoveListener != null && k != null) {
                    keyRemoveListener.onCollectionRemove(context, k);
                }
                if (valueRemoveListener == null || v == null) continue;
                valueRemoveListener.onCollectionRemove(context, this.removedObjectsInView.get(k));
            }
        } else {
            map.entrySet().removeAll(this.elements);
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        for (Map.Entry<K, V> entry : this.removedObjectsInView.entrySet()) {
            if (!removedKeys.contains(entry.getKey()) && !removedElements.contains(entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return this.removedObjectsInView.keySet();
    }

    @Override
    public Collection<Object> getAddedElements() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements() {
        return this.removedObjectsInView.values();
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        ArrayList<Object> list = new ArrayList<Object>(this.elements.size());
        for (Map.Entry<K, V> entry : this.elements) {
            K k = entry.getKey();
            if (k == null) continue;
            list.add(k);
        }
        return list;
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        ArrayList<Object> list = new ArrayList<Object>(this.elements.size());
        for (Map.Entry<K, V> entry : this.elements) {
            V v = entry.getValue();
            if (v == null) continue;
            list.add(v);
        }
        return list;
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        List<Map.Entry<K, V>> newElements = RecordingUtils.replaceEntries(this.elements, oldKey, oldValue, newKey, newValue);
        if (newElements == null) {
            return null;
        }
        return new MapRemoveAllEntriesAction<C, K, V>(newElements, this.removedObjectsInView);
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        List<Map.Entry<K, V>> newElements = RecordingUtils.replaceEntries(this.elements, objectMapping);
        Map<Object, Object> newRemovedObjectsInView = RecordingUtils.replaceElements(this.removedObjectsInView, objectMapping);
        if (newElements != null) {
            if (newRemovedObjectsInView == null) {
                return new MapRemoveAllEntriesAction<C, K, V>(newElements, this.removedObjectsInView);
            }
            return new MapRemoveAllEntriesAction<C, Object, Object>(newElements, newRemovedObjectsInView);
        }
        if (newRemovedObjectsInView != null) {
            return new MapRemoveAllEntriesAction<C, Object, Object>(this.elements, newRemovedObjectsInView);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

