/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.RecordingUtils;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapRemoveAllValuesAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final Collection<?> elements;
    private final Map<K, V> removedObjectsInView;

    public MapRemoveAllValuesAction(Object o, Map<K, V> delegate) {
        this((Collection<?>)new ArrayList<Object>(Collections.singletonList(o)), delegate);
    }

    public MapRemoveAllValuesAction(Collection<?> elements, Map<K, V> delegate) {
        this.elements = elements;
        this.removedObjectsInView = new LinkedHashMap(elements.size());
        for (Map.Entry<K, V> entry : delegate.entrySet()) {
            if (!elements.contains(entry.getValue())) continue;
            this.removedObjectsInView.put(entry.getKey(), entry.getValue());
        }
    }

    private MapRemoveAllValuesAction(List<?> elements, Map<K, V> removedObjectsInView) {
        this.elements = elements;
        this.removedObjectsInView = removedObjectsInView;
    }

    public static <C extends Map<K, V>, K, V> MapRemoveAllValuesAction<C, K, V> retainAll(Collection<?> c, C delegate) {
        int size = c.size() >= delegate.size() ? delegate.size() : delegate.size() - c.size();
        LinkedHashMap<K, V> removedObjectsInView = new LinkedHashMap<K, V>(size);
        for (Map.Entry<K, V> entry : delegate.entrySet()) {
            if (c.contains(entry.getValue())) continue;
            removedObjectsInView.put(entry.getKey(), entry.getValue());
        }
        return new MapRemoveAllValuesAction(new ArrayList(removedObjectsInView.values()), removedObjectsInView);
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        if (mapper != null && mapper.getValueMapper() != null) {
            for (Object e : this.elements) {
                Object value = mapper.getValueMapper().applyToEntity(context, null, e);
                this.removeByValue(context, map, e, value, keyRemoveListener, valueRemoveListener);
            }
        } else if (map.size() > 0 && (keyRemoveListener != null || valueRemoveListener != null)) {
            for (Object e : this.elements) {
                this.removeByValue(context, map, e, e, keyRemoveListener, valueRemoveListener);
            }
        } else {
            map.values().removeAll(this.elements);
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        for (Map.Entry<K, V> entry : this.removedObjectsInView.entrySet()) {
            if (!removedKeys.contains(entry.getKey()) && !removedElements.contains(entry.getValue())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    private void removeByValue(UpdateContext context, C map, Object originalValue, V value, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!value.equals(v)) continue;
            if (keyRemoveListener != null) {
                keyRemoveListener.onCollectionRemove(context, k);
            }
            if (valueRemoveListener == null) continue;
            valueRemoveListener.onCollectionRemove(context, originalValue);
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return this.removedObjectsInView.keySet();
    }

    @Override
    public Collection<Object> getAddedElements() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements() {
        return this.removedObjectsInView.values();
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        ArrayList<Object> removedObjects = new ArrayList<Object>(collection.size());
        for (Map.Entry entry : collection.entrySet()) {
            if (!this.elements.contains(entry.getValue())) continue;
            removedObjects.add(entry.getKey());
        }
        return removedObjects;
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        ArrayList<Object> removedObjects = new ArrayList<Object>(collection.size());
        for (Map.Entry entry : collection.entrySet()) {
            if (!this.elements.contains(entry.getValue())) continue;
            removedObjects.add(entry.getKey());
        }
        return removedObjects;
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, oldValue, newValue);
        if (newElements == null) {
            return null;
        }
        return new MapRemoveAllValuesAction<C, K, V>(newElements, this.removedObjectsInView);
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        List<Object> newElements = RecordingUtils.replaceElements(this.elements, objectMapping);
        Map<Object, Object> newRemovedObjectsInView = RecordingUtils.replaceElements(this.removedObjectsInView, objectMapping);
        if (newElements != null) {
            if (newRemovedObjectsInView == null) {
                return new MapRemoveAllValuesAction<C, K, V>(newElements, this.removedObjectsInView);
            }
            return new MapRemoveAllValuesAction<C, Object, Object>(newElements, newRemovedObjectsInView);
        }
        if (newRemovedObjectsInView != null) {
            return new MapRemoveAllValuesAction<C, Object, Object>(this.elements, newRemovedObjectsInView);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

