/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiCollection<E>
extends AbstractCollection<E> {
    private final Collection<E>[] collections;

    public MultiCollection(Collection<E> ... collections) {
        this.collections = collections;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> c : this.collections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> c : this.collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> c : this.collections) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int cursor = -1;
            Iterator<E> iter;

            @Override
            public boolean hasNext() {
                if (this.iter != null && this.iter.hasNext()) {
                    return true;
                }
                for (int i = this.cursor + 1; i < MultiCollection.this.collections.length; ++i) {
                    if (MultiCollection.this.collections[i].isEmpty()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.iter != null && this.iter.hasNext()) {
                    return this.iter.next();
                }
                for (int i = ++this.cursor; i < MultiCollection.this.collections.length; ++i) {
                    if (MultiCollection.this.collections[i].isEmpty()) continue;
                    this.iter = MultiCollection.this.collections[i].iterator();
                    return this.iter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

