/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionAddAllAction;
import com.blazebit.persistence.view.impl.collection.CollectionClearAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveAllAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.RecordingIterator;
import com.blazebit.persistence.view.impl.collection.RecordingReplacingIterator;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.DirtyTracker;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class RecordingCollection<C extends Collection<E>, E>
implements Collection<E>,
DirtyTracker,
Serializable {
    private static final long[] DIRTY_MARKER = new long[0];
    protected final C delegate;
    protected final Set<Class<?>> allowedSubtypes;
    protected final Set<Class<?>> parentRequiringUpdateSubtypes;
    protected final Set<Class<?>> parentRequiringCreateSubtypes;
    protected final boolean updatable;
    protected final boolean indexed;
    private final boolean ordered;
    private final boolean optimize;
    private final boolean hashBased;
    private final boolean strictCascadingCheck;
    private BasicDirtyTracker parent;
    private int parentIndex;
    private boolean dirty;
    private List<CollectionAction<C>> actions;
    private Map<E, E> addedElements;
    private Map<E, E> removedElements;
    private transient RecordingReplacingIterator<E> currentIterator;

    protected RecordingCollection(C delegate, boolean indexed, boolean ordered, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringUpdateSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean optimize, boolean hashBased, boolean strictCascadingCheck) {
        this.delegate = delegate;
        this.allowedSubtypes = allowedSubtypes;
        this.parentRequiringUpdateSubtypes = parentRequiringUpdateSubtypes;
        this.parentRequiringCreateSubtypes = parentRequiringCreateSubtypes;
        this.updatable = updatable;
        this.indexed = indexed;
        this.ordered = ordered;
        this.optimize = optimize;
        this.hashBased = hashBased;
        this.strictCascadingCheck = strictCascadingCheck;
    }

    public RecordingCollection(C delegate, boolean indexed, boolean ordered, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringUpdateSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean optimize, boolean strictCascadingCheck) {
        this.delegate = delegate;
        this.allowedSubtypes = allowedSubtypes;
        this.parentRequiringUpdateSubtypes = parentRequiringUpdateSubtypes;
        this.parentRequiringCreateSubtypes = parentRequiringCreateSubtypes;
        this.updatable = updatable;
        this.indexed = indexed;
        this.ordered = ordered;
        this.optimize = optimize;
        this.strictCascadingCheck = strictCascadingCheck;
        this.hashBased = false;
    }

    public boolean $$_isDirty() {
        return this.dirty;
    }

    @Override
    public boolean $$_isDirty(int attributeIndex) {
        return this.dirty;
    }

    @Override
    public <T> boolean $$_copyDirty(T[] source, T[] target) {
        if (this.dirty) {
            target[0] = source[0];
            return true;
        }
        return false;
    }

    @Override
    public void $$_setDirty(long[] dirty) {
        this.dirty = dirty != null;
    }

    @Override
    public long[] $$_resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            return DIRTY_MARKER;
        }
        return null;
    }

    @Override
    public long[] $$_getDirty() {
        if (this.dirty) {
            return DIRTY_MARKER;
        }
        return null;
    }

    @Override
    public long $$_getSimpleDirty() {
        if (this.dirty) {
            return 1L;
        }
        return 0L;
    }

    public void $$_markDirty(int attributeIndex) {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.$$_markDirty(this.parentIndex);
        }
    }

    public void $$_unmarkDirty() {
        this.dirty = false;
    }

    public void $$_setParent(BasicDirtyTracker parent, int parentIndex) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent object for " + this.toString() + " is already set to " + this.parent.toString() + " and can't be set to:" + parent.toString());
        }
        this.parent = parent;
        this.parentIndex = parentIndex;
        for (Object e : this.delegate) {
            if (!(e instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)e).$$_setParent((BasicDirtyTracker)this, 1);
        }
    }

    public boolean $$_hasParent() {
        return this.parent != null;
    }

    @Override
    public void $$_replaceAttribute(Object oldObject, int attributeIndex, Object newObject) {
        if (oldObject instanceof MutableStateTrackable) {
            ((MutableStateTrackable)oldObject).$$_removeReadOnlyParent(this, attributeIndex);
        }
        if (newObject instanceof MutableStateTrackable) {
            ((MutableStateTrackable)newObject).$$_addReadOnlyParent(this, attributeIndex);
        }
        if (this.currentIterator != null && this.currentIterator.getCurrent() == oldObject) {
            return;
        }
        if (newObject == null) {
            this.delegate.remove(oldObject);
        } else if (this.ordered) {
            ArrayList<Object> newCollection = new ArrayList<Object>(this.delegate.size());
            for (Object e : this.delegate) {
                if (e == oldObject) {
                    newCollection.add(newObject);
                    continue;
                }
                newCollection.add(e);
            }
            this.delegate.clear();
            this.delegate.addAll(newCollection);
        } else {
            this.delegate.remove(oldObject);
            this.delegate.add((Object)newObject);
        }
    }

    public void $$_unsetParent() {
        this.parentIndex = 0;
        this.parent = null;
        for (Object e : this.delegate) {
            if (!(e instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)e).$$_unsetParent();
        }
    }

    public boolean isHashBased() {
        return this.hashBased;
    }

    public RecordingReplacingIterator<E> getCurrentIterator() {
        return this.currentIterator;
    }

    public RecordingReplacingIterator<E> recordingIterator() {
        if (this.currentIterator != null) {
            throw new IllegalStateException("Multiple concurrent invocations for recording iterator!");
        }
        this.currentIterator = new RecordingReplacingIterator(this);
        return this.currentIterator;
    }

    public void resetRecordingIterator() {
        if (this.currentIterator == null) {
            throw new IllegalStateException("Multiple concurrent invocations for recording iterator!");
        }
        this.currentIterator.reset();
        this.currentIterator = null;
    }

    public C getDelegate() {
        return this.delegate;
    }

    public boolean hasActions() {
        return this.actions != null && this.actions.size() > 0;
    }

    public List<CollectionAction<C>> getActions() {
        return this.actions;
    }

    public Set<E> getAddedElements() {
        if (this.addedElements == null) {
            return Collections.emptySet();
        }
        return this.addedElements.keySet();
    }

    public Set<E> getRemovedElements() {
        if (this.removedElements == null) {
            return Collections.emptySet();
        }
        return this.removedElements.keySet();
    }

    void addAddedElement(Object o) {
        if (this.removedElements.remove(o) == null) {
            this.addedElements.put(o, o);
        }
        if (this.parent != null && o instanceof BasicDirtyTracker) {
            ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 1);
        }
    }

    void addRemovedElement(Object o) {
        if (this.addedElements.remove(o) == null) {
            this.removedElements.put(o, o);
        }
        if (o instanceof BasicDirtyTracker) {
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
    }

    public void setActions(RecordingCollection<C, E> recordingCollection, Map<Object, Object> objectMapping) {
        if (recordingCollection.actions == null) {
            this.actions = null;
            this.addedElements = null;
            this.removedElements = null;
        } else {
            Object newElement;
            this.actions = new ArrayList<CollectionAction<C>>(recordingCollection.actions.size());
            this.addedElements = new IdentityHashMap<E, E>(recordingCollection.addedElements.size());
            this.removedElements = new IdentityHashMap<E, E>(recordingCollection.removedElements.size());
            for (CollectionAction<C> action : recordingCollection.actions) {
                this.actions.add(action.replaceObjects(objectMapping));
            }
            for (CollectionAction<Object> e : recordingCollection.addedElements.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.addedElements.put(e, e);
                    continue;
                }
                this.addedElements.put(newElement, newElement);
            }
            for (CollectionAction<Object> e : recordingCollection.removedElements.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.removedElements.put(e, e);
                    continue;
                }
                this.removedElements.put(newElement, newElement);
            }
        }
        if (recordingCollection.dirty) {
            this.$$_markDirty(-1);
        }
    }

    public void setActions(List<CollectionAction<C>> actions, Map<E, E> addedElements, Map<E, E> removedElements) {
        this.actions = actions;
        this.addedElements = addedElements;
        this.removedElements = removedElements;
        if (this.ordered) {
            ArrayList objects = new ArrayList(this.delegate.size());
            for (Object elem : this.delegate) {
                for (E oldElem : addedElements.keySet()) {
                    if (!oldElem.equals(elem) || elem == oldElem) continue;
                    if (elem instanceof DirtyTracker) {
                        ((DirtyTracker)elem).$$_unsetParent();
                    }
                    if (oldElem instanceof DirtyTracker) {
                        ((DirtyTracker)oldElem).$$_setParent(this, 1);
                    }
                    elem = oldElem;
                    break;
                }
                objects.add(elem);
            }
            this.delegate.clear();
            this.delegate.addAll(objects);
        } else {
            Iterator iterator = this.delegate.iterator();
            block2: while (iterator.hasNext()) {
                Object elem = iterator.next();
                for (E oldElem : addedElements.keySet()) {
                    if (!oldElem.equals(elem) || elem == oldElem) continue;
                    if (elem instanceof DirtyTracker) {
                        ((DirtyTracker)elem).$$_unsetParent();
                    }
                    if (oldElem instanceof DirtyTracker) {
                        ((DirtyTracker)oldElem).$$_setParent(this, 1);
                    }
                    iterator.remove();
                    continue block2;
                }
            }
            this.delegate.addAll(addedElements.keySet());
        }
        this.$$_markDirty(-1);
    }

    protected C copyDelegate() {
        if (this.ordered) {
            if (this.hashBased) {
                return (C)new LinkedHashSet(this.delegate);
            }
            return (C)new ArrayList(this.delegate);
        }
        if (this.hashBased) {
            return (C)new HashSet(this.delegate);
        }
        return (C)new ArrayList(this.delegate);
    }

    public C getInitialVersion() {
        if (this.actions == null || this.actions.isEmpty()) {
            return (C)this;
        }
        C collection = this.copyDelegate();
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            CollectionAction<C> action = this.actions.get(i);
            action.undo(collection, this.removedElements.keySet(), this.addedElements.keySet());
        }
        return collection;
    }

    public List<CollectionAction<C>> resetActions(UpdateContext context) {
        List<CollectionAction<C>> oldActions = this.actions;
        if (oldActions == null) {
            return Collections.emptyList();
        }
        Map<E, E> addedElements = this.addedElements;
        Map<E, E> removedElements = this.removedElements;
        this.actions = null;
        this.dirty = false;
        this.addedElements = null;
        this.removedElements = null;
        context.getInitialStateResetter().addRecordingCollection(this, oldActions, addedElements, removedElements);
        return oldActions;
    }

    public void initiateActionsAgainstState(List<CollectionAction<C>> actions, C initialState) {
        IdentityHashMap<E, E> addedElements = new IdentityHashMap<E, E>();
        IdentityHashMap<E, E> removedElements = new IdentityHashMap<E, E>();
        for (CollectionAction<C> action : actions) {
            if (action instanceof CollectionClearAction) {
                for (Object o : initialState) {
                    removedElements.put(o, o);
                }
                continue;
            }
            for (Object o : action.getAddedObjects()) {
                if (removedElements.remove(o) != null) continue;
                addedElements.put(o, o);
            }
            for (Object o : action.getRemovedObjects()) {
                if (addedElements.remove(o) != null) continue;
                removedElements.put(o, o);
            }
        }
        this.actions = actions;
        this.dirty = true;
        this.addedElements = addedElements;
        this.removedElements = removedElements;
        for (CollectionAction<Object> o : removedElements.keySet()) {
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
    }

    protected boolean allowDuplicates() {
        return true;
    }

    protected final void addAction(CollectionAction<C> action) {
        if (!this.updatable) {
            throw new UnsupportedOperationException("Collection is not updatable. Only it's elements are mutable! Consider annotating @UpdatableMapping if you want the collection role to be updatable!");
        }
        Collection<Object> addedElements = action.getAddedObjects();
        Collection<Object> removedElements = action.getRemovedObjects();
        if (removedElements.isEmpty() && !addedElements.isEmpty() && !this.allowDuplicates() && addedElements.removeAll((Collection<?>)this.delegate) && addedElements.isEmpty()) {
            return;
        }
        if (this.actions == null) {
            this.actions = new ArrayList<CollectionAction<C>>();
            this.addedElements = new IdentityHashMap<E, E>();
            this.removedElements = new IdentityHashMap<E, E>();
        }
        if (this.optimize) {
            action.addAction(this, this.actions);
        } else {
            this.actions.add(action);
        }
        for (Object o : addedElements) {
            if (this.removedElements.remove(o) == null) {
                if (this.addedElements.put(o, o) != null || this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
                ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 1);
                continue;
            }
            if (this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 1);
        }
        for (Object o : removedElements) {
            if (this.addedElements.remove(o) == null) {
                if (this.removedElements.put(o, o) != null || !(o instanceof BasicDirtyTracker)) continue;
                ((BasicDirtyTracker)o).$$_unsetParent();
                continue;
            }
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
        this.$$_markDirty(-1);
    }

    public void replay(C collection, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        if (this.actions != null) {
            for (CollectionAction<C> action : this.resetActions(context)) {
                action.doAction(collection, context, mapper, removeListener);
            }
        }
    }

    public void replaceActionElement(Object oldElem, Object elem) {
        if (this.actions != null && oldElem != elem) {
            ListIterator<CollectionAction<C>> iter = this.actions.listIterator();
            while (iter.hasNext()) {
                CollectionAction<C> action = iter.next();
                CollectionAction<C> newAction = action.replaceObject(oldElem, elem);
                if (newAction == null) continue;
                iter.set(newAction);
            }
        }
    }

    protected void checkType(Object e, String action) {
        if (e != null && !this.allowedSubtypes.isEmpty()) {
            boolean isNew;
            Class c;
            if (e instanceof EntityViewProxy) {
                c = ((EntityViewProxy)e).$$_getEntityViewClass();
                isNew = ((EntityViewProxy)e).$$_isNew();
            } else {
                c = e.getClass();
                isNew = false;
            }
            if (!this.allowedSubtypes.contains(c)) {
                throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed!");
            }
            if (this.strictCascadingCheck) {
                if (e != this.parent && !isNew && this.parentRequiringUpdateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that update cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false");
                }
                if (e != this.parent && isNew && this.parentRequiringCreateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that persist cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false");
                }
            }
        }
    }

    protected void checkType(Collection<?> collection, String action) {
        if (collection != null && !collection.isEmpty() && !this.allowedSubtypes.isEmpty()) {
            for (Object e : collection) {
                boolean isNew;
                Class c;
                if (e instanceof EntityViewProxy) {
                    c = ((EntityViewProxy)e).$$_getEntityViewClass();
                    isNew = ((EntityViewProxy)e).$$_isNew();
                } else {
                    c = e.getClass();
                    isNew = false;
                }
                if (!this.allowedSubtypes.contains(c)) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed!");
                }
                if (!this.strictCascadingCheck) continue;
                if (!isNew && this.parentRequiringUpdateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that update cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE })");
                }
                if (!isNew || !this.parentRequiringCreateSubtypes.contains(c) || ((DirtyTracker)e).$$_hasParent()) continue;
                throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that persist cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST })");
            }
        }
    }

    void addAddAction(E e) {
        this.addAction(new CollectionAddAllAction(e, this.allowDuplicates()));
    }

    @Override
    public boolean add(E e) {
        this.checkType(e, "Adding");
        this.addAddAction(e);
        return this.delegate.add(e);
    }

    void addRemoveAction(Object o) {
        this.addAction(new CollectionRemoveAllAction(o, this.allowDuplicates()));
    }

    @Override
    public boolean remove(Object o) {
        this.checkType(o, "Removing");
        this.addRemoveAction(o);
        return this.delegate.remove(o);
    }

    void addAddAllAction(Collection<? extends E> c) {
        this.addAction(new CollectionAddAllAction(c, this.allowDuplicates()));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.checkType(c, "Adding");
        this.addAddAllAction(c);
        return this.delegate.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkType(c, "Removing");
        this.addAction(new CollectionRemoveAllAction(c, this.allowDuplicates()));
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.addAction(CollectionRemoveAllAction.retainAll(c, this.delegate, this.allowDuplicates()));
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.addAction(new CollectionRemoveAllAction((Collection<?>)this.delegate, this.allowDuplicates()));
        this.delegate.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return new RecordingIterator(this);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

