/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RecordingEntrySetReplacingIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final RecordingMap<Map<K, V>, K, V> recordingMap;
    private final Iterator<Map.Entry<K, V>> iterator;
    private MutableEntry<K, V> current;
    private Map<K, V> replacedElements;

    public RecordingEntrySetReplacingIterator(RecordingMap<? extends Map<K, V>, K, V> recordingMap) {
        this.recordingMap = recordingMap;
        this.iterator = recordingMap.delegate.entrySet().iterator();
        this.current = new MutableEntry();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this.replacedElements != null) {
            Map.Entry<K, V> entry = this.iterator.next();
            this.current.key = entry.getKey();
            this.current.value = entry.getValue();
            this.replacedElements.put(entry.getKey(), entry.getValue());
            this.iterator.remove();
            return entry;
        }
        Map.Entry<K, V> entry = this.iterator.next();
        this.current.key = entry.getKey();
        this.current.value = entry.getValue();
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public V replace() {
        if (this.replacedElements == null) {
            this.replacedElements = new LinkedHashMap();
            V old = this.recordingMap.get(this.current.key);
            this.iterator.remove();
            return old;
        }
        return this.replacedElements.remove(this.current.key);
    }

    public void replaceValue(Set<Object> removedKeys) {
        if (this.replacedElements == null) {
            this.replacedElements = new LinkedHashMap();
            removedKeys.add(this.current.key);
            this.iterator.remove();
        } else {
            removedKeys.add(this.current.key);
            this.replacedElements.remove(this.current.key);
        }
    }

    public void reset() {
        if (this.replacedElements != null) {
            Map<K, V> delegate = this.recordingMap.getDelegate();
            if (this.replacedElements.isEmpty() || this.current.value != this.replacedElements.get(this.current.key)) {
                delegate.put(this.current.key, this.current.value);
            }
            delegate.putAll(this.replacedElements);
        }
    }

    public void add(K key, V value) {
        if (this.replacedElements != null) {
            this.replacedElements.put(key, value);
            this.current.key = null;
            this.current.value = null;
        }
    }

    public V getCurrent() {
        return this.current.value;
    }

    private static final class MutableEntry<K, V> {
        K key;
        V value;

        private MutableEntry() {
        }
    }
}

