/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.ListAddAction;
import com.blazebit.persistence.view.impl.collection.ListAddAllAction;
import com.blazebit.persistence.view.impl.collection.ListRemoveAction;
import com.blazebit.persistence.view.impl.collection.ListSetAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingListIterator;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class RecordingList<E>
extends RecordingCollection<List<E>, E>
implements List<E> {
    public RecordingList(List<E> delegate, boolean indexed, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean optimize, boolean strictCascadingCheck) {
        super(delegate, indexed, indexed, allowedSubtypes, parentRequiringSubtypes, parentRequiringCreateSubtypes, updatable, optimize, strictCascadingCheck);
    }

    @Override
    void addAddAction(E e) {
        this.addAddAction(this.size(), e);
    }

    @Override
    void addRemoveAction(Object o) {
        if (this.indexed) {
            this.addRemoveAction(this.indexOf(o));
        } else {
            super.addRemoveAction(o);
        }
    }

    @Override
    void addAddAllAction(Collection<? extends E> c) {
        this.addAddAllAction(this.size(), c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.indexed) {
            this.checkType(c, "Removing");
            boolean modified = false;
            for (Object o : c) {
                if (this.remove(this.indexOf(o)) == null) continue;
                modified = true;
            }
            return modified;
        }
        return super.removeAll(c);
    }

    @Override
    public void clear() {
        int size = ((List)this.delegate).size();
        for (int i = size - 1; i >= 0; --i) {
            this.addRemoveAction(i);
        }
        ((List)this.delegate).clear();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.indexed) {
            boolean modified = false;
            ListIterator<E> it = this.listIterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
        return super.retainAll(c);
    }

    void addAddAllAction(int index, Collection<? extends E> c) {
        if (this.indexed) {
            this.addAction(new ListAddAllAction(index, ((List)this.delegate).size() == index, c));
        } else {
            this.addAddAllAction(c);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.checkType(c, "Adding");
        this.addAddAllAction(index, c);
        return ((List)this.delegate).addAll(index, c);
    }

    void addSetAction(int index, E element) {
        if (this.indexed) {
            this.addAction(new ListSetAction(index, ((List)this.delegate).size() == index - 1, (List)element, (List)this.delegate));
        } else {
            this.addRemoveAction(index);
            this.addAddAction(element);
        }
    }

    @Override
    public E set(int index, E element) {
        this.checkType(element, "Setting");
        this.addSetAction(index, element);
        return ((List)this.delegate).set(index, element);
    }

    void addAddAction(int index, E element) {
        if (this.indexed) {
            this.addAction(new ListAddAction(index, ((List)this.delegate).size() == index, element));
        } else {
            super.addAddAction(element);
        }
    }

    @Override
    public void add(int index, E element) {
        this.checkType(element, "Adding");
        this.addAddAction(index, element);
        ((List)this.delegate).add(index, element);
    }

    void addRemoveAction(int index) {
        if (this.indexed) {
            this.addAction(new ListRemoveAction(index, index == ((List)this.delegate).size() - 1, (List)this.delegate));
        } else {
            this.addRemoveAction(((List)this.delegate).get(index));
        }
    }

    @Override
    public E remove(int index) {
        this.addRemoveAction(index);
        return ((List)this.delegate).remove(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new RecordingListIterator(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new RecordingListIterator(this, index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        final List subDelegate = ((List)this.delegate).subList(fromIndex, toIndex);
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return subDelegate.get(index);
            }

            @Override
            public boolean contains(Object o) {
                return subDelegate.contains(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return subDelegate.containsAll(c);
            }

            @Override
            public int indexOf(Object o) {
                return subDelegate.indexOf(o);
            }

            @Override
            public int lastIndexOf(Object o) {
                return subDelegate.lastIndexOf(o);
            }

            @Override
            public int size() {
                return subDelegate.size();
            }

            @Override
            public Object[] toArray() {
                return subDelegate.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return subDelegate.toArray(a);
            }
        };
    }

    @Override
    public E get(int index) {
        return ((List)this.delegate).get(index);
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.delegate).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.delegate).lastIndexOf(o);
    }
}

