/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.collection.MapClearAction;
import com.blazebit.persistence.view.impl.collection.MapPutAction;
import com.blazebit.persistence.view.impl.collection.MapPutAllAction;
import com.blazebit.persistence.view.impl.collection.MapRemoveAction;
import com.blazebit.persistence.view.impl.collection.MapRemoveAllKeysAction;
import com.blazebit.persistence.view.impl.collection.RecordingEntrySet;
import com.blazebit.persistence.view.impl.collection.RecordingEntrySetReplacingIterator;
import com.blazebit.persistence.view.impl.collection.RecordingKeySet;
import com.blazebit.persistence.view.impl.collection.RecordingValuesCollection;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.proxy.DirtyTracker;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.spi.type.BasicDirtyTracker;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RecordingMap<C extends Map<K, V>, K, V>
implements Map<K, V>,
DirtyTracker,
Serializable {
    private static final long[] DIRTY_MARKER = new long[0];
    protected final C delegate;
    protected final Set<Class<?>> allowedSubtypes;
    protected final Set<Class<?>> parentRequiringUpdateSubtypes;
    protected final Set<Class<?>> parentRequiringCreateSubtypes;
    protected final boolean updatable;
    private final boolean optimize;
    private final boolean hashBased;
    private final boolean ordered;
    private final boolean strictCascadingCheck;
    private BasicDirtyTracker parent;
    private int parentIndex;
    private boolean dirty;
    private List<MapAction<C>> actions;
    private Map<K, K> addedKeys;
    private Map<K, K> removedKeys;
    private Map<V, V> addedElements;
    private Map<V, V> removedElements;
    private transient RecordingEntrySetReplacingIterator<K, V> currentIterator;

    protected RecordingMap(C delegate, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringUpdateSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean optimize, boolean hashBased, boolean ordered, boolean strictCascadingCheck) {
        this.delegate = delegate;
        this.allowedSubtypes = allowedSubtypes;
        this.parentRequiringUpdateSubtypes = parentRequiringUpdateSubtypes;
        this.parentRequiringCreateSubtypes = parentRequiringCreateSubtypes;
        this.updatable = updatable;
        this.optimize = optimize;
        this.hashBased = hashBased;
        this.ordered = ordered;
        this.strictCascadingCheck = strictCascadingCheck;
    }

    public RecordingMap(C delegate, boolean ordered, Set<Class<?>> allowedSubtypes, Set<Class<?>> parentRequiringUpdateSubtypes, Set<Class<?>> parentRequiringCreateSubtypes, boolean updatable, boolean optimize, boolean strictCascadingCheck) {
        this.delegate = delegate;
        this.allowedSubtypes = allowedSubtypes;
        this.parentRequiringUpdateSubtypes = parentRequiringUpdateSubtypes;
        this.parentRequiringCreateSubtypes = parentRequiringCreateSubtypes;
        this.updatable = updatable;
        this.optimize = optimize;
        this.ordered = ordered;
        this.strictCascadingCheck = strictCascadingCheck;
        this.hashBased = true;
    }

    public boolean $$_isDirty() {
        return this.dirty;
    }

    @Override
    public boolean $$_isDirty(int attributeIndex) {
        return this.dirty;
    }

    @Override
    public <T> boolean $$_copyDirty(T[] source, T[] target) {
        if (this.dirty) {
            target[0] = source[0];
            return true;
        }
        return false;
    }

    @Override
    public void $$_setDirty(long[] dirty) {
        this.dirty = dirty != null;
    }

    @Override
    public long[] $$_resetDirty() {
        if (this.dirty) {
            this.dirty = false;
            return DIRTY_MARKER;
        }
        return null;
    }

    @Override
    public long[] $$_getDirty() {
        if (this.dirty) {
            return DIRTY_MARKER;
        }
        return null;
    }

    @Override
    public long $$_getSimpleDirty() {
        if (this.dirty) {
            return 1L;
        }
        return 0L;
    }

    public void $$_markDirty(int attributeIndex) {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.$$_markDirty(this.parentIndex);
        }
    }

    public void $$_unmarkDirty() {
        this.dirty = false;
    }

    public void $$_setParent(BasicDirtyTracker parent, int parentIndex) {
        if (this.parent != null) {
            throw new IllegalStateException("Parent object for " + this.toString() + " is already set to " + this.parent.toString() + " and can't be set to:" + parent.toString());
        }
        this.parent = parent;
        this.parentIndex = parentIndex;
        for (Map.Entry entry : this.delegate.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (key instanceof BasicDirtyTracker) {
                ((BasicDirtyTracker)key).$$_setParent((BasicDirtyTracker)this, 1);
            }
            if (!((value = entry.getValue()) instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)value).$$_setParent((BasicDirtyTracker)this, 2);
        }
    }

    public boolean $$_hasParent() {
        return this.parent != null;
    }

    @Override
    public void $$_replaceAttribute(Object oldObject, int attributeIndex, Object newObject) {
        if (oldObject instanceof MutableStateTrackable) {
            ((MutableStateTrackable)oldObject).$$_removeReadOnlyParent(this, attributeIndex);
        }
        if (newObject instanceof MutableStateTrackable) {
            ((MutableStateTrackable)newObject).$$_addReadOnlyParent(this, attributeIndex);
        }
        if (this.currentIterator != null && this.currentIterator.getCurrent() == oldObject) {
            return;
        }
        if (attributeIndex == 1) {
            if (newObject == null) {
                this.delegate.remove(oldObject);
            } else if (this.ordered) {
                LinkedHashMap newMap = new LinkedHashMap(this.delegate.size());
                for (Map.Entry entry : this.delegate.entrySet()) {
                    if (entry.getKey() == oldObject) {
                        newMap.put(newObject, entry.getValue());
                        continue;
                    }
                    newMap.put(entry.getKey(), entry.getValue());
                }
                this.delegate.clear();
                this.delegate.putAll(newMap);
            } else {
                Object value = this.delegate.remove(oldObject);
                this.delegate.put((Object)newObject, value);
            }
        } else {
            for (Map.Entry entry : this.delegate.entrySet()) {
                if (entry.getValue() != oldObject) continue;
                entry.setValue(newObject);
                break;
            }
        }
    }

    public void $$_unsetParent() {
        this.parentIndex = 0;
        this.parent = null;
        for (Map.Entry entry : this.delegate.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (key instanceof BasicDirtyTracker) {
                ((BasicDirtyTracker)key).$$_unsetParent();
            }
            if (!((value = entry.getValue()) instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)value).$$_unsetParent();
        }
    }

    public boolean isHashBased() {
        return this.hashBased;
    }

    public RecordingEntrySetReplacingIterator<K, V> getCurrentIterator() {
        return this.currentIterator;
    }

    public RecordingEntrySetReplacingIterator<K, V> recordingIterator() {
        if (this.currentIterator != null) {
            throw new IllegalStateException("Multiple concurrent invocations for recording iterator!");
        }
        this.currentIterator = new RecordingEntrySetReplacingIterator(this);
        return this.currentIterator;
    }

    public void resetRecordingIterator() {
        if (this.currentIterator == null) {
            throw new IllegalStateException("Multiple concurrent invocations for recording iterator!");
        }
        this.currentIterator.reset();
        this.currentIterator = null;
    }

    public C getDelegate() {
        return this.delegate;
    }

    public boolean hasActions() {
        return this.actions != null && this.actions.size() > 0;
    }

    public void setActions(RecordingMap<C, K, V> recordingMap, Map<Object, Object> objectMapping) {
        if (recordingMap.actions == null) {
            this.actions = null;
            this.addedKeys = null;
            this.removedKeys = null;
            this.addedElements = null;
            this.removedElements = null;
        } else {
            Object newElement;
            this.actions = new ArrayList<MapAction<C>>(recordingMap.actions.size());
            this.addedKeys = new IdentityHashMap<K, K>(recordingMap.addedKeys.size());
            this.removedKeys = new IdentityHashMap<K, K>(recordingMap.removedKeys.size());
            this.addedElements = new IdentityHashMap<V, V>(recordingMap.addedElements.size());
            this.removedElements = new IdentityHashMap<V, V>(recordingMap.removedElements.size());
            for (MapAction<C> action : recordingMap.actions) {
                this.actions.add(action.replaceObjects(objectMapping));
            }
            for (MapAction<Object> e : recordingMap.addedKeys.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.addedKeys.put(e, e);
                    continue;
                }
                this.addedKeys.put(newElement, newElement);
            }
            for (MapAction<Object> e : recordingMap.removedKeys.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.removedKeys.put(e, e);
                    continue;
                }
                this.removedKeys.put(newElement, newElement);
            }
            for (MapAction<Object> e : recordingMap.addedElements.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.addedElements.put(e, e);
                    continue;
                }
                this.addedElements.put(newElement, newElement);
            }
            for (MapAction<Object> e : recordingMap.removedElements.keySet()) {
                newElement = objectMapping.get(e);
                if (newElement == null) {
                    this.removedElements.put(e, e);
                    continue;
                }
                this.removedElements.put(newElement, newElement);
            }
        }
        if (recordingMap.dirty) {
            this.$$_markDirty(-1);
        }
    }

    public void setActions(List<MapAction<C>> actions, Map<K, K> addedKeys, Map<K, K> removedKeys, Map<V, V> addedElements, Map<V, V> removedElements) {
        this.actions = actions;
        this.addedKeys = addedKeys;
        this.removedKeys = removedKeys;
        this.addedElements = addedElements;
        this.removedElements = removedElements;
        if (this.ordered) {
            ArrayList<Object> objects = new ArrayList<Object>(this.delegate.size() * 2);
            for (Map.Entry entry : this.delegate.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                for (K oldKey : addedKeys.keySet()) {
                    if (!oldKey.equals(key) || key == oldKey) continue;
                    if (key instanceof DirtyTracker) {
                        ((DirtyTracker)key).$$_unsetParent();
                    }
                    if (oldKey instanceof DirtyTracker) {
                        ((DirtyTracker)oldKey).$$_setParent(this, 1);
                    }
                    key = oldKey;
                    break;
                }
                objects.add(key);
                for (Object oldValue : addedElements.keySet()) {
                    if (!oldValue.equals(value) || value == oldValue) continue;
                    if (value instanceof DirtyTracker) {
                        ((DirtyTracker)value).$$_unsetParent();
                    }
                    if (oldValue instanceof DirtyTracker) {
                        ((DirtyTracker)oldValue).$$_setParent(this, 2);
                    }
                    value = oldValue;
                    break;
                }
                objects.add(value);
            }
            this.delegate.clear();
            for (int i = 0; i < objects.size(); i += 2) {
                this.delegate.put(objects.get(i), objects.get(i + 1));
            }
        } else {
            Iterator iterator = this.delegate.entrySet().iterator();
            HashMap newValues = new HashMap();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                boolean removed = false;
                Object oldKey = entry.getKey();
                for (K k : addedKeys.keySet()) {
                    if (!k.equals(entry.getKey()) || entry.getKey() == k) continue;
                    if (oldKey instanceof DirtyTracker) {
                        ((DirtyTracker)oldKey).$$_unsetParent();
                    }
                    if (k instanceof DirtyTracker) {
                        ((DirtyTracker)k).$$_setParent(this, 1);
                    }
                    oldKey = k;
                    iterator.remove();
                    removed = true;
                    break;
                }
                Object oldValue = entry.getValue();
                for (V v : addedElements.keySet()) {
                    if (!v.equals(entry.getValue()) || entry.getValue() == v) continue;
                    if (oldValue instanceof DirtyTracker) {
                        ((DirtyTracker)oldValue).$$_unsetParent();
                    }
                    if (v instanceof DirtyTracker) {
                        ((DirtyTracker)v).$$_setParent(this, 2);
                    }
                    oldValue = v;
                    if (removed) break;
                    iterator.remove();
                    removed = true;
                    break;
                }
                if (!removed) continue;
                newValues.put(oldKey, oldValue);
            }
            this.delegate.putAll(newValues);
        }
        this.$$_markDirty(-1);
    }

    protected C copyDelegate() {
        if (this.ordered) {
            return (C)new LinkedHashMap(this.delegate);
        }
        if (this.hashBased) {
            return (C)new HashMap(this.delegate);
        }
        return (C)new TreeMap(this.delegate);
    }

    public C getInitialVersion() {
        if (this.actions == null || this.actions.isEmpty()) {
            return (C)this;
        }
        C collection = this.copyDelegate();
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            MapAction<C> action = this.actions.get(i);
            action.undo(collection, this.removedKeys.keySet(), this.addedKeys.keySet(), this.removedElements.keySet(), this.addedElements.keySet());
        }
        return collection;
    }

    public List<MapAction<C>> resetActions(UpdateContext context) {
        List<MapAction<C>> oldActions = this.actions;
        if (oldActions == null) {
            return Collections.emptyList();
        }
        Map<K, K> addedKeys = this.addedKeys;
        Map<K, K> removedKeys = this.removedKeys;
        Map<V, V> addedElements = this.addedElements;
        Map<V, V> removedElements = this.removedElements;
        this.actions = null;
        this.dirty = false;
        this.addedKeys = null;
        this.addedElements = null;
        this.removedKeys = null;
        this.removedElements = null;
        context.getInitialStateResetter().addRecordingMap(this, oldActions, addedKeys, removedKeys, addedElements, removedElements);
        return oldActions;
    }

    public void initiateActionsAgainstState(List<MapAction<C>> actions, C initialState) {
        IdentityHashMap<Object, Object> addedKeys = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> removedKeys = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> addedElements = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> removedElements = new IdentityHashMap<Object, Object>();
        for (MapAction<C> action : actions) {
            if (action instanceof MapClearAction) {
                for (Map.Entry entry : initialState.entrySet()) {
                    removedKeys.put(entry.getKey(), entry.getKey());
                    removedElements.put(entry.getValue(), entry.getValue());
                }
                continue;
            }
            for (Object object : action.getAddedKeys(initialState)) {
                if (removedKeys.remove(object) != null) continue;
                addedKeys.put(object, object);
            }
            for (Object object : action.getRemovedKeys(initialState)) {
                if (addedKeys.remove(object) != null) continue;
                removedKeys.put(object, object);
            }
            for (Object object : action.getAddedElements(initialState)) {
                if (removedElements.remove(object) != null) continue;
                addedElements.put(object, object);
            }
            for (Object object : action.getRemovedElements(initialState)) {
                if (addedElements.remove(object) != null) continue;
                removedElements.put(object, object);
            }
        }
        this.actions = actions;
        this.dirty = true;
        this.addedKeys = addedKeys;
        this.addedElements = addedElements;
        this.removedKeys = removedKeys;
        this.removedElements = removedElements;
        for (MapAction<Object> o : removedKeys.keySet()) {
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
        for (MapAction<Object> o : removedElements.keySet()) {
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
    }

    public List<MapAction<C>> getActions() {
        return this.actions;
    }

    public Set<K> getAddedKeys() {
        if (this.addedKeys == null) {
            return Collections.emptySet();
        }
        return this.addedKeys.keySet();
    }

    public Set<K> getRemovedKeys() {
        if (this.removedKeys == null) {
            return Collections.emptySet();
        }
        return this.removedKeys.keySet();
    }

    public Set<V> getAddedElements() {
        if (this.addedElements == null) {
            return Collections.emptySet();
        }
        return this.addedElements.keySet();
    }

    public Set<V> getRemovedElements() {
        if (this.removedElements == null) {
            return Collections.emptySet();
        }
        return this.removedElements.keySet();
    }

    public void replay(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        if (this.actions != null) {
            for (MapAction<C> action : this.resetActions(context)) {
                action.doAction(map, context, mapper, keyRemoveListener, valueRemoveListener);
            }
        }
    }

    public void replaceActionElement(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        if (this.actions != null && (oldKey != newKey || oldValue != newValue)) {
            ListIterator<MapAction<C>> iter = this.actions.listIterator();
            while (iter.hasNext()) {
                MapAction<C> action = iter.next();
                MapAction<C> newAction = action.replaceObject(oldKey, oldValue, newKey, newValue);
                if (newAction == null) continue;
                iter.set(newAction);
            }
        }
    }

    protected void checkType(Object e, String action) {
        if (e != null && !this.allowedSubtypes.isEmpty()) {
            boolean isNew;
            Class c;
            if (e instanceof EntityViewProxy) {
                c = ((EntityViewProxy)e).$$_getEntityViewClass();
                isNew = ((EntityViewProxy)e).$$_isNew();
            } else {
                c = e.getClass();
                isNew = false;
            }
            if (!this.allowedSubtypes.contains(c)) {
                throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed!");
            }
            if (this.strictCascadingCheck) {
                if (e != this.parent && !isNew && this.parentRequiringUpdateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that update cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE })");
                }
                if (e != this.parent && isNew && this.parentRequiringCreateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that persist cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST })");
                }
            }
        }
    }

    protected void checkType(Map<?, ?> collection, String action) {
        if (collection != null && !collection.isEmpty() && !this.allowedSubtypes.isEmpty()) {
            for (Object e : collection.values()) {
                boolean isNew;
                Class c;
                if (e instanceof EntityViewProxy) {
                    c = ((EntityViewProxy)e).$$_getEntityViewClass();
                    isNew = ((EntityViewProxy)e).$$_isNew();
                } else {
                    c = e.getClass();
                    isNew = false;
                }
                if (!this.allowedSubtypes.contains(c)) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed!");
                }
                if (!this.strictCascadingCheck) continue;
                if (!isNew && this.parentRequiringUpdateSubtypes.contains(c) && !((DirtyTracker)e).$$_hasParent()) {
                    throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that update cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { UPDATE }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false");
                }
                if (!isNew || !this.parentRequiringCreateSubtypes.contains(c) || ((DirtyTracker)e).$$_hasParent()) continue;
                throw new IllegalArgumentException(action + " instances of type [" + c.getName() + "] is not allowed until they are assigned to an attribute that persist cascades the type! If you want this attribute to cascade, annotate it with @UpdatableMapping(cascade = { PERSIST }). You can also turn off strict cascading checks by setting ConfigurationProperties.UPDATER_STRICT_CASCADING_CHECK to false");
            }
        }
    }

    protected final void addAction(MapAction<C> action) {
        if (!this.updatable) {
            throw new UnsupportedOperationException("Collection is not updatable. Only it's elements are mutable! Consider annotating @UpdatableMapping if you want the collection role to be updatable!");
        }
        Collection<Object> addedKeys = action.getAddedKeys();
        Collection<Object> removedKeys = action.getRemovedKeys();
        Collection<Object> addedElements = action.getAddedElements();
        Collection<Object> removedElements = action.getRemovedElements();
        if (this.actions == null) {
            this.actions = new ArrayList<MapAction<C>>();
            this.addedKeys = new IdentityHashMap<K, K>();
            this.addedElements = new IdentityHashMap<V, V>();
            this.removedKeys = new IdentityHashMap<K, K>();
            this.removedElements = new IdentityHashMap<V, V>();
        }
        if (this.optimize) {
            action.addAction(this.actions, addedKeys, removedKeys, addedElements, removedElements);
        } else {
            this.actions.add(action);
        }
        for (Object o : addedKeys) {
            if (this.removedKeys.remove(o) == null) {
                if (this.addedKeys.put(o, o) != null || this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
                if (removedKeys.remove(o)) {
                    this.addedKeys.remove(o);
                    continue;
                }
                ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 1);
                continue;
            }
            if (this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 1);
        }
        for (Object o : removedKeys) {
            if (this.addedKeys.remove(o) == null) {
                if (this.removedKeys.put(o, o) != null || !(o instanceof BasicDirtyTracker)) continue;
                ((BasicDirtyTracker)o).$$_unsetParent();
                continue;
            }
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
        for (Object o : addedElements) {
            if (this.removedElements.remove(o) == null) {
                if (this.addedElements.put(o, o) != null || this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
                if (removedElements.remove(o)) {
                    this.addedElements.remove(o);
                    continue;
                }
                ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 2);
                continue;
            }
            if (this.parent == null || !(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_setParent((BasicDirtyTracker)this, 2);
        }
        for (Object o : removedElements) {
            if (o == null) continue;
            if (this.addedElements.remove(o) == null) {
                if (this.removedElements.put(o, o) != null || !(o instanceof BasicDirtyTracker)) continue;
                ((BasicDirtyTracker)o).$$_unsetParent();
                continue;
            }
            if (!(o instanceof BasicDirtyTracker)) continue;
            ((BasicDirtyTracker)o).$$_unsetParent();
        }
        this.$$_markDirty(-1);
    }

    @Override
    public V put(K key, V value) {
        this.checkType(value, "Putting");
        this.addAction(new MapPutAction(key, value, this.delegate));
        return this.delegate.put(key, value);
    }

    void addRemoveAction(Object key) {
        this.addAction(new MapRemoveAction(key, this.delegate));
    }

    @Override
    public V remove(Object key) {
        this.addRemoveAction(key);
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.checkType(m, "Putting");
        this.addAction(new MapPutAllAction(m, this.delegate));
        this.delegate.putAll(m);
    }

    void addClearAction() {
        this.addAction(new MapRemoveAllKeysAction(this.delegate.keySet(), this.delegate));
    }

    @Override
    public void clear() {
        this.addClearAction();
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return new RecordingKeySet(this.delegate.keySet(), this);
    }

    @Override
    public Collection<V> values() {
        return new RecordingValuesCollection(this.delegate.values(), this);
    }

    public RecordingEntrySet<C, K, V> entrySet() {
        return new RecordingEntrySet(this.delegate.entrySet(), this);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

