/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RecordingUtils {
    private RecordingUtils() {
    }

    public static Collection<Object> compensateObjects(Collection<?> elements, Collection<Object> objectsToCompensate) {
        ArrayList<Object> newObjectsToRemove = null;
        for (Object o : objectsToCompensate) {
            if (!elements.contains(o)) continue;
            newObjectsToRemove = new ArrayList<Object>(objectsToCompensate.size());
            break;
        }
        if (newObjectsToRemove == null) {
            return objectsToCompensate;
        }
        for (Object o : objectsToCompensate) {
            if (elements.remove(o)) continue;
            newObjectsToRemove.add(o);
        }
        return newObjectsToRemove;
    }

    public static List<Object> replaceElements(Collection<?> elements, Object oldElem, Object elem) {
        ArrayList newElements = null;
        int i = 0;
        for (Object element : elements) {
            if (element == oldElem) {
                if (newElements == null) {
                    newElements = new ArrayList(elements);
                }
                newElements.set(i, elem);
            }
            ++i;
        }
        return newElements;
    }

    public static Map<Object, Object> replaceElements(Map<?, ?> elements, Object oldKey, Object oldValue, Object newKey, Object newValue) {
        LinkedHashMap newElements = null;
        for (Map.Entry<?, ?> entry : elements.entrySet()) {
            if (entry.getKey() != oldKey && entry.getValue() != oldValue) continue;
            if (newElements == null) {
                newElements = new LinkedHashMap(elements);
            }
            newElements.remove(oldKey);
            newElements.put(newKey, newValue);
        }
        return newElements;
    }

    public static List<Map.Entry<Object, Object>> replaceEntries(Collection<? extends Map.Entry<?, ?>> elements, Object oldKey, Object oldValue, Object newKey, Object newValue) {
        ArrayList newElements = null;
        int i = 0;
        for (Map.Entry<?, ?> element : elements) {
            if (element.getKey() == oldKey || element.getValue() == oldValue) {
                if (newElements == null) {
                    newElements = new ArrayList(elements);
                }
                newElements.set(i, new AbstractMap.SimpleEntry<Object, Object>(newKey, newValue));
            }
            ++i;
        }
        return newElements;
    }

    public static List<Object> replaceElements(Collection<?> elements, Map<Object, Object> objectMapping) {
        ArrayList newElements = null;
        if (objectMapping != null) {
            int i = 0;
            for (Object element : elements) {
                Object newElement = objectMapping.get(element);
                if (newElement != null) {
                    if (newElements == null) {
                        newElements = new ArrayList(elements);
                    }
                    newElements.set(i, newElement);
                }
                ++i;
            }
        }
        return newElements;
    }

    public static Map<Object, Object> replaceElements(Map<?, ?> elements, Map<Object, Object> objectMapping) {
        LinkedHashMap newElements = null;
        for (Map.Entry<?, ?> entry : elements.entrySet()) {
            Object newKey = objectMapping.get(entry.getKey());
            Object newValue = objectMapping.get(entry.getValue());
            if (newKey == null && newValue == null) continue;
            if (newElements == null) {
                newElements = new LinkedHashMap(elements);
            }
            if (newKey == null) {
                newKey = entry.getKey();
            } else if (newValue == null) {
                newValue = entry.getValue();
            }
            newElements.remove(entry.getKey());
            newElements.put(newKey, newValue);
        }
        return newElements;
    }

    public static List<Map.Entry<Object, Object>> replaceEntries(Collection<? extends Map.Entry<?, ?>> elements, Map<Object, Object> objectMapping) {
        ArrayList newElements = null;
        int i = 0;
        for (Map.Entry<?, ?> element : elements) {
            Object newKey = objectMapping.get(element.getKey());
            Object newValue = objectMapping.get(element.getValue());
            if (newKey != null || newValue != null) {
                if (newElements == null) {
                    newElements = new ArrayList(elements);
                }
                if (newKey == null) {
                    newKey = element.getKey();
                } else if (newValue == null) {
                    newValue = element.getValue();
                }
                newElements.set(i, new AbstractMap.SimpleEntry<Object, Object>(newKey, newValue));
            }
            ++i;
        }
        return newElements;
    }
}

