/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import java.lang.reflect.Constructor;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractEntityLoader
implements EntityLoader {
    protected final Class<?> entityClass;
    protected final ViewToEntityMapper viewIdMapper;
    protected final Constructor<Object> entityConstructor;
    protected final String idAttributeName;
    protected final AttributeAccessor entityIdAccessor;
    protected final boolean primaryKeyId;

    public AbstractEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> jpaIdAttribute, SingularAttribute<?, ?> viewIdMappingAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor) {
        this.entityClass = entityClass;
        this.viewIdMapper = viewIdMapper;
        try {
            Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.entityConstructor = constructor;
            if (jpaIdAttribute != null) {
                if (viewIdMappingAttribute != null && !viewIdMappingAttribute.getName().equals(jpaIdAttribute.getName())) {
                    this.idAttributeName = viewIdMappingAttribute.getName();
                    this.entityIdAccessor = Accessors.forEntityMapping(evm, entityClass, viewIdMappingAttribute.getName());
                    this.primaryKeyId = false;
                } else {
                    this.idAttributeName = jpaIdAttribute.getName();
                    this.entityIdAccessor = entityIdAccessor;
                    this.primaryKeyId = true;
                }
            } else {
                this.idAttributeName = null;
                this.entityIdAccessor = null;
                this.primaryKeyId = true;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't find required no-arg constructor for entity class: " + entityClass.getName(), e);
        }
    }

    protected static SingularAttribute<?, ?> jpaIdOf(EntityViewManagerImpl evm, ManagedViewType<?> subviewType) {
        if (subviewType instanceof ViewType) {
            return JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)evm.getMetamodel().getEntityMetamodel().entity(subviewType.getEntityClass()));
        }
        return null;
    }

    protected static SingularAttribute<?, ?> viewIdMappingOf(EntityViewManagerImpl evm, ManagedViewType<?> subviewType) {
        if (subviewType instanceof ViewType) {
            ExtendedManagedType managedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, subviewType.getEntityClass());
            return (SingularAttribute)((ExtendedAttribute)managedType.getAttributes().get(((MappingAttribute)((ViewType)subviewType).getIdAttribute()).getMapping())).getAttribute();
        }
        return null;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public Object getEntityId(UpdateContext context, Object entity) {
        if (this.entityIdAccessor == null) {
            return null;
        }
        return this.entityIdAccessor.getValue(entity);
    }

    protected final Object createEntity() {
        try {
            return this.entityConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't map entity view to entity!", e);
        }
    }

    protected final Object getReferenceOrLoad(UpdateContext context, Object view, Object id) {
        id = this.getEntityId(context, view, id);
        if (this.primaryKeyId && context.containsEntity(this.entityClass, id)) {
            return context.getEntityManager().getReference(this.entityClass, id);
        }
        return this.queryEntity(context.getEntityManager(), id);
    }

    protected final Object getEntityId(UpdateContext context, Object view, Object id) {
        if (this.viewIdMapper != null) {
            id = this.viewIdMapper.applyToEntity(context, null, id);
        }
        return id;
    }

    protected abstract Object queryEntity(EntityManager var1, Object var2);
}

