/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.CriteriaBuilder;
import com.blazebit.persistence.CriteriaBuilderFactory;
import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.EntityLoaderFetchGraphNode;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.FetchGraphNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.metamodel.EntityType;

public class DefaultEntityLoaderFetchGraphNode
extends AbstractEntityLoader
implements EntityLoaderFetchGraphNode<DefaultEntityLoaderFetchGraphNode> {
    private static final String[] EMPTY = new String[0];
    private final String attributeName;
    private final Map<String, Map<?, ?>> fetchGraph;
    private final String queryString;

    public DefaultEntityLoaderFetchGraphNode(EntityViewManagerImpl evm, String attributeName, EntityType<?> entityType, Map<String, Map<?, ?>> fetchGraph) {
        super(evm, entityType.getJavaType(), JpaMetamodelUtils.getSingleIdAttribute(entityType), null, null, evm.getEntityIdAccessor());
        this.attributeName = attributeName;
        this.fetchGraph = fetchGraph;
        this.queryString = this.createQueryString(evm, entityType, fetchGraph);
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getMapping() {
        return this.attributeName;
    }

    @Override
    public void appendFetchJoinQueryFragment(String base, StringBuilder sb) {
        if (this.fetchGraph != null) {
            this.applyFetchGraph(sb, base, this.fetchGraph);
        }
    }

    @Override
    public FetchGraphNode<?> mergeWith(List<DefaultEntityLoaderFetchGraphNode> fetchGraphNodes) {
        for (int i = 0; i < fetchGraphNodes.size(); ++i) {
            DefaultEntityLoaderFetchGraphNode flusher = fetchGraphNodes.get(i);
            if (flusher.fetchGraph == this.fetchGraph) continue;
            if (this.fetchGraph == null) {
                return flusher;
            }
            return this;
        }
        return this;
    }

    private void applyFetchGraph(StringBuilder sb, String base, Map<String, Map<?, ?>> fetchGraph) {
        for (Map.Entry<String, Map<?, ?>> entry : fetchGraph.entrySet()) {
            String newBase = base.replace('.', '_') + "_" + entry.getKey();
            sb.append(" LEFT JOIN FETCH ").append(base).append('.').append(entry.getKey());
            sb.append(' ').append(newBase);
            this.applyFetchGraph(sb, newBase, entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createQueryString(EntityViewManagerImpl evm, EntityType<?> entityType, Map<String, Map<?, ?>> fetchGraph) {
        CriteriaBuilderFactory cbf = evm.getCriteriaBuilderFactory();
        EntityManagerFactory emf = (EntityManagerFactory)cbf.getService(EntityManagerFactory.class);
        try (EntityManager em = emf.createEntityManager();){
            String[] paths = this.flatten(fetchGraph);
            if (paths.length == 0) {
                String string = null;
                return string;
            }
            String string = ((CriteriaBuilder)((CriteriaBuilder)cbf.create(em, this.entityClass).fetch(paths)).where(JpaMetamodelUtils.getSingleIdAttribute(entityType).getName()).eqExpression(":id")).getQueryString();
            return string;
        }
    }

    private String[] flatten(Map<String, Map<?, ?>> fetchGraph) {
        if (fetchGraph == null || fetchGraph.isEmpty()) {
            return EMPTY;
        }
        ArrayList<String> paths = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<?, ?>> entry : fetchGraph.entrySet()) {
            sb.append(entry.getKey());
            this.flatten(paths, sb, entry.getValue());
            sb.setLength(0);
        }
        return paths.toArray(new String[paths.size()]);
    }

    private void flatten(List<String> paths, StringBuilder sb, Map<String, Map<?, ?>> fetchGraph) {
        if (fetchGraph == null || fetchGraph.isEmpty()) {
            paths.add(sb.toString());
        } else {
            int length = sb.length();
            for (Map.Entry<String, Map<?, ?>> entry : fetchGraph.entrySet()) {
                sb.append('.');
                sb.append(entry.getKey());
                this.flatten(paths, sb, entry.getValue());
                sb.setLength(length);
            }
        }
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null || this.queryString == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        if (this.queryString == null) {
            return em.find(this.entityClass, id);
        }
        List list = em.createQuery(this.queryString).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        return list.get(0);
    }
}

