/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.metamodel.SingularAttribute;

public class FlusherBasedEntityLoader
extends AbstractEntityLoader {
    private final DirtyAttributeFlusher<?, Object, Object>[] flushers;
    private volatile String queryString;

    public FlusherBasedEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> jpaIdAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor, DirtyAttributeFlusher<?, Object, Object>[] flushers) {
        super(evm, entityClass, jpaIdAttribute, null, viewIdMapper, entityIdAccessor);
        this.flushers = flushers;
    }

    private String getQueryString() {
        String query = this.queryString;
        if (query != null) {
            return query;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT e FROM ").append(this.entityClass.getName()).append(" e");
        for (int i = 0; i < this.flushers.length; ++i) {
            if (this.flushers[i] == null) continue;
            this.flushers[i].appendFetchJoinQueryFragment("e", sb);
        }
        sb.append(" WHERE e.").append(this.idAttributeName).append(" = :id");
        this.queryString = query = sb.toString();
        return query;
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null || this.entityIdAccessor == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        List list = em.createQuery(this.getQueryString()).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        return list.get(0);
    }
}

