/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.InverseElementToEntityMapper;
import com.blazebit.persistence.view.impl.entity.ReferenceEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.mapper.Mapper;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImplementor;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.impl.update.flush.DirtyAttributeFlusher;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import javax.persistence.Query;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.IdentifiableType;

public class InverseViewToEntityMapper<E>
implements InverseElementToEntityMapper<E> {
    private static final String ID_PARAM_NAME = "_id";
    private final ViewTypeImplementor<?> viewType;
    private final AttributeAccessor viewIdAccessor;
    private final EntityLoader entityLoader;
    private final boolean persistAllowed;
    private final Mapper<Object, Object> parentEntityOnChildViewMapper;
    private final Mapper<Object, Object> parentEntityOnChildEntityAddMapper;
    private final Mapper<Object, Object> parentEntityOnChildEntityRemoveMapper;
    private final ViewToEntityMapper elementViewToEntityMapper;
    private final String updatePrefixString;
    private final String updatePostfixString;
    private final String fullUpdateQueryString;
    private final DirtyAttributeFlusher<?, Object, Object> parentReferenceAttributeFlusher;
    private final DirtyAttributeFlusher<?, Object, Object> idAttributeFlusher;

    public InverseViewToEntityMapper(EntityViewManagerImpl evm, ViewType<?> childViewType, Mapper<Object, Object> parentEntityOnChildViewMapper, Mapper<Object, Object> parentEntityOnChildEntityAddMapper, Mapper<Object, Object> parentEntityOnChildEntityRemoveMapper, ViewToEntityMapper elementViewToEntityMapper, DirtyAttributeFlusher<?, Object, Object> parentReferenceAttributeFlusher, DirtyAttributeFlusher<?, Object, Object> idAttributeFlusher) {
        this.viewType = (ViewTypeImplementor)childViewType;
        this.elementViewToEntityMapper = elementViewToEntityMapper;
        this.viewIdAccessor = Accessors.forViewId(evm, childViewType, true);
        this.entityLoader = new ReferenceEntityLoader(evm, (ManagedViewType<?>)childViewType, EntityViewUpdaterImpl.createViewIdMapper(evm, childViewType));
        this.persistAllowed = false;
        EntityType entityType = evm.getMetamodel().getEntityMetamodel().entity(childViewType.getEntityClass());
        this.parentEntityOnChildViewMapper = parentEntityOnChildViewMapper;
        this.parentEntityOnChildEntityAddMapper = parentEntityOnChildEntityAddMapper;
        this.parentEntityOnChildEntityRemoveMapper = parentEntityOnChildEntityRemoveMapper;
        this.updatePrefixString = "UPDATE " + entityType.getName() + " e SET ";
        if (idAttributeFlusher == null) {
            this.updatePostfixString = " WHERE e." + JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)entityType).getName() + " = :" + ID_PARAM_NAME;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(" WHERE ");
            idAttributeFlusher.appendUpdateQueryFragment(null, sb, "e.", "_", " AND ");
            this.updatePostfixString = sb.toString();
        }
        this.parentReferenceAttributeFlusher = parentReferenceAttributeFlusher;
        this.idAttributeFlusher = idAttributeFlusher;
        this.fullUpdateQueryString = this.createQueryString(null, parentReferenceAttributeFlusher);
    }

    public ViewTypeImplementor<?> getViewType() {
        return this.viewType;
    }

    @Override
    public void flushEntity(UpdateContext context, Object oldParent, final Object newParent, final Object child, DirtyAttributeFlusher<?, E, Object> nestedGraphNode) {
        if (child == null) {
            return;
        }
        Object elementEntity = null;
        Object id = this.viewIdAccessor.getValue(child);
        Runnable parentEntityOnChildViewMapperListener = null;
        if (this.parentEntityOnChildViewMapper != null) {
            parentEntityOnChildViewMapperListener = new Runnable(){

                @Override
                public void run() {
                    InverseViewToEntityMapper.this.parentEntityOnChildViewMapper.map(newParent, child);
                }
            };
        }
        if (this.shouldPersist(child)) {
            elementEntity = this.entityLoader.toEntity(context, child, null);
            if (newParent == null) {
                this.parentEntityOnChildEntityRemoveMapper.map(oldParent, elementEntity);
            } else {
                this.parentEntityOnChildEntityAddMapper.map(newParent, elementEntity);
            }
            if (nestedGraphNode == null) {
                if (parentEntityOnChildViewMapperListener != null) {
                    parentEntityOnChildViewMapperListener.run();
                }
            } else {
                nestedGraphNode.flushEntity(context, elementEntity, child, null, child, parentEntityOnChildViewMapperListener);
            }
            this.elementViewToEntityMapper.applyToEntity(context, elementEntity, child);
        } else {
            elementEntity = this.entityLoader.toEntity(context, child, id);
            if (newParent == null) {
                this.parentEntityOnChildEntityRemoveMapper.map(oldParent, elementEntity);
            } else {
                this.parentEntityOnChildEntityAddMapper.map(newParent, elementEntity);
            }
            if (nestedGraphNode == null) {
                if (parentEntityOnChildViewMapperListener != null) {
                    parentEntityOnChildViewMapperListener.run();
                }
            } else {
                nestedGraphNode.flushEntity(context, elementEntity, child, null, child, parentEntityOnChildViewMapperListener);
            }
            this.elementViewToEntityMapper.applyToEntity(context, elementEntity, child);
        }
    }

    protected boolean shouldPersist(Object view) {
        return view instanceof EntityViewProxy && ((EntityViewProxy)view).$$_isNew();
    }

    private String createQueryString(DirtyAttributeFlusher<?, ?, ?> nestedGraphNode, DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher) {
        StringBuilder sb = new StringBuilder(this.updatePrefixString.length() + this.updatePostfixString.length() + 250);
        sb.append(this.updatePrefixString);
        inverseAttributeFlusher.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
        if (nestedGraphNode != null) {
            sb.append(", ");
            int initialLength = sb.length();
            nestedGraphNode.appendUpdateQueryFragment(null, sb, "e.", "", ", ");
            if (sb.length() == initialLength) {
                sb.setLength(sb.length() - 2);
                sb.append(this.updatePostfixString);
                return sb.toString();
            }
            sb.append(this.updatePostfixString);
            return sb.toString();
        }
        sb.append(this.updatePostfixString);
        return sb.toString();
    }

    @Override
    public Query createInverseUpdateQuery(UpdateContext context, Object view, DirtyAttributeFlusher<?, E, Object> nestedGraphNode, DirtyAttributeFlusher<?, ?, ?> inverseAttributeFlusher) {
        String queryString = inverseAttributeFlusher == this.parentReferenceAttributeFlusher && nestedGraphNode == null ? this.fullUpdateQueryString : this.createQueryString(nestedGraphNode, inverseAttributeFlusher);
        Query query = null;
        if (queryString != null) {
            query = context.getEntityManager().createQuery(queryString);
            if (this.idAttributeFlusher == null) {
                query.setParameter(ID_PARAM_NAME, this.viewIdAccessor.getValue(view));
            } else {
                this.idAttributeFlusher.flushQuery(context, "_", null, query, view, view, this.viewIdAccessor.getValue(view), null);
            }
        }
        return query;
    }
}

