/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.AbstractViewToEntityMapper;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.util.Set;

public class LoadOrPersistViewToEntityMapper
extends AbstractViewToEntityMapper {
    public LoadOrPersistViewToEntityMapper(String attributeLocation, EntityViewManagerImpl evm, Class<?> viewTypeClass, Set<Type<?>> readOnlyAllowedSubtypes, Set<Type<?>> persistAllowedSubtypes, Set<Type<?>> updateAllowedSubtypes, EntityLoader entityLoader, AttributeAccessor viewIdAccessor, AttributeAccessor entityIdAccessor, boolean persistAllowed, EntityViewUpdaterImpl owner, String ownerMapping) {
        super(attributeLocation, evm, viewTypeClass, readOnlyAllowedSubtypes, persistAllowedSubtypes, updateAllowedSubtypes, entityLoader, viewIdAccessor, entityIdAccessor, persistAllowed, owner, ownerMapping);
    }

    @Override
    public Object applyToEntity(UpdateContext context, Object entity, Object view) {
        Object object = this.flushToEntity(context, entity, view);
        if (object == null) {
            return this.loadEntity(context, view);
        }
        return object;
    }

    @Override
    public Object flushToEntity(UpdateContext context, Object entity, Object view) {
        if (view == null) {
            return null;
        }
        if (this.viewIdAccessor != null) {
            Object id = this.viewIdAccessor.getValue(view);
            if (this.shouldPersist(view, id)) {
                return this.persist(context, entity, view);
            }
            Class<?> viewTypeClass = this.getViewTypeClass(view);
            if (!(this.viewTypeClasses.contains(viewTypeClass) || this.persistAllowed && this.persistUpdater.containsKey(viewTypeClass) && !((EntityViewProxy)view).$$_isNew())) {
                throw new IllegalArgumentException("Couldn't load entity object for attribute '" + this.attributeLocation + "'. Expected subview of one of the types " + LoadOrPersistViewToEntityMapper.names(this.viewTypeClasses) + " but got: " + view);
            }
        }
        return null;
    }

    @Override
    public Object loadEntity(UpdateContext context, Object view) {
        if (view == null) {
            return null;
        }
        Object id = null;
        if (this.viewIdAccessor != null) {
            id = this.viewIdAccessor.getValue(view);
        }
        return this.entityLoader.toEntity(context, view, id);
    }
}

