/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.AbstractEntityLoader;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.TargetViewClassBasedEntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.update.EntityViewUpdaterImpl;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.metamodel.SingularAttribute;

public class ReferenceEntityLoader
extends AbstractEntityLoader {
    private final String queryString;

    public ReferenceEntityLoader(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, ViewToEntityMapper viewIdMapper) {
        this(evm, subviewType.getEntityClass(), ReferenceEntityLoader.jpaIdOf(evm, subviewType), ReferenceEntityLoader.viewIdMappingOf(evm, subviewType), viewIdMapper, evm.getEntityIdAccessor());
    }

    public ReferenceEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> idAttribute, SingularAttribute<?, ?> viewIdMappingAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor) {
        super(evm, entityClass, idAttribute, viewIdMappingAttribute, viewIdMapper, entityIdAccessor);
        this.queryString = this.primaryKeyId ? null : "SELECT e FROM " + evm.getMetamodel().getEntityMetamodel().entity(entityClass).getName() + " e WHERE e." + this.idAttributeName + " = :id";
    }

    public static EntityLoader forAttribute(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, AbstractMethodAttribute<?, ?> attribute) {
        return ReferenceEntityLoader.forAttribute(evm, subviewType, attribute.getViewTypes());
    }

    public static EntityLoader forAttribute(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, Set<? extends ManagedViewType<?>> viewTypes) {
        if (viewTypes.size() == 1) {
            return new ReferenceEntityLoader(evm, subviewType, EntityViewUpdaterImpl.createViewIdMapper(evm, subviewType));
        }
        ReferenceEntityLoader first = null;
        HashMap entityLoaderMap = new HashMap(viewTypes.size());
        for (ManagedViewType<?> viewType : viewTypes) {
            ReferenceEntityLoader referenceEntityLoader = new ReferenceEntityLoader(evm, viewType, EntityViewUpdaterImpl.createViewIdMapper(evm, viewType));
            entityLoaderMap.put(viewType.getJavaType(), referenceEntityLoader);
            if (viewType != subviewType) continue;
            first = referenceEntityLoader;
        }
        return new TargetViewClassBasedEntityLoader(first, entityLoaderMap);
    }

    @Override
    public Object toEntity(UpdateContext context, Object view, Object id) {
        if (id == null) {
            return this.createEntity();
        }
        return this.getReferenceOrLoad(context, view, id);
    }

    @Override
    protected Object queryEntity(EntityManager em, Object id) {
        if (this.queryString == null) {
            return em.getReference(this.entityClass, id);
        }
        List list = em.createQuery(this.queryString).setParameter("id", id).getResultList();
        if (list.isEmpty()) {
            throw new EntityNotFoundException("Required entity '" + this.entityClass.getName() + "' with id '" + id + "' couldn't be found!");
        }
        return list.get(0);
    }

    @Override
    public Object getEntityId(UpdateContext context, Object entity) {
        if (this.entityIdAccessor == null) {
            return null;
        }
        return this.entityIdAccessor.getValue(entity);
    }
}

