/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.macro;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.view.spi.ViewRootJpqlMacro;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class CorrelatedSubqueryViewRootJpqlMacro
implements ViewRootJpqlMacro {
    public static final String CORRELATION_VIEW_ROOT_ALIAS = "correlationViewRootAlias_";
    private static final String CORRELATION_VIEW_ROOT_PARAM_PREFIX = "correlationViewRootParam_";
    private static final String CORRELATION_VIEW_ROOT_ID_PARAM_PREFIX = "correlationViewRootIdParam_";
    protected final FullQueryBuilder<?, ?> criteriaBuilder;
    protected final Map<String, Object> optionalParameters;
    protected final boolean batchedViewRoot;
    protected final Class<?> viewRootEntityType;
    protected final String viewRootIdPath;
    protected String originalViewRootExpression;
    protected String viewRootExpression;
    protected String viewRootParamName;
    protected String viewRootIdParamName;
    protected boolean used;
    protected boolean nonIdUsed;

    public CorrelatedSubqueryViewRootJpqlMacro(FullQueryBuilder<?, ?> criteriaBuilder, Map<String, Object> optionalParameters, boolean batchedViewRoot, Class<?> viewRootEntityType, String viewRootIdPath, String viewRootExpression) {
        this.criteriaBuilder = criteriaBuilder;
        this.optionalParameters = optionalParameters;
        this.batchedViewRoot = batchedViewRoot;
        this.viewRootEntityType = viewRootEntityType;
        this.viewRootIdPath = viewRootIdPath;
        this.viewRootExpression = viewRootExpression;
    }

    public void setParameters(FullQueryBuilder<?, ?> criteriaBuilder, Query query, Object viewRootId) {
        if (this.batchedViewRoot) {
            if (this.originalViewRootExpression != null) {
                this.setEntityParam(criteriaBuilder, query, this.originalViewRootExpression, viewRootId);
            } else {
                this.setEntityParam(criteriaBuilder, query, this.viewRootExpression, viewRootId);
            }
            return;
        }
        if (this.viewRootParamName != null) {
            this.setEntityParam(criteriaBuilder, query, this.viewRootParamName, viewRootId);
        }
        if (this.viewRootIdParamName != null && criteriaBuilder.containsParameter(this.viewRootIdParamName)) {
            criteriaBuilder.setParameter(this.viewRootIdParamName, viewRootId);
            query.setParameter(this.viewRootIdParamName, viewRootId);
        }
    }

    protected final void setEntityParam(FullQueryBuilder<?, ?> criteriaBuilder, Query query, String paramName, Object viewRootId) {
        EntityManager em = criteriaBuilder.getEntityManager();
        if (viewRootId instanceof Collection) {
            Collection paramCollection = (Collection)viewRootId;
            ArrayList<Object> viewRootEntities = new ArrayList<Object>(paramCollection.size());
            for (Object paramValue : paramCollection) {
                if (paramValue == null) continue;
                viewRootEntities.add(em.getReference(this.viewRootEntityType, paramValue));
            }
            if (criteriaBuilder.containsParameter(paramName)) {
                criteriaBuilder.setParameter(paramName, viewRootEntities);
                query.setParameter(paramName, viewRootEntities);
            }
        } else if (criteriaBuilder.containsParameter(paramName)) {
            Object viewRootEntity = em.getReference(this.viewRootEntityType, viewRootId);
            criteriaBuilder.setParameter(paramName, viewRootEntity);
            query.setParameter(paramName, viewRootEntity);
        }
    }

    public String getViewRoot() {
        if (this.viewRootExpression == null || this.viewRootExpression.charAt(0) == ':') {
            return null;
        }
        return this.viewRootExpression;
    }

    public Class<?> getViewRootEntityType() {
        return this.viewRootEntityType;
    }

    public boolean usesViewRootEntityParameter() {
        return this.viewRootExpression != null;
    }

    public boolean usesViewMacro() {
        return this.used;
    }

    public boolean usesViewMacroNonId() {
        return this.nonIdUsed;
    }

    public void addIdParamPredicate(FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.viewRootExpression != null && this.viewRootExpression.charAt(0) != ':') {
            if (this.viewRootParamName != null) {
                criteriaBuilder.where(this.viewRootExpression).eqExpression(":" + this.viewRootParamName);
            } else {
                criteriaBuilder.where(this.viewRootExpression + '.' + this.viewRootIdPath).eqExpression(":" + this.getIdParamName());
            }
        }
    }

    public void addBatchPredicate(FullQueryBuilder<?, ?> criteriaBuilder) {
        if (this.viewRootExpression == CORRELATION_VIEW_ROOT_ALIAS) {
            ((JoinOnBuilder)criteriaBuilder.innerJoinOn(this.originalViewRootExpression, this.viewRootEntityType, CORRELATION_VIEW_ROOT_ALIAS).on(this.originalViewRootExpression + "." + this.viewRootIdPath).eqExpression("correlationViewRootAlias_." + this.viewRootIdPath)).end();
        }
    }

    protected String getParamName() {
        if (this.viewRootParamName == null) {
            this.viewRootParamName = this.generateParamName(CORRELATION_VIEW_ROOT_PARAM_PREFIX);
        }
        return this.viewRootParamName;
    }

    protected String getIdParamName() {
        if (this.viewRootIdParamName == null) {
            this.viewRootIdParamName = this.generateParamName(CORRELATION_VIEW_ROOT_ID_PARAM_PREFIX);
        }
        return this.viewRootIdParamName;
    }

    protected String addViewRootNode() {
        if (this.viewRootExpression != CORRELATION_VIEW_ROOT_ALIAS) {
            this.originalViewRootExpression = this.viewRootExpression;
            this.viewRootExpression = CORRELATION_VIEW_ROOT_ALIAS;
            if (!this.batchedViewRoot) {
                this.criteriaBuilder.from(this.viewRootEntityType, CORRELATION_VIEW_ROOT_ALIAS);
            }
        }
        return this.viewRootExpression;
    }

    protected final String generateParamName(String prefix) {
        String paramName;
        int paramNumber = 0;
        while (true) {
            if (this.criteriaBuilder.getParameter(paramName = prefix + paramNumber) != null) {
                ++paramNumber;
                continue;
            }
            if (!this.optionalParameters.containsKey(paramName)) break;
            ++paramNumber;
        }
        return paramName;
    }

    protected String getViewRootIdPath() {
        return this.viewRootIdPath;
    }

    public void render(FunctionRenderContext context) {
        if (context.getArgumentsSize() > 1) {
            throw new IllegalArgumentException("The VIEW_ROOT macro allows maximally one argument: <expression>!");
        }
        this.used = true;
        if (context.getArgumentsSize() > 0) {
            if (this.viewRootExpression != null) {
                String firstArgument = context.getArgument(0);
                if (this.viewRootIdPath.startsWith(firstArgument) && (this.viewRootIdPath.length() == firstArgument.length() || firstArgument.charAt(this.viewRootIdPath.length()) == '.')) {
                    context.addChunk(this.viewRootExpression);
                    context.addChunk(".");
                    context.addChunk(this.getViewRootIdPath());
                } else {
                    String alias = this.batchedViewRoot ? this.addViewRootNode() : this.viewRootExpression;
                    this.nonIdUsed = true;
                    context.addChunk(alias);
                    context.addChunk(".");
                    context.addArgument(0);
                }
            } else if (this.viewRootIdPath.equals(context.getArgument(0))) {
                context.addChunk(":");
                context.addChunk(this.getIdParamName());
            } else {
                String alias = this.addViewRootNode();
                this.nonIdUsed = true;
                context.addChunk(alias);
                context.addChunk(".");
                context.addArgument(0);
            }
        } else {
            this.used = true;
            if (this.viewRootExpression != null) {
                context.addChunk(this.viewRootExpression);
            } else {
                context.addChunk(":");
                context.addChunk(this.getParamName());
            }
        }
    }
}

