/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.mapper;

import com.blazebit.persistence.view.ConvertOperationBuilder;
import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.mapper.ViewMapper;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;

public class ConvertOperationBuilderImpl<T>
implements ConvertOperationBuilder<T> {
    private final EntityViewManagerImpl entityViewManager;
    private final ViewMapper.Key<Object, T> key;
    private final Map<String, ViewMapper.Key<Object, Object>> subMappers = new HashMap<String, ViewMapper.Key<Object, Object>>();
    private final Object source;

    public ConvertOperationBuilderImpl(EntityViewManagerImpl entityViewManager, ViewMapper.Key<Object, T> key, Object source) {
        this.entityViewManager = entityViewManager;
        this.key = key;
        this.source = source;
    }

    public T convert() {
        return this.entityViewManager.getViewMapper(this.key, this.subMappers).map(this.source);
    }

    public ConvertOperationBuilder<T> excludeAttribute(String attributePath) {
        if (!this.key.getSourceType().getRecursiveAttributes().containsKey(attributePath) && !this.key.getSourceType().getRecursiveSubviewAttributes().containsKey(attributePath)) {
            throw new IllegalArgumentException("Attribute '" + attributePath + "' could not be found on type: " + this.key.getSourceType().getJavaType().getName());
        }
        this.subMappers.put(attributePath, ViewMapper.Key.EXCLUDE_MARKER);
        return this;
    }

    public ConvertOperationBuilder<T> excludeAttributes(String ... attributePaths) {
        ManagedViewTypeImplementor<Object> sourceType = this.key.getSourceType();
        NavigableMap<String, AbstractMethodAttribute<Object, ?>> recursiveAttributes = sourceType.getRecursiveAttributes();
        NavigableMap<String, AbstractMethodAttribute<Object, ?>> recursiveSubviewAttributes = sourceType.getRecursiveSubviewAttributes();
        for (String attributePath : attributePaths) {
            if (!recursiveAttributes.containsKey(attributePath) && !recursiveSubviewAttributes.containsKey(attributePath)) {
                throw new IllegalArgumentException("Attribute '" + attributePath + "' could not be found on type: " + sourceType.getJavaType().getName());
            }
            this.subMappers.put(attributePath, ViewMapper.Key.EXCLUDE_MARKER);
        }
        return this;
    }

    public ConvertOperationBuilder<T> convertAttribute(String attributePath, Class<?> attributeViewClass, ConvertOption ... convertOptions) {
        AbstractMethodAttribute sourceAttribute = (AbstractMethodAttribute)this.key.getSourceType().getRecursiveSubviewAttributes().get(attributePath);
        if (sourceAttribute == null) {
            throw new IllegalArgumentException("Attribute '" + attributePath + "' could not be found on type: " + this.key.getSourceType().getJavaType().getName());
        }
        Class elementType = sourceAttribute.getConvertedJavaType();
        if (sourceAttribute instanceof PluralAttribute) {
            elementType = ((PluralAttribute)sourceAttribute).getElementType().getJavaType();
        }
        if (!elementType.isAssignableFrom(attributeViewClass)) {
            throw new IllegalArgumentException("The given type '" + attributeViewClass.getName() + "' is not assignable to the declared type of '" + this.key.getSourceType().getJavaType().getName() + "." + attributePath + "': " + elementType.getName());
        }
        this.subMappers.put(attributePath, ViewMapper.Key.create((ViewMetamodel)this.entityViewManager.getMetamodel(), elementType, attributeViewClass, convertOptions));
        return this;
    }
}

