/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.mapper;

import com.blazebit.persistence.view.ConvertOption;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.MapInstantiator;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.proxy.ConvertReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.DirtyStateTrackable;
import com.blazebit.persistence.view.impl.proxy.DirtyTracker;
import com.blazebit.persistence.view.impl.proxy.MutableStateTrackable;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewMetamodel;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.type.EntityViewProxy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ViewMapper<S, T> {
    private final int[] dirtyMapping;
    private final boolean copyInitialState;
    private final AttributeAccessor[] sourceAccessors;
    private final ObjectInstantiator<T> objectInstantiator;
    private final boolean markNew;
    private final Method postConvert;
    private final boolean postConvertUsesSource;

    public ViewMapper(ManagedViewType<S> sourceType, ManagedViewType<T> targetType, boolean ignoreMissing, Boolean maybeMarkNew, EntityViewManager entityViewManager, ProxyFactory proxyFactory, String prefix, Map<String, Key<Object, Object>> subMappers) {
        if (!targetType.getEntityClass().isAssignableFrom(sourceType.getEntityClass())) {
            throw this.inconvertible("Incompatible entity types!", sourceType, targetType);
        }
        boolean markNew = maybeMarkNew != null ? maybeMarkNew.booleanValue() : targetType.isCreatable();
        Set attributes = targetType.getAttributes();
        Class[] parameterTypes = new Class[attributes.size()];
        AttributeAccessor[] sourceAccessors = new AttributeAccessor[attributes.size()];
        Iterator iterator = attributes.iterator();
        MethodAttribute idAttribute = null;
        ArrayList<Integer> dirtyMapping = new ArrayList<Integer>();
        int i = 0;
        if (targetType instanceof ViewType) {
            idAttribute = ((ViewType)targetType).getIdAttribute();
            parameterTypes[i] = idAttribute.getConvertedJavaType();
            sourceAccessors[i] = this.createAccessor(sourceType, targetType, ignoreMissing, markNew, entityViewManager, proxyFactory, idAttribute, prefix, subMappers);
            ++i;
        }
        while (iterator.hasNext()) {
            int sourceIndex;
            MethodAttribute sourceAttribute;
            MethodAttribute targetAttribute = (MethodAttribute)iterator.next();
            if (targetAttribute == idAttribute) continue;
            parameterTypes[i] = targetAttribute.getConvertedJavaType();
            sourceAccessors[i] = this.createAccessor(sourceType, targetType, ignoreMissing, markNew, entityViewManager, proxyFactory, targetAttribute, prefix, subMappers);
            int dirtyStateIndex = ((AbstractMethodAttribute)targetAttribute).getDirtyStateIndex();
            if (dirtyStateIndex != -1 && (sourceAttribute = sourceType.getAttribute(targetAttribute.getName())) != null && (sourceIndex = ((AbstractMethodAttribute)sourceAttribute).getDirtyStateIndex()) != -1) {
                for (int j = dirtyMapping.size(); j <= dirtyStateIndex; ++j) {
                    dirtyMapping.add(-1);
                }
                dirtyMapping.set(dirtyStateIndex, sourceIndex);
            }
            ++i;
        }
        if (dirtyMapping.isEmpty()) {
            this.dirtyMapping = null;
        } else {
            int[] dirtyMappingArray = new int[dirtyMapping.size()];
            for (i = 0; i < dirtyMapping.size(); ++i) {
                dirtyMappingArray[i] = (Integer)dirtyMapping.get(i);
            }
            this.dirtyMapping = dirtyMappingArray;
        }
        this.copyInitialState = !markNew;
        this.sourceAccessors = sourceAccessors;
        try {
            this.objectInstantiator = new ConvertReflectionInstantiator<T>(proxyFactory, targetType, parameterTypes, markNew, entityViewManager);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Empty constructor is required for conversion. Please make sure " + targetType.getJavaType().getName() + " has an empty constructor!", ex);
        }
        if (markNew && !targetType.isCreatable()) {
            throw new IllegalArgumentException("Defined to convert to new object but target view type isn't annotated with @CreatableEntityView: " + targetType.getJavaType().getName());
        }
        this.markNew = markNew;
        this.postConvert = targetType.getPostConvertMethod();
        this.postConvertUsesSource = targetType.getPostConvertMethod() != null && targetType.getPostConvertMethod().getParameterTypes().length != 0;
    }

    private AttributeAccessor createAccessor(ManagedViewType<S> sourceType, ManagedViewType<T> targetType, boolean ignoreMissing, boolean markNew, EntityViewManager entityViewManager, ProxyFactory proxyFactory, MethodAttribute<? super T, ?> targetAttribute, String prefix, Map<String, Key<Object, Object>> subMappers) {
        MethodAttribute sourceAttribute;
        String newPrefix = prefix.isEmpty() ? targetAttribute.getName() : prefix + "." + targetAttribute.getName();
        Boolean maybeMarkNew = markNew ? null : Boolean.valueOf(false);
        Key<Object, Object> subMapperKey = subMappers.get(newPrefix);
        if (subMapperKey == Key.EXCLUDE_MARKER) {
            return null;
        }
        if (subMapperKey != null) {
            ignoreMissing = ((Key)subMapperKey).ignoreMissing;
            maybeMarkNew = ((Key)subMapperKey).markNew;
        }
        if ((sourceAttribute = sourceType.getAttribute(targetAttribute.getName())) == null) {
            if (ignoreMissing) {
                return null;
            }
            throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type is missing in source type!", sourceType, targetType);
        }
        if (targetAttribute.isCollection()) {
            if (targetAttribute.getConvertedJavaType() != sourceAttribute.getConvertedJavaType()) {
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different plural type than in source type!", sourceType, targetType);
            }
            PluralAttribute targetPluralAttr = (PluralAttribute)targetAttribute;
            PluralAttribute sourcePluralAttr = (PluralAttribute)sourceAttribute;
            ViewMapper<Object, Object> valueMapper = null;
            Object attributeType = targetPluralAttr.getElementType();
            if (subMapperKey != null) {
                attributeType = ((Key)subMapperKey).targetType;
            }
            if (targetAttribute.isSubview()) {
                valueMapper = this.createViewMapper((Type<?>)sourcePluralAttr.getElementType(), (Type<?>)attributeType, ignoreMissing, maybeMarkNew, entityViewManager, proxyFactory, newPrefix, subMappers);
            } else if (targetPluralAttr.getElementType() != sourcePluralAttr.getElementType()) {
                throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different element type than in source type!", sourceType, targetType);
            }
            boolean needsDirtyTracker = ((AbstractAttribute)targetAttribute).needsDirtyTracker();
            if (targetPluralAttr.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                MapAttribute targetMapAttr = (MapAttribute)targetAttribute;
                MapAttribute sourceMapAttr = (MapAttribute)sourceAttribute;
                ViewMapper<Object, Object> keyMapper = null;
                if (targetMapAttr.isKeySubview()) {
                    String newKeyPrefix = "KEY(" + newPrefix + ")";
                    Key<Object, Object> keySubMapperKey = subMappers.get(newKeyPrefix);
                    if (keySubMapperKey == Key.EXCLUDE_MARKER) {
                        keyMapper = null;
                    } else {
                        Boolean maybeMarkNewKey;
                        Object keyTargetType = targetMapAttr.getKeyType();
                        Boolean bl = maybeMarkNewKey = markNew ? null : Boolean.valueOf(false);
                        if (subMapperKey != null) {
                            keyTargetType = ((Key)keySubMapperKey).targetType;
                            ignoreMissing = ((Key)keySubMapperKey).ignoreMissing;
                            maybeMarkNewKey = ((Key)keySubMapperKey).markNew;
                        }
                        keyMapper = this.createViewMapper((Type<?>)sourceMapAttr.getKeyType(), (Type<?>)keyTargetType, ignoreMissing, maybeMarkNewKey, entityViewManager, proxyFactory, newPrefix, subMappers);
                    }
                } else if (targetMapAttr.getKeyType() != sourceMapAttr.getKeyType()) {
                    throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different key type than in source type!", sourceType, targetType);
                }
                MapInstantiator mapInstantiator = ((AbstractAttribute)targetAttribute).getMapInstantiator();
                return new MapMappingAccessor(Accessors.forViewAttribute(null, sourceAttribute, true), needsDirtyTracker, !markNew, mapInstantiator, keyMapper, valueMapper);
            }
            CollectionInstantiator collectionInstantiator = ((AbstractAttribute)targetAttribute).getCollectionInstantiator();
            return new CollectionMappingAccessor(Accessors.forViewAttribute(null, sourceAttribute, true), needsDirtyTracker, !markNew, collectionInstantiator, valueMapper);
        }
        if (targetAttribute.isSubview()) {
            Object attributeType = ((SingularAttribute)targetAttribute).getType();
            if (subMapperKey != null) {
                attributeType = ((Key)subMapperKey).targetType;
            }
            ViewMapper<Object, Object> mapper = this.createViewMapper((Type<?>)((SingularAttribute)sourceAttribute).getType(), (Type<?>)attributeType, ignoreMissing, maybeMarkNew, entityViewManager, proxyFactory, newPrefix, subMappers);
            return new AttributeMappingAccessor(Accessors.forViewAttribute(null, sourceAttribute, true), mapper);
        }
        if (targetAttribute.getConvertedJavaType() != sourceAttribute.getConvertedJavaType()) {
            throw this.inconvertible("Attribute '" + targetAttribute.getName() + "' from target type has a different type than in source type!", sourceType, targetType);
        }
        return Accessors.forViewAttribute(null, sourceAttribute, true);
    }

    private ViewMapper<Object, Object> createViewMapper(Type<?> source, Type<?> target, boolean ignoreMissing, Boolean markNew, EntityViewManager entityViewManager, ProxyFactory proxyFactory, String prefix, Map<String, Key<Object, Object>> subMappers) {
        ManagedViewType sourceType = (ManagedViewType)source;
        ManagedViewType targetType = (ManagedViewType)target;
        return new ViewMapper<Object, Object>(sourceType, targetType, ignoreMissing, markNew, entityViewManager, proxyFactory, prefix, subMappers);
    }

    private RuntimeException inconvertible(String reason, ManagedViewType<S> sourceType, ManagedViewType<T> targetType) {
        return new IllegalArgumentException("Can't convert from '" + sourceType.getJavaType().getName() + "' to '" + targetType.getJavaType().getName() + "'! " + reason);
    }

    public T map(S source) {
        Object[] tuple = new Object[this.sourceAccessors.length];
        for (int i = 0; i < this.sourceAccessors.length; ++i) {
            if (this.sourceAccessors[i] == null) continue;
            tuple[i] = this.sourceAccessors[i].getValue(source);
        }
        T result = this.objectInstantiator.newInstance(tuple);
        if (this.dirtyMapping != null && source instanceof DirtyTracker) {
            DirtyTracker oldDirtyTracker = (DirtyTracker)source;
            DirtyTracker dirtyTracker = (DirtyTracker)result;
            if (this.copyInitialState) {
                if (oldDirtyTracker instanceof DirtyStateTrackable && dirtyTracker instanceof DirtyStateTrackable) {
                    Object[] oldInitial = ((DirtyStateTrackable)oldDirtyTracker).$$_getInitialState();
                    Object[] newInitial = ((DirtyStateTrackable)dirtyTracker).$$_getInitialState();
                    for (int i = 0; i < this.dirtyMapping.length; ++i) {
                        int dirtyStateIndex = this.dirtyMapping[i];
                        if (!oldDirtyTracker.$$_isDirty(dirtyStateIndex)) continue;
                        newInitial[i] = oldInitial[dirtyStateIndex];
                        dirtyTracker.$$_markDirty(i);
                    }
                } else {
                    for (int i = 0; i < this.dirtyMapping.length; ++i) {
                        if (!oldDirtyTracker.$$_isDirty(this.dirtyMapping[i])) continue;
                        dirtyTracker.$$_markDirty(i);
                    }
                }
            } else {
                if (dirtyTracker instanceof DirtyStateTrackable) {
                    Object[] initialState = ((DirtyStateTrackable)dirtyTracker).$$_getInitialState();
                    Arrays.fill(initialState, null);
                }
                for (int i = 0; i < this.dirtyMapping.length; ++i) {
                    if (!oldDirtyTracker.$$_isDirty(this.dirtyMapping[i])) continue;
                    dirtyTracker.$$_markDirty(i);
                }
            }
        }
        if (this.markNew) {
            ((MutableStateTrackable)result).$$_setIsNew(true);
        }
        if (this.postConvert != null) {
            try {
                if (this.postConvertUsesSource) {
                    this.postConvert.invoke(result, source);
                } else {
                    this.postConvert.invoke(result, new Object[0]);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Error during invocation of post convert method!", ex);
            }
        }
        return result;
    }

    private static abstract class ReadOnlyAccessor
    implements AttributeAccessor {
        private ReadOnlyAccessor() {
        }

        @Override
        public void setValue(Object object, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getOrCreateValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    private static class AttributeMappingAccessor
    extends ReadOnlyAccessor {
        private final AttributeAccessor accessor;
        private final ViewMapper<Object, Object> mapper;

        public AttributeMappingAccessor(AttributeAccessor accessor, ViewMapper<Object, Object> mapper) {
            this.accessor = accessor;
            this.mapper = mapper;
        }

        @Override
        public Object getValue(Object object) {
            Object value = this.accessor.getValue(object);
            if (value != null) {
                return this.mapper.map(value);
            }
            return null;
        }
    }

    private static class CollectionMappingAccessor
    extends ReadOnlyAccessor {
        private final AttributeAccessor accessor;
        private final boolean recording;
        private final boolean copyDirtyState;
        private final CollectionInstantiator collectionInstantiator;
        private final ViewMapper<Object, Object> valueMapper;

        public CollectionMappingAccessor(AttributeAccessor accessor, boolean recording, boolean copyDirtyState, CollectionInstantiator collectionInstantiator, ViewMapper<Object, Object> valueMapper) {
            this.accessor = accessor;
            this.recording = recording;
            this.copyDirtyState = copyDirtyState;
            this.collectionInstantiator = collectionInstantiator;
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(Object object) {
            Collection collection = (Collection)this.accessor.getValue(object);
            Collection<Object> newCollection = null;
            if (collection != null) {
                Collection<?> backingCollection;
                IdentityHashMap<Object, Object> objectMapping = null;
                if (this.recording) {
                    RecordingCollection<?, ?> coll = this.collectionInstantiator.createRecordingCollection(collection.size());
                    newCollection = coll;
                    if (this.copyDirtyState) {
                        backingCollection = coll.getDelegate();
                        if (collection instanceof RecordingCollection && this.valueMapper != null) {
                            objectMapping = new IdentityHashMap<Object, Object>(collection.size());
                            for (Object e : ((RecordingCollection)collection).getRemovedElements()) {
                                objectMapping.put(e, this.valueMapper.map(e));
                            }
                        }
                    } else {
                        backingCollection = newCollection;
                    }
                } else {
                    backingCollection = this.collectionInstantiator.createCollection(collection.size());
                    newCollection = backingCollection;
                }
                if (this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Object o : collection) {
                            backingCollection.add(this.valueMapper.map(o));
                        }
                    } else {
                        for (Object o : collection) {
                            Object newObject = this.valueMapper.map(o);
                            objectMapping.put(o, newObject);
                            backingCollection.add(newObject);
                        }
                    }
                } else {
                    backingCollection.addAll(collection);
                }
                if (this.recording && this.copyDirtyState && collection instanceof RecordingCollection) {
                    ((RecordingCollection)newCollection).setActions((RecordingCollection)collection, objectMapping);
                }
            }
            return newCollection;
        }
    }

    private static class MapMappingAccessor
    extends ReadOnlyAccessor {
        private final AttributeAccessor accessor;
        private final boolean recording;
        private final boolean copyDirtyState;
        private final MapInstantiator<?, ?> mapInstantiator;
        private final ViewMapper<Object, Object> keyMapper;
        private final ViewMapper<Object, Object> valueMapper;

        public MapMappingAccessor(AttributeAccessor accessor, boolean recording, boolean copyDirtyState, MapInstantiator<?, ?> mapInstantiator, ViewMapper<Object, Object> keyMapper, ViewMapper<Object, Object> valueMapper) {
            this.accessor = accessor;
            this.recording = recording;
            this.copyDirtyState = copyDirtyState;
            this.mapInstantiator = mapInstantiator;
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(Object object) {
            Map map = (Map)this.accessor.getValue(object);
            Object newMap = null;
            if (map != null) {
                Object newKey;
                Object backingMap;
                IdentityHashMap<Object, Object> objectMapping = null;
                if (this.recording) {
                    Object recordingMap = this.mapInstantiator.createRecordingCollection(map.size());
                    newMap = recordingMap;
                    if (this.copyDirtyState) {
                        backingMap = ((RecordingMap)recordingMap).getDelegate();
                        if (map instanceof RecordingMap && (this.keyMapper != null || this.valueMapper != null)) {
                            objectMapping = new IdentityHashMap<Object, Object>(map.size() * 2);
                            if (this.keyMapper != null) {
                                for (Object e : ((RecordingMap)map).getRemovedKeys()) {
                                    objectMapping.put(e, this.keyMapper.map(e));
                                }
                            }
                            if (this.valueMapper != null) {
                                for (Object e : ((RecordingMap)map).getRemovedElements()) {
                                    objectMapping.put(e, this.valueMapper.map(e));
                                }
                            }
                        }
                    } else {
                        backingMap = newMap;
                    }
                } else {
                    backingMap = this.mapInstantiator.createCollection(map.size());
                    newMap = backingMap;
                }
                if (this.keyMapper != null && this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(this.keyMapper.map(entry.getKey()), this.valueMapper.map(entry.getValue()));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            newKey = this.keyMapper.map(entry.getKey());
                            Object newValue = this.valueMapper.map(entry.getValue());
                            objectMapping.put(entry.getKey(), newKey);
                            objectMapping.put(entry.getValue(), newValue);
                            backingMap.put(newKey, newValue);
                        }
                    }
                } else if (this.keyMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(this.keyMapper.map(entry.getKey()), entry.getValue());
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            newKey = this.keyMapper.map(entry.getKey());
                            objectMapping.put(entry.getKey(), newKey);
                            backingMap.put(newKey, entry.getValue());
                        }
                    }
                } else if (this.valueMapper != null) {
                    if (objectMapping == null) {
                        for (Map.Entry entry : map.entrySet()) {
                            backingMap.put(entry.getKey(), this.valueMapper.map(entry.getValue()));
                        }
                    } else {
                        for (Map.Entry entry : map.entrySet()) {
                            Object newValue = this.valueMapper.map(entry.getValue());
                            objectMapping.put(entry.getValue(), newValue);
                            backingMap.put(entry.getKey(), newValue);
                        }
                    }
                } else {
                    backingMap.putAll(map);
                }
                if (this.recording && this.copyDirtyState && map instanceof RecordingMap) {
                    ((RecordingMap)newMap).setActions((RecordingMap)map, objectMapping);
                }
            }
            return newMap;
        }
    }

    public static class Key<S, T> {
        public static final Key<Object, Object> EXCLUDE_MARKER = new Key(null, null, false, false);
        private final ManagedViewTypeImplementor<S> sourceType;
        private final ManagedViewTypeImplementor<T> targetType;
        private final boolean ignoreMissing;
        private final boolean markNew;

        public Key(ManagedViewTypeImplementor<S> sourceType, ManagedViewTypeImplementor<T> targetType, boolean ignoreMissing, boolean markNew) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.ignoreMissing = ignoreMissing;
            this.markNew = markNew;
        }

        public ViewMapper<S, T> createViewMapper(EntityViewManager entityViewManager, ProxyFactory proxyFactory, Map<String, Key<Object, Object>> subMappers) {
            return new ViewMapper<S, T>(this.sourceType, this.targetType, this.ignoreMissing, this.markNew, entityViewManager, proxyFactory, "", subMappers);
        }

        public static <Y> Key<Object, Y> create(ViewMetamodel metamodel, Object source, Class<Y> entityViewClass, ConvertOption ... convertOptions) {
            if (!(source instanceof EntityViewProxy)) {
                throw new IllegalArgumentException("Can only convert one entity view to another. Invalid source type: " + source.getClass());
            }
            EntityViewProxy sourceProxy = (EntityViewProxy)source;
            return Key.create(metamodel, sourceProxy.$$_getEntityViewClass(), entityViewClass, convertOptions);
        }

        public static <X, Y> Key<X, Y> create(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> entityViewClass, ConvertOption ... convertOptions) {
            boolean ignoreMissingAttributes = false;
            boolean markNew = false;
            block4: for (ConvertOption copyOption : convertOptions) {
                switch (copyOption) {
                    case CREATE_NEW: {
                        markNew = true;
                        continue block4;
                    }
                    case IGNORE_MISSING_ATTRIBUTES: {
                        ignoreMissingAttributes = true;
                        continue block4;
                    }
                }
            }
            return Key.create(metamodel, sourceEntityViewClass, entityViewClass, ignoreMissingAttributes, markNew);
        }

        public static <X, Y> Key<X, Y> create(ViewMetamodel metamodel, Class<X> sourceEntityViewClass, Class<Y> entityViewClass, boolean ignoreMissingAttributes, boolean markNew) {
            ManagedViewTypeImplementor sourceViewType = (ManagedViewTypeImplementor)metamodel.managedView(sourceEntityViewClass);
            if (sourceViewType == null) {
                throw new IllegalArgumentException("Unknown source view type: " + sourceEntityViewClass.getName());
            }
            ManagedViewTypeImplementor targetViewType = (ManagedViewTypeImplementor)metamodel.managedView(entityViewClass);
            if (targetViewType == null) {
                throw new IllegalArgumentException("Unknown target view type: " + entityViewClass.getName());
            }
            return new Key(sourceViewType, targetViewType, ignoreMissingAttributes, markNew);
        }

        public ManagedViewTypeImplementor<S> getSourceType() {
            return this.sourceType;
        }

        public ManagedViewTypeImplementor<T> getTargetType() {
            return this.targetType;
        }

        public boolean isIgnoreMissing() {
            return this.ignoreMissing;
        }

        public boolean isMarkNew() {
            return this.markNew;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this == EXCLUDE_MARKER || o == EXCLUDE_MARKER || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.ignoreMissing != key.ignoreMissing) {
                return false;
            }
            if (this.markNew != key.markNew) {
                return false;
            }
            if (!this.sourceType.equals(key.sourceType)) {
                return false;
            }
            return this.targetType.equals(key.targetType);
        }

        public int hashCode() {
            if (this == EXCLUDE_MARKER) {
                return 0;
            }
            int result = this.sourceType.hashCode();
            result = 31 * result + this.targetType.hashCode();
            result = 31 * result + (this.ignoreMissing ? 1 : 0);
            result = 31 * result + (this.markNew ? 1 : 0);
            return result;
        }
    }
}

