/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class AbstractAnnotationAttributeMappingReader {
    protected final MetamodelBootContext context;

    public AbstractAnnotationAttributeMappingReader(MetamodelBootContext context) {
        this.context = context;
    }

    public void applyCollectionMapping(AttributeMapping attributeMapping, CollectionMapping collectionMapping) {
        Class<?> collectionType = attributeMapping.getDeclaredType();
        if (collectionMapping != null && collectionMapping.ignoreIndex() && Map.class.isAssignableFrom(collectionType)) {
            this.context.addError("Illegal ignoreIndex mapping for the " + attributeMapping.getErrorLocation());
        }
        if (collectionMapping != null) {
            Class c = collectionMapping.comparator();
            Class comparatorClass = c == Comparator.class ? null : c;
            if (comparatorClass != null || MetamodelUtils.isSorted(collectionType)) {
                if (collectionMapping.ignoreIndex()) {
                    this.context.addError("Illegal ignoreIndex mapping for the sorted " + attributeMapping.getErrorLocation());
                }
                if (collectionMapping.ordered()) {
                    this.context.addError("Illegal ordered mapping for the sorted " + attributeMapping.getErrorLocation());
                }
                attributeMapping.setContainerSorted(comparatorClass);
            } else if (collectionType == List.class) {
                if (collectionMapping.ignoreIndex()) {
                    attributeMapping.setContainerDefault();
                }
            } else if (collectionMapping.ordered()) {
                attributeMapping.setContainerOrdered();
            } else {
                attributeMapping.setContainerDefault();
            }
            attributeMapping.setForceUniqueness(collectionMapping.forceUnique());
        } else if (collectionType != List.class) {
            if (MetamodelUtils.isSorted(collectionType)) {
                attributeMapping.setContainerSorted(null);
            } else {
                attributeMapping.setContainerDefault();
            }
        }
    }
}

