/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.lang.StringUtils;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.spi.ServiceProvider;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.FetchStrategy;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.SubqueryProviderFactory;
import com.blazebit.persistence.view.impl.CollectionJoinMappingGathererExpressionVisitor;
import com.blazebit.persistence.view.impl.CorrelationProviderHelper;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import com.blazebit.persistence.view.impl.ScalarTargetResolvingExpressionVisitor;
import com.blazebit.persistence.view.impl.SubqueryProviderHelper;
import com.blazebit.persistence.view.impl.UpdatableExpressionVisitor;
import com.blazebit.persistence.view.impl.collection.CollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.ListCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.MapInstantiator;
import com.blazebit.persistence.view.impl.collection.OrderedCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.OrderedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.OrderedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.collection.SortedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.SortedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.collection.UnorderedMapInstantiator;
import com.blazebit.persistence.view.impl.collection.UnorderedSetCollectionInstantiator;
import com.blazebit.persistence.view.impl.metamodel.AttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelUtils;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.persistence.view.metamodel.ViewType;
import com.blazebit.persistence.view.spi.EmbeddingViewJpqlMacro;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;

public abstract class AbstractAttribute<X, Y>
implements com.blazebit.persistence.view.metamodel.Attribute<X, Y> {
    private static final String[] EMPTY = new String[0];
    private static final String THIS = "this";
    private static final Pattern PREFIX_THIS_REPLACE_PATTERN = Pattern.compile("([^a-zA-Z0-9\\.])this\\.");
    protected final ManagedViewTypeImplementor<X> declaringType;
    protected final Class<Y> javaType;
    protected final Class<?> convertedJavaType;
    protected final String mapping;
    protected final String[] fetches;
    protected final FetchStrategy fetchStrategy;
    protected final int batchSize;
    protected final SubqueryProviderFactory subqueryProviderFactory;
    protected final Class<? extends SubqueryProvider> subqueryProvider;
    protected final String subqueryExpression;
    protected final String subqueryAlias;
    protected final CorrelationProviderFactory correlationProviderFactory;
    protected final Class<? extends CorrelationProvider> correlationProvider;
    protected final String correlationBasis;
    protected final String correlationResult;
    protected final Class<?> correlated;
    protected final String correlationKeyAlias;
    protected final String correlationExpression;
    protected final Attribute.MappingType mappingType;
    protected final boolean id;
    protected final Attribute<?, ?> updateMappableAttribute;
    private final List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargetTypes;

    public AbstractAttribute(ManagedViewTypeImplementor<X> declaringType, AttributeMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        int batchSize;
        Class<?> javaType = null;
        try {
            javaType = mapping.getJavaType(context, embeddableMapping);
            if (javaType == null) {
                context.addError("The attribute type is not resolvable at the " + mapping.getErrorLocation());
            }
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the attribute type at the " + mapping.getErrorLocation());
        }
        this.possibleTargetTypes = mapping.getPossibleTargetTypes(context);
        Integer defaultbatchSize = mapping.getDefaultBatchSize();
        if (defaultbatchSize == null || defaultbatchSize == -1) {
            batchSize = -1;
        } else if (defaultbatchSize < 1) {
            context.addError("Illegal batch fetch size lower than 1 defined at '" + mapping.getErrorLocation() + "'!");
            batchSize = Integer.MIN_VALUE;
        } else {
            batchSize = defaultbatchSize;
        }
        this.declaringType = declaringType;
        this.javaType = javaType;
        this.convertedJavaType = AbstractAttribute.getConvertedType(declaringType.getJavaType(), mapping.getType(context, embeddableMapping).getConvertedType(), javaType);
        Annotation mappingAnnotation = mapping.getMapping();
        if (mappingAnnotation instanceof IdMapping) {
            this.mapping = ((IdMapping)mappingAnnotation).value();
            this.fetches = EMPTY;
            this.fetchStrategy = FetchStrategy.JOIN;
            this.batchSize = -1;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = true;
            this.updateMappableAttribute = this.getUpdateMappableAttribute(this.mapping, context);
            this.mappingType = Attribute.MappingType.BASIC;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            this.correlationBasis = null;
            this.correlationResult = null;
            this.correlationProvider = null;
            this.correlationProviderFactory = null;
            this.correlated = null;
            this.correlationKeyAlias = null;
            this.correlationExpression = null;
        } else if (mappingAnnotation instanceof Mapping) {
            Mapping m = (Mapping)mappingAnnotation;
            this.mapping = m.value();
            this.fetches = m.fetches();
            this.fetchStrategy = m.fetch();
            this.batchSize = batchSize;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = false;
            this.updateMappableAttribute = this.getUpdateMappableAttribute(this.mapping, context);
            this.mappingType = Attribute.MappingType.BASIC;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            if (this.fetchStrategy == FetchStrategy.JOIN) {
                this.correlationProvider = null;
                this.correlationProviderFactory = null;
                this.correlationResult = null;
                this.correlationBasis = null;
                this.correlated = null;
                this.correlationKeyAlias = null;
                this.correlationExpression = null;
            } else {
                int index;
                ExtendedManagedType managedType = (ExtendedManagedType)context.getEntityMetamodel().getManagedType(ExtendedManagedType.class, declaringType.getJpaManagedType());
                ExtendedAttribute attribute = (ExtendedAttribute)managedType.getOwnedAttributes().get(this.mapping);
                this.correlationKeyAlias = "__correlationAlias";
                if (this.fetchStrategy == FetchStrategy.SELECT && attribute != null && attribute.hasJoinCondition()) {
                    this.correlated = declaringType.getEntityClass();
                    this.correlationExpression = "this IN __correlationAlias";
                    this.correlationResult = this.mapping;
                } else if (attribute == null && (index = this.mapping.indexOf(46)) != -1 && this.mapping.indexOf(40) == -1 && (attribute = (ExtendedAttribute)managedType.getOwnedAttributes().get(this.mapping.substring(0, index))) != null && !StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && !attribute.hasJoinCondition()) {
                    this.correlated = attribute.getElementClass();
                    this.correlationExpression = attribute.getMappedBy() + " IN __correlationAlias";
                    this.correlationResult = this.mapping.substring(index + 1);
                } else if (attribute != null && !StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && !attribute.hasJoinCondition()) {
                    this.correlated = attribute.getElementClass();
                    this.correlationExpression = attribute.getMappedBy() + " IN __correlationAlias";
                    this.correlationResult = "";
                } else {
                    this.correlated = declaringType.getEntityClass();
                    this.correlationExpression = "this IN __correlationAlias";
                    this.correlationResult = this.mapping;
                }
                this.correlationBasis = THIS;
                this.correlationProvider = CorrelationProviderHelper.createCorrelationProvider(this.correlated, this.correlationKeyAlias, this.correlationExpression, context);
                this.correlationProviderFactory = CorrelationProviderHelper.getFactory(this.correlationProvider);
            }
        } else if (mappingAnnotation instanceof MappingParameter) {
            this.mapping = ((MappingParameter)mappingAnnotation).value();
            this.fetches = EMPTY;
            this.fetchStrategy = FetchStrategy.JOIN;
            this.batchSize = -1;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = false;
            this.updateMappableAttribute = null;
            this.mappingType = Attribute.MappingType.PARAMETER;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            this.correlationBasis = null;
            this.correlationResult = null;
            this.correlationProvider = null;
            this.correlationProviderFactory = null;
            this.correlated = null;
            this.correlationKeyAlias = null;
            this.correlationExpression = null;
        } else if (mappingAnnotation instanceof MappingSubquery) {
            MappingSubquery mappingSubquery = (MappingSubquery)mappingAnnotation;
            this.mapping = null;
            this.fetches = EMPTY;
            this.subqueryProvider = mappingSubquery.value();
            this.subqueryProviderFactory = SubqueryProviderHelper.getFactory(this.subqueryProvider);
            this.fetchStrategy = FetchStrategy.JOIN;
            this.batchSize = -1;
            this.id = false;
            this.updateMappableAttribute = null;
            this.mappingType = Attribute.MappingType.SUBQUERY;
            this.subqueryExpression = mappingSubquery.expression();
            this.subqueryAlias = mappingSubquery.subqueryAlias();
            this.correlationBasis = null;
            this.correlationResult = null;
            this.correlationProvider = null;
            this.correlationProviderFactory = null;
            this.correlated = null;
            this.correlationKeyAlias = null;
            this.correlationExpression = null;
            if (!this.subqueryExpression.isEmpty() && this.subqueryAlias.isEmpty()) {
                context.addError("The subquery alias is empty although the subquery expression is not " + mapping.getErrorLocation());
            }
            if (this.subqueryProvider.getEnclosingClass() != null && !Modifier.isStatic(this.subqueryProvider.getModifiers())) {
                context.addError("The subquery provider is defined as non-static inner class. Make it static, otherwise it can't be instantiated: " + mapping.getErrorLocation());
            }
        } else if (mappingAnnotation instanceof MappingCorrelated) {
            MappingCorrelated mappingCorrelated = (MappingCorrelated)mappingAnnotation;
            this.mapping = null;
            this.fetches = mappingCorrelated.fetches();
            this.fetchStrategy = mappingCorrelated.fetch();
            this.batchSize = this.fetchStrategy == FetchStrategy.SELECT ? batchSize : -1;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = false;
            this.updateMappableAttribute = null;
            this.mappingType = Attribute.MappingType.CORRELATED;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            this.correlationBasis = mappingCorrelated.correlationBasis();
            this.correlationResult = mappingCorrelated.correlationResult();
            this.correlationProvider = mappingCorrelated.correlator();
            this.correlated = null;
            this.correlationKeyAlias = null;
            this.correlationExpression = null;
            if (this.correlationProvider.getEnclosingClass() != null && !Modifier.isStatic(this.correlationProvider.getModifiers())) {
                context.addError("The correlation provider is defined as non-static inner class. Make it static, otherwise it can't be instantiated: " + mapping.getErrorLocation());
            }
            this.correlationProviderFactory = CorrelationProviderHelper.getFactory(this.correlationProvider);
        } else if (mappingAnnotation instanceof MappingCorrelatedSimple) {
            MappingCorrelatedSimple mappingCorrelated = (MappingCorrelatedSimple)mappingAnnotation;
            this.mapping = null;
            this.fetches = mappingCorrelated.fetches();
            this.fetchStrategy = mappingCorrelated.fetch();
            this.batchSize = this.fetchStrategy == FetchStrategy.SELECT ? batchSize : -1;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = false;
            this.updateMappableAttribute = null;
            this.mappingType = Attribute.MappingType.CORRELATED;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            this.correlationProvider = CorrelationProviderHelper.createCorrelationProvider(mappingCorrelated.correlated(), mappingCorrelated.correlationKeyAlias(), mappingCorrelated.correlationExpression(), context);
            this.correlationProviderFactory = CorrelationProviderHelper.getFactory(this.correlationProvider);
            this.correlationBasis = mappingCorrelated.correlationBasis();
            this.correlationResult = mappingCorrelated.correlationResult();
            this.correlated = mappingCorrelated.correlated();
            this.correlationKeyAlias = mappingCorrelated.correlationKeyAlias();
            this.correlationExpression = mappingCorrelated.correlationExpression();
            if (mappingCorrelated.correlationBasis().isEmpty()) {
                context.addError("Illegal empty correlation basis in the " + mapping.getErrorLocation());
            }
            if (!(declaringType instanceof ViewType) && (this.fetchStrategy == FetchStrategy.SELECT || this.fetchStrategy == FetchStrategy.SUBSELECT) && mappingCorrelated.correlationExpression().toUpperCase().contains("EMBEDDING_VIEW")) {
                context.addError("The use of EMBEDDING_VIEW in the correlation for '" + mapping.getErrorLocation() + "' is illegal because the embedding view type '" + declaringType.getJavaType().getName() + "' does not declare a @IdMapping!");
            }
        } else {
            context.addError("No mapping annotation could be found " + mapping.getErrorLocation());
            this.mapping = null;
            this.fetches = EMPTY;
            this.fetchStrategy = null;
            this.batchSize = Integer.MIN_VALUE;
            this.subqueryProviderFactory = null;
            this.subqueryProvider = null;
            this.id = false;
            this.updateMappableAttribute = null;
            this.mappingType = null;
            this.subqueryExpression = null;
            this.subqueryAlias = null;
            this.correlationBasis = null;
            this.correlationResult = null;
            this.correlationProvider = null;
            this.correlationProviderFactory = null;
            this.correlated = null;
            this.correlationKeyAlias = null;
            this.correlationExpression = null;
        }
    }

    private static Class<?> getConvertedType(Class<?> declaringClass, Type convertedType, Class<?> javaType) {
        if (convertedType == null) {
            return javaType;
        }
        return ReflectionUtils.resolveType(declaringClass, (Type)convertedType);
    }

    private Attribute<?, ?> getUpdateMappableAttribute(String mapping, MetamodelBuildingContext context) {
        try {
            UpdatableExpressionVisitor visitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), this.declaringType.getEntityClass(), true);
            context.getExpressionFactory().createPathExpression(mapping).accept((Expression.Visitor)visitor);
            Iterator<Attribute<?, ?>> iterator = visitor.getPossibleTargets().keySet().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String stripThisFromMapping(String mapping) {
        return AbstractAttribute.replaceThisFromMapping(mapping, "");
    }

    public static String replaceThisFromMapping(String mapping, String root) {
        if (mapping == null) {
            return null;
        }
        if ((mapping = mapping.trim()).startsWith(THIS)) {
            if (mapping.length() == THIS.length()) {
                return root;
            }
            if (root.isEmpty()) {
                char nextChar = mapping.charAt(THIS.length());
                if (nextChar == '.') {
                    mapping = mapping.substring(THIS.length() + 1);
                }
            } else {
                mapping = root + mapping.substring(THIS.length());
            }
        }
        String replacement = root.isEmpty() ? "$1" : "$1" + root + ".";
        mapping = PREFIX_THIS_REPLACE_PATTERN.matcher(mapping).replaceAll(replacement);
        return mapping;
    }

    public final void renderSubqueryExpression(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.subqueryExpression, this.subqueryAlias, serviceProvider, sb);
    }

    public final void renderSubqueryExpression(String parent, String subqueryExpression, String subqueryAlias, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, subqueryExpression, subqueryAlias, serviceProvider, sb);
    }

    public final void renderCorrelationBasis(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.correlationBasis, null, serviceProvider, sb);
    }

    public final void renderCorrelationResult(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.correlationResult, null, serviceProvider, sb);
    }

    public final void renderMapping(String parent, ServiceProvider serviceProvider, StringBuilder sb) {
        this.renderExpression(parent, this.mapping, null, serviceProvider, sb);
    }

    private void renderExpression(String parent, String expression, String aliasToSkip, ServiceProvider serviceProvider, StringBuilder sb) {
        if (expression.isEmpty()) {
            if (parent != null && !parent.isEmpty()) {
                sb.append(AbstractAttribute.stripThisFromMapping(parent));
            }
            return;
        }
        if (parent != null && !parent.isEmpty()) {
            ExpressionFactory ef = (ExpressionFactory)serviceProvider.getService(ExpressionFactory.class);
            Expression expr = ef.createSimpleExpression(expression, false, false, true);
            EmbeddingViewJpqlMacro embeddingViewJpqlMacro = (EmbeddingViewJpqlMacro)ef.getDefaultMacroConfiguration().get("EMBEDDING_VIEW").getState()[0];
            PrefixingQueryGenerator generator = new PrefixingQueryGenerator(Collections.singletonList(parent), embeddingViewJpqlMacro.getEmbeddingViewPath(), "correlationEmbeddingViewAlias_", aliasToSkip);
            generator.setQueryBuffer(sb);
            expr.accept((Expression.Visitor)generator);
        } else {
            sb.append(expression);
        }
    }

    public Map<String, Boolean> getCollectionJoinMappings(ManagedType<?> managedType, MetamodelBuildingContext context) {
        if (this.mapping == null || this.isQueryParameter() || this.getFetchStrategy() != FetchStrategy.JOIN) {
            return Collections.emptyMap();
        }
        CollectionJoinMappingGathererExpressionVisitor visitor = new CollectionJoinMappingGathererExpressionVisitor(managedType, context.getEntityMetamodel());
        String expression = AbstractAttribute.stripThisFromMapping(this.mapping);
        if (expression.isEmpty()) {
            return Collections.emptyMap();
        }
        context.getTypeValidationExpressionFactory().createSimpleExpression(expression, false, false, true).accept((Expression.Visitor)visitor);
        HashMap<String, Boolean> mappings = new HashMap<String, Boolean>();
        boolean aggregate = this.getAttributeType() == Attribute.AttributeType.SINGULAR;
        for (String s : visitor.getPaths()) {
            mappings.put(s, aggregate);
        }
        return mappings;
    }

    public boolean hasJoinFetchedCollections() {
        return this.getFetchStrategy() == FetchStrategy.JOIN && (this.isCollection() || this.getElementType() instanceof ManagedViewTypeImpl && ((ManagedViewTypeImplementor)this.getElementType()).hasJoinFetchedCollections());
    }

    protected boolean determineForcedUnique(MetamodelBuildingContext context) {
        ExtendedManagedType managedType;
        ExtendedAttribute attribute;
        if (this.isCollection() && this.getMapping() != null && this.getMapping().indexOf(46) == -1 && (attribute = (ExtendedAttribute)(managedType = (ExtendedManagedType)context.getEntityMetamodel().getManagedType(ExtendedManagedType.class, this.getDeclaringType().getJpaManagedType())).getOwnedAttributes().get(this.getMapping())) != null && attribute.getAttribute() instanceof PluralAttribute) {
            return !(((PluralAttribute)attribute.getAttribute()).getCollectionType() == PluralAttribute.CollectionType.MAP || StringUtils.isEmpty((CharSequence)attribute.getMappedBy()) && attribute.isBag() || attribute.getJoinTable() != null && attribute.getJoinTable().getKeyColumnMappings() != null || MetamodelUtils.isIndexedList(context.getEntityMetamodel(), context.getExpressionFactory(), managedType.getType().getJavaType(), this.getMapping()));
        }
        return false;
    }

    public Attribute<?, ?> getUpdateMappableAttribute() {
        return this.updateMappableAttribute;
    }

    public boolean isUpdateMappable() {
        return this.hasDirtyStateIndex() || this.updateMappableAttribute != null;
    }

    public Class<?> getCorrelated() {
        return this.correlated;
    }

    public String getCorrelationKeyAlias() {
        return this.correlationKeyAlias;
    }

    public String getCorrelationExpression() {
        return this.correlationExpression;
    }

    public abstract boolean needsDirtyTracker();

    public abstract boolean hasDirtyStateIndex();

    private static boolean isCompatible(ScalarTargetResolvingExpressionVisitor.TargetType t, Class<?> targetType, Class<?> targetElementType, boolean subtypesAllowed, boolean singular) {
        if (t.hasCollectionJoin()) {
            return AbstractAttribute.isCompatible(t.getLeafBaseClass(), t.getLeafBaseValueClass(), targetType, targetElementType, subtypesAllowed, singular);
        }
        Class<?> entityAttributeElementType = AbstractAttribute.getElementTypeOrNull(t, singular);
        return AbstractAttribute.isCompatible(t.getLeafBaseClass(), entityAttributeElementType, targetType, targetElementType, subtypesAllowed, singular);
    }

    private static Class<?> getElementTypeOrNull(ScalarTargetResolvingExpressionVisitor.TargetType t, boolean singular) {
        if (singular && t.getLeafBaseClass() == t.getLeafBaseValueClass() && (Collection.class.isAssignableFrom(t.getLeafBaseClass()) || Map.class.isAssignableFrom(t.getLeafBaseClass()))) {
            Class elementClass;
            Member javaMember = t.getLeafMethod().getJavaMember();
            if (javaMember instanceof Field) {
                Class[] resolvedFieldTypeArguments = ReflectionUtils.getResolvedFieldTypeArguments((Class)t.getLeafMethod().getDeclaringType().getJavaType(), (Field)((Field)javaMember));
                elementClass = resolvedFieldTypeArguments[resolvedFieldTypeArguments.length - 1];
            } else if (javaMember instanceof Method) {
                Class[] resolvedMethodReturnTypeArguments = ReflectionUtils.getResolvedMethodReturnTypeArguments((Class)t.getLeafMethod().getDeclaringType().getJavaType(), (Method)((Method)javaMember));
                elementClass = resolvedMethodReturnTypeArguments[resolvedMethodReturnTypeArguments.length - 1];
            } else {
                elementClass = null;
            }
            if (elementClass != t.getLeafBaseValueClass()) {
                return elementClass;
            }
        }
        return null;
    }

    private static boolean isCompatible(Class<?> entityAttributeType, Class<?> entityAttributeElementType, Class<?> viewAttributeType, Class<?> viewAttributeElementType, boolean subtypesAllowed, boolean singular) {
        if (entityAttributeType == null) {
            return true;
        }
        if (subtypesAllowed) {
            if (entityAttributeElementType != null) {
                if (viewAttributeElementType != null) {
                    return (viewAttributeType.isAssignableFrom(entityAttributeType) || !singular && Map.class.isAssignableFrom(entityAttributeType) && Collection.class.isAssignableFrom(viewAttributeType)) && viewAttributeElementType.isAssignableFrom(entityAttributeElementType);
                }
                return viewAttributeType.isAssignableFrom(entityAttributeElementType);
            }
            if (viewAttributeElementType != null) {
                return viewAttributeElementType.isAssignableFrom(entityAttributeType);
            }
            return viewAttributeType.isAssignableFrom(entityAttributeType);
        }
        if (entityAttributeElementType != null) {
            if (viewAttributeElementType != null) {
                return viewAttributeType == entityAttributeType && viewAttributeElementType == entityAttributeElementType;
            }
            return viewAttributeType == entityAttributeElementType;
        }
        if (viewAttributeElementType != null) {
            return viewAttributeElementType == entityAttributeType;
        }
        return viewAttributeType == entityAttributeType;
    }

    private static void validateTypesCompatible(ManagedType<?> managedType, String expression, Class<?> targetType, Class<?> targetElementType, boolean subtypesAllowed, boolean singular, MetamodelBuildingContext context, ExpressionLocation expressionLocation, String location) {
        if (expression.isEmpty()) {
            if (AbstractAttribute.isCompatible(managedType.getJavaType(), null, targetType, targetElementType, subtypesAllowed, singular)) {
                return;
            }
            context.addError(AbstractAttribute.typeCompatibilityError(Arrays.asList(new ScalarTargetResolvingExpressionVisitor.TargetTypeImpl(false, null, managedType.getJavaType(), null, null)), targetType, targetElementType, expressionLocation, location));
            return;
        }
        ScalarTargetResolvingExpressionVisitor visitor = new ScalarTargetResolvingExpressionVisitor(managedType, context.getEntityMetamodel(), context.getJpqlFunctions());
        try {
            context.getTypeValidationExpressionFactory().createSimpleExpression(expression, false, false, true).accept((Expression.Visitor)visitor);
        }
        catch (SyntaxErrorException ex) {
            context.addError("Syntax error in " + (Object)((Object)expressionLocation) + " '" + expression + "' of the " + location + ": " + ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            context.addError("An error occurred while trying to resolve the " + (Object)((Object)expressionLocation) + " of the " + location + ": " + ex.getMessage());
        }
        AbstractAttribute.validateTypesCompatible(visitor.getPossibleTargetTypes(), targetType, targetElementType, subtypesAllowed, singular, context, expressionLocation, location);
    }

    private static void validateTypesCompatible(List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargets, Class<?> targetType, Class<?> targetElementType, boolean subtypesAllowed, boolean singular, MetamodelBuildingContext context, ExpressionLocation expressionLocation, String location) {
        Class expressionType = targetType;
        if (!possibleTargets.isEmpty()) {
            boolean error = true;
            for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
                if (!AbstractAttribute.isCompatible(t, targetType, targetElementType, subtypesAllowed, singular)) continue;
                error = false;
                break;
            }
            if (error && (targetType = targetType.isPrimitive() ? ReflectionUtils.getObjectClassOfPrimitve(targetType) : ReflectionUtils.getPrimitiveClassOfWrapper(targetType)) != null) {
                for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
                    if (!AbstractAttribute.isCompatible(t, targetType, targetElementType, subtypesAllowed, singular)) continue;
                    error = false;
                    break;
                }
            }
            if (error) {
                context.addError(AbstractAttribute.typeCompatibilityError(possibleTargets, expressionType, targetElementType, expressionLocation, location));
            }
        }
    }

    private static String typeCompatibilityError(List<ScalarTargetResolvingExpressionVisitor.TargetType> possibleTargets, Class<?> targetType, Class<?> targetElementType, ExpressionLocation expressionLocation, String location) {
        StringBuilder sb = new StringBuilder();
        sb.append("The resolved possible types ");
        sb.append('[');
        for (ScalarTargetResolvingExpressionVisitor.TargetType t : possibleTargets) {
            sb.append(t.getLeafBaseClass().getName());
            if (t.getLeafBaseValueClass() != null && t.getLeafBaseClass() != t.getLeafBaseValueClass()) {
                sb.append('<');
                sb.append(t.getLeafBaseValueClass().getName());
                sb.append('>');
            }
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(']');
        sb.append(" are not assignable to the given expression type '");
        sb.append(targetType.getName());
        if (targetElementType != null && targetElementType != targetType) {
            sb.append('<');
            sb.append(targetElementType.getName());
            sb.append('>');
        }
        sb.append("' of the ");
        sb.append((Object)expressionLocation);
        sb.append(" declared by the ");
        sb.append(location);
        sb.append("!");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void checkAttribute(ManagedType<?> managedType, MetamodelBuildingContext context) {
        PathTargetResolvingExpressionVisitor visitor;
        Class expressionType = this.getJavaType();
        Class keyType = null;
        Class elementType = null;
        if (this.fetches.length != 0) {
            ManagedType entityType = context.getEntityMetamodel().getManagedType(this.getElementType().getJavaType());
            if (entityType == null) {
                context.addError("Specifying fetches for non-entity attribute type [" + Arrays.toString(this.fetches) + "] at the " + this.getLocation() + " is not allowed!");
            } else {
                visitor = new ScalarTargetResolvingExpressionVisitor(entityType, context.getEntityMetamodel(), context.getJpqlFunctions());
                for (int i = 0; i < this.fetches.length; ++i) {
                    void var10_17;
                    String fetch = this.fetches[i];
                    if (this.fetches.length == 1) {
                        String string = "the fetch expression";
                    } else {
                        String string = "the " + (i + 1) + ". fetch expression";
                    }
                    visitor.clear();
                    try {
                        context.getExpressionFactory().createPathExpression(fetch).accept((Expression.Visitor)visitor);
                        continue;
                    }
                    catch (SyntaxErrorException ex) {
                        try {
                            context.getExpressionFactory().createSimpleExpression(fetch, false);
                            context.addError("Invalid fetch expression '" + (String)fetch + "' of the " + this.getLocation() + ". Simplify the fetch expression to a simple path expression. Encountered error: " + ex.getMessage());
                        }
                        catch (SyntaxErrorException ex2) {
                            context.addError("Syntax error in " + (String)var10_17 + " '" + (String)fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                        }
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        context.addError("An error occurred while trying to resolve the " + (String)var10_17 + " '" + (String)fetch + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    }
                }
            }
        }
        if (this.isCollection()) {
            elementType = this.getElementType().getJavaType();
            if (!this.isUpdatable()) {
                if (this.isIndexed()) {
                    if (this.getCollectionType() == PluralAttribute.CollectionType.MAP) {
                        expressionType = Map.class;
                        keyType = this.getKeyType().getJavaType();
                    } else {
                        expressionType = List.class;
                        keyType = Integer.class;
                    }
                } else {
                    expressionType = Collection.class;
                }
            }
        }
        if (this.isSubview()) {
            ManagedViewTypeImplementor subviewType = (ManagedViewTypeImplementor)this.getElementType();
            if (this.isCollection()) {
                elementType = subviewType.getEntityClass();
            } else {
                expressionType = subviewType.getEntityClass();
            }
        } else {
            Class elementJavaType = this.getElementType().getJavaType();
            if ((elementJavaType.getModifiers() & 0x400) != 0 && !this.isQueryParameter() && AnnotationUtils.findAnnotation((Class)elementJavaType, EntityView.class) != null && this.getElementType().getConvertedType() == null) {
                context.addError("The element type '" + elementJavaType.getName() + "' is considered basic although the class is annotated with @EntityView. Add a type converter or add the java class to the entity view configuration! Problematic attribute " + this.getLocation());
            }
        }
        if (this.isKeySubview()) {
            keyType = ((ManagedViewTypeImplementor)this.getKeyType()).getEntityClass();
        }
        if (this.isCorrelated()) {
            AbstractAttribute.validateTypesCompatible(managedType, AbstractAttribute.stripThisFromMapping(this.correlationBasis), Object.class, null, true, true, context, ExpressionLocation.CORRELATION_BASIS, this.getLocation());
            if (this.correlated != null) {
                AbstractAttribute.validateTypesCompatible(context.getEntityMetamodel().managedType(this.correlated), AbstractAttribute.stripThisFromMapping(this.correlationResult), expressionType, elementType, true, !this.isCollection(), context, ExpressionLocation.CORRELATION_RESULT, this.getLocation());
                try {
                    context.getTypeValidationExpressionFactory().createBooleanExpression(this.correlationExpression, false);
                }
                catch (SyntaxErrorException ex) {
                    context.addError("Syntax error in " + (Object)((Object)ExpressionLocation.CORRELATION_EXPRESSION) + " '" + this.correlationExpression + "' of the " + this.getLocation() + ": " + ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    context.addError("An error occurred while trying to resolve the " + (Object)((Object)ExpressionLocation.CORRELATION_EXPRESSION) + " of the " + this.getLocation() + ": " + ex.getMessage());
                }
            }
        } else if (!this.isSubquery() && !this.isQueryParameter()) {
            boolean subtypesAllowed;
            boolean bl = subtypesAllowed = !this.isUpdatable();
            if (!this.isCollection() && (Collection.class.isAssignableFrom(expressionType) || Map.class.isAssignableFrom(expressionType))) {
                Class[] typeArguments = this.getTypeArguments();
                elementType = typeArguments[typeArguments.length - 1];
            }
            if (this.getElementType().getConvertedType() == null) {
                AbstractAttribute.validateTypesCompatible(this.possibleTargetTypes, expressionType, elementType, subtypesAllowed, !this.isCollection(), context, ExpressionLocation.MAPPING, this.getLocation());
            }
            if (this.isMutable() && (this.declaringType.isUpdatable() || this.declaringType.isCreatable())) {
                visitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), managedType.getJavaType(), this.isUpdatable());
                try {
                    context.getExpressionFactory().createPathExpression(this.mapping).accept((Expression.Visitor)visitor);
                    Map<Attribute<?, ?>, javax.persistence.metamodel.Type<?>> possibleTargets = visitor.getPossibleTargets();
                    if (possibleTargets.size() > 1) {
                        context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                    }
                    if (this.isDisallowOwnedUpdatableSubview()) {
                        for (com.blazebit.persistence.view.metamodel.Type type : this.getUpdateCascadeAllowedSubtypes()) {
                            ManagedViewType managedViewType = (ManagedViewType)type;
                            if (!managedViewType.isUpdatable()) continue;
                            context.addError("Invalid use of @UpdatableEntityView type '" + managedViewType.getJavaType().getName() + "' for the " + this.getLocation() + ". Consider using a read-only view type instead or use @AllowUpdatableEntityViews! For further information on this topic, please consult the documentation https://persistence.blazebit.com/documentation/entity-view/manual/en_US/index.html#updatable-mappings-subview");
                        }
                    }
                }
                catch (SyntaxErrorException ex) {
                    try {
                        context.getExpressionFactory().createSimpleExpression(this.mapping, false);
                        context.addError("Invalid mapping expression '" + this.mapping + "' of the " + this.getLocation() + " for an updatable attribute. Consider annotating the attribute with @UpdatableMapping(updatable = false) or simplify the mapping expression to a simple path expression. Encountered error: " + ex.getMessage());
                    }
                    catch (SyntaxErrorException ex2) {
                        context.addError("Syntax error in mapping expression '" + this.mapping + "' of the " + this.getLocation() + ": " + ex.getMessage());
                    }
                }
                catch (IllegalArgumentException ex) {
                    context.addError("There is an error for the " + this.getLocation() + ": " + ex.getMessage());
                }
            }
        }
    }

    protected abstract boolean isDisallowOwnedUpdatableSubview();

    public void checkNestedAttribute(List<AbstractAttribute<?, ?>> parents, ManagedType<?> managedType, MetamodelBuildingContext context) {
        if (!parents.isEmpty() && this.getDeclaringType().getMappingType() == Type.MappingType.FLAT_VIEW && this.isCollection() && this.getFetchStrategy() == FetchStrategy.JOIN) {
            for (int i = parents.size() - 1; i >= 0; --i) {
                AbstractAttribute<?, ?> parentAttribute = parents.get(i);
                if (parentAttribute.isCollection() && !parentAttribute.isIndexed()) {
                    String path = parents.get(0).getDeclaringType().getJavaType().getName();
                    for (i = 0; i < parents.size(); ++i) {
                        path = path + " > " + parents.get(i).getLocation();
                    }
                    context.addError("Illegal mapping of join fetched collection for the " + this.getLocation() + " via the path: " + path + ". Join fetched collections in flat views are only allowed for when the flat view is contained in an indexed collections or in a view.");
                    break;
                }
                if (parentAttribute.getDeclaringType().getMappingType() == Type.MappingType.VIEW) break;
            }
        }
        if (this.isSubview()) {
            Map<ManagedViewTypeImplementor<?>, String> inheritanceSubtypeMappings = this.elementInheritanceSubtypeMappings();
            if (inheritanceSubtypeMappings.isEmpty()) {
                context.addError("Illegal empty inheritance subtype mappings for the " + this.getLocation() + ". Remove the @MappingInheritance annotation, set the 'onlySubtypes' attribute to false or add a @MappingInheritanceSubtype element!");
            }
            for (ManagedViewTypeImplementor<?> subviewType : inheritanceSubtypeMappings.keySet()) {
                parents.add(this);
                subviewType.checkNestedAttributes(parents, context);
                parents.remove(parents.size() - 1);
            }
        }
        if (this.isKeySubview()) {
            Map<ManagedViewTypeImplementor<?>, String> inheritanceSubtypeMappings = this.keyInheritanceSubtypeMappings();
            if (inheritanceSubtypeMappings.isEmpty()) {
                context.addError("Illegal empty inheritance subtype mappings for the " + this.getLocation() + ". Remove the @MappingInheritance annotation, set the 'onlySubtypes' attribute to false or add a @MappingInheritanceSubtype element!");
            }
            for (ManagedViewTypeImplementor<?> subviewType : inheritanceSubtypeMappings.keySet()) {
                parents.add(this);
                subviewType.checkNestedAttributes(parents, context);
                parents.remove(parents.size() - 1);
            }
        }
    }

    protected boolean isEmbedded() {
        return this.getDeclaringType().getMappingType() == Type.MappingType.FLAT_VIEW && THIS.equals(this.mapping);
    }

    protected abstract Class[] getTypeArguments();

    public abstract String getLocation();

    public abstract boolean isUpdatable();

    public abstract boolean isMutable();

    public abstract String getMappedBy();

    public abstract boolean isUpdateCascaded();

    public abstract Set<com.blazebit.persistence.view.metamodel.Type<?>> getUpdateCascadeAllowedSubtypes();

    protected abstract boolean isIndexed();

    protected abstract boolean isForcedUnique();

    protected abstract PluralAttribute.CollectionType getCollectionType();

    protected abstract com.blazebit.persistence.view.metamodel.Type<?> getElementType();

    protected abstract Map<ManagedViewTypeImplementor<?>, String> elementInheritanceSubtypeMappings();

    protected abstract com.blazebit.persistence.view.metamodel.Type<?> getKeyType();

    protected abstract Map<ManagedViewTypeImplementor<?>, String> keyInheritanceSubtypeMappings();

    protected abstract boolean isKeySubview();

    public abstract Set<Class<?>> getAllowedSubtypes();

    public abstract Set<Class<?>> getParentRequiringUpdateSubtypes();

    public abstract Set<Class<?>> getParentRequiringCreateSubtypes();

    public abstract boolean isOptimizeCollectionActionsEnabled();

    public abstract CollectionInstantiator getCollectionInstantiator();

    public abstract MapInstantiator getMapInstantiator();

    protected final CollectionInstantiator createCollectionInstantiator(MetamodelBuildingContext context, PluralObjectFactory<? extends Collection<?>> collectionFactory, boolean indexed, boolean sorted, boolean ordered, Comparator comparator) {
        if (indexed) {
            if (this.isForcedUnique()) {
                context.addError("Forcing uniqueness for indexed attribute is invalid at the " + this.getLocation());
            }
            if (comparator != null) {
                context.addError("Comparator can't be defined for indexed attribute at the " + this.getLocation());
            }
            return new ListCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), true, this.isOptimizeCollectionActionsEnabled(), false, context.isStrictCascadingCheck(), null);
        }
        if (sorted) {
            return new SortedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck(), comparator);
        }
        if (this.getCollectionType() == PluralAttribute.CollectionType.SET) {
            if (comparator != null) {
                context.addError("Comparator can't be defined for non-sorted set attribute at the " + this.getLocation());
            }
            if (ordered) {
                return new OrderedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
            }
            return new UnorderedSetCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
        }
        if (this.getCollectionType() == PluralAttribute.CollectionType.LIST) {
            return new ListCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), false, this.isOptimizeCollectionActionsEnabled(), this.isForcedUnique(), context.isStrictCascadingCheck(), comparator);
        }
        return new OrderedCollectionInstantiator(collectionFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), this.isForcedUnique(), context.isStrictCascadingCheck(), comparator);
    }

    protected final MapInstantiator createMapInstantiator(MetamodelBuildingContext context, PluralObjectFactory<? extends Map<?, ?>> mapFactory, boolean sorted, boolean ordered, Comparator comparator) {
        if (sorted) {
            return new SortedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck(), comparator);
        }
        if (ordered) {
            return new OrderedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
        }
        return new UnorderedMapInstantiator(mapFactory, this.getAllowedSubtypes(), this.getParentRequiringUpdateSubtypes(), this.getParentRequiringCreateSubtypes(), this.isUpdatable(), this.isOptimizeCollectionActionsEnabled(), context.isStrictCascadingCheck());
    }

    public final Attribute.MappingType getMappingType() {
        return this.mappingType;
    }

    public final boolean isQueryParameter() {
        return this.mappingType == Attribute.MappingType.PARAMETER;
    }

    public final boolean isId() {
        return this.id;
    }

    public final SubqueryProviderFactory getSubqueryProviderFactory() {
        return this.subqueryProviderFactory;
    }

    public final Class<? extends SubqueryProvider> getSubqueryProvider() {
        return this.subqueryProvider;
    }

    public final String getSubqueryExpression() {
        return this.subqueryExpression;
    }

    public final String getSubqueryAlias() {
        return this.subqueryAlias;
    }

    public CorrelationProviderFactory getCorrelationProviderFactory() {
        return this.correlationProviderFactory;
    }

    public final Class<? extends CorrelationProvider> getCorrelationProvider() {
        return this.correlationProvider;
    }

    public final String getCorrelationBasis() {
        return this.correlationBasis;
    }

    public final String getCorrelationResult() {
        return this.correlationResult;
    }

    public final FetchStrategy getFetchStrategy() {
        return this.fetchStrategy;
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final String getMapping() {
        return this.mapping;
    }

    public final boolean isSubquery() {
        return this.mappingType == Attribute.MappingType.SUBQUERY;
    }

    public final ManagedViewTypeImplementor<X> getDeclaringType() {
        return this.declaringType;
    }

    public final Class<Y> getJavaType() {
        return this.javaType;
    }

    public Class<?> getConvertedJavaType() {
        return this.convertedJavaType;
    }

    public final String[] getFetches() {
        return this.fetches;
    }

    private static enum ExpressionLocation {
        MAPPING("mapping expression"),
        CORRELATION_BASIS("correlation basis"),
        CORRELATION_RESULT("correlation result"),
        CORRELATION_EXPRESSION("correlation expression");

        private final String location;

        private ExpressionLocation(String location) {
            this.location = location;
        }

        public String toString() {
            return this.location;
        }
    }
}

