/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.SyntaxErrorException;
import com.blazebit.persistence.view.AttributeFilter;
import com.blazebit.persistence.view.AttributeFilters;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.InverseRemoveStrategy;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.impl.UpdatableExpressionVisitor;
import com.blazebit.persistence.view.impl.collection.ListFactory;
import com.blazebit.persistence.view.impl.collection.MapFactory;
import com.blazebit.persistence.view.impl.collection.PluralObjectFactory;
import com.blazebit.persistence.view.impl.collection.SetFactory;
import com.blazebit.persistence.view.impl.collection.SortedMapFactory;
import com.blazebit.persistence.view.impl.collection.SortedSetFactory;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.AttributeFilterMappingImpl;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.IdMappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.metamodel.MappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.SetView;
import com.blazebit.persistence.view.impl.metamodel.ViewTypeImpl;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.AttributeFilterMapping;
import com.blazebit.persistence.view.metamodel.BasicType;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractMethodAttribute<X, Y>
extends AbstractAttribute<X, Y>
implements MethodAttribute<X, Y> {
    private final int attributeIndex;
    private final String name;
    private final Method javaMethod;
    private final Map<String, AttributeFilterMapping> filterMappings;

    protected AbstractMethodAttribute(ManagedViewTypeImplementor<X> viewType, MethodAttributeMapping mapping, int attributeIndex, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        super(viewType, mapping, context, embeddableMapping);
        this.attributeIndex = attributeIndex;
        this.name = mapping.getName();
        this.javaMethod = mapping.getMethod();
        HashMap<String, AttributeFilterMapping> filterMappings = new HashMap<String, AttributeFilterMapping>();
        AttributeFilter filterMapping = (AttributeFilter)AnnotationUtils.findAnnotation((Method)this.javaMethod, AttributeFilter.class);
        AttributeFilters filtersMapping = (AttributeFilters)AnnotationUtils.findAnnotation((Method)this.javaMethod, AttributeFilters.class);
        if (filterMapping != null) {
            if (filtersMapping != null) {
                context.addError("Illegal occurrences of @Filter and @Filters on the " + mapping.getErrorLocation() + "!");
            } else {
                this.addFilterMapping(filterMapping, filterMappings, context);
            }
        } else if (filtersMapping != null) {
            for (AttributeFilter f : filtersMapping.value()) {
                this.addFilterMapping(f, filterMappings, context);
            }
        }
        this.filterMappings = Collections.unmodifiableMap(filterMappings);
    }

    public Set<ManagedViewType<?>> getViewTypes() {
        com.blazebit.persistence.view.metamodel.Type<?> elementType = this.getElementType();
        if (elementType instanceof ManagedViewType) {
            Set<com.blazebit.persistence.view.metamodel.Type<?>> updateCascadeAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
            Set persistCascadeAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
            Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
            HashSet viewTypes = new HashSet(persistCascadeAllowedSubtypes.size() + updateCascadeAllowedSubtypes.size() + readOnlyAllowedSubtypes.size() + 1);
            viewTypes.add((ManagedViewType)elementType);
            viewTypes.addAll(persistCascadeAllowedSubtypes);
            viewTypes.addAll(updateCascadeAllowedSubtypes);
            viewTypes.addAll(readOnlyAllowedSubtypes);
            return viewTypes;
        }
        return Collections.emptySet();
    }

    @Override
    protected Class<?>[] getTypeArguments() {
        return ReflectionUtils.getResolvedMethodReturnTypeArguments((Class)this.getDeclaringType().getJavaType(), (Method)this.getJavaMethod());
    }

    protected int determineDirtyStateIndex(int dirtyStateIndex) {
        if (this.isUpdatable() || this.isMutable() && (this.isPersistCascaded() || this.isUpdateCascaded())) {
            return dirtyStateIndex;
        }
        return -1;
    }

    protected Set<com.blazebit.persistence.view.metamodel.Type<?>> determinePersistSubtypeSet(com.blazebit.persistence.view.metamodel.Type<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes1, Set<ManagedViewTypeImplementor<?>> subtypes2, MetamodelBuildingContext context) {
        Class superTypeClass = superType.getJavaType();
        HashSet set = new HashSet(subtypes1.size() + subtypes2.size());
        if (superType.getMappingType() == Type.MappingType.BASIC && context.getEntityMetamodel().getManagedType(superType.getJavaType()) != null || superType.getMappingType() != Type.MappingType.BASIC && ((ManagedViewType)superType).isCreatable()) {
            set.add(superType);
        }
        this.addToPersistSubtypeSet(set, superTypeClass, subtypes1, context, false);
        this.addToPersistSubtypeSet(set, superTypeClass, subtypes2, context, true);
        return Collections.unmodifiableSet(set);
    }

    protected Set<com.blazebit.persistence.view.metamodel.Type<?>> determineUpdateSubtypeSet(com.blazebit.persistence.view.metamodel.Type<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes1, Set<ManagedViewTypeImplementor<?>> subtypes2, MetamodelBuildingContext context) {
        Class superTypeClass = superType.getJavaType();
        HashSet set = new HashSet(subtypes1.size() + subtypes2.size());
        if (superType.getMappingType() == Type.MappingType.BASIC && ((BasicType)superType).getUserType().isMutable() || superType.getMappingType() != Type.MappingType.BASIC && ((ManagedViewType)superType).isUpdatable()) {
            set.add(superType);
        }
        this.addToUpdateSubtypeSet(set, superTypeClass, subtypes1, context, false);
        this.addToUpdateSubtypeSet(set, superTypeClass, subtypes2, context, true);
        return Collections.unmodifiableSet(set);
    }

    private void addToPersistSubtypeSet(Set<com.blazebit.persistence.view.metamodel.Type<?>> set, Class<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes, MetamodelBuildingContext context, boolean failIfNotCreatable) {
        for (ManagedViewTypeImplementor<?> type : subtypes) {
            Class c = type.getJavaType();
            if (c == superType) continue;
            if (!superType.isAssignableFrom(c)) {
                context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not a subtype of declared attribute element type [" + superType.getName() + "] in the " + this.getLocation());
            }
            if (type.isCreatable()) {
                set.add((com.blazebit.persistence.view.metamodel.Type<?>)type);
                continue;
            }
            if (!failIfNotCreatable) continue;
            context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not creatable in the " + this.getLocation());
        }
    }

    private void addToUpdateSubtypeSet(Set<com.blazebit.persistence.view.metamodel.Type<?>> set, Class<?> superType, Set<ManagedViewTypeImplementor<?>> subtypes, MetamodelBuildingContext context, boolean failIfNotUpdatable) {
        for (ManagedViewTypeImplementor<?> type : subtypes) {
            Class c = type.getJavaType();
            if (c == superType) continue;
            if (!superType.isAssignableFrom(c)) {
                context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not a subtype of declared attribute element type [" + superType.getName() + "] in the " + this.getLocation());
            }
            if (type.isUpdatable()) {
                set.add((com.blazebit.persistence.view.metamodel.Type<?>)type);
                continue;
            }
            if (!failIfNotUpdatable) continue;
            context.addError("Invalid subtype [" + c.getName() + "] in updatable mapping is not updatable in the " + this.getLocation());
        }
    }

    protected boolean determineMutable(com.blazebit.persistence.view.metamodel.Type<?> elementType) {
        if (this.isUpdatable()) {
            return true;
        }
        if (elementType == null) {
            return false;
        }
        return this.isUpdateCascaded();
    }

    protected final PluralObjectFactory<? extends Collection<?>> createCollectionFactory(MetamodelBuildingContext context) {
        Class<?> pluralContainerType = this.getPluralContainerType(context);
        if (pluralContainerType == null) {
            return null;
        }
        if (SortedSet.class.isAssignableFrom(pluralContainerType)) {
            return new SortedSetFactory();
        }
        if (Set.class.isAssignableFrom(pluralContainerType)) {
            return new SetFactory();
        }
        return new ListFactory();
    }

    protected final PluralObjectFactory<? extends Map<?, ?>> createMapFactory(MetamodelBuildingContext context) {
        Class<?> pluralContainerType = this.getPluralContainerType(context);
        if (pluralContainerType == null) {
            return null;
        }
        if (SortedMap.class.isAssignableFrom(pluralContainerType)) {
            return new SortedMapFactory();
        }
        return new MapFactory();
    }

    private Class<?> getPluralContainerType(MetamodelBuildingContext context) {
        if (this.isMutable() && (this.declaringType.isUpdatable() || this.declaringType.isCreatable())) {
            if (this.mapping == null) {
                switch (this.getCollectionType()) {
                    case MAP: {
                        return Map.class;
                    }
                    case SET: {
                        return Set.class;
                    }
                    case LIST: {
                        return List.class;
                    }
                    case COLLECTION: {
                        return Collection.class;
                    }
                }
                return null;
            }
            UpdatableExpressionVisitor visitor = new UpdatableExpressionVisitor(context.getEntityMetamodel(), this.getDeclaringType().getEntityClass(), this.isUpdatable());
            try {
                context.getExpressionFactory().createPathExpression(this.mapping).accept((Expression.Visitor)visitor);
                Map<Attribute<?, ?>, Type<?>> possibleTargets = visitor.getPossibleTargets();
                if (possibleTargets.size() > 1) {
                    context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                }
                return possibleTargets.values().iterator().next().getJavaType();
            }
            catch (SyntaxErrorException ex) {
                try {
                    context.getExpressionFactory().createSimpleExpression(this.mapping, false);
                    context.addError("Invalid mapping expression '" + this.mapping + "' of the " + this.getLocation() + " for an updatable attribute. Consider annotating the attribute with @UpdatableMapping(updatable = false) or simplify the mapping expression to a simple path expression. Encountered error: " + ex.getMessage());
                }
                catch (SyntaxErrorException ex2) {
                    context.addError("Syntax error in mapping expression '" + this.mapping + "' of the " + this.getLocation() + ": " + ex.getMessage());
                }
            }
            catch (IllegalArgumentException ex) {
                context.addError("There is an error for the " + this.getLocation() + ": " + ex.getMessage());
            }
        }
        return null;
    }

    protected boolean determineOptimisticLockProtected(MethodAttributeMapping mapping, MetamodelBuildingContext context, boolean mutable) {
        Boolean isOptimisticLockProtected = mapping.getOptimisticLockProtected();
        if (isOptimisticLockProtected != null) {
            if (!this.declaringType.isUpdatable() && !this.declaringType.isCreatable()) {
                context.addError("The usage of @OptimisticLock is only allowed on updatable or creatable entity view types! Invalid definition on the " + mapping.getErrorLocation());
            }
            return isOptimisticLockProtected;
        }
        if (!mutable) {
            return false;
        }
        if (this.declaringType instanceof ViewTypeImpl) {
            ViewTypeImpl owner = (ViewTypeImpl)this.declaringType;
            return owner.getLockMode() == LockMode.AUTO || owner.getLockMode() == LockMode.OPTIMISTIC;
        }
        return true;
    }

    @Override
    public void checkAttribute(ManagedType<?> managedType, MetamodelBuildingContext context) {
        String mappedBy;
        super.checkAttribute(managedType, context);
        if (this.isUpdatable() && this.declaringType.isUpdatable() && (mappedBy = this.getMappedBy()) != null && this.getInverseRemoveStrategy() == InverseRemoveStrategy.SET_NULL) {
            com.blazebit.persistence.view.metamodel.Type<?> elementType = this.getElementType();
            Object elementJpaType = elementType instanceof ManagedViewTypeImplementor ? ((ManagedViewTypeImplementor)elementType).getJpaManagedType() : ((BasicTypeImpl)elementType).getManagedType();
            Map<String, String> writableMappedByMappings = this.getWritableMappedByMappings();
            if (writableMappedByMappings == null) {
                Attribute attribute = elementJpaType.getAttribute(mappedBy);
                if (attribute instanceof SingularAttribute && !((SingularAttribute)attribute).isOptional()) {
                    context.addError("Illegal use of the remove strategy SET_NULL for non-nullable mapped by attribute '" + mappedBy + "' at " + this.getLocation() + " Use a different strategy via @MappingInverse(removeStrategy = InverseRemoveStrategy...)");
                }
            } else {
                PathTargetResolvingExpressionVisitor visitor = new PathTargetResolvingExpressionVisitor(context.getEntityMetamodel(), elementJpaType, null);
                for (String value : writableMappedByMappings.values()) {
                    Attribute attribute;
                    visitor.reset(elementJpaType);
                    context.getTypeValidationExpressionFactory().createPathExpression(value).accept((Expression.Visitor)visitor);
                    Map possibleTargets = visitor.getPossibleTargets();
                    if (possibleTargets.size() > 1) {
                        context.addError("Multiple possible target type for the mapping in the " + this.getLocation() + ": " + possibleTargets);
                    }
                    if (!((attribute = (Attribute)possibleTargets.keySet().iterator().next()) instanceof SingularAttribute) || ((SingularAttribute)attribute).isOptional()) continue;
                    context.addError("Illegal use of the remove strategy SET_NULL for non-nullable mapped by attribute '" + mappedBy + "' because writable mapping '" + value + "' is non-optional at " + this.getLocation() + " Use a different strategy via @MappingInverse(removeStrategy = InverseRemoveStrategy...)");
                }
            }
        }
    }

    protected static String getAttributeName(Method getterOrSetter) {
        String name = getterOrSetter.getName();
        StringBuilder sb = new StringBuilder(name.length());
        int index = name.startsWith("is") ? 2 : 3;
        char firstAttributeNameChar = name.charAt(index);
        return sb.append(Character.toLowerCase(firstAttributeNameChar)).append(name, index + 1, name.length()).toString();
    }

    private void addFilterMapping(AttributeFilter filterMapping, Map<String, AttributeFilterMapping> filterMappings, MetamodelBuildingContext context) {
        String filterName = filterMapping.name();
        boolean errorOccurred = false;
        if (filterMappings.containsKey(filterName)) {
            errorOccurred = true;
            context.addError("Illegal duplicate filter name mapping '" + filterName + "' at " + this.getLocation());
        }
        if (!errorOccurred) {
            AttributeFilterMappingImpl attributeFilterMapping = new AttributeFilterMappingImpl(this, filterName, filterMapping.value());
            filterMappings.put(attributeFilterMapping.getName(), attributeFilterMapping);
        }
    }

    @Override
    public String getLocation() {
        return MethodAttributeMapping.getLocation(this.getName(), this.getJavaMethod());
    }

    public String getName() {
        return this.name;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    @Override
    public boolean needsDirtyTracker() {
        return this.isUpdatable() || this.isUpdateCascaded() && !this.getUpdateCascadeAllowedSubtypes().isEmpty();
    }

    @Override
    public boolean hasDirtyStateIndex() {
        return this.getDirtyStateIndex() != -1;
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    public Y getValue(Object o) {
        try {
            return (Y)this.javaMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't get value!", e);
        }
    }

    public abstract int getDirtyStateIndex();

    public boolean isUpdatableOnly() {
        return this.hasDirtyStateIndex() && !this.isPersistCascaded() && !this.isUpdateCascaded();
    }

    public abstract Map<String, String> getWritableMappedByMappings();

    protected final Set<Class<?>> createAllowedSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size() + persistAllowedSubtypes.size() + updateAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type type : readOnlyAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        for (com.blazebit.persistence.view.metamodel.Type type : persistAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        for (com.blazebit.persistence.view.metamodel.Type type : updateAllowedSubtypes) {
            allowedSubtypes.add(type.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    protected final Set<Class<?>> createParentRequiringUpdateSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type t : readOnlyAllowedSubtypes) {
            ManagedViewTypeImplementor viewType;
            if (!(t instanceof ManagedViewTypeImplementor) || (!(viewType = (ManagedViewTypeImplementor)t).isUpdatable() || updateAllowedSubtypes.contains(t)) && (!viewType.isCreatable() || persistAllowedSubtypes.contains(t))) continue;
            allowedSubtypes.add(t.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    protected final Set<Class<?>> createParentRequiringCreateSubtypesSet() {
        Set readOnlyAllowedSubtypes = this.getReadOnlyAllowedSubtypes();
        Set persistAllowedSubtypes = this.getPersistCascadeAllowedSubtypes();
        Set<com.blazebit.persistence.view.metamodel.Type<?>> updateAllowedSubtypes = this.getUpdateCascadeAllowedSubtypes();
        HashSet<Class> allowedSubtypes = new HashSet<Class>(readOnlyAllowedSubtypes.size());
        for (com.blazebit.persistence.view.metamodel.Type t : readOnlyAllowedSubtypes) {
            ManagedViewTypeImplementor viewType;
            if (!(t instanceof ManagedViewTypeImplementor) || (!(viewType = (ManagedViewTypeImplementor)t).isUpdatable() || updateAllowedSubtypes.contains(t)) && (!viewType.isCreatable() || persistAllowedSubtypes.contains(t))) continue;
            allowedSubtypes.add(t.getJavaType());
        }
        return Collections.unmodifiableSet(allowedSubtypes);
    }

    @Override
    public boolean isOptimizeCollectionActionsEnabled() {
        return this.isOptimisticLockProtected();
    }

    public Attribute.MemberType getMemberType() {
        return Attribute.MemberType.METHOD;
    }

    public AttributeFilterMapping getFilter(String filterName) {
        return this.filterMappings.get(filterName);
    }

    public Set<AttributeFilterMapping> getFilters() {
        return new SetView<AttributeFilterMapping>(this.filterMappings.values());
    }

    public Map<String, AttributeFilterMapping> getFilterMappings() {
        return this.filterMappings;
    }

    public static String extractAttributeName(Class<?> viewType, Method m, MetamodelBootContext context) {
        if (ReflectionUtils.isSetter((Method)m)) {
            String attributeName = AbstractMethodAttribute.getAttributeName(m);
            Method getter = ReflectionUtils.getGetter(viewType, (String)attributeName);
            if (getter == null) {
                context.addError("The setter '" + m.getName() + "' from the entity view '" + viewType.getName() + "' has no corresponding getter!");
                return null;
            }
            if (ReflectionUtils.getResolvedMethodParameterTypes(viewType, (Method)m)[0] != ReflectionUtils.getResolvedMethodReturnType(viewType, (Method)getter)) {
                context.addError("The setter '" + m.getName() + "' of the class '" + viewType.getName() + "' must accept an argument of the same type as it's corresponding getter returns!");
                return null;
            }
            return null;
        }
        if (!ReflectionUtils.isGetter((Method)m)) {
            context.addError("The given method '" + m.getName() + "' from the entity view '" + viewType.getName() + "' is no bean style getter or setter!");
            return null;
        }
        String attributeName = AbstractMethodAttribute.getAttributeName(m);
        Method setter = ReflectionUtils.getSetter(viewType, (String)attributeName);
        if (setter != null && ReflectionUtils.getResolvedMethodParameterTypes(viewType, (Method)setter)[0] != ReflectionUtils.getResolvedMethodReturnType(viewType, (Method)m)) {
            context.addError("The getter '" + m.getName() + "' of the class '" + viewType.getName() + "' must have the same return type as it's corresponding setter accepts!");
            return null;
        }
        if (m.getExceptionTypes().length > 0) {
            context.addError("The given method '" + m.getName() + "' from the entity view '" + viewType.getName() + "' must not throw an exception!");
            return null;
        }
        return attributeName;
    }

    public static Annotation getMapping(String attributeName, Method m, MetamodelBootContext context) {
        Mapping mapping = (Mapping)AnnotationUtils.findAnnotation((Method)m, Mapping.class);
        if (mapping == null) {
            IdMapping idMapping = (IdMapping)AnnotationUtils.findAnnotation((Method)m, IdMapping.class);
            if (idMapping != null) {
                if (idMapping.value().isEmpty()) {
                    idMapping = new IdMappingLiteral(AbstractMethodAttribute.getAttributeName(m));
                }
                return idMapping;
            }
            MappingParameter mappingParameter = (MappingParameter)AnnotationUtils.findAnnotation((Method)m, MappingParameter.class);
            if (mappingParameter != null) {
                if (mappingParameter.value().isEmpty()) {
                    context.addError("Illegal empty mapping parameter for the " + MethodAttributeMapping.getLocation(attributeName, m));
                }
                return mappingParameter;
            }
            MappingSubquery mappingSubquery = (MappingSubquery)AnnotationUtils.findAnnotation((Method)m, MappingSubquery.class);
            if (mappingSubquery != null) {
                return mappingSubquery;
            }
            MappingCorrelated mappingCorrelated = (MappingCorrelated)AnnotationUtils.findAnnotation((Method)m, MappingCorrelated.class);
            if (mappingCorrelated != null) {
                return mappingCorrelated;
            }
            MappingCorrelatedSimple mappingCorrelatedSimple = (MappingCorrelatedSimple)AnnotationUtils.findAnnotation((Method)m, MappingCorrelatedSimple.class);
            if (mappingCorrelatedSimple != null) {
                return mappingCorrelatedSimple;
            }
            mapping = new MappingLiteral(AbstractMethodAttribute.getAttributeName(m));
        }
        if (mapping.value().isEmpty()) {
            mapping = new MappingLiteral(AbstractMethodAttribute.getAttributeName(m), mapping);
        }
        return mapping;
    }
}

