/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.impl.metamodel.AbstractAttribute;
import com.blazebit.persistence.view.impl.metamodel.EmbeddableOwner;
import com.blazebit.persistence.view.impl.metamodel.MappingConstructorImpl;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.persistence.view.metamodel.ParameterAttribute;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractParameterAttribute<X, Y>
extends AbstractAttribute<X, Y>
implements ParameterAttribute<X, Y> {
    private final int index;
    private final MappingConstructor<X> declaringConstructor;

    public AbstractParameterAttribute(MappingConstructorImpl<X> constructor, ParameterAttributeMapping mapping, MetamodelBuildingContext context, EmbeddableOwner embeddableMapping) {
        super(constructor.getDeclaringType(), mapping, context, embeddableMapping);
        this.index = mapping.getIndex();
        this.declaringConstructor = constructor;
        if (this.mapping != null && this.mapping.isEmpty()) {
            context.addError("Illegal empty mapping for the " + mapping.getErrorLocation());
        }
    }

    @Override
    protected Class<?>[] getTypeArguments() {
        Class clazz = this.getDeclaringType().getJavaType();
        Constructor constructor = this.getDeclaringConstructor().getJavaConstructor();
        Type[] genericParameterTypes = constructor.getGenericParameterTypes();
        return ReflectionUtils.resolveTypeArguments((Class)clazz, (Type)genericParameterTypes[this.getIndex()]);
    }

    public static Annotation getMapping(Constructor<?> constructor, int index, MetamodelBootContext context) {
        Annotation[] annotations;
        for (Annotation a : annotations = constructor.getParameterAnnotations()[index]) {
            if (!MappingParameter.class.isInstance(a) && !Mapping.class.isInstance(a) && !MappingSubquery.class.isInstance(a) && !MappingCorrelated.class.isInstance(a) && !MappingCorrelatedSimple.class.isInstance(a)) continue;
            return a;
        }
        context.addError("No MappingParameter annotation given for the " + ParameterAttributeMapping.getLocation(constructor, index));
        return null;
    }

    @Override
    public String getLocation() {
        return ParameterAttributeMapping.getLocation(this.declaringConstructor.getJavaConstructor(), this.index);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean hasDirtyStateIndex() {
        return false;
    }

    @Override
    public String getMappedBy() {
        return null;
    }

    @Override
    protected boolean isDisallowOwnedUpdatableSubview() {
        return false;
    }

    @Override
    public boolean isUpdateCascaded() {
        return false;
    }

    @Override
    public Set<com.blazebit.persistence.view.metamodel.Type<?>> getUpdateCascadeAllowedSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean needsDirtyTracker() {
        return false;
    }

    public Attribute.MemberType getMemberType() {
        return Attribute.MemberType.PARAMETER;
    }

    @Override
    public Set<Class<?>> getAllowedSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<?>> getParentRequiringUpdateSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<?>> getParentRequiringCreateSubtypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isOptimizeCollectionActionsEnabled() {
        return false;
    }

    public MappingConstructor<X> getDeclaringConstructor() {
        return this.declaringConstructor;
    }
}

