/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.view.BatchFetch;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.CreatableEntityView;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViewInheritance;
import com.blazebit.persistence.view.EntityViewInheritanceMapping;
import com.blazebit.persistence.view.EntityViewListener;
import com.blazebit.persistence.view.EntityViewListeners;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.LockOwner;
import com.blazebit.persistence.view.PostCommit;
import com.blazebit.persistence.view.PostConvert;
import com.blazebit.persistence.view.PostCreate;
import com.blazebit.persistence.view.PostPersist;
import com.blazebit.persistence.view.PostRemove;
import com.blazebit.persistence.view.PostRollback;
import com.blazebit.persistence.view.PostUpdate;
import com.blazebit.persistence.view.PrePersist;
import com.blazebit.persistence.view.PreRemove;
import com.blazebit.persistence.view.PreUpdate;
import com.blazebit.persistence.view.UpdatableEntityView;
import com.blazebit.persistence.view.ViewConstructor;
import com.blazebit.persistence.view.With;
import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.AbstractParameterAttribute;
import com.blazebit.persistence.view.impl.metamodel.AnnotationMethodAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.AnnotationParameterAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.MappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MappingReader;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMappingImpl;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationMappingReader
implements MappingReader {
    private static final Map<Class<?>, LifecycleEntry> LIFECYCLE_ENTRY_MAP;
    private static final LifecycleEntry[] LIFECYCLE_ENTRIES;
    private final MetamodelBootContext context;
    private final AnnotationMethodAttributeMappingReader methodAttributeMappingReader;
    private final AnnotationParameterAttributeMappingReader parameterAttributeMappingReader;

    public AnnotationMappingReader(MetamodelBootContext context) {
        this.context = context;
        this.methodAttributeMappingReader = new AnnotationMethodAttributeMappingReader(context);
        this.parameterAttributeMappingReader = new AnnotationParameterAttributeMappingReader(context);
    }

    @Override
    public MetamodelBootContext getContext() {
        return this.context;
    }

    @Override
    public void readViewListenerMapping(Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        EntityViewListener entityViewListener = (EntityViewListener)AnnotationUtils.findAnnotation(entityViewListenerClass, EntityViewListener.class);
        if (entityViewListener == null) {
            EntityViewListeners entityViewListeners = (EntityViewListeners)AnnotationUtils.findAnnotation(entityViewListenerClass, EntityViewListeners.class);
            if (entityViewListeners == null) {
                TypeVariable<Class<?>>[] typeParameters = factory.getListenerKind().getTypeParameters();
                if (typeParameters.length > 0) {
                    Class[] typeArguments = new Class[typeParameters.length];
                    for (int i = 0; i < typeParameters.length; ++i) {
                        typeArguments[i] = ReflectionUtils.resolveTypeVariable(entityViewListenerClass, typeParameters[i]);
                    }
                    if (typeArguments.length > 1) {
                        this.context.addEntityViewListener(typeArguments[0], typeArguments[1], factory);
                    } else {
                        this.context.addEntityViewListener(typeArguments[0], Object.class, factory);
                    }
                }
            } else {
                for (EntityViewListener viewListener : entityViewListeners.value()) {
                    this.context.addEntityViewListener(viewListener.entityView(), viewListener.entity(), factory);
                }
            }
        } else {
            this.context.addEntityViewListener(entityViewListener.entityView(), entityViewListener.entity(), factory);
        }
    }

    @Override
    public ViewMapping readViewMapping(Class<?> entityViewClass) {
        Method postCommit;
        CreatableEntityView creatableEntityView;
        ViewMapping existingMapping = this.context.getViewMapping(entityViewClass);
        if (existingMapping != null) {
            return existingMapping;
        }
        EntityView entityView = (EntityView)AnnotationUtils.findAnnotation(entityViewClass, EntityView.class);
        if (entityView == null) {
            return null;
        }
        Class entityClass = entityView.value();
        ViewMappingImpl viewMapping = new ViewMappingImpl(entityViewClass, entityClass, this.context);
        this.context.addViewMapping(entityViewClass, viewMapping);
        BatchFetch batchFetch = (BatchFetch)AnnotationUtils.findAnnotation(entityViewClass, BatchFetch.class);
        if (batchFetch != null) {
            viewMapping.setDefaultBatchSize(batchFetch.size());
        }
        LinkedHashSet<Class<? extends CTEProvider>> cteProviders = new LinkedHashSet<Class<? extends CTEProvider>>();
        for (Annotation a : AnnotationUtils.getAllAnnotations(entityViewClass)) {
            if (!(a instanceof With)) continue;
            cteProviders.addAll(Arrays.asList(((With)a).value()));
        }
        viewMapping.setCteProviders(cteProviders);
        UpdatableEntityView updatableEntityView = (UpdatableEntityView)AnnotationUtils.findAnnotation(entityViewClass, UpdatableEntityView.class);
        if (updatableEntityView != null) {
            viewMapping.setUpdatable(true);
            viewMapping.setFlushMode(updatableEntityView.mode());
            viewMapping.setFlushStrategy(updatableEntityView.strategy());
            viewMapping.setLockMode(updatableEntityView.lockMode());
        }
        if ((creatableEntityView = (CreatableEntityView)AnnotationUtils.findAnnotation(entityViewClass, CreatableEntityView.class)) != null) {
            viewMapping.setCreatable(true);
            viewMapping.setValidatePersistability(creatableEntityView.validatePersistability());
            viewMapping.getExcludedAttributes().addAll(Arrays.asList(creatableEntityView.excludedEntityAttributes()));
        }
        if (updatableEntityView != null || creatableEntityView != null) {
            LockOwner lockOwner = (LockOwner)AnnotationUtils.findAnnotation(entityViewClass, LockOwner.class);
            if (lockOwner != null) {
                viewMapping.setLockOwner(lockOwner.value());
            }
        } else {
            viewMapping.setLockMode(LockMode.NONE);
        }
        EntityViewInheritance inheritanceAnnotation = entityViewClass.getAnnotation(EntityViewInheritance.class);
        EntityViewInheritanceMapping inheritanceMappingAnnotation = entityViewClass.getAnnotation(EntityViewInheritanceMapping.class);
        String inheritanceMapping = inheritanceMappingAnnotation != null ? inheritanceMappingAnnotation.value() : null;
        viewMapping.setInheritanceMapping(inheritanceMapping);
        if (inheritanceAnnotation == null) {
            viewMapping.setInheritanceSubtypesResolved(true);
        } else if (inheritanceAnnotation.value().length > 0) {
            viewMapping.getInheritanceSubtypeClasses().addAll(Arrays.asList(inheritanceAnnotation.value()));
            viewMapping.setInheritanceSubtypesResolved(true);
        }
        MethodAttributeMapping idAttribute = null;
        Map<String, MethodAttributeMapping> attributes = viewMapping.getMethodAttributes();
        ArrayList<Method> specialMethods = new ArrayList<Method>();
        Method[] methods = entityViewClass.getMethods();
        HashSet<String> handledMethods = new HashSet<String>(methods.length);
        HashSet<String> concreteMethods = new HashSet<String>(methods.length);
        Method[] lifecycleMethods = this.visitAndCollectLifecycleMethods(entityViewClass, methods, handledMethods, concreteMethods);
        Method[] lifecycleMethodCandidates = new Method[lifecycleMethods.length];
        for (Class c : ReflectionUtils.getSuperTypes(entityViewClass)) {
            for (Method method : c.getDeclaredMethods()) {
                if (!Modifier.isPrivate(method.getModifiers()) && Modifier.isAbstract(method.getModifiers()) && !method.isBridge()) {
                    Annotation mapping;
                    String attributeName;
                    String methodName = method.getName();
                    if (handledMethods.add(methodName)) {
                        if (method.getReturnType() == EntityViewManager.class) {
                            specialMethods.add(method);
                        } else {
                            attributeName = AbstractMethodAttribute.extractAttributeName(entityViewClass, method, this.context);
                            if (attributeName != null && !attributes.containsKey(attributeName) && (mapping = AbstractMethodAttribute.getMapping(attributeName, method, this.context)) != null) {
                                MethodAttributeMapping attribute = this.methodAttributeMappingReader.readMethodAttributeMapping(viewMapping, mapping, attributeName, method);
                                attributes.put(attributeName, attribute);
                                if (attribute.isId()) {
                                    idAttribute = attribute.handleReplacement(idAttribute);
                                }
                            }
                        }
                    } else if (!concreteMethods.contains(methodName)) {
                        attributeName = AbstractMethodAttribute.getAttributeName(method);
                        mapping = AbstractMethodAttribute.getMapping(attributeName, method, this.context);
                        if (mapping instanceof MappingLiteral) continue;
                        MethodAttributeMapping originalAttribute = attributes.get(attributeName);
                        MethodAttributeMapping attribute = this.methodAttributeMappingReader.readMethodAttributeMapping(viewMapping, mapping, attributeName, method);
                        MethodAttributeMapping newAttribute = attribute.handleReplacement(originalAttribute);
                        if (newAttribute != originalAttribute) {
                            attributes.put(attributeName, newAttribute);
                            if (newAttribute.isId()) {
                                idAttribute = newAttribute.handleReplacement(idAttribute);
                            }
                        }
                    }
                }
                if (Modifier.isAbstract(method.getModifiers()) || method.isBridge()) continue;
                for (int i = 0; i < lifecycleMethods.length; ++i) {
                    if (lifecycleMethods[i] != null || AnnotationUtils.findAnnotation((Method)method, (Class)LIFECYCLE_ENTRIES[i].annotation) == null) continue;
                    if (lifecycleMethodCandidates[i] != null) {
                        if (lifecycleMethodCandidates[i].getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
                            lifecycleMethodCandidates[i] = method;
                            continue;
                        }
                        if (method.getDeclaringClass().isAssignableFrom(lifecycleMethodCandidates[i].getDeclaringClass())) continue;
                        this.context.addError("Multiple " + LIFECYCLE_ENTRIES[i].name + " methods found in super types of entity view '" + entityViewClass.getName() + "':\n\t" + lifecycleMethodCandidates[i].getDeclaringClass().getName() + "." + lifecycleMethodCandidates[i].getName() + "\n\t" + method.getDeclaringClass().getName() + "." + method.getName());
                        continue;
                    }
                    lifecycleMethodCandidates[i] = method;
                }
            }
        }
        for (int i = 0; i < lifecycleMethods.length; ++i) {
            if (lifecycleMethods[i] != null) continue;
            lifecycleMethods[i] = lifecycleMethodCandidates[i];
        }
        viewMapping.setPostCreateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostCreate.class).index]);
        viewMapping.setPostConvertMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostConvert.class).index]);
        viewMapping.setPrePersistMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PrePersist.class).index]);
        viewMapping.setPostPersistMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostPersist.class).index]);
        viewMapping.setPreUpdateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PreUpdate.class).index]);
        viewMapping.setPostUpdateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostUpdate.class).index]);
        viewMapping.setPreRemoveMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PreRemove.class).index]);
        viewMapping.setPostRemoveMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostRemove.class).index]);
        Method postRollback = lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostRollback.class).index];
        if (postRollback != null) {
            viewMapping.setPostRollbackMethod(postRollback);
            PostRollback annotation = (PostRollback)AnnotationUtils.findAnnotation((Method)postRollback, PostRollback.class);
            viewMapping.setPostRollbackTransitions(annotation.transitions());
        }
        if ((postCommit = lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostCommit.class).index]) != null) {
            viewMapping.setPostCommitMethod(postCommit);
            PostCommit annotation = (PostCommit)AnnotationUtils.findAnnotation((Method)postCommit, PostCommit.class);
            viewMapping.setPostCommitTransitions(annotation.transitions());
        }
        viewMapping.setSpecialMethods(specialMethods);
        viewMapping.setIdAttributeMapping(idAttribute);
        for (Executable executable : entityViewClass.getDeclaredConstructors()) {
            int parameterCount = ((Constructor)executable).getParameterTypes().length;
            ArrayList<ParameterAttributeMapping> parameters = new ArrayList<ParameterAttributeMapping>(parameterCount);
            String constructorName = AnnotationMappingReader.extractConstructorName(executable);
            ConstructorMapping constructorMapping = new ConstructorMapping(viewMapping, constructorName, (Constructor<?>)executable, (List<ParameterAttributeMapping>)parameters, this.context);
            Annotation[][] parameterAnnotations = ((Constructor)executable).getParameterAnnotations();
            for (int i = 0; i < parameterCount; ++i) {
                Annotation mapping = AbstractParameterAttribute.getMapping(executable, i, this.context);
                if (mapping == null) continue;
                ParameterAttributeMapping parameter = this.parameterAttributeMappingReader.readParameterAttributeMapping(viewMapping, mapping, constructorMapping, i, parameterAnnotations[i]);
                parameters.add(parameter);
            }
            viewMapping.addConstructor(constructorMapping);
        }
        return viewMapping;
    }

    private Method[] visitAndCollectLifecycleMethods(Class<?> entityViewClass, Method[] methods, Set<String> handledMethods, Set<String> concreteMethods) {
        Method[] foundMethods = new Method[LIFECYCLE_ENTRY_MAP.size()];
        for (Method method : methods) {
            if (Modifier.isAbstract(method.getModifiers()) || method.isBridge()) continue;
            handledMethods.add(method.getName());
            concreteMethods.add(method.getName());
            if (entityViewClass.isInterface()) continue;
            for (Annotation annotation : AnnotationUtils.getAllAnnotations((Method)method)) {
                LifecycleEntry lifecycleEntry = LIFECYCLE_ENTRY_MAP.get(annotation.annotationType());
                if (lifecycleEntry == null) continue;
                if (foundMethods[lifecycleEntry.index] != null) {
                    this.context.addError("Multiple " + lifecycleEntry.name + " methods found:\n\t" + foundMethods[lifecycleEntry.index].getDeclaringClass().getName() + "." + foundMethods[lifecycleEntry.index].getName() + "\n\t" + method.getDeclaringClass().getName() + "." + method.getName());
                    continue;
                }
                foundMethods[((LifecycleEntry)lifecycleEntry).index] = method;
            }
        }
        return foundMethods;
    }

    public static String extractConstructorName(Constructor<?> c) {
        ViewConstructor viewConstructor = c.getAnnotation(ViewConstructor.class);
        if (viewConstructor == null) {
            return "init";
        }
        return viewConstructor.value();
    }

    static {
        LifecycleEntry[] lifecycleEntries = new LifecycleEntry[]{new LifecycleEntry(0, "post create", PostCreate.class), new LifecycleEntry(1, "pre persist", PrePersist.class), new LifecycleEntry(2, "post persist", PostPersist.class), new LifecycleEntry(3, "pre update", PreUpdate.class), new LifecycleEntry(4, "post update", PostUpdate.class), new LifecycleEntry(5, "pre remove", PreRemove.class), new LifecycleEntry(6, "post remove", PostRemove.class), new LifecycleEntry(7, "post rollback", PostRollback.class), new LifecycleEntry(8, "post commit", PostCommit.class), new LifecycleEntry(9, "post create", PostConvert.class)};
        LIFECYCLE_ENTRIES = lifecycleEntries;
        HashMap lifecycleEntryMap = new HashMap(lifecycleEntries.length);
        for (LifecycleEntry lifecycleEntry : lifecycleEntries) {
            lifecycleEntryMap.put(lifecycleEntry.annotation, lifecycleEntry);
        }
        LIFECYCLE_ENTRY_MAP = lifecycleEntryMap;
    }

    private static class LifecycleEntry {
        private final int index;
        private final String name;
        private final Class<? extends Annotation> annotation;

        public LifecycleEntry(int index, String name, Class<? extends Annotation> annotation) {
            this.index = index;
            this.name = name;
            this.annotation = annotation;
        }
    }
}

